/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataFileOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespaceOraclev9i
extends DDLStatementHandler {
    private TableSpaceOraclev9i tableSpace;
    private RDBMSSite site;
    private StorageDesignOraclev9i stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTablespaceOraclev9i.class);

    public SHCreateTablespaceOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTablespaceOraclev9i.clearCR(string);
        if (Token.startsWithString(string2, "create tablespace") || Token.startsWithString(string2, "create smallfile tablespace") || Token.startsWithString(string2, "create bigfile tablespace")) {
            try {
                this.parseTablespace(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateTablespaceOraclev9i.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseTablespace(String string) {
        this.statement = string;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = (TableSpaceOraclev9i)this.stoDesign.getTableSpaceSet().createTableSpace();
            if (this.tableSpace != null) {
                this.initName();
                this.initDataFiles();
                this.initMinimumExtent();
                this.initBlockSize();
                this.initLogging();
                this.initForceLogging();
                this.initStatus();
                this.initContents();
                this.initDefaultStorage();
                this.initExtManagement();
                this.initSegmentManagement();
                this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
            }
        }
    }

    private void initBlockSize() {
        if (Token.hasToken(this.statement, "BLOCKSIZE")) {
            String string = this.getNumberOnly(Token.getTokenAfter(this.statement, "BLOCKSIZE").trim());
            try {
                int n = Integer.parseInt(string);
                this.tableSpace.setBlockSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong BLOCKSIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initBlockSize() : " + numberFormatException.getMessage());
            }
        }
    }

    private void initName() {
        String string = Token.getNameAfterToken(this.statement, "TABLESPACE", '\"', '\"').trim();
        this.tableSpace.setName(string);
    }

    public TableSpaceOraclev9i getTablespace() {
        return this.tableSpace;
    }

    private void initDataFiles() {
        if (Token.hasToken(this.statement, "DATAFILE")) {
            String[] stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String string = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), stringArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                this.initDataFile(string2);
            }
        }
    }

    private void initDataFile(String string) {
        if (!"".equalsIgnoreCase(string)) {
            String string2;
            String string3;
            DataFileOraclev9i dataFileOraclev9i = (DataFileOraclev9i)this.stoDesign.getDataFileSet().createDataFile();
            dataFileOraclev9i.setTableSpace(this.tableSpace);
            String string4 = Token.getValBetweenQuotes(string);
            dataFileOraclev9i.setFileName(string4);
            this.design.getRelationalDesign().stampModelObjectDDL(dataFileOraclev9i);
            if (Token.hasToken(string, "SIZE")) {
                string3 = Token.getTokenAfter(string, "SIZE");
                try {
                    long l = Long.parseLong(this.getNumberOnly(string3));
                    dataFileOraclev9i.setSize(l);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", numberFormatException);
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                }
                string2 = this.getMeasureUnit(string3, string);
                dataFileOraclev9i.setMeasureUnit(string2);
            }
            if (Token.hasToken(string, "REUSE")) {
                dataFileOraclev9i.setReuse("YES");
            } else {
                dataFileOraclev9i.setReuse("NO");
            }
            if (Token.hasToken(string, "AUTOEXTEND")) {
                string3 = Token.getTokenAfter(string, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(string3)) {
                    dataFileOraclev9i.setAutoextend("ON");
                    if (Token.hasToken(string, "NEXT")) {
                        string2 = Token.getTokenAfter(string, "NEXT").trim();
                        try {
                            int n = Integer.parseInt(this.getNumberOnly(string2));
                            dataFileOraclev9i.setNextBlockSize(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", numberFormatException);
                            this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                        }
                    }
                    if (Token.hasToken(string, "MAXSIZE")) {
                        dataFileOraclev9i.setMaxSize(this.getNumberOnly(Token.getTokenAfter(string, "MAXSIZE").trim()));
                    }
                } else if ("OFF".equalsIgnoreCase(string3)) {
                    dataFileOraclev9i.setAutoextend("OFF");
                }
            }
        }
    }

    private String getMeasureUnit(String string, String string2) {
        String string3 = string.toUpperCase();
        if (string3.endsWith("K")) {
            return "K";
        }
        if (string3.endsWith("M")) {
            return "M";
        }
        string3 = Token.getTokenAfter(string2, string).toUpperCase();
        if (string3.equals("K") || string3.equals("M")) {
            return string3;
        }
        return "";
    }

    private String getNumberOnly(String string) {
        String string2 = string.toUpperCase();
        if (string2.endsWith("K") || string2.endsWith("M")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void initMinimumExtent() {
        String string;
        if (Token.hasToken(this.statement, "MINIMUM") && "EXTENT".equalsIgnoreCase(Token.getFirstToken(string = Token.getStringAfter(this.statement, "MINIMUM")).trim())) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "EXTENT").trim());
            try {
                int n = Integer.parseInt(string2);
                this.tableSpace.setMinExtLen(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initMinimumExtent : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong MINIMUM format in statement " + this.statement);
            }
        }
    }

    private void initLogging() {
        if (Token.hasToken(this.statement, "NOLOGGING")) {
            this.tableSpace.setLogging("NOLOGGING");
        }
    }

    private void initForceLogging() {
        if (this.statement.toUpperCase().indexOf("FORCE LOGGING") > -1) {
            this.tableSpace.setForceLogging("YES");
        }
    }

    private void initStatus() {
        if (Token.hasToken(this.statement, "OFFLINE")) {
            this.tableSpace.setStatus("OFFLINE");
        }
    }

    private void initContents() {
        if (Token.hasToken(this.statement, "TEMPORARY")) {
            this.tableSpace.setContents("TEMPORARY");
        }
    }

    private void initDefaultStorage() {
        String string;
        if (Token.hasToken(this.statement, "STORAGE") && Token.hasCloseAndOpenBrackets(string = Token.getStringAfter(this.statement, "STORAGE"))) {
            string = Token.getValBetweenBrackets(string, 1).trim();
            this.initInitialExtent(string);
            this.initMinExtents(string);
            this.initNextExtents(string);
            this.initMaxExtents(string);
            this.initPctIncrease(string);
        }
    }

    private void initInitialExtent(String string) {
        if (Token.hasToken(string, "INITIAL")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "INITIAL").trim());
            try {
                long l = Long.parseLong(string2);
                this.tableSpace.setDSInitialExtent(l);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initInitialExtent : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
            }
        }
    }

    private void initMinExtents(String string) {
        if (Token.hasToken(string, "MINEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MINEXTENTS").trim());
            try {
                int n = Integer.parseInt(string2);
                this.tableSpace.setDSMinExtents(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initMinExtents : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
            }
        }
    }

    private void initNextExtents(String string) {
        if (Token.hasToken(string, "NEXT")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "NEXT").trim());
            try {
                long l = Long.parseLong(string2);
                this.tableSpace.setDSNextExtent(l);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initNextExtents : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
            }
        }
    }

    private void initMaxExtents(String string) {
        if (Token.hasToken(string, "MAXEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MAXEXTENTS").trim());
            this.tableSpace.setDSMaxExtents(string2);
        }
    }

    private void initPctIncrease(String string) {
        if (Token.hasToken(string, "PCTINCREASE")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "PCTINCREASE").trim());
            try {
                int n = Integer.parseInt(string2);
                this.tableSpace.setDSPctIncrease(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initPctIncrease : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
            }
        }
    }

    private void initExtManagement() {
        int n = this.statement.toUpperCase().indexOf("EXTENT MANAGEMENT");
        if (n > -1) {
            String string = this.statement.substring(n + 17).trim();
            if (Token.getFirstToken(string).equalsIgnoreCase("LOCAL")) {
                this.tableSpace.setExtentManagement("LOCAL");
                String string2 = Token.getTokenAfter(string, "LOCAL").trim();
                if (string2.equalsIgnoreCase("UNIFORM")) {
                    this.tableSpace.setEMLocalSubtype("UNIFORM");
                    String string3 = this.getNumberOnly(Token.getTokenAfter(string, "SIZE").trim());
                    if (!string3.equals("")) {
                        try {
                            int n2 = Integer.parseInt(string3);
                            this.tableSpace.setEMUniformSize(n2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initExtManagement : " + numberFormatException.getMessage());
                            this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                        }
                    }
                }
            } else if (Token.getFirstToken(string).equalsIgnoreCase("DICTIONARY")) {
                this.tableSpace.setExtentManagement("DICTIONARY");
            }
        }
    }

    private void initSegmentManagement() {
        int n = this.statement.toUpperCase().indexOf("SEGMENT SPACE MANAGEMENT");
        if (n > -1) {
            String string = this.statement.substring(n + 24).trim();
            this.tableSpace.setSegmentManagement(Token.getFirstToken(string));
        }
    }
}

