/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHColumnElementsOraclev9i;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class SHCreateTableOraclev9i
extends DDLStatementHandler
implements SectionConstants,
CreateTableHandler {
    private Table table = null;
    private RDBMSSite site = null;
    private StorageDesignOraclev9i storageDesign = null;
    private TableProxyOraclev9i tableProxy = null;
    private boolean createDomainsDuringImport;
    private String tableName;
    private ArrayList columns;
    protected List fkList;
    protected List refAtColumnList;
    protected List tableNodeList = new ArrayList();
    private String outSideBrackets;
    private String inSideBrackets;
    private String userName;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateTableOraclev9i.class);
    private final String[] colPropsStartWords = new String[]{"COLUMN", "NESTED TABLE", "VARRAY", "XMLTYPE"};

    public SHCreateTableOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        block5: {
            String string2 = SHCreateTableOraclev9i.clearCR(string);
            if ((Token.startsWithString(string2, "create table") || Token.startsWithString(string2, "create global temporary table")) && string2.toLowerCase().indexOf("organization external") == -1) {
                try {
                    this.fkList = new ArrayList();
                    this.refAtColumnList = new ArrayList();
                    this.parseTable(string2);
                    FKRefNode fKRefNode = new FKRefNode();
                    fKRefNode.processedTable = this.table;
                    fKRefNode.fkStatements = this.fkList;
                    fKRefNode.refAtColumns = this.refAtColumnList;
                    this.tableNodeList.add(fKRefNode);
                    if (this.failed) {
                        this.importLog.addFailedStatement(SHCreateTableOraclev9i.FormatCR(string, "\n"));
                        break block5;
                    }
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception exception) {
                    LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                    this.importLog.addFailedStatement(SHCreateTableOraclev9i.FormatCR(string, "\n"));
                }
            } else {
                this.nextHandler(string);
            }
        }
    }

    public void parseTable(String string) {
        Object object;
        int n;
        this.setStatement(string);
        this.tableName = this.initTableName();
        this.table = this.design.getRelationalDesign().createTable();
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(this.site);
        this.tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.initUser();
        this.table.setName(this.tableName);
        this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        this.createDomainsDuringImport = this.design.getAppView().getSettings().isCreateDomainsDuringImport();
        String string2 = Token.getStringAfterToken(string, "OF").trim();
        String string3 = null;
        if ("".equalsIgnoreCase(string2)) {
            this.inSideBrackets = Token.getValBetweenBrackets(this.statement, 1).trim();
            this.outSideBrackets = Token.getValAfterBrackets(this.statement, 1).trim();
        } else {
            this.inSideBrackets = "";
            string3 = Token.getFirstToken(string2);
            this.outSideBrackets = Token.cutTokenFromFront(string2, string3);
        }
        boolean bl = false;
        if (string3 != null) {
            n = string3.indexOf(46);
            if (n > 0) {
                string3 = Token.getValAfterCharacter(string3, '.');
            }
            if (string3.startsWith("\"")) {
                string3 = Token.getValBetweenDoubleQuotes(string3);
            }
            if ((object = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string3)) != null) {
                this.table.setBasedOnStructuredType((StructuredType)object);
                bl = true;
                if (this.tableProxy.getIndexes().size() > 0) {
                    this.tableProxy.getIndexes().removeAll();
                }
            } else {
                LOGGER.error("Unable to find required Structured Type: " + string3);
            }
        }
        if (bl) {
            ModelIDObject modelIDObject;
            String string4;
            String string5;
            String string6 = Token.getValBetweenBrackets(string, 1);
            if (string6.length() > 0) {
                object = new StringTokenizer(string6, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string5 = Token.trimLeft(((StringTokenizer)object).nextToken());
                    string4 = Token.getFirstToken(string5);
                    int n2 = (string5 = string5.toUpperCase()).indexOf(" NOT ");
                    if (n2 < 0 || !string5.substring(n2 + 5).trim().startsWith("NULL") || (modelIDObject = (Column)this.table.getElementByName(string4)) == null) continue;
                    ((ContainedObject)modelIDObject).setNullsAllowed(false);
                }
            }
            if (Token.hasString(string.toUpperCase(), "OBJECT IDENTIFIER IS") && ((String)(object = Token.getStringAfter(string, "OBJECT IDENTIFIER IS"))).toUpperCase().startsWith("SYSTEM GENERATED")) {
                this.table.setUserDefinedOid(false);
            }
            if (Token.hasToken(string, "OIDINDEX")) {
                object = Token.getStringAfterToken(string, "OIDINDEX");
                string5 = Token.getTokenAfter((String)object, "OIDINDEX");
                if (!"".equalsIgnoreCase(string5 = Token.getStringBefore(string5, "(").trim())) {
                    // empty if block
                }
            }
            if ("XMLTYPE".equalsIgnoreCase(string3)) {
                if (Token.hasString(string.toUpperCase(), "XMLTYPE STORE AS")) {
                    object = Token.getStringAfter(string, "XMLTYPE STORE AS");
                    string5 = Token.getFirstToken((String)object);
                    if (string5.equalsIgnoreCase("OBJECT")) {
                        this.tableProxy.setStoreAs("OBJECT RELATIONAL");
                    } else if (string5.equalsIgnoreCase("CLOB")) {
                        String string7;
                        this.tableProxy.setStoreAs("CLOB");
                        string4 = Token.getValBetweenBrackets((String)object, 1);
                        if (Token.hasToken(string4, "TABLESPACE") && !(string7 = Token.getQuotedNameAfterToken(string4, "TABLESPACE")).equals("")) {
                            modelIDObject = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string7);
                            if (modelIDObject == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                                modelIDObject = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)modelIDObject).setName(string7);
                                this.design.getRelationalDesign().stampModelObjectDDL(modelIDObject);
                            }
                            if (modelIDObject != null) {
                                this.tableProxy.setXmlTypeTableSpace((TableSpaceOracle)modelIDObject);
                            }
                        }
                        if (Token.hasToken(string4, "CHUNK")) {
                            try {
                                int n3 = Integer.parseInt(Token.getTokenAfter(string4, "CHUNK").trim());
                                this.tableProxy.setChunk(n3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHCreateTableOracle.parseTable : " + numberFormatException.getMessage());
                                this.importLog.addWarning("Wrong CHUNK format in statement " + string);
                            }
                        }
                        if (Token.hasToken(string4, "PCTVERSION")) {
                            try {
                                this.tableProxy.setOldVersions(ColumnProxyOraclev9i.getOldVersionChoices()[1]);
                                int n4 = Integer.parseInt(Token.getTokenAfter(string4, "PCTVERSION").trim());
                                this.tableProxy.setPCTVersion(n4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHCreateTableOracle.parseTable : " + numberFormatException.getMessage());
                                this.importLog.addWarning("Wrong PCTVERSION format in statement " + string);
                            }
                        } else if (Token.hasToken(string4, "RETENTION")) {
                            this.tableProxy.setOldVersions("RETENTION");
                        }
                        if (Token.hasToken(string4, "FREEPOOLS")) {
                            try {
                                int n5 = Integer.parseInt(Token.getTokenAfter(string4, "FREEPOOLS").trim());
                                this.tableProxy.setFreepools(n5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHCreateTableOracle.parseTable : ", numberFormatException);
                                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + string);
                            }
                        }
                        if (Token.hasString(string4.toUpperCase(), "STORAGE IN ROW")) {
                            String string8 = Token.getTokenBefore(string4, "STORAGE IN ROW");
                            this.tableProxy.setStorageInRow(string8);
                        }
                        if (Token.hasToken(string4, "CACHE")) {
                            if (Token.hasString(string4.toUpperCase(), "CACHE READS")) {
                                this.tableProxy.setXmlTypeCache("CACHE READS");
                            } else {
                                this.tableProxy.setXmlTypeCache("CACHE");
                            }
                        } else if (Token.hasToken(string4, "NOCACHE")) {
                            this.tableProxy.setXmlTypeCache("NOCACHE");
                        }
                        if (Token.hasToken(string4, "NOLOGGING")) {
                            this.tableProxy.setXmlTypeLogging("NO");
                        } else if (Token.hasToken(string4, "LOGGING")) {
                            this.tableProxy.setXmlTypeLogging("YES");
                        }
                    }
                }
                if (Token.hasToken(string, "ELEMENT")) {
                    object = "";
                    string5 = Token.getQuotedNameAfterToken(string, "ELEMENT");
                    int n6 = string5.indexOf(35);
                    if (n6 > -1) {
                        object = string5.substring(0, n6);
                        string5 = string5.substring(n6 + 1);
                    } else if (Token.hasToken(string, "XMLSCHEMA")) {
                        object = Token.getQuotedNameAfterToken(string, "XMLSCHEMA");
                    }
                    this.tableProxy.setXmlSchemaUrl((String)object);
                    this.tableProxy.setXmlSchemaElement(string5);
                }
            }
        }
        if (!bl) {
            this.columns = this.initColumns();
            for (n = 0; n < this.columns.size(); ++n) {
                TableProxyOracle tableProxyOracle;
                String string9;
                boolean bl2;
                String string10;
                TableCheckConstraintOracle tableCheckConstraintOracle;
                Object object2;
                object = (Map)this.columns.get(n);
                boolean bl3 = (Boolean)object.get("IS_CONSTRAINT");
                if (!bl3) {
                    this.initCol((Map)object);
                    continue;
                }
                boolean bl4 = (Boolean)object.get("PRIMARY KEY");
                if (bl4) {
                    this.initPrimaryKey((Map)object);
                    continue;
                }
                boolean bl5 = (Boolean)object.get("UNIQUE");
                if (bl5) {
                    this.initUniqueKey((Map)object);
                    continue;
                }
                boolean bl6 = (Boolean)object.get("HAS_CHECK_CONSTRAINT");
                if (!bl6) continue;
                String string11 = (String)object.get("CHECK_CONSTRAINT");
                String string12 = (String)object.get("CHECK");
                if (string11.equals("")) {
                    object2 = this.tableName;
                    if (((String)object2).length() > 24) {
                        object2 = ((String)object2).substring(0, 24);
                    }
                    string11 = "SYS_" + (String)object2 + this.table.getCheckConstraints().size();
                }
                object2 = this.table.createCheckConstraint(string11, string12);
                ((DesignObject)object2).setName(string11);
                this.table.addCheckConstraint((TableLevelConstraint)object2);
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                if (this.tableProxy == null || (tableCheckConstraintOracle = this.tableProxy.getTableConstraint((TableLevelConstraint)object2)) == null) continue;
                if (object.get("CHK_DEFERRABLE") != null) {
                    boolean bl7 = (Boolean)object.get("CHK_DEFERRABLE");
                    tableCheckConstraintOracle.setDeferrable(bl7 ? "YES" : "NO");
                }
                if ((string10 = (String)object.get("CHK_INITIALLY")) != null) {
                    tableCheckConstraintOracle.setInitially(string10);
                }
                if (object.get("CHK_DISABLE") != null) {
                    bl2 = (Boolean)object.get("CHK_DISABLE");
                    tableCheckConstraintOracle.setEnable(bl2 ? "NO" : "YES");
                }
                if (object.get("CHK_NOVALIDATE") != null) {
                    bl2 = (Boolean)object.get("CHK_NOVALIDATE");
                    tableCheckConstraintOracle.setValidate(bl2 ? "NO" : "YES");
                }
                if ((string9 = (String)object.get("CHK_EXCEPTIONS")) == null || (tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(string9)) == null) continue;
                tableCheckConstraintOracle.setExceptionsTable(tableProxyOracle);
            }
        }
        if (this.tableProxy != null) {
            int n7;
            this.tableProxy.setNameHasQuotes(this.nameHasQuotes());
            this.initTemporary();
            this.initOnCommit();
            String string13 = this.outSideBrackets;
            if (Token.hasToken(this.outSideBrackets, "PARTITION")) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "PARTITION");
            }
            object = this.outSideBrackets;
            if (Token.hasToken(this.outSideBrackets, "LOB")) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "LOB");
            }
            if (Token.hasToken(this.outSideBrackets, "XMLTYPE") && !"XMLTYPE".equalsIgnoreCase(string3)) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "XMLTYPE");
            }
            if (Token.hasToken(this.outSideBrackets, "VARRAY")) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "VARRAY");
            }
            if (this.outSideBrackets.toUpperCase().indexOf("NESTED TABLE") > -1) {
                this.outSideBrackets = Token.getStringBefore(this.outSideBrackets, "NESTED TABLE");
            }
            if (this.outSideBrackets.length() < string13.length() && (n7 = string13.lastIndexOf(")")) > -1) {
                this.outSideBrackets = this.outSideBrackets + ' ' + string13.substring(n7 + 1).trim();
            }
            if (Token.hasToken(this.outSideBrackets, "CLUSTER")) {
                this.initCluster();
            } else {
                boolean bl8 = false;
                if (Token.hasToken(this.outSideBrackets, "ORGANIZATION")) {
                    String string14 = Token.getTokenAfter(this.outSideBrackets, "ORGANIZATION");
                    if (string14.equalsIgnoreCase("HEAP")) {
                        this.tableProxy.setOrganization("HEAP");
                    } else if (string14.equalsIgnoreCase("INDEX")) {
                        this.tableProxy.setOrganization("INDEX");
                        this.initIndexOrganizedTable();
                        bl8 = true;
                    }
                }
                if (!bl8) {
                    this.initTableSpace();
                    this.initSegment(this.outSideBrackets);
                    this.initCompression();
                }
            }
            this.initCache();
            this.outSideBrackets = object;
            this.initTableLobStorages();
            this.initColumnlProperties(this.outSideBrackets);
            this.outSideBrackets = string13;
            this.initPartitions();
            this.initParallel();
            this.initMonitoring();
            this.initRowDependency();
            this.initRowMovement();
        }
    }

    private void initColumnlProperties(String string) {
        String string2 = Token.getStringToFirstMatch(string.toUpperCase(), this.colPropsStartWords);
        String string3 = string.substring(string2.length()).trim();
        while (string3.length() > 0) {
            String string4 = Token.getFirstToken(string3);
            if (string4.equalsIgnoreCase("NESTED") && string3.toUpperCase().startsWith("NESTED TABLE")) {
                string4 = "NESTED TABLE";
            }
            String string5 = string4;
            if (string4.equalsIgnoreCase("XMLTYPE") && string3.toUpperCase().startsWith("XMLTYPE COLUMN")) {
                string5 = "XMLTYPE COLUMN";
            }
            string3 = string3.substring(string5.length()).trim();
            String string6 = Token.getStringToFirstMatch(string3.toUpperCase(), this.colPropsStartWords);
            String string7 = string3.substring(0, string6.length());
            string3 = string3.substring(string7.length()).trim();
            if (string4.equalsIgnoreCase("COLUMN")) {
                this.initSubstitutableColumnClause(string7);
                continue;
            }
            if (string4.equalsIgnoreCase("NESTED TABLE") || string4.equalsIgnoreCase("VARRAY")) {
                this.parseLine(string7);
                continue;
            }
            if (!string4.equalsIgnoreCase("XMLTYPE")) continue;
            this.parseXmlTypeColumnProperties(string7);
        }
    }

    private void parseXmlTypeColumnProperties(String string) {
        ColumnProxyOraclev9i columnProxyOraclev9i;
        String string2 = Token.getFirstName(string, '\"', '\"');
        if (string2 != null && (columnProxyOraclev9i = (ColumnProxyOraclev9i)this.tableProxy.getColumnProxyByName(string2)) != null) {
            String string3;
            String string4;
            if (Token.hasString(string.toUpperCase(), "STORE AS")) {
                string4 = Token.getStringAfter(string, "STORE AS");
                string3 = Token.getFirstToken(string4);
                if (string3.equalsIgnoreCase("OBJECT")) {
                    columnProxyOraclev9i.setStoreAs("OBJECT RELATIONAL");
                } else if (string3.equalsIgnoreCase("CLOB")) {
                    columnProxyOraclev9i.setStoreAs("CLOB");
                    string4 = Token.cutTokenFromFront(string4, "CLOB");
                    if (!string4.equals("")) {
                        if (!string4.startsWith("(")) {
                            string4 = Token.cutFirstToken2(string4);
                        }
                        if (string4.startsWith("(")) {
                            String string5;
                            String string6 = Token.getValBetweenBrackets(string4, 1);
                            if (Token.hasToken(string6, "TABLESPACE") && !(string5 = Token.getQuotedNameAfterToken(string6, "TABLESPACE")).equals("")) {
                                TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string5);
                                if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                                    tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    tableSpaceOraclev9i.setName(string5);
                                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
                                }
                                if (tableSpaceOraclev9i != null) {
                                    columnProxyOraclev9i.setTablespace(tableSpaceOraclev9i);
                                }
                            }
                            this.initXmlTypeStorage(string6, columnProxyOraclev9i);
                        }
                    }
                }
            }
            if (Token.hasToken(string, "ELEMENT")) {
                string4 = "";
                string3 = Token.getQuotedNameAfterToken(string, "ELEMENT");
                int n = string3.indexOf(35);
                if (n > -1) {
                    string4 = string3.substring(0, n);
                    string3 = string3.substring(n + 1);
                } else if (Token.hasToken(string, "XMLSCHEMA")) {
                    string4 = Token.getQuotedNameAfterToken(string, "XMLSCHEMA");
                }
                columnProxyOraclev9i.setXmlSchemaUrl(string4);
                columnProxyOraclev9i.setXmlSchemaElement(string3);
            }
        }
    }

    private void initXmlTypeStorage(String string, ColumnProxyOraclev9i columnProxyOraclev9i) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, null, null, columnProxyOraclev9i);
            this.initNext(string2, null, null, columnProxyOraclev9i);
            this.initPCtIncrease(string2, null, null, columnProxyOraclev9i);
            this.initMinExtents(string2, null, null, columnProxyOraclev9i);
            this.initMaxExtents(string2, null, null, columnProxyOraclev9i);
            this.initFreeLists(string2, null, null, columnProxyOraclev9i);
            this.initFreeListGroups(string2, null, null, columnProxyOraclev9i);
            this.initSegBufferPool(string2, null, null, columnProxyOraclev9i);
        }
        this.initChunk(string, columnProxyOraclev9i);
        this.initRetention(string, columnProxyOraclev9i);
        this.initPctVersion(string, columnProxyOraclev9i);
        this.initFreePools(string, columnProxyOraclev9i);
        this.initStorageInRow(string, columnProxyOraclev9i);
        this.initLSCache(string, columnProxyOraclev9i);
        this.initLogging(string, columnProxyOraclev9i);
    }

    private void initChunk(String string, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "CHUNK")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "CHUNK").trim());
                columnProxyOraclev9i.setChunk(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initChunk : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong CHUNK format in statement " + this.statement);
            }
        }
    }

    private void initRetention(String string, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "RETENTION")) {
            columnProxyOraclev9i.setOldVersions("RETENTION");
        }
    }

    private void initFreePools(String string, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "FREEPOOLS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "FREEPOOLS").trim());
                columnProxyOraclev9i.setFreepools(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initFreePools : ", numberFormatException);
                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + this.statement);
            }
        }
    }

    private void initPctVersion(String string, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "PCTVERSION")) {
            try {
                columnProxyOraclev9i.setOldVersions(ColumnProxyOraclev9i.getOldVersionChoices()[1]);
                int n = Integer.parseInt(Token.getTokenAfter(string, "PCTVERSION").trim());
                columnProxyOraclev9i.setPCTVersion(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initPctVersion : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
            }
        }
    }

    private void initStorageInRow(String string, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasString(string.toUpperCase(), "STORAGE IN ROW")) {
            String string2 = Token.getTokenBefore(string, "STORAGE IN ROW");
            columnProxyOraclev9i.setStorageInRow(string2);
        }
    }

    private void initLSCache(String string, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "CACHE")) {
            if (Token.hasString(string.toUpperCase(), "CACHE READS")) {
                columnProxyOraclev9i.setCache("CACHE READS");
            } else {
                columnProxyOraclev9i.setCache("CACHE");
            }
        } else if (Token.hasToken(string, "NOCACHE")) {
            columnProxyOraclev9i.setCache("NOCACHE");
        }
    }

    private void initLogging(String string, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "NOLOGGING")) {
            columnProxyOraclev9i.setLogging("NO");
        } else if (Token.hasToken(string, "LOGGING")) {
            columnProxyOraclev9i.setLogging("YES");
        } else {
            columnProxyOraclev9i.setLogging("");
        }
    }

    private boolean nameHasQuotes() {
        String string = Token.getStringAfterToken(this.statement, "TABLE").trim();
        return string.startsWith("\"");
    }

    private String initTableName() {
        int n;
        String string = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        if (Token.hasOpenBracket(string)) {
            string = Token.getStringBefore(string, "(");
        }
        if ((n = string.indexOf(46)) > 0) {
            this.userName = Token.getValBeforeCharacter(string, '.');
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void initUser() {
        if (this.userName != null) {
            SchemaObject schemaObject;
            UserSetOracle userSetOracle = this.storageDesign.getUserSet();
            String string = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
            String string2 = Token.getValBeforeCharacter(string, '.');
            UserOracle userOracle = (UserOracle)userSetOracle.getByName(string2);
            SchemaObjectSet schemaObjectSet = ((RelationalDesign)this.table.getDesignPart()).getSchemaObjectSet();
            if (userOracle == null && !string2.trim().equalsIgnoreCase("")) {
                userOracle = userSetOracle.createUser();
                userOracle.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(userOracle);
            }
            if ((schemaObject = (SchemaObject)schemaObjectSet.getByName(string2)) == null && !string2.trim().equalsIgnoreCase("")) {
                schemaObject = schemaObjectSet.createSchemaObject(null);
                schemaObject.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(schemaObject);
            }
            if (userOracle != null) {
                if (userOracle.getSchemaObject() == null) {
                    userOracle.setSchemaObject(schemaObject);
                }
                if (userOracle.getSchemaObject() != schemaObject) {
                    this.tableProxy.setUser(userOracle);
                }
            }
            if (schemaObject != null) {
                this.table.setSchemaObject(schemaObject);
            }
        }
    }

    public static void setColumnsForIndex(Index index, String string, ImportLogger importLogger) throws ObjectDoesNotExistException {
        if (index != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                arrayList.add(Token.removeQuotes(string2).toUpperCase());
            }
            for (String string3 : arrayList) {
                Column column = (Column)index.getTable().getElementByName(string3);
                if (column != null) {
                    index.add(column);
                    continue;
                }
                importLogger.addError("Column for index " + index.getName() + " doesn't exist.");
                throw new ObjectDoesNotExistException("Column");
            }
        }
    }

    private ArrayList initColumns() {
        Object object;
        Object object2;
        Object object3;
        String string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = this.inSideBrackets;
        if (Token.hasToken(string2, "SUPPLEMENTAL")) {
            this.tableProxy.setSuplementalLogGroupName(Token.getTokenAfter(string2, "GROUP"));
            string = Token.getStringAfter(string2, "GROUP");
            object3 = Token.getValBetweenBrackets(string);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = Token.getFirstName(stringTokenizer.nextToken(), '\"', '\"');
                ColumnProxy columnProxy = this.tableProxy.getColumnProxyByName(string3);
                if (columnProxy == null) continue;
                this.tableProxy.setSuplementalLogColumns(columnProxy.getObjectID());
            }
            if (Token.getTokenAfter(string, ")").equalsIgnoreCase("ALWAYS")) {
                this.tableProxy.setSuplementalLogConditions("ALWAYS");
                object2 = Token.getStringAfter(string, "ALWAYS");
            } else {
                object2 = Token.getStringAfter(string, ")");
            }
            object = Token.getStringBeforeToken(string2, "SUPPLEMENTAL").trim();
            if (((String)object).endsWith(",")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            string2 = (String)object + (String)object2;
        }
        object = new SHColumnElementsOraclev9i();
        object2 = new StringTokenizer(string2, ",");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            string = ((StringTokenizer)object2).nextToken();
            if (Token.hasOpenBracket(string)) {
                object3 = new StringBuffer(string);
                while (Token.hasOpenBracket(string) && ((StringTokenizer)object2).hasMoreTokens()) {
                    ((StringBuffer)object3).append(",").append(((StringTokenizer)object2).nextToken());
                    string = ((StringBuffer)object3).toString();
                }
            }
            if (Boolean.TRUE.equals((object3 = ((SHColumnElementsOraclev9i)object).getElementsColumn(string.trim())).get("IS_CONSTRAINT")) && string.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(string);
                continue;
            }
            arrayList.add(object3);
        }
        return arrayList;
    }

    private void initCol(Map map) {
        Object v;
        boolean bl;
        boolean bl2;
        CharSequence charSequence;
        ModelIDObject modelIDObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        String string2 = (String)map.get("columnname");
        Column column = this.table.createColumn(string2);
        this.design.getRelationalDesign().stampModelObjectDDL(column);
        String string3 = (String)map.get("datatype");
        if (string3 != null) {
            string = (String)map.get("scale");
            String string4 = (String)map.get("size");
            object5 = (String)map.get("precision");
            object4 = new String[]{object5, string, string4};
            object3 = StandardDatatypeNames.getUsedDatatypeName(string3);
            object3 = StandardDatatypeNames.getTransformedDatatypeName((String)object3, this.getStorageDesign().getRDBMSType());
            object2 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object3);
            if (this.createDomainsDuringImport) {
                object = DomainFactory.createDomainName((LogicalDatatype)object2, (String[])object4);
                modelIDObject = this.getCorrespondingDomain((String)object);
                if (modelIDObject != null) {
                    column.setDomain((Domain)modelIDObject);
                } else {
                    charSequence = new StringBuffer("domain is null in SHCreateTableOracle.parseTable : ");
                    charSequence.append((String)object);
                    LOGGER.error(charSequence.toString());
                    this.importLog.addError("Null domain occurred while creating " + this.tableName);
                }
            } else {
                column.setLogicalDatatype((LogicalDatatype)object2);
                column.setUse((short)1);
                column.setDataTypeParameter("scale", string);
                column.setDataTypeParameter("precision", (String)object5);
                column.setDataTypeParameter("size", string4);
            }
        } else {
            string = (String)map.get(NameElements.COL_STRUCTURED_TYPE);
            if (string != null && !"".equalsIgnoreCase(string)) {
                boolean bl3 = Token.hasToken(string, "REF");
                int n = (string = bl3 ? Token.getQuotedNameAfterToken(string, "REF") : Token.getFirstName(string, '\"', '\"')).indexOf(46);
                if (n > 0) {
                    string = Token.getValAfterCharacter(string, '.');
                }
                if ((object4 = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string)) != null) {
                    column.setStructuredType((StructuredType)object4);
                    column.setUse((short)3);
                    if (bl3) {
                        column.setReference(true);
                    }
                }
                if ((object3 = (CollectionType)this.design.getDataTypesDesign().getCollectionTypeSet().getByName(string)) != null) {
                    column.setCollectionType((CollectionType)object3);
                    column.setUse((short)4);
                }
                if ((object2 = (DistinctType)this.design.getDataTypesDesign().getDistinctTypeSet().getByName(string)) != null) {
                    column.setDistinctType((DistinctType)object2);
                    column.setUse((short)2);
                }
            }
        }
        boolean bl4 = (Boolean)map.get("NOT NULL");
        column.setNullsAllowed(!bl4);
        boolean bl5 = (Boolean)map.get("PRIMARY KEY");
        if (bl5) {
            object5 = this.table.createIndex();
            ((Index)object5).add(column);
            ((KeyObject)object5).makePK();
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
        } else {
            boolean bl6 = (Boolean)map.get("UNIQUE");
            if (bl6) {
                object4 = this.table.createIndex();
                ((Index)object4).add(column);
                ((Index)object4).setIndexState("Unique Constraint");
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object4);
            }
        }
        if (bl4) {
            String string5 = (String)map.get("NN_CONSTRAINT_NAME");
            if (string5 != null && !string5.startsWith("SYS_C")) {
                column.setNotNullConstraintName(string5);
            }
            if (this.storageDesign != null && (object4 = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID())) != null) {
                if (map.get("NN_DEFERRABLE") != null) {
                    boolean bl7 = (Boolean)map.get("NN_DEFERRABLE");
                    ((ColumnProxyOracle)object4).setNncDeferrable(bl7 ? "YES" : "NO");
                }
                if ((object3 = (String)map.get("NN_INITIALLY")) != null) {
                    ((ColumnProxyOracle)object4).setNncInitially((String)object3);
                }
                if (map.get("NN_RELY") != null) {
                    boolean bl8 = (Boolean)map.get("NN_RELY");
                    ((ColumnProxyOracle)object4).setNncRely(bl8 ? "NO" : "YES");
                }
                if (map.get("NN_DISABLE") != null) {
                    boolean bl9 = (Boolean)map.get("NN_DISABLE");
                    ((ColumnProxyOracle)object4).setNncEnable(bl9 ? "NO" : "YES");
                }
                if (map.get("NN_NOVALIDATE") != null) {
                    boolean bl10 = (Boolean)map.get("NN_NOVALIDATE");
                    ((ColumnProxyOracle)object4).setNncValidate(bl10 ? "NO" : "YES");
                }
                if ((object2 = (String)map.get("NN_EXCEPTIONS")) != null && (object = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName((String)object2)) != null) {
                    ((ColumnProxyOracle)object4).setNncExceptionsTable((TableProxyOracle)object);
                }
            }
        }
        if ((bl2 = ((Boolean)map.get("IS DEFAULT")).booleanValue()) && !"".equalsIgnoreCase((String)(object4 = (String)map.get("DEFAULT")))) {
            if (((String)object4).startsWith("'") || ((String)object4).toUpperCase().startsWith("N'") || ((String)object4).toUpperCase().startsWith("Q'") || ((String)object4).toUpperCase().startsWith("NQ'") || ((String)object4).startsWith("\"") || ((String)object4).equalsIgnoreCase("NULL") || ((String)object4).indexOf("(") > -1 || ((String)object4).equalsIgnoreCase("CURRENT_DATE") || ((String)object4).equalsIgnoreCase("CURRENT_TIMESTAMP") || ((String)object4).equalsIgnoreCase("DBTIMEZONE") || ((String)object4).equalsIgnoreCase("LOCALTIMESTAMP") || ((String)object4).equalsIgnoreCase("SESSIONTIMEZONE") || ((String)object4).equalsIgnoreCase("SYSDATE") || ((String)object4).equalsIgnoreCase("SYSTIMESTAMP") || ((String)object4).equalsIgnoreCase("UID") || ((String)object4).equalsIgnoreCase("USER")) {
                column.setDefaultValue((String)object4);
            } else {
                try {
                    Double.parseDouble((String)object4);
                    column.setDefaultValue((String)object4);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Bad default value for column " + column.getLongName());
                }
            }
        }
        if ((object4 = (String)map.get("REFERENCES")) != null) {
            object3 = new RefAtColNode();
            int n = ((String)object4).indexOf(46);
            if (n > 0) {
                object4 = Token.getValAfterCharacter((String)object4, '.');
            }
            ((RefAtColNode)object3).onDelete = (String)map.get("ON DELETE");
            ((RefAtColNode)object3).columnName = (String)map.get("columnname");
            ((RefAtColNode)object3).refColumn = (String)map.get("REFERENCED_COLUMN");
            ((RefAtColNode)object3).referencedTable = object4;
            ((RefAtColNode)object3).constraintName = (String)map.get("CONSTRAINT_NAME");
            this.refAtColumnList.add(object3);
        }
        if (bl = ((Boolean)map.get("HAS_CHECK_CONSTRAINT")).booleanValue()) {
            String string6 = (String)map.get("CHECK_CONSTRAINT");
            object = (String)map.get("CHECK");
            if (object != null) {
                this.initCheckConstraint((String)object, string6, column);
                if (this.storageDesign != null && (modelIDObject = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID())) != null) {
                    TableProxyOracle tableProxyOracle;
                    String string7;
                    boolean bl11;
                    if (map.get("CHK_DEFERRABLE") != null) {
                        boolean bl12 = (Boolean)map.get("CHK_DEFERRABLE");
                        ((ColumnProxyOracle)modelIDObject).setDeferrable(bl12 ? "YES" : "NO");
                    }
                    if ((charSequence = (String)map.get("CHK_INITIALLY")) != null) {
                        ((ColumnProxyOracle)modelIDObject).setInitially((String)charSequence);
                    }
                    if (map.get("CHK_DISABLE") != null) {
                        bl11 = (Boolean)map.get("CHK_DISABLE");
                        ((ColumnProxyOracle)modelIDObject).setEnable(bl11 ? "NO" : "YES");
                    }
                    if (map.get("CHK_NOVALIDATE") != null) {
                        bl11 = (Boolean)map.get("CHK_NOVALIDATE");
                        ((ColumnProxyOracle)modelIDObject).setValidate(bl11 ? "NO" : "YES");
                    }
                    if ((string7 = (String)map.get("CHK_EXCEPTIONS")) != null && (tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(string7)) != null) {
                        ((ColumnProxyOracle)modelIDObject).setExceptionsTable(tableProxyOracle);
                    }
                }
            }
        }
        if ((v = map.get("WITH ROWID")) != null && (object = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID())) != null) {
            ((ColumnProxyOracle)object).setWithRowId("YES");
        }
    }

    private void initPrimaryKey(Map map) {
        if (this.storageDesign != null) {
            CharSequence charSequence;
            Object object;
            Object object2;
            String string = (String)map.get("PKUK_CONSTRAINT_NAME");
            Index index = this.table.createIndex();
            if (string != null) {
                if ("".equals(string)) {
                    object2 = this.table.getDesign().getDLSettings().getNamingStandardRule();
                    object = this.table.getName();
                    charSequence = this.table.getAbbreviation();
                    if (charSequence == null || "".equals(charSequence)) {
                        charSequence = object;
                    }
                    string = ApplyNamingStandards.createPK_Name((String)object, (NamingStandardRule)object2, this.table.getDesignPart().getName(), (String)charSequence);
                }
                index.setName(string);
            }
            object2 = (String)map.get("VALUES");
            try {
                SHCreateTableOraclev9i.setColumnsForIndex(index, (String)object2, this.importLog);
                index.makePK();
                this.design.getRelationalDesign().stampModelObjectDDL(index);
            }
            catch (ObjectDoesNotExistException objectDoesNotExistException) {
                charSequence = new StringBuffer(objectDoesNotExistException.getMessage());
                ((StringBuffer)charSequence).append(" in SHCreateTableOracle.SetPK");
                LOGGER.error(((StringBuffer)charSequence).toString());
                this.importLog.addError("Columns for primary key " + index.getName() + " don't exist.");
                this.failed = true;
            }
            if (index != null) {
                object = (PKProxyOraclev9i)this.storageDesign.getPKProxySet().getProxy(index.getObjectID());
                boolean bl = (Boolean)map.get("IS_PK_CONSTRAINT");
                if (bl && object != null) {
                    boolean bl2;
                    TableProxyOracle tableProxyOracle;
                    String string2;
                    boolean bl3;
                    String string3;
                    if (map.get("PKUK_DEFERRABLE") != null) {
                        boolean bl4 = (Boolean)map.get("PKUK_DEFERRABLE");
                        ((PKProxyOracle)object).setDeferrable(bl4 ? "YES" : "NO");
                    }
                    if ((string3 = (String)map.get("PKUK_INITIALLY")) != null) {
                        ((PKProxyOracle)object).setInitially(string3);
                    }
                    if (map.get("PKUK_DISABLE") != null) {
                        bl3 = (Boolean)map.get("PKUK_DISABLE");
                        ((PKProxyOracle)object).setEnable(bl3 ? "NO" : "YES");
                    }
                    if (map.get("PKUK_NOVALIDATE") != null) {
                        bl3 = (Boolean)map.get("PKUK_NOVALIDATE");
                        ((PKProxyOracle)object).setValidate(bl3 ? "NO" : "YES");
                    }
                    if ((string2 = (String)map.get("PKUK_EXCEPTIONS")) != null && (tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(string2)) != null) {
                        ((PKProxyOracle)object).setExceptionsTable(tableProxyOracle);
                    }
                    if (bl2 = ((Boolean)map.get("USING INDEX")).booleanValue()) {
                        Object object3;
                        Object object4;
                        Object object5;
                        Object object6;
                        String string4;
                        String string5;
                        AbstractStorageObjectOracle abstractStorageObjectOracle;
                        ((PKProxyOraclev9i)object).setUsingIndex("BY INDEX NAME");
                        if (map.get("BY CREATE INDEX STATEMENT") != null) {
                            ((PKProxyOraclev9i)object).setUsingIndex("BY CREATE INDEX STATEMENT");
                            ((PKProxyOraclev9i)object).setCreateIndexStatement((String)map.get("BY CREATE INDEX STATEMENT"));
                        } else if (map.get("GLOBAL") != null && ((Boolean)map.get("GLOBAL")).booleanValue()) {
                            abstractStorageObjectOracle = (IndexGlobalPartitionsListOraclev9i)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                            this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                            ((PKProxyOraclev9i)object).setIndexGlobalPL((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle);
                            ((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).setIndex((IndexProxy)object);
                            ((PKProxyOraclev9i)object).setUsingIndex("GLOBAL PARTITIONED");
                            string5 = (String)map.get("COLUMN_LIST");
                            ((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).setGlobalPartColumns(((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).columnNamesToColumnIDs(string5));
                            string4 = (String)map.get("PARTITIONS");
                            object6 = new StringTokenizer(string4, ",");
                            while (((StringTokenizer)object6).hasMoreTokens()) {
                                String string6 = ((StringTokenizer)object6).nextToken();
                                if (Token.hasOpenBracket(string6)) {
                                    while (Token.hasOpenBracket(string6) && ((StringTokenizer)object6).hasMoreTokens()) {
                                        string6 = string6 + "," + ((StringTokenizer)object6).nextToken();
                                    }
                                }
                                object5 = (IndexGlobalPartitionOraclev9i)this.storageDesign.getIndexGlobalPartitionSet().createIndexGlobalPartition();
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                                object4 = Token.getQuotedNameAfterToken(string6, "PARTITION").trim();
                                ((StorageObject)object5).setName((String)object4);
                                ((IndexGlobalPartitionOracle)object5).setIndexGlobalPartList((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle);
                                object3 = Token.getValBetweenBrackets(string6, 1).trim();
                                ((IndexGlobalPartitionOracle)object5).setValueList((String)object3);
                                if (Token.hasToken(string6, "TABLESPACE")) {
                                    String string7 = Token.getQuotedNameAfterToken(string6, "TABLESPACE");
                                    TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string7);
                                    if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                                        tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        tableSpaceOraclev9i.setName(string7);
                                        this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
                                    }
                                    if (tableSpaceOraclev9i != null) {
                                        ((IndexGlobalPartitionOracle)object5).setTableSpace(tableSpaceOraclev9i);
                                    }
                                }
                                if (Token.hasToken(string6, "NOLOGGING")) {
                                    ((IndexGlobalPartitionOracle)object5).setLogging("NO");
                                    continue;
                                }
                                if (Token.hasToken(string6, "LOGGING")) {
                                    ((IndexGlobalPartitionOracle)object5).setLogging("YES");
                                    continue;
                                }
                                ((IndexGlobalPartitionOracle)object5).setLogging("");
                            }
                        } else if (map.get("LOCAL") != null && ((Boolean)map.get("LOCAL")).booleanValue()) {
                            ((PKProxyOraclev9i)object).setUsingIndex("LOCAL PARTITIONED");
                        }
                        if (!((PKProxyOraclev9i)object).getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                            abstractStorageObjectOracle = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment();
                            this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                            string5 = (String)map.get("PCTFREE");
                            if (!"".equalsIgnoreCase(string5)) {
                                try {
                                    int n = Integer.parseInt(string5);
                                    ((SegmentOracle)abstractStorageObjectOracle).setPCTFree(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string4 = (String)map.get("INITRANS"))) {
                                try {
                                    int n = Integer.parseInt(string4);
                                    ((SegmentOracle)abstractStorageObjectOracle).setInitrans(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase((String)(object6 = (String)map.get("MAXTRANS")))) {
                                try {
                                    int n = Integer.parseInt((String)object6);
                                    ((SegmentOracle)abstractStorageObjectOracle).setMaxTrans(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            boolean bl5 = false;
                            if (map.get("STORAGE") != null) {
                                bl5 = (Boolean)map.get("STORAGE");
                            }
                            if (bl5) {
                                String string8;
                                String string9;
                                String string10;
                                String string11;
                                object5 = (String)map.get("INITIAL");
                                if (!"".equalsIgnoreCase((String)object5)) {
                                    try {
                                        long l = Long.parseLong((String)object5);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCInitialExtent(l);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase((String)(object4 = (String)map.get("NEXT")))) {
                                    try {
                                        long l = Long.parseLong((String)object4);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCNextExtent(l);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase((String)(object3 = (String)map.get("PCTINCREASE")))) {
                                    try {
                                        int n = Integer.parseInt((String)object3);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCPctIncrease(n);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(string11 = (String)map.get("MINEXTENTS"))) {
                                    try {
                                        int n = Integer.parseInt(string11);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCMinExtents(n);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(string10 = (String)map.get("MAXEXTENTS"))) {
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCMaxExtents(string10);
                                }
                                if (!"".equalsIgnoreCase(string9 = (String)map.get("FREELISTS"))) {
                                    try {
                                        int n = Integer.parseInt(string9);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCFreeLists(n);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(string8 = (String)map.get("GROUPS"))) {
                                    try {
                                        int n = Integer.parseInt(string8);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCFreelistGroups(n);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                String string12 = (String)map.get("BUFFER_POOL");
                                if (!"".equalsIgnoreCase(string8)) {
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCBufferPool(string12);
                                }
                            }
                            if ((object5 = (String)map.get("TABLESPACE")) != null && !((String)object5).equals("")) {
                                object4 = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName((String)object5);
                                if (object4 == null && !"SYSTEM".equalsIgnoreCase((String)object5)) {
                                    object4 = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    ((TableSpaceOracle)object4).setName((String)object5);
                                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object4);
                                }
                                if (object4 != null) {
                                    ((PKProxyOracle)object).setTableSpace((TableSpaceOracle)object4);
                                }
                            }
                            if ((object4 = (String)map.get("LOGGING")) == null) {
                                object4 = "";
                            }
                            ((PKProxyOracle)object).setLogging((String)object4);
                            object3 = this.storageDesign.getSegmentSet().findEqual((SegmentOracle)abstractStorageObjectOracle);
                            ((PKProxyOracle)object).setIndexSegment((SegmentOracle)object3);
                        }
                    }
                }
            }
        }
    }

    private void initUniqueKey(Map map) {
        if (this.storageDesign != null) {
            UniqueOraclev9i uniqueOraclev9i;
            CharSequence charSequence;
            String string = (String)map.get("PKUK_CONSTRAINT_NAME");
            Index index = this.table.createIndex();
            if (string != null) {
                index.setName(string);
            }
            String string2 = (String)map.get("VALUES");
            try {
                SHCreateTableOraclev9i.setColumnsForIndex(index, string2, this.importLog);
                index.setIndexState("Unique Constraint");
                this.design.getRelationalDesign().stampModelObjectDDL(index);
            }
            catch (ObjectDoesNotExistException objectDoesNotExistException) {
                charSequence = new StringBuffer(objectDoesNotExistException.getMessage());
                charSequence.append(" in SHCreateTableOracle.SetUnique");
                LOGGER.error(charSequence.toString());
                this.importLog.addError("Columns for unique key " + index.getName() + " don't exist.");
                this.failed = true;
            }
            if (index != null && (uniqueOraclev9i = (UniqueOraclev9i)this.storageDesign.getUniqueSet().getProxy(index.getObjectID())) != null) {
                boolean bl;
                TableProxyOracle tableProxyOracle;
                String string3;
                boolean bl2;
                if (map.get("PKUK_DEFERRABLE") != null) {
                    boolean bl3 = (Boolean)map.get("PKUK_DEFERRABLE");
                    uniqueOraclev9i.setDeferrable(bl3 ? "YES" : "NO");
                }
                if ((charSequence = (String)map.get("PKUK_INITIALLY")) != null) {
                    uniqueOraclev9i.setInitially((String)charSequence);
                }
                if (map.get("PKUK_DISABLE") != null) {
                    bl2 = (Boolean)map.get("PKUK_DISABLE");
                    uniqueOraclev9i.setEnable(bl2 ? "NO" : "YES");
                }
                if (map.get("PKUK_NOVALIDATE") != null) {
                    bl2 = (Boolean)map.get("PKUK_NOVALIDATE");
                    uniqueOraclev9i.setValidate(bl2 ? "NO" : "YES");
                }
                if ((string3 = (String)map.get("PKUK_EXCEPTIONS")) != null && (tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(string3)) != null) {
                    uniqueOraclev9i.setExceptionsTable(tableProxyOracle);
                }
                if (bl = ((Boolean)map.get("USING INDEX")).booleanValue()) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    String string4;
                    String string5;
                    AbstractStorageObjectOracle abstractStorageObjectOracle;
                    uniqueOraclev9i.setUsingIndex("BY INDEX NAME");
                    if (map.get("BY CREATE INDEX STATEMENT") != null) {
                        uniqueOraclev9i.setUsingIndex("BY CREATE INDEX STATEMENT");
                        uniqueOraclev9i.setCreateIndexStatement((String)map.get("BY CREATE INDEX STATEMENT"));
                    } else if (map.get("GLOBAL") != null && ((Boolean)map.get("GLOBAL")).booleanValue()) {
                        abstractStorageObjectOracle = (IndexGlobalPartitionsListOraclev9i)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                        uniqueOraclev9i.setUsingIndexGlobalPL((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle);
                        ((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).setIndex(uniqueOraclev9i);
                        uniqueOraclev9i.setUsingIndex("GLOBAL PARTITIONED");
                        string5 = (String)map.get("COLUMN_LIST");
                        ((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).setGlobalPartColumns(((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).columnNamesToColumnIDs(string5));
                        string4 = (String)map.get("PARTITIONS");
                        object4 = new StringTokenizer(string4, ",");
                        while (((StringTokenizer)object4).hasMoreTokens()) {
                            String string6 = ((StringTokenizer)object4).nextToken();
                            if (Token.hasOpenBracket(string6)) {
                                while (Token.hasOpenBracket(string6) && ((StringTokenizer)object4).hasMoreTokens()) {
                                    string6 = string6 + "," + ((StringTokenizer)object4).nextToken();
                                }
                            }
                            object3 = (IndexGlobalPartitionOraclev9i)this.storageDesign.getIndexGlobalPartitionSet().createIndexGlobalPartition();
                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object3);
                            object2 = Token.getQuotedNameAfterToken(string6, "PARTITION").trim();
                            ((StorageObject)object3).setName((String)object2);
                            ((IndexGlobalPartitionOracle)object3).setIndexGlobalPartList((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle);
                            String string7 = Token.getValBetweenBrackets(string6, 1).trim();
                            ((IndexGlobalPartitionOracle)object3).setValueList(string7);
                            if (Token.hasToken(string6, "TABLESPACE")) {
                                String string8 = Token.getQuotedNameAfterToken(string6, "TABLESPACE");
                                object = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string8);
                                if (object == null && !"SYSTEM".equalsIgnoreCase(string8)) {
                                    object = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    ((TableSpaceOracle)object).setName(string8);
                                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                                }
                                if (object != null) {
                                    ((IndexGlobalPartitionOracle)object3).setTableSpace((TableSpaceOracle)object);
                                }
                            }
                            if (Token.hasToken(string6, "NOLOGGING")) {
                                ((IndexGlobalPartitionOracle)object3).setLogging("NO");
                                continue;
                            }
                            if (Token.hasToken(string6, "LOGGING")) {
                                ((IndexGlobalPartitionOracle)object3).setLogging("YES");
                                continue;
                            }
                            ((IndexGlobalPartitionOracle)object3).setLogging("");
                        }
                    } else if (map.get("LOCAL") != null && ((Boolean)map.get("LOCAL")).booleanValue()) {
                        uniqueOraclev9i.setUsingIndex("LOCAL PARTITIONED");
                    }
                    if (!uniqueOraclev9i.getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        String string9;
                        abstractStorageObjectOracle = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment();
                        this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                        string5 = (String)map.get("PCTFREE");
                        if (!"".equalsIgnoreCase(string5)) {
                            try {
                                int n = Integer.parseInt(string5);
                                ((SegmentOracle)abstractStorageObjectOracle).setPCTFree(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(string4 = (String)map.get("INITRANS"))) {
                            try {
                                int n = Integer.parseInt(string4);
                                ((SegmentOracle)abstractStorageObjectOracle).setInitrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase((String)(object4 = (String)map.get("MAXTRANS")))) {
                            try {
                                int n = Integer.parseInt((String)object4);
                                ((SegmentOracle)abstractStorageObjectOracle).setMaxTrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (map.get("STORAGE") != null && ((Boolean)map.get("STORAGE")).booleanValue()) {
                            String string10;
                            String string11;
                            String string12;
                            String string13 = (String)map.get("INITIAL");
                            if (!"".equalsIgnoreCase(string13)) {
                                try {
                                    long l = Long.parseLong(string13);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCInitialExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase((String)(object3 = (String)map.get("NEXT")))) {
                                try {
                                    long l = Long.parseLong((String)object3);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCNextExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase((String)(object2 = (String)map.get("PCTINCREASE")))) {
                                try {
                                    int n = Integer.parseInt((String)object2);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCPctIncrease(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string12 = (String)map.get("MINEXTENTS"))) {
                                try {
                                    int n = Integer.parseInt(string12);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCMinExtents(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string11 = (String)map.get("MAXEXTENTS"))) {
                                ((SegmentOracle)abstractStorageObjectOracle).setSCMaxExtents(string11);
                            }
                            if (!"".equalsIgnoreCase((String)(object = (String)map.get("FREELISTS")))) {
                                try {
                                    int n = Integer.parseInt((String)object);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCFreeLists(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string10 = (String)map.get("GROUPS"))) {
                                try {
                                    int n = Integer.parseInt(string10);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCFreelistGroups(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            String string14 = (String)map.get("BUFFER_POOL");
                            if (!"".equalsIgnoreCase(string10)) {
                                ((SegmentOracle)abstractStorageObjectOracle).setSCBufferPool(string14);
                            }
                        }
                        if ((string9 = (String)map.get("TABLESPACE")) != null && !string9.equals("")) {
                            object3 = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string9);
                            if (object3 == null && !"SYSTEM".equalsIgnoreCase(string9)) {
                                object3 = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)object3).setName(string9);
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object3);
                            }
                            if (object3 != null) {
                                uniqueOraclev9i.setTableSpace((TableSpaceOracle)object3);
                            }
                        }
                        if ((object3 = (String)map.get("LOGGING")) == null) {
                            object3 = "";
                        }
                        uniqueOraclev9i.setLogging((String)object3);
                        object2 = this.storageDesign.getSegmentSet().findEqual((SegmentOracle)abstractStorageObjectOracle);
                        uniqueOraclev9i.setIndexSegment((SegmentOracle)object2);
                    }
                }
            }
        }
    }

    private void initCheckConstraint(String string, String string2, Column column) {
        CheckConstraint checkConstraint = new CheckConstraint();
        checkConstraint.add(StorageDesignOraclev9i.RDBMS_TYPE, string);
        if (!"".equalsIgnoreCase(string2) && string2 != null) {
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        } else {
            String string3 = column.getName();
            if (string3.length() > 25) {
                string3 = string3.substring(0, 25);
            }
            string2 = string3 + "_CHCK";
            checkConstraint.setName(string2);
            column.setConstraintName("");
        }
        checkConstraint.setDesign(this.design);
        column.setUseDomainConstraints(false);
        column.setCheck(checkConstraint);
    }

    public Table getTable() {
        return this.table;
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1).trim();
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n *= 1024);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("SHCreateTableOracle9i.getNumberOnly - Unable to parse value: " + string, numberFormatException);
            }
        }
        return string;
    }

    private Domain getCorrespondingDomain(String string) {
        Domain domain = null;
        DomainSet domainSet = this.design.getDomainSet();
        Iterator iterator = domainSet.iterator();
        while (iterator.hasNext()) {
            Domain domain2 = (Domain)iterator.next();
            if (!domain2.getName().equalsIgnoreCase(string)) continue;
            domain = domain2;
            return domain;
        }
        return domain;
    }

    private void initTemporary() {
        if ("GLOBAL".equalsIgnoreCase(Token.getTokenAfter(this.statement, "CREATE"))) {
            this.tableProxy.setTemporary("YES");
        }
    }

    private void initOnCommit() {
        String string;
        if (Token.hasToken(this.outSideBrackets, "COMMIT") && (string = Token.getTokenAfter(this.outSideBrackets, "COMMIT").trim()).equalsIgnoreCase("DELETE")) {
            this.tableProxy.setTempPreserveRows("NO");
        }
    }

    private void initCluster() {
        ClusterOraclev9i clusterOraclev9i;
        String string = Token.getQuotedNameAfterToken(this.outSideBrackets, "CLUSTER");
        if (string.indexOf(46) > -1) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        if ((clusterOraclev9i = (ClusterOraclev9i)this.storageDesign.getClusterSet().getByName(string)) != null) {
            this.tableProxy.setCluster(clusterOraclev9i);
            String string2 = Token.getStringAfter(this.outSideBrackets, "CLUSTER");
            string2 = Token.getValBetweenBrackets(string2, 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = Token.getFirstName(stringTokenizer.nextToken(), '\"', '\"');
                ColumnProxy columnProxy = this.tableProxy.getColumnProxyByName(string3);
                if (columnProxy == null) continue;
                this.tableProxy.setClusterColumns(columnProxy.getObjectID());
            }
        }
    }

    private void initIndexOrganizedTable() {
        StorageObject storageObject;
        String string;
        String string2 = Token.getStringAfter(this.outSideBrackets, "ORGANIZATION");
        string2 = Token.cutFirstToken(string2);
        String string3 = "";
        if (Token.hasToken(string2, "OVERFLOW")) {
            string3 = Token.getStringAfterToken(string2, "OVERFLOW");
            string2 = Token.getStringBeforeToken(string2, "OVERFLOW");
        }
        this.initSegment(string2);
        if (Token.hasToken(string2, "PCTTHRESHOLD")) {
            string = Token.getTokenAfter(string2, "PCTTHRESHOLD");
            try {
                this.tableProxy.setIotPctThreshold(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTTHRESHOLD format in statement " + this.statement);
                LOGGER.error("Wrong syntax near " + string2, numberFormatException);
            }
        }
        if (Token.hasToken(string2, "COMPRESS")) {
            string = Token.getTokenAfter(string2, "COMPRESS");
            try {
                this.tableProxy.setIotCompress(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong COMPRESS format in statement " + this.statement);
                LOGGER.error("Wrong syntax near " + string2, numberFormatException);
            }
        }
        if (Token.hasString(string2.toUpperCase(), "MAPPING TABLE")) {
            this.tableProxy.setIOTMappingTable("YES");
        }
        if (Token.hasToken(string2, "INCLUDING") && (storageObject = (ColumnProxyOraclev9i)this.tableProxy.getColumnProxyByName(string = Token.getQuotedNameAfterToken(string2, "INCLUDING"))) != null) {
            this.tableProxy.setIotIncluding((ColumnProxy)storageObject);
        }
        if (Token.hasToken(string2, "TABLESPACE")) {
            string = Token.getQuotedNameAfterToken(string2, "TABLESPACE");
            storageObject = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string);
            if (storageObject == null && !"SYSTEM".equalsIgnoreCase(string)) {
                storageObject = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                ((TableSpaceOracle)storageObject).setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
            }
            if (storageObject != null) {
                this.tableProxy.setTableSpace((TableSpaceOracle)storageObject);
            }
        }
        if (!string3.equals("")) {
            this.initOverflowSegment(string3);
        }
    }

    private void initOverflowSegment(String string) {
        SegmentOraclev9i segmentOraclev9i = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev9i = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev9i);
            this.initPctUsed(string, segmentOraclev9i);
            this.initInitrans(string, segmentOraclev9i);
            this.initMaxtrans(string, segmentOraclev9i);
            this.initStorage(string, segmentOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev9i);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev9i);
            this.tableProxy.setIotOverflowSegment(segmentOracle);
        }
    }

    private void initTableSpace() {
        if (Token.hasToken(this.outSideBrackets, "TABLESPACE")) {
            String string = Token.getQuotedNameAfterToken(this.outSideBrackets, "TABLESPACE");
            TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string);
            if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string)) {
                tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                tableSpaceOraclev9i.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
            }
            if (tableSpaceOraclev9i != null) {
                this.tableProxy.setTableSpace(tableSpaceOraclev9i);
            }
        }
    }

    private void initCompression() {
        if (Token.hasToken(this.outSideBrackets, "COMPRESS")) {
            this.tableProxy.setDataSegmentCompression("YES");
        }
    }

    private void initSegment(String string) {
        SegmentOraclev9i segmentOraclev9i = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev9i = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev9i);
            this.initPctUsed(string, segmentOraclev9i);
            this.initInitrans(string, segmentOraclev9i);
            this.initMaxtrans(string, segmentOraclev9i);
            this.initStorage(string, segmentOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev9i);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev9i);
            this.tableProxy.setSegment(segmentOracle);
        }
        this.initLogging(string);
    }

    private void initPctFree(String string, SegmentOraclev9i segmentOraclev9i) {
        String string2 = Token.getTokenAfter(string, "PCTFREE").trim();
        try {
            if (!"".equals(string2)) {
                int n = Integer.parseInt(string2);
                segmentOraclev9i.setPCTFree(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
            LOGGER.error("wrong format in SHCreateTableOracle.initPctFree : " + numberFormatException.getMessage());
        }
    }

    private void initPctUsed(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "PCTUSED")) {
            String string2 = Token.getTokenAfter(string, "PCTUSED").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev9i.setPCTUsed(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTUSED format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initPctUsed : " + numberFormatException.getMessage());
            }
        }
    }

    private void initInitrans(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "INITRANS")) {
            String string2 = Token.getTokenAfter(string, "INITRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev9i.setInitrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initInitrans : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxtrans(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "MAXTRANS")) {
            String string2 = Token.getTokenAfter(string, "MAXTRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev9i.setMaxTrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initMaxtrans : " + numberFormatException.getMessage());
            }
        }
    }

    private void initStorage(String string, SegmentOraclev9i segmentOraclev9i) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, segmentOraclev9i, null, null);
            this.initNext(string2, segmentOraclev9i, null, null);
            this.initPCtIncrease(string2, segmentOraclev9i, null, null);
            this.initMinExtents(string2, segmentOraclev9i, null, null);
            this.initMaxExtents(string2, segmentOraclev9i, null, null);
            this.initFreeLists(string2, segmentOraclev9i, null, null);
            this.initFreeListGroups(string2, segmentOraclev9i, null, null);
            this.initSegBufferPool(string2, segmentOraclev9i, null, null);
        }
    }

    private void initInitial(String string, SegmentOraclev9i segmentOraclev9i, LobStorageOraclev9i lobStorageOraclev9i, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "INITIAL")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "INITIAL").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOraclev9i != null) {
                    segmentOraclev9i.setSCInitialExtent(l);
                } else if (lobStorageOraclev9i != null) {
                    lobStorageOraclev9i.setSCInitialExtent(l);
                } else if (columnProxyOraclev9i != null) {
                    columnProxyOraclev9i.setSCInitialExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initInitial : " + numberFormatException.getMessage());
            }
        }
    }

    private void initNext(String string, SegmentOraclev9i segmentOraclev9i, LobStorageOraclev9i lobStorageOraclev9i, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "NEXT")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "NEXT").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOraclev9i != null) {
                    segmentOraclev9i.setSCNextExtent(l);
                } else if (lobStorageOraclev9i != null) {
                    lobStorageOraclev9i.setSCNextExtent(l);
                } else if (columnProxyOraclev9i != null) {
                    columnProxyOraclev9i.setSCNextExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initNext : " + numberFormatException.getMessage());
            }
        }
    }

    private void initPCtIncrease(String string, SegmentOraclev9i segmentOraclev9i, LobStorageOraclev9i lobStorageOraclev9i, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "PCTINCREASE")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "PCTINCREASE").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev9i != null) {
                    segmentOraclev9i.setSCPctIncrease(n);
                } else if (lobStorageOraclev9i != null) {
                    lobStorageOraclev9i.setSCPctIncrease(n);
                } else if (columnProxyOraclev9i != null) {
                    columnProxyOraclev9i.setSCPctIncrease(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initPCtIncrease : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMinExtents(String string, SegmentOraclev9i segmentOraclev9i, LobStorageOraclev9i lobStorageOraclev9i, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "MINEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MINEXTENTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev9i != null) {
                    segmentOraclev9i.setSCMinExtents(n);
                } else if (lobStorageOraclev9i != null) {
                    lobStorageOraclev9i.setSCMinExtents(n);
                } else if (columnProxyOraclev9i != null) {
                    columnProxyOraclev9i.setSCMinExtents(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initMinExtents : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxExtents(String string, SegmentOraclev9i segmentOraclev9i, LobStorageOraclev9i lobStorageOraclev9i, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "MAXEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MAXEXTENTS").trim());
            if (segmentOraclev9i != null) {
                segmentOraclev9i.setSCMaxExtents(string2);
            } else if (lobStorageOraclev9i != null) {
                lobStorageOraclev9i.setSCMaxExtents(string2);
            } else if (columnProxyOraclev9i != null) {
                columnProxyOraclev9i.setSCMaxExtents(string2);
            }
        }
    }

    private void initFreeLists(String string, SegmentOraclev9i segmentOraclev9i, LobStorageOraclev9i lobStorageOraclev9i, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "FREELISTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "FREELISTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev9i != null) {
                    segmentOraclev9i.setSCFreeLists(n);
                } else if (lobStorageOraclev9i != null) {
                    lobStorageOraclev9i.setSCFreeLists(n);
                } else if (columnProxyOraclev9i != null) {
                    columnProxyOraclev9i.setSCFreeLists(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initFreeLists : " + numberFormatException.getMessage());
            }
        }
    }

    private void initFreeListGroups(String string, SegmentOraclev9i segmentOraclev9i, LobStorageOraclev9i lobStorageOraclev9i, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "GROUPS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "GROUPS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev9i != null) {
                    segmentOraclev9i.setSCFreelistGroups(n);
                } else if (lobStorageOraclev9i != null) {
                    lobStorageOraclev9i.setSCFreelistGroups(n);
                } else if (columnProxyOraclev9i != null) {
                    columnProxyOraclev9i.setSCFreelistGroups(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initFreeListGroups : " + numberFormatException.getMessage());
            }
        }
    }

    private void initSegBufferPool(String string, SegmentOraclev9i segmentOraclev9i, LobStorageOraclev9i lobStorageOraclev9i, ColumnProxyOraclev9i columnProxyOraclev9i) {
        if (Token.hasToken(string, "BUFFER_POOL")) {
            String string2 = Token.getQuotedNameAfterToken(string, "BUFFER_POOL");
            if (segmentOraclev9i != null) {
                segmentOraclev9i.setSCBufferPool(string2);
            } else if (lobStorageOraclev9i != null) {
                lobStorageOraclev9i.setSCBufferPool(string2);
            } else if (columnProxyOraclev9i != null) {
                columnProxyOraclev9i.setSCBufferPool(string2);
            }
        }
    }

    private void initLogging(String string) {
        if (Token.hasToken(string, "NOLOGGING")) {
            this.tableProxy.setLogging("NO");
        } else if (Token.hasToken(string, "LOGGING")) {
            this.tableProxy.setLogging("YES");
        } else {
            this.tableProxy.setLogging("");
        }
    }

    private void initCache() {
        if (Token.hasToken(this.outSideBrackets, "CACHE")) {
            this.tableProxy.setCache("YES");
        }
    }

    private void initMonitoring() {
        if (Token.hasToken(this.outSideBrackets, "MONITORING")) {
            this.tableProxy.setMonitoring("YES");
        }
    }

    private void initRowMovement() {
        if (Token.hasString(this.outSideBrackets.toUpperCase(), "ROW MOVEMENT")) {
            String string = Token.getTokenBefore(this.outSideBrackets, "ROW MOVEMENT");
            this.tableProxy.setParttitionedRowMovement(string.toUpperCase());
        }
    }

    private void initParallel() {
        if (Token.hasToken(this.outSideBrackets, "PARALLEL")) {
            this.tableProxy.setParallel("YES");
            String string = Token.getTokenAfter(this.outSideBrackets, "PARALLEL").trim();
            try {
                Integer.parseInt(string);
                this.tableProxy.setDegree(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void initRowDependency() {
        if (Token.hasToken(this.outSideBrackets, "ROWDEPENDENCIES")) {
            this.tableProxy.setRowDependency("YES");
        }
    }

    public void initPartitionsForSnapshotTable(String string, TableProxyOraclev9i tableProxyOraclev9i) {
        if (tableProxyOraclev9i != null) {
            this.outSideBrackets = string;
            this.tableProxy = tableProxyOraclev9i;
            this.table = (Table)tableProxyOraclev9i.getObject();
            this.storageDesign = (StorageDesignOraclev9i)tableProxyOraclev9i.getStorageDesign();
            this.initPartitions();
        }
    }

    private void initPartitions() {
        if (Token.hasString(this.outSideBrackets.toUpperCase(), "PARTITION BY")) {
            PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)this.storageDesign.getPartitionListSet().createPartitionList();
            this.design.getRelationalDesign().stampModelObjectDDL(partitionListOraclev9i);
            partitionListOraclev9i.setTable(this.tableProxy);
            String string = Token.getStringAfter(this.outSideBrackets, "PARTITION BY");
            String string2 = Token.getFirstToken(string);
            int n = string2.indexOf("(");
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
            String string3 = Token.getValBetweenBrackets(string, 1).trim();
            string = Token.getValAfterBrackets(string, 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                partitionListOraclev9i.setColumnList(Token.getName(stringTokenizer.nextToken().trim()));
            }
            if (string2.equalsIgnoreCase("RANGE")) {
                if (Token.hasString(string.toUpperCase(), "SUBPARTITION BY HASH")) {
                    partitionListOraclev9i.setPartitionType("COMPOSITE BY HASH");
                    string = this.doSubPartByHash(string, partitionListOraclev9i);
                } else if (Token.hasString(string.toUpperCase(), "SUBPARTITION BY LIST")) {
                    partitionListOraclev9i.setPartitionType("COMPOSITE BY LIST");
                    string = this.doSubPartByList(string, partitionListOraclev9i);
                } else {
                    partitionListOraclev9i.setPartitionType("RANGE");
                }
                this.doRangePartitions(string, partitionListOraclev9i);
            } else if (string2.equalsIgnoreCase("HASH")) {
                partitionListOraclev9i.setPartitionType("HASH BY LIST OF PARTITIONS");
                if (string.charAt(0) == '(') {
                    String string4 = Token.getValBetweenBrackets(string, 1).trim();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
                    while (stringTokenizer2.hasMoreTokens()) {
                        Object object;
                        String string5;
                        Object object2 = stringTokenizer2.nextToken();
                        while (Token.hasOpenBracket((String)object2) && stringTokenizer2.hasMoreTokens()) {
                            object2 = (String)object2 + "," + stringTokenizer2.nextToken();
                        }
                        if (!Token.hasToken((String)object2, "PARTITION")) continue;
                        String string6 = Token.getQuotedNameAfterToken((String)object2, "PARTITION");
                        HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)this.storageDesign.getHashPartitionSet().createHashPartition();
                        hashPartitionOraclev9i.setName(string6);
                        this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionOraclev9i);
                        hashPartitionOraclev9i.setPartitionList(partitionListOraclev9i);
                        String string7 = object2;
                        if (Token.hasToken(string7, "LOB")) {
                            string7 = Token.getStringBeforeToken(string7, "LOB");
                        }
                        if (string7.toUpperCase().indexOf("NESTED TABLE") > -1) {
                            string7 = Token.getStringBefore(string7, "NESTED TABLE");
                        }
                        String string8 = string7;
                        if (Token.hasToken(string7, "OVERFLOW")) {
                            string8 = Token.getStringBeforeToken(string7, "OVERFLOW");
                        }
                        if (!(string5 = Token.getQuotedNameAfterToken(string8, "TABLESPACE")).equals("")) {
                            object = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string5);
                            if (object == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                                object = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)object).setName(string5);
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                            }
                            if (object != null) {
                                hashPartitionOraclev9i.setTableSpace((TableSpaceOracle)object);
                            }
                        }
                        while (Token.hasToken((String)object2, "LOB")) {
                            String string9;
                            object = Token.getStringAfter((String)object2, "LOB");
                            String string10 = Token.getFirstName(Token.getValBetweenBrackets((String)object, 1), '\"', '\"');
                            HashPartitionLobItemOraclev9i hashPartitionLobItemOraclev9i = (HashPartitionLobItemOraclev9i)this.storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
                            hashPartitionLobItemOraclev9i.setName(string10);
                            this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionLobItemOraclev9i);
                            hashPartitionLobItemOraclev9i.setLobColumn(this.tableProxy.getColumnProxyByName(string10));
                            hashPartitionLobItemOraclev9i.setHashPartition(hashPartitionOraclev9i);
                            object = Token.getStringAfter((String)object, "STORE AS");
                            String string11 = Token.getStringBeforeToken((String)object, "TABLESPACE");
                            if (string11.length() > 0 && !Token.hasToken(string11, "LOB") && !(string9 = Token.getQuotedNameAfterToken((String)object, "TABLESPACE")).equals("")) {
                                TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string9);
                                if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string9)) {
                                    tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    tableSpaceOraclev9i.setName(string9);
                                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
                                }
                                if (tableSpaceOraclev9i != null) {
                                    hashPartitionLobItemOraclev9i.setTableSpace(tableSpaceOraclev9i);
                                }
                            }
                            object2 = object;
                        }
                    }
                } else if (Token.isTokenEqualTo(string, 1, "PARTITIONS")) {
                    TableSpaceOracle tableSpaceOracle;
                    String string12;
                    StringTokenizer stringTokenizer3;
                    partitionListOraclev9i.setPartitionType("HASH BY QUANTITY");
                    string = Token.cutTokenFromFront(string, "PARTITIONS");
                    String string13 = Token.getFirstToken(string);
                    string = Token.cutTokenFromFront(string, string13);
                    try {
                        int n2 = Integer.parseInt(string13);
                        partitionListOraclev9i.setHashPQuantity(n2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.importLog.addWarning("Wrong PARTITIONS format in statement " + this.statement);
                        LOGGER.error("wrong format in SHCreateTableOraclev9i.initPartitions : " + numberFormatException.getMessage());
                    }
                    if (Token.startsWithString(string, "STORE IN")) {
                        String string14 = Token.getValBetweenBrackets(string, 1);
                        string = Token.getValAfterBrackets(string, 1);
                        stringTokenizer3 = new StringTokenizer(string14, ",");
                        while (stringTokenizer3.hasMoreTokens()) {
                            string12 = Token.getName(stringTokenizer3.nextToken().trim());
                            tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string12);
                            if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string12)) {
                                tableSpaceOracle = this.storageDesign.getTableSpaceSet().createTableSpace();
                                tableSpaceOracle.setName(string12);
                                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                            }
                            if (tableSpaceOracle == null) continue;
                            partitionListOraclev9i.setHashPTableSpaces(tableSpaceOracle.getObjectID());
                        }
                    }
                    if (Token.hasToken(string, "OVERFLOW") && Token.startsWithString(string = Token.getStringAfterToken(string, "OVERFLOW"), "STORE IN")) {
                        String string15 = Token.getValBetweenBrackets(string, 1);
                        string = Token.getValAfterBrackets(string, 1);
                        stringTokenizer3 = new StringTokenizer(string15, ",");
                        while (stringTokenizer3.hasMoreTokens()) {
                            string12 = Token.getName(stringTokenizer3.nextToken().trim());
                            tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string12);
                            if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string12)) {
                                tableSpaceOracle = this.storageDesign.getTableSpaceSet().createTableSpace();
                                tableSpaceOracle.setName(string12);
                                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                            }
                            if (tableSpaceOracle == null) continue;
                            partitionListOraclev9i.setIOTOverflowHashPTSSet(tableSpaceOracle.getObjectID());
                        }
                    }
                }
            } else if (string2.equalsIgnoreCase("LIST")) {
                partitionListOraclev9i.setPartitionType("LIST");
                if (Token.hasCloseAndOpenBrackets(string)) {
                    String string16 = Token.getValBetweenBrackets(string, 1).trim();
                    StringTokenizer stringTokenizer4 = new StringTokenizer(string16, ",");
                    while (stringTokenizer4.hasMoreTokens()) {
                        String string17;
                        String string18 = stringTokenizer4.nextToken();
                        while (Token.hasOpenBracket(string18) && stringTokenizer4.hasMoreTokens()) {
                            string18 = string18 + "," + stringTokenizer4.nextToken();
                        }
                        if (!Token.hasToken(string18, "PARTITION")) continue;
                        String string19 = Token.getQuotedNameAfterToken(string18, "PARTITION");
                        ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)this.storageDesign.getListPartitionSet().createListPartition();
                        if (!string19.equalsIgnoreCase("VALUES")) {
                            listPartitionOraclev9i.setName(string19);
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(listPartitionOraclev9i);
                        listPartitionOraclev9i.setPartitionList(partitionListOraclev9i);
                        if (Token.hasToken(string18, "VALUES")) {
                            string17 = Token.getStringAfter(string18, "VALUES");
                            if ((string17 = Token.getValBetweenBrackets(string17, 1).trim()).equalsIgnoreCase("DEFAULT")) {
                                listPartitionOraclev9i.setColumns("DEFAULT");
                            } else {
                                listPartitionOraclev9i.setColumns(string17);
                            }
                        }
                        if (Token.hasToken(string17 = string18, "LOB")) {
                            string17 = Token.getStringBeforeToken(string17, "LOB");
                        }
                        if (string17.toUpperCase().indexOf("NESTED TABLE") > -1) {
                            string17 = Token.getStringBefore(string17, "NESTED TABLE");
                        }
                        String string20 = string17;
                        if (Token.hasToken(string17, "OVERFLOW")) {
                            string20 = Token.getStringBeforeToken(string17, "OVERFLOW");
                        }
                        this.initPartSegment(string20, listPartitionOraclev9i);
                        String string21 = Token.getQuotedNameAfterToken(string20, "TABLESPACE");
                        if (!string21.equals("")) {
                            TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string21);
                            if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string21)) {
                                tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                                tableSpaceOraclev9i.setName(string21);
                                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
                            }
                            if (tableSpaceOraclev9i != null) {
                                listPartitionOraclev9i.setTablespace(tableSpaceOraclev9i);
                            }
                        }
                        if (Token.hasToken(string17, "LOGGING")) {
                            listPartitionOraclev9i.setLogging("YES");
                        } else if (Token.hasToken(string17, "NOLOGGING")) {
                            listPartitionOraclev9i.setLogging("NO");
                        } else {
                            listPartitionOraclev9i.setLogging("");
                        }
                        if (Token.hasToken(string17, "COMPRESS")) {
                            listPartitionOraclev9i.setDataSegmentCompression("YES");
                        } else if (Token.hasToken(string17, "NOCOMPRESS")) {
                            listPartitionOraclev9i.setDataSegmentCompression("NO");
                        }
                        this.initLobStorage(string18, listPartitionOraclev9i);
                    }
                }
            }
            this.tableProxy.setPartitionList(partitionListOraclev9i);
        }
    }

    private String doSubPartByHash(String string, PartitionListOraclev9i partitionListOraclev9i) {
        block14: {
            block13: {
                string = Token.getStringAfter(string, "SUBPARTITION BY HASH");
                String string2 = Token.getValBetweenBrackets(string, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    partitionListOraclev9i.setSubPartitionsColumnList(Token.getName(stringTokenizer.nextToken().trim()));
                }
                if (!Token.getFirstToken(string = Token.getValAfterBrackets(string, 1)).equalsIgnoreCase("SUBPARTITIONS")) break block13;
                string = Token.cutTokenFromFront(string, "SUBPARTITIONS");
                String string3 = Token.getFirstToken(string);
                string = Token.cutTokenFromFront(string, string3);
                try {
                    int n = Integer.parseInt(string3);
                    partitionListOraclev9i.setSubPartitionsQuantity(n);
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong SUBPARTITIONS format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateTableOracle.doSubPartByHash : " + numberFormatException.getMessage());
                }
                if (!Token.startsWithString(string, "STORE IN")) break block14;
                String string4 = Token.getValBetweenBrackets(string, 1);
                string = Token.getValAfterBrackets(string, 1);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string5 = Token.getName(stringTokenizer2.nextToken().trim());
                    TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string5);
                    if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                        tableSpaceOracle = this.storageDesign.getTableSpaceSet().createTableSpace();
                        tableSpaceOracle.setName(string5);
                        this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                    }
                    if (tableSpaceOracle == null) continue;
                    partitionListOraclev9i.setSubPartitionsTableSpaces(tableSpaceOracle.getObjectID());
                }
                break block14;
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("SUBPARTITION") && Token.getFirstToken(Token.cutTokenFromFront(string, "SUBPARTITION")).equalsIgnoreCase("TEMPLATE")) {
                partitionListOraclev9i.setUseSubpartStorageTemplate("YES");
                String string6 = Token.getStringAfter(string, "TEMPLATE");
                if (!string6.startsWith("(")) {
                    String string7 = Token.getFirstToken(string6);
                    string = Token.cutTokenFromFront(string6, string7);
                    try {
                        int n = Integer.parseInt(string7);
                        partitionListOraclev9i.setSubPartitionsQuantity(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("wrong format in SHCreateTableOracle.doSubPartByHash : " + numberFormatException.getMessage());
                        this.importLog.addWarning("Wrong SUBPARTITION TEMPLATE format in statement " + this.statement);
                    }
                } else {
                    String string8 = Token.getValBetweenBrackets(string6, 1).trim();
                    string = Token.getValAfterBrackets(string6, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string9 = stringTokenizer.nextToken();
                        while (Token.hasOpenBracket(string9) && stringTokenizer.hasMoreTokens()) {
                            string9 = string9 + "," + stringTokenizer.nextToken();
                        }
                        if (!Token.hasToken(string9, "SUBPARTITION")) continue;
                        String string10 = Token.getQuotedNameAfterToken(string9, "SUBPARTITION");
                        HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)this.storageDesign.getHashPartitionSet().createHashPartition();
                        if (!(string10.equalsIgnoreCase("TABLESPACE") || string10.equalsIgnoreCase("OVERFLOW") || string10.equalsIgnoreCase("COMPRESS") || string10.equalsIgnoreCase("NOCOMPRESS") || string10.equalsIgnoreCase("LOB") || string10.equalsIgnoreCase("VARRAY"))) {
                            hashPartitionOraclev9i.setName(string10);
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionOraclev9i);
                        hashPartitionOraclev9i.setPartOfStorageTable(this.tableProxy);
                        this.initHashSubPartition(string9, hashPartitionOraclev9i);
                    }
                }
            }
        }
        return string;
    }

    private void initHashSubPartition(String string, HashPartitionOraclev9i hashPartitionOraclev9i) {
        Object object;
        String string2;
        String string3 = string;
        while (Token.hasToken(string3, "TABLESPACE")) {
            if (Token.hasOpenBracketNoClose(Token.getStringBeforeToken(string3, "TABLESPACE"))) {
                string3 = Token.getValAfterBrackets(string3, 1);
                continue;
            }
            string2 = Token.getQuotedNameAfterToken(string3, "TABLESPACE");
            if (string2.indexOf(",") > 0) {
                string2 = Token.getStringBefore(string2, ",").trim();
            }
            if (!string2.equals("")) {
                object = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string2);
                if (object == null && !"SYSTEM".equalsIgnoreCase(string2)) {
                    object = this.storageDesign.getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)object).setName(string2);
                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                }
                if (object != null) {
                    if (Token.getTokenBefore(string3, "TABLESPACE").equalsIgnoreCase("OVERFLOW")) {
                        hashPartitionOraclev9i.setIotOverflowTablespace((TableSpaceOracle)object);
                    } else {
                        hashPartitionOraclev9i.setTableSpace((TableSpaceOracle)object);
                    }
                }
            }
            string3 = Token.getStringAfterToken(string3, "TABLESPACE");
        }
        while (Token.hasToken(string, "LOB")) {
            String string4;
            string2 = Token.getStringAfter(string, "LOB");
            object = Token.getFirstName(Token.getValBetweenBrackets(string2, 1), '\"', '\"');
            HashPartitionLobItemOraclev9i hashPartitionLobItemOraclev9i = (HashPartitionLobItemOraclev9i)this.storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
            hashPartitionLobItemOraclev9i.setName((String)object);
            this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionLobItemOraclev9i);
            hashPartitionLobItemOraclev9i.setLobColumn(this.tableProxy.getColumnProxyByName((String)object));
            hashPartitionLobItemOraclev9i.setHashPartition(hashPartitionOraclev9i);
            string2 = Token.getStringAfter(string2, "STORE AS");
            String string5 = Token.getStringBeforeToken(string2, "TABLESPACE");
            if (string5.length() > 0 && !Token.hasToken(string5, "LOB") && !(string4 = Token.getQuotedNameAfterToken(string2, "TABLESPACE")).equals("")) {
                TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string4);
                if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string4)) {
                    tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev9i.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
                }
                if (tableSpaceOraclev9i != null) {
                    hashPartitionLobItemOraclev9i.setTableSpace(tableSpaceOraclev9i);
                }
            }
            string = string2;
        }
    }

    private String doSubPartByList(String string, PartitionListOraclev9i partitionListOraclev9i) {
        string = Token.getStringAfter(string, "SUBPARTITION BY LIST");
        String string2 = Token.getValBetweenBrackets(string, 1).trim();
        partitionListOraclev9i.setSubPartitionsColumnList(Token.getName(string2));
        string = Token.getValAfterBrackets(string, 1);
        if (Token.getFirstToken(string).equalsIgnoreCase("SUBPARTITION") && Token.getFirstToken(Token.cutTokenFromFront(string, "SUBPARTITION")).equalsIgnoreCase("TEMPLATE")) {
            partitionListOraclev9i.setUseSubpartStorageTemplate("YES");
            String string3 = Token.getStringAfter(string, "TEMPLATE");
            String string4 = Token.getValBetweenBrackets(string3, 1).trim();
            string = Token.getValAfterBrackets(string3, 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                while (Token.hasOpenBracket(string5) && stringTokenizer.hasMoreTokens()) {
                    string5 = string5 + "," + stringTokenizer.nextToken();
                }
                if (!Token.hasToken(string5, "SUBPARTITION")) continue;
                String string6 = Token.getQuotedNameAfterToken(string5, "SUBPARTITION");
                ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)this.storageDesign.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                listStorageTemplatePartitionOraclev9i.setName(string6);
                this.design.getRelationalDesign().stampModelObjectDDL(listStorageTemplatePartitionOraclev9i);
                listStorageTemplatePartitionOraclev9i.setPartOfStorageTable(this.tableProxy);
                this.initListSubPartition(string5, listStorageTemplatePartitionOraclev9i);
            }
        }
        return string;
    }

    private void initListSubPartition(String string, ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i) {
        Object object;
        String string2;
        String string3;
        if (Token.hasToken(string, "VALUES")) {
            string3 = Token.getStringAfter(string, "VALUES");
            if ((string3 = Token.getValBetweenBrackets(string3, 1).trim()).equalsIgnoreCase("DEFAULT")) {
                listStorageTemplatePartitionOraclev9i.setValueList("DEFAULT");
            } else {
                listStorageTemplatePartitionOraclev9i.setValueList(string3);
            }
        }
        if ((string3 = Token.getStringBeforeToken(string, "TABLESPACE")).length() > 0 && !Token.endsWithOpenBracket(string3) && !(string2 = Token.getQuotedNameAfterToken(string, "TABLESPACE")).equals("")) {
            if (string2.indexOf(",") > 0) {
                string2 = Token.getStringBefore(string2, ",").trim();
            }
            if ((object = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string2)) == null && !"SYSTEM".equalsIgnoreCase(string2)) {
                object = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                ((TableSpaceOracle)object).setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
            }
            if (object != null) {
                listStorageTemplatePartitionOraclev9i.setTablespace((TableSpaceOracle)object);
            }
        }
        while (Token.hasToken(string, "LOB")) {
            String string4;
            string2 = Token.getStringAfter(string, "LOB");
            object = Token.getFirstName(Token.getValBetweenBrackets(string2, 1), '\"', '\"');
            HashPartitionLobItemOraclev9i hashPartitionLobItemOraclev9i = (HashPartitionLobItemOraclev9i)this.storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
            hashPartitionLobItemOraclev9i.setName((String)object);
            this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionLobItemOraclev9i);
            hashPartitionLobItemOraclev9i.setLobColumn(this.tableProxy.getColumnProxyByName((String)object));
            hashPartitionLobItemOraclev9i.setListTemplatePartition(listStorageTemplatePartitionOraclev9i);
            string2 = Token.getStringAfter(string2, "STORE AS");
            String string5 = Token.getStringBeforeToken(string2, "TABLESPACE");
            if (string5.length() > 0 && !Token.hasToken(string5, "LOB") && !(string4 = Token.getQuotedNameAfterToken(string2, "TABLESPACE")).equals("")) {
                TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string4);
                if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string4)) {
                    tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev9i.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
                }
                if (tableSpaceOraclev9i != null) {
                    hashPartitionLobItemOraclev9i.setTableSpace(tableSpaceOraclev9i);
                }
            }
            string = string2;
        }
    }

    private void doRangePartitions(String string, PartitionListOraclev9i partitionListOraclev9i) {
        String string2 = Token.getValBetweenBrackets(string, 1).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            ++n;
            String string4 = stringTokenizer.nextToken();
            while (Token.hasOpenBracket(string4) && stringTokenizer.hasMoreTokens()) {
                string4 = string4 + "," + stringTokenizer.nextToken();
            }
            if (!Token.hasToken(string4, "PARTITION")) continue;
            String string5 = Token.getQuotedNameAfterToken(string4, "PARTITION");
            PartitionOraclev9i partitionOraclev9i = (PartitionOraclev9i)this.storageDesign.getPartitionSet().createPartition();
            if (!string5.equalsIgnoreCase("VALUES")) {
                partitionOraclev9i.setName(string5);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(partitionOraclev9i);
            partitionOraclev9i.setPartitionList(partitionListOraclev9i);
            partitionOraclev9i.setPosition(n);
            string4 = Token.getStringAfter(string4, "LESS THAN");
            String string6 = Token.getValBetweenBrackets(string4, 1).trim();
            partitionOraclev9i.setValueList(string6);
            String string7 = string4 = Token.getValAfterBrackets(string4, 1);
            if (Token.hasToken(string4, "SUBPARTITION")) {
                string7 = Token.getStringBeforeToken(string4, "SUBPARTITION");
            }
            if (Token.hasToken(string3 = string7, "LOB")) {
                string3 = Token.getStringBeforeToken(string3, "LOB");
            }
            if (string3.toUpperCase().indexOf("NESTED TABLE") > -1) {
                string3 = Token.getStringBefore(string3, "NESTED TABLE");
            }
            String string8 = string3;
            if (Token.hasToken(string3, "OVERFLOW")) {
                string8 = Token.getStringBeforeToken(string3, "OVERFLOW");
                this.initOverflowSegment(Token.getStringAfter(string3, "OVERFLOW"), partitionOraclev9i);
            }
            this.initPartSegment(string8, partitionOraclev9i);
            String string9 = Token.getQuotedNameAfterToken(string8, "TABLESPACE");
            if (!string9.equals("")) {
                TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string9);
                if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string9)) {
                    tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev9i.setName(string9);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
                }
                if (tableSpaceOraclev9i != null) {
                    partitionOraclev9i.setTableSpace(tableSpaceOraclev9i);
                }
            }
            if (Token.hasToken(string3, "LOGGING")) {
                partitionOraclev9i.setLogging("YES");
            } else if (Token.hasToken(string3, "NOLOGGING")) {
                partitionOraclev9i.setLogging("NO");
            } else {
                partitionOraclev9i.setLogging("");
            }
            if (Token.hasToken(string3, "COMPRESS")) {
                partitionOraclev9i.setDataSegmentCompression("YES");
            } else if (Token.hasToken(string3, "NOCOMPRESS")) {
                partitionOraclev9i.setDataSegmentCompression("NO");
            }
            this.initLobStorage(string7, partitionOraclev9i);
            this.initSubPartitions(string4, partitionOraclev9i, partitionListOraclev9i.getPartitionType());
        }
    }

    private void initPartSegment(String string, ListPartitionOraclev9i listPartitionOraclev9i) {
        SegmentOraclev9i segmentOraclev9i = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev9i = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev9i);
            this.initPctUsed(string, segmentOraclev9i);
            this.initInitrans(string, segmentOraclev9i);
            this.initMaxtrans(string, segmentOraclev9i);
            this.initStorage(string, segmentOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev9i);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev9i);
            listPartitionOraclev9i.setSegment(segmentOracle);
        }
    }

    private void initPartSegment(String string, PartitionOraclev9i partitionOraclev9i) {
        SegmentOraclev9i segmentOraclev9i = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev9i = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev9i);
            this.initPctUsed(string, segmentOraclev9i);
            this.initInitrans(string, segmentOraclev9i);
            this.initMaxtrans(string, segmentOraclev9i);
            this.initStorage(string, segmentOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev9i);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev9i);
            partitionOraclev9i.setSegment(segmentOracle);
        }
    }

    private void initSubPartitions(String string, PartitionOraclev9i partitionOraclev9i, String string2) {
        block12: {
            String string3;
            block11: {
                string3 = string;
                if (!"COMPOSITE BY LIST".equalsIgnoreCase(string2)) break block11;
                while (Token.hasToken(string3, "SUBPARTITION")) {
                    String string4 = Token.getQuotedNameAfterToken(string3, "SUBPARTITION");
                    String string5 = Token.getStringBeforeToken(string3 = Token.getStringAfter(string3, "SUBPARTITION"), "SUBPARTITION");
                    if (string5.length() == 0) {
                        string5 = string3;
                    }
                    ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)this.storageDesign.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(listStorageTemplatePartitionOraclev9i);
                    if (!string4.equalsIgnoreCase("VALUES")) {
                        listStorageTemplatePartitionOraclev9i.setName(string4);
                    }
                    listStorageTemplatePartitionOraclev9i.setSubPartitionOf(partitionOraclev9i);
                    this.initListSubPartition(string5, listStorageTemplatePartitionOraclev9i);
                }
                break block12;
            }
            if (!"COMPOSITE BY HASH".equalsIgnoreCase(string2)) break block12;
            if (Token.hasToken(string, "SUBPARTITIONS")) {
                try {
                    int n = Integer.parseInt(Token.getTokenAfter(string, "SUBPARTITIONS").trim());
                    partitionOraclev9i.setSubPartitionsQuantity(n);
                }
                catch (NumberFormatException numberFormatException) {
                    this.importLog.addWarning("Wrong SUBPARTITIONS format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateTableOraclev9i.initSubPartitions : " + numberFormatException.getMessage());
                }
                String string6 = Token.getStringAfter(string, "STORE IN");
                String string7 = Token.getValBetweenBrackets(string6, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken().trim();
                    TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(string8);
                    if (tableSpaceOracle == null) continue;
                    partitionOraclev9i.setSubPartitionsTableSpaces(tableSpaceOracle.getObjectID());
                }
            } else {
                while (Token.hasToken(string3, "SUBPARTITION")) {
                    String string9 = Token.getQuotedNameAfterToken(string3, "SUBPARTITION");
                    String string10 = Token.getStringBeforeToken(string3 = Token.getStringAfter(string3, "SUBPARTITION"), "SUBPARTITION");
                    if (string10.length() == 0) {
                        string10 = string3;
                    }
                    HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)this.storageDesign.getHashPartitionSet().createHashPartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionOraclev9i);
                    if (!(string9.equalsIgnoreCase("TABLESPACE") || string9.equalsIgnoreCase("OVERFLOW") || string9.equalsIgnoreCase("COMPRESS") || string9.equalsIgnoreCase("NOCOMPRESS") || string9.equalsIgnoreCase("LOB") || string9.equalsIgnoreCase("VARRAY"))) {
                        hashPartitionOraclev9i.setName(string9);
                    }
                    hashPartitionOraclev9i.setSubPartitionOf(partitionOraclev9i);
                    this.initHashSubPartition(string10, hashPartitionOraclev9i);
                }
            }
        }
    }

    private void initTableLobStorages() {
        String string = this.outSideBrackets;
        while (Token.hasToken(string, "LOB")) {
            String string2;
            String string3;
            LobStorageOraclev9i lobStorageOraclev9i = (LobStorageOraclev9i)this.storageDesign.getLobStorageSet().createLobStorage();
            this.design.getRelationalDesign().stampModelObjectDDL(lobStorageOraclev9i);
            lobStorageOraclev9i.setTable(this.tableProxy);
            String string4 = Token.getStringAfter(string, "LOB");
            String string5 = Token.getValBetweenBrackets(string4, 1).replaceAll("\"", "").trim();
            lobStorageOraclev9i.setColumn(string5);
            string4 = Token.getStringAfter(string4, "STORE AS");
            String string6 = Token.getFirstToken(string4);
            int n = string6.indexOf("(");
            if (n >= 0) {
                string6 = string6.substring(0, n);
            }
            if (string6.length() > 0) {
                string6 = Token.getName(string6);
                lobStorageOraclev9i.setLobSegmentName(string6);
            }
            if (!(string3 = Token.getQuotedNameAfterToken(string2 = Token.getValBetweenBrackets(string4, 1).trim(), "TABLESPACE")).equals("")) {
                TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string3);
                if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string3)) {
                    tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev9i.setName(string3);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
                }
                if (tableSpaceOraclev9i != null) {
                    lobStorageOraclev9i.setTableSpace(tableSpaceOraclev9i);
                }
            }
            this.initLobStorageStorage(string2, lobStorageOraclev9i);
            string = string4;
        }
    }

    private void initLobStorage(String string, AbstractStorageObjectOracle abstractStorageObjectOracle) {
        if (Token.hasToken(string, "LOB")) {
            LobStorageOraclev9i lobStorageOraclev9i = (LobStorageOraclev9i)this.storageDesign.getLobStorageSet().createLobStorage();
            this.design.getRelationalDesign().stampModelObjectDDL(lobStorageOraclev9i);
            if (abstractStorageObjectOracle instanceof PartitionOraclev9i) {
                lobStorageOraclev9i.setPartition((PartitionOraclev9i)abstractStorageObjectOracle);
            } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev9i) {
                lobStorageOraclev9i.setListPartition((ListPartitionOraclev9i)abstractStorageObjectOracle);
            }
            String string2 = Token.getStringAfter(string, "LOB");
            String string3 = Token.getValBetweenBrackets(string2, 1).replaceAll("\"", "").trim();
            lobStorageOraclev9i.setColumn(string3);
            string2 = Token.getStringAfter(string2, "STORE AS");
            String string4 = Token.getTokenBefore(string2, "(").trim();
            string4 = Token.getName(string4);
            lobStorageOraclev9i.setName(string4);
            String string5 = Token.getValBetweenBrackets(string2, 1).trim();
            String string6 = Token.getQuotedNameAfterToken(string5, "TABLESPACE");
            if (!string6.equals("")) {
                TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().getByName(string6);
                if (tableSpaceOraclev9i == null && !"SYSTEM".equalsIgnoreCase(string6)) {
                    tableSpaceOraclev9i = (TableSpaceOraclev9i)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev9i.setName(string6);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev9i);
                }
                if (tableSpaceOraclev9i != null) {
                    lobStorageOraclev9i.setTableSpace(tableSpaceOraclev9i);
                }
            }
            this.initLobStorageStorage(string5, lobStorageOraclev9i);
        }
    }

    private void initOverflowSegment(String string, PartitionOraclev9i partitionOraclev9i) {
        SegmentOraclev9i segmentOraclev9i = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev9i = (SegmentOraclev9i)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev9i);
            this.initPctUsed(string, segmentOraclev9i);
            this.initInitrans(string, segmentOraclev9i);
            this.initMaxtrans(string, segmentOraclev9i);
            this.initStorage(string, segmentOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev9i);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev9i);
            partitionOraclev9i.setIOTOverflowSegment(segmentOracle);
        }
    }

    private void initLobStorageStorage(String string, LobStorageOraclev9i lobStorageOraclev9i) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, null, lobStorageOraclev9i, null);
            this.initNext(string2, null, lobStorageOraclev9i, null);
            this.initPCtIncrease(string2, null, lobStorageOraclev9i, null);
            this.initMinExtents(string2, null, lobStorageOraclev9i, null);
            this.initMaxExtents(string2, null, lobStorageOraclev9i, null);
            this.initFreeLists(string2, null, lobStorageOraclev9i, null);
            this.initFreeListGroups(string2, null, lobStorageOraclev9i, null);
            this.initSegBufferPool(string2, null, lobStorageOraclev9i, null);
        }
        this.initChunk(string, lobStorageOraclev9i);
        this.initRetention(string, lobStorageOraclev9i);
        this.initPctVersion(string, lobStorageOraclev9i);
        this.initFreePools(string, lobStorageOraclev9i);
        this.initStorageInRow(string, lobStorageOraclev9i);
        this.initLSCache(string, lobStorageOraclev9i);
        this.initLogging(string, lobStorageOraclev9i);
    }

    private void initChunk(String string, LobStorageOraclev9i lobStorageOraclev9i) {
        if (Token.hasToken(string, "CHUNK")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "CHUNK").trim());
                lobStorageOraclev9i.setChunk(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong chunk format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initChunk : " + numberFormatException.getMessage());
            }
        }
    }

    private void initRetention(String string, LobStorageOraclev9i lobStorageOraclev9i) {
        if (Token.hasToken(string, "RETENTION")) {
            lobStorageOraclev9i.setOldVersions("RETENTION");
        }
    }

    private void initFreePools(String string, LobStorageOraclev9i lobStorageOraclev9i) {
        if (Token.hasToken(string, "FREEPOOLS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "FREEPOOLS").trim());
                lobStorageOraclev9i.setFreepools(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initFreePools : ", numberFormatException);
            }
        }
    }

    private void initPctVersion(String string, LobStorageOraclev9i lobStorageOraclev9i) {
        if (Token.hasToken(string, "PCTVERSION")) {
            try {
                lobStorageOraclev9i.setOldVersions(LobStorageOracle.OLD_VERSIONS[1]);
                int n = Integer.parseInt(Token.getTokenAfter(string, "PCTVERSION").trim());
                lobStorageOraclev9i.setPCTVersion(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTableOracle.initPctVersion : " + numberFormatException.getMessage());
            }
        }
    }

    private void initStorageInRow(String string, LobStorageOraclev9i lobStorageOraclev9i) {
        if (Token.hasString(string.toUpperCase(), "STORAGE IN ROW")) {
            String string2 = Token.getTokenBefore(string, "STORAGE IN ROW");
            lobStorageOraclev9i.setStorageInRow(string2);
        }
    }

    private void initLSCache(String string, LobStorageOraclev9i lobStorageOraclev9i) {
        if (Token.hasToken(string, "CACHE")) {
            if (Token.hasString(string.toUpperCase(), "CACHE READS")) {
                lobStorageOraclev9i.setCache("CACHE READS");
            } else {
                lobStorageOraclev9i.setCache("CACHE");
            }
        } else if (Token.hasToken(string, "NOCACHE")) {
            lobStorageOraclev9i.setCache("NOCACHE");
        }
    }

    private void initLogging(String string, LobStorageOraclev9i lobStorageOraclev9i) {
        if (Token.hasToken(string, "NOLOGGING")) {
            lobStorageOraclev9i.setLogging("NO");
        } else if (Token.hasToken(string, "LOGGING")) {
            lobStorageOraclev9i.setLogging("YES");
        } else {
            lobStorageOraclev9i.setLogging("");
        }
    }

    private Table getReferencedTable(String string) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table table = (Table)tableSet.getByName(string);
        if (table != null) {
            return table;
        }
        this.importLog.addError("Table with name " + string + " does not exist.");
        throw new ObjectDoesNotExistException("Table with name " + string);
    }

    private void addForeignKey(String string, Table table) {
        block29: {
            Table table2;
            ArrayList<Column> arrayList;
            String string2;
            block30: {
                String string3;
                int n;
                string2 = null;
                if (Token.hasToken(string, "CONSTRAINT")) {
                    string2 = Token.getTokenAfter(string, "CONSTRAINT");
                } else {
                    string2 = Token.getTokenAfter(string, "KEY");
                    n = string2.indexOf("(");
                    if (n > 0) {
                        string2 = string2.substring(0, n);
                    } else if (n == 0) {
                        string2 = null;
                    }
                }
                if (string2 != null) {
                    string2 = Token.removeQuotes(string2);
                }
                n = string.indexOf(41);
                String string4 = string.substring(0, n + 1).trim();
                String string5 = Token.getValBetweenBrackets(string4);
                List list = this.getColumnNames(string5);
                arrayList = new ArrayList<Column>();
                Column[] columnArray = (Column[])table.getElements();
                for (String string6 : list) {
                    for (int i = 0; i < columnArray.length; ++i) {
                        string3 = columnArray[i].getName().trim();
                        if (!string6.equalsIgnoreCase(string3)) continue;
                        arrayList.add(columnArray[i]);
                    }
                }
                int n2 = string.toUpperCase().indexOf("REFERENCES");
                string = string.substring(n2);
                String string7 = Token.getQuotedNameAfterToken(string, "REFERENCES");
                string3 = Token.getValBeforeCharacter(string7, '.');
                String string8 = this.getNameFor(string7);
                string8 = Token.removeQuotes(string8);
                table2 = null;
                if (string3 != null && !"".equals(string3)) {
                    string3 = Token.removeQuotes(string3);
                    table2 = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string3, string8);
                }
                if (table2 == null) {
                    table2 = this.getTableFor(string8);
                }
                if (table2 == null) break block29;
                boolean bl = Token.hasString(string, "(");
                if (!bl) break block30;
                String string9 = Token.getValBetweenBrackets(string);
                List list2 = this.getColumnNames(string9);
                FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(table2, list2);
                if (index == null) break block29;
                FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (string2 != null) {
                    fKIndexAssociation.setName(string2);
                    fKIndexAssociation.getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl2 = Token.hasToken(string, "DELETE");
                if (bl2) {
                    String string10 = Token.getTokenAfter(string, "DELETE");
                    if (string10.equalsIgnoreCase("NO")) {
                        if (Token.getTokenAfter(string, "NO").equalsIgnoreCase("ACTION")) {
                            string10 = "NO ACTION";
                        }
                    } else if (string10.equalsIgnoreCase("SET") && Token.getTokenAfter(string, "SET").equalsIgnoreCase("NULL")) {
                        string10 = "SET NULL";
                    }
                    String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string10.equalsIgnoreCase(stringArray[i])) continue;
                        fKIndexAssociation.setDeleteRule(stringArray[i]);
                        break block29;
                    }
                }
                break block29;
            }
            FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
            Index index = (Index)table2.getPK();
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (string2 != null) {
                    fKIndexAssociation.setName(string2);
                    fKIndexAssociation.getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl = Token.hasToken(string, "DELETE");
                if (bl) {
                    String string11 = Token.getTokenAfter(string, "DELETE");
                    if (string11.equalsIgnoreCase("NO")) {
                        if (Token.getTokenAfter(string, "NO").equalsIgnoreCase("ACTION")) {
                            string11 = "NO ACTION";
                        }
                    } else if (string11.equalsIgnoreCase("SET") && Token.getTokenAfter(string, "SET").equalsIgnoreCase("NULL")) {
                        string11 = "SET NULL";
                    }
                    String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string11.equalsIgnoreCase(stringArray[i])) continue;
                        fKIndexAssociation.setDeleteRule(stringArray[i]);
                        break;
                    }
                }
            }
        }
    }

    private List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            string2 = Token.removeQuotes(string2);
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private String getNameFor(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            if (column.isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            Column column2 = (Column)index2.getElements()[n];
            fKIndexAssociation.swapAndRemoveFKColumn(column2, column, columnArray[n]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    Column getColumnByName(Table table, String string) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getName().equalsIgnoreCase(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    private void processRefAtColumn(RefAtColNode refAtColNode, Table table) {
        String string = this.getNameFor(refAtColNode.referencedTable);
        Table table2 = null;
        try {
            table2 = this.getReferencedTable(string);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
        if (table2 != null) {
            Index index;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (refAtColNode.refColumn != null) {
                arrayList.add(refAtColNode.refColumn);
                index = this.getUniqueIndexForColumnNames(table2, arrayList);
            } else {
                index = (Index)table2.getPK();
            }
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (refAtColNode.constraintName != null) {
                    fKIndexAssociation.setName(refAtColNode.constraintName);
                    fKIndexAssociation.getLocalFKIndex().setName(refAtColNode.constraintName);
                }
                ArrayList<Column> arrayList2 = new ArrayList<Column>();
                Column column = this.getColumnByName(table, refAtColNode.columnName);
                if (column != null) {
                    arrayList2.add(column);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fKIndexAssociation, arrayList2, index);
                    } else {
                        this.fixFKColumns(fKIndexAssociation, arrayList2, index);
                    }
                    if (refAtColNode.onDelete != null) {
                        String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!refAtColNode.onDelete.equalsIgnoreCase(stringArray[i])) continue;
                            fKIndexAssociation.setDeleteRule(stringArray[i]);
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode fKRefNode : this.tableNodeList) {
            Object object2;
            for (Object object2 : fKRefNode.fkStatements) {
                this.addForeignKey((String)object2, fKRefNode.processedTable);
            }
            object2 = fKRefNode.refAtColumns.iterator();
            while (object2.hasNext()) {
                this.processRefAtColumn((RefAtColNode)object2.next(), fKRefNode.processedTable);
            }
        }
    }

    private void parseLine(String string) {
        ColumnProxyOraclev9i columnProxyOraclev9i;
        String string2 = Token.getFirstName(string, '\"', '\"');
        if (string2 != null && (columnProxyOraclev9i = (ColumnProxyOraclev9i)this.tableProxy.getColumnProxyByName(string2)) != null) {
            this.initSubstitutableColumnClause(string, columnProxyOraclev9i);
            if (Token.hasString(string.toUpperCase(), "STORE AS")) {
                if (Token.hasString(string.toUpperCase(), "STORE AS LOB")) {
                    String string3 = Token.getStringAfter(string, "STORE AS LOB");
                    if (!string3.equals("") && !string3.startsWith("(")) {
                        columnProxyOraclev9i.setLobSegname(Token.getFirstName(string3, '\"', '\"'));
                    }
                } else {
                    String string4;
                    columnProxyOraclev9i.setNtStorageTable(Token.getFirstName(Token.getStringAfter(string, "STORE AS"), '\"', '\"'));
                    if (Token.hasCloseAndOpenBrackets(Token.getStringAfter(string, "STORE AS"))) {
                        string4 = Token.getValBetweenBrackets(Token.getStringAfter(string, "STORE AS"), 1);
                        columnProxyOraclev9i.setAdditionalNTS(string4);
                    }
                    if (Token.hasString(string.toUpperCase(), "RETURN AS")) {
                        string4 = Token.getFirstToken(Token.getStringAfter(string, "RETURN AS"));
                        columnProxyOraclev9i.setNtReturn(string4);
                    }
                }
            }
        }
    }

    private void initSubstitutableColumnClause(String string) {
        ColumnProxyOraclev9i columnProxyOraclev9i;
        String string2 = Token.getFirstName(string, '\"', '\"');
        if (string2 != null && (columnProxyOraclev9i = (ColumnProxyOraclev9i)this.tableProxy.getColumnProxyByName(string2)) != null) {
            this.initSubstitutableColumnClause(string, columnProxyOraclev9i);
        }
    }

    private void initSubstitutableColumnClause(String string, ColumnProxyOraclev9i columnProxyOraclev9i) {
        String string2;
        if (Token.hasToken(string, "SUBSTITUTABLE")) {
            if (Token.hasString(string.toUpperCase(), "NOT SUBSTITUTABLE")) {
                columnProxyOraclev9i.setSubtitutable("NO");
            } else {
                columnProxyOraclev9i.setSubtitutable("YES");
            }
        } else if (Token.hasCloseAndOpenBrackets(string) && Token.hasToken(string2 = Token.getValBetweenBrackets(string, 1), "ONLY")) {
            String string3 = Token.getQuotedNameAfterToken(string2, "ONLY");
            columnProxyOraclev9i.setElementType(string3);
            Column column = (Column)columnProxyOraclev9i.getObject();
            column.setAllowSubtypeSubstitution(true);
            if (!column.getDataType().equals(string3)) {
                columnProxyOraclev9i.setSubtitutable("ONLY FOR TYPE");
            } else {
                columnProxyOraclev9i.setSubtitutable("YES");
            }
        }
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String constraintName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

