/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateClusterOraclev9i
extends DDLStatementHandler {
    private String userName;
    private String line;
    private static final Logger LOGGER = new Logger(SHCreateClusterOraclev9i.class);

    public SHCreateClusterOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateClusterOraclev9i.clearCR(string);
        this.line = string;
        if (Token.startsWithString(string2, "create cluster")) {
            this.parseCluster(string2);
        } else {
            this.nextHandler(string);
        }
    }

    public void parseCluster(String string) {
        ClusterOraclev9i clusterOraclev9i;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOraclev9i storageDesignOraclev9i = (StorageDesignOraclev9i)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOraclev9i != null && (clusterOraclev9i = (ClusterOraclev9i)storageDesignOraclev9i.getClusterSet().createCluster()) != null) {
            try {
                this.initName(clusterOraclev9i);
                this.initUser(clusterOraclev9i, storageDesignOraclev9i);
                this.initColumns(clusterOraclev9i, storageDesignOraclev9i);
                this.initSegment(clusterOraclev9i, storageDesignOraclev9i);
                this.initSize(clusterOraclev9i);
                this.initTableSpace(clusterOraclev9i, storageDesignOraclev9i);
                this.initIndex(clusterOraclev9i);
                this.initSingleTable(clusterOraclev9i);
                this.initHashKeys(clusterOraclev9i);
                this.initParallel(clusterOraclev9i);
                this.initRowDependency(clusterOraclev9i);
                this.initCache(clusterOraclev9i);
                this.design.getRelationalDesign().stampModelObjectDDL(clusterOraclev9i);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string + " for Oracle failed!");
                this.importLog.addFailedStatement(SHCreateClusterOraclev9i.FormatCR(this.line, "\n"));
            }
        }
    }

    private void initRowDependency(ClusterOraclev9i clusterOraclev9i) {
        if (Token.hasToken(this.statement, "ROWDEPENDENCIES")) {
            clusterOraclev9i.setRowDependency("YES");
        } else if (Token.hasToken(this.statement, "NOROWDEPENDENCIES")) {
            clusterOraclev9i.setRowDependency("NO");
        }
    }

    private void initName(ClusterOraclev9i clusterOraclev9i) {
        String string = Token.getNameAfterToken(this.statement, "CLUSTER", '\"', '\"').trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.userName = Token.getValBeforeCharacter(string, '.');
            string = Token.getValAfterCharacter(string, '.');
        }
        clusterOraclev9i.setName(string);
    }

    private void initUser(ClusterOraclev9i clusterOraclev9i, StorageDesignOraclev9i storageDesignOraclev9i) {
        if (this.userName != null) {
            UserOraclev9i userOraclev9i = (UserOraclev9i)storageDesignOraclev9i.getUserSet().getByName(this.userName);
            if (userOraclev9i == null) {
                userOraclev9i = (UserOraclev9i)storageDesignOraclev9i.getUserSet().createUser();
                userOraclev9i.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(userOraclev9i);
            }
            clusterOraclev9i.setUser(userOraclev9i);
        }
    }

    private void initColumns(ClusterOraclev9i clusterOraclev9i, StorageDesignOraclev9i storageDesignOraclev9i) {
        String string = Token.getStringAfter(this.statement, Token.getTokenAfter(this.statement, "CLUSTER").trim());
        if (string.indexOf("(") == 0) {
            String string2 = Token.getValBetweenBrackets(string, 1);
            int n = 1;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                while (Token.hasOpenBracket(string3) && stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + "," + stringTokenizer.nextToken();
                }
                string3 = string3.trim();
                String string4 = Token.getFirstToken(string3);
                string3 = Token.cutTokenFromFront(string3, string4).toUpperCase();
                string4 = Token.getName(string4);
                String string5 = Token.getFirstToken(string3);
                int n2 = string5.indexOf("(");
                if (n2 >= 0) {
                    string5 = string5.substring(0, n2);
                }
                if (string5.equals("TIMESTAMP")) {
                    if (string3.indexOf("WITH") >= 0) {
                        string5 = string3.indexOf("LOCAL") >= 0 ? "TIMESTAMP WITH LOCAL TIME ZONE" : "TIMESTAMP WITH TIME ZONE";
                    }
                } else if (string5.equals("INTERVAL")) {
                    if (string3.indexOf("YEAR") >= 0) {
                        string5 = "INTERVAL YEAR TO MONTH";
                    } else if (string3.indexOf("DAY") >= 0) {
                        string5 = "INTERVAL DAY TO SECOND";
                    }
                } else if (string5.equals("DOUBLE")) {
                    string5 = "DOUBLE PRECISION";
                }
                ClusterColumnOracle clusterColumnOracle = storageDesignOraclev9i.getClusterColumnSet().createClusterColumn();
                clusterColumnOracle.setCluster(clusterOraclev9i);
                clusterColumnOracle.setName(string4);
                this.design.getRelationalDesign().stampModelObjectDDL(clusterColumnOracle);
                clusterColumnOracle.setDataType(string5);
                if (Token.hasCloseAndOpenBrackets(string3)) {
                    String string6;
                    String string7;
                    if (string5.equals("INTERVAL DAY TO SECOND")) {
                        String string8;
                        String string9;
                        string7 = Token.cutTokenFromFront(string3, "INTERVAL");
                        String string10 = Token.cutTokenFromFront(string7, "DAY");
                        if (string10.startsWith("(") && (string6 = Token.getValBetweenBrackets(string10, 1).trim()).length() > 0) {
                            clusterColumnOracle.setLengthPrecision(string6);
                        }
                        if ((string9 = Token.cutTokenFromFront(string6 = Token.getStringAfterToken(string7, "TO"), "SECOND")).startsWith("(") && (string8 = Token.getValBetweenBrackets(string9, 1).trim()).length() > 0) {
                            try {
                                clusterColumnOracle.setScale(Integer.parseInt(string8));
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("Wrong precision format " + string8);
                                this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                            }
                        }
                    } else {
                        string7 = Token.getValBetweenBrackets(string3);
                        int n3 = string7.indexOf(44);
                        if (n3 >= 0) {
                            string6 = string7.substring(n3 + 1).trim();
                            string7 = string7.substring(0, n3).trim();
                            try {
                                clusterColumnOracle.setScale(Integer.parseInt(string6));
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHCreateClusterOracle.initColumns : " + numberFormatException.getMessage());
                                this.importLog.addWarning("Wrong Scale value in statement " + this.statement);
                            }
                        }
                        clusterColumnOracle.setLengthPrecision(string7);
                    }
                }
                clusterColumnOracle.setPosition(n++);
            }
        }
    }

    private void initSegment(ClusterOraclev9i clusterOraclev9i, StorageDesignOraclev9i storageDesignOraclev9i) {
        SegmentOraclev9i segmentOraclev9i = null;
        if (Token.hasToken(this.statement, "PCTFREE") && (segmentOraclev9i = (SegmentOraclev9i)storageDesignOraclev9i.getSegmentSet().createSegment()) != null) {
            this.initPctFree(segmentOraclev9i);
            this.initPctUsed(segmentOraclev9i);
            this.initInitrans(segmentOraclev9i);
            this.initMaxtrans(segmentOraclev9i);
            this.initStorage(segmentOraclev9i);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev9i);
            SegmentOracle segmentOracle = storageDesignOraclev9i.getSegmentSet().findEqual(segmentOraclev9i);
            clusterOraclev9i.setSegment(segmentOracle);
        }
    }

    private void initPctFree(SegmentOraclev9i segmentOraclev9i) {
        String string = Token.getTokenAfter(this.statement, "PCTFREE").trim();
        try {
            int n = Integer.parseInt(string);
            segmentOraclev9i.setPCTFree(n);
        }
        catch (NumberFormatException numberFormatException) {
            this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
            LOGGER.error("wrong format in SHCreateClusterOracle.initPctFree : " + numberFormatException.getMessage());
        }
    }

    private void initPctUsed(SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(this.statement, "PCTUSED")) {
            String string = Token.getTokenAfter(this.statement, "PCTUSED").trim();
            try {
                int n = Integer.parseInt(string);
                segmentOraclev9i.setPCTUsed(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTUSED format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initPctUsed : " + numberFormatException.getMessage());
            }
        }
    }

    private void initInitrans(SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(this.statement, "INITRANS")) {
            String string = Token.getTokenAfter(this.statement, "INITRANS").trim();
            try {
                int n = Integer.parseInt(string);
                segmentOraclev9i.setInitrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initInitrans : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxtrans(SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(this.statement, "MAXTRANS")) {
            String string = Token.getTokenAfter(this.statement, "MAXTRANS").trim();
            try {
                int n = Integer.parseInt(string);
                segmentOraclev9i.setMaxTrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initMaxtrans : " + numberFormatException.getMessage());
            }
        }
    }

    private void initStorage(SegmentOraclev9i segmentOraclev9i) {
        String string;
        if (Token.hasToken(this.statement, "STORAGE") && Token.getFirstToken(string = Token.getStringAfter(this.statement, "STORAGE")).equalsIgnoreCase("(")) {
            string = Token.getValBetweenBrackets(string, 1).trim();
            this.initInitial(string, segmentOraclev9i);
            this.initNext(string, segmentOraclev9i);
            this.initPCtIncrease(string, segmentOraclev9i);
            this.initMinExtents(string, segmentOraclev9i);
            this.initMaxExtents(string, segmentOraclev9i);
            this.initFreeLists(string, segmentOraclev9i);
            this.initFreeListGroups(string, segmentOraclev9i);
            this.initSegBufferPool(string, segmentOraclev9i);
        }
    }

    private void initInitial(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "INITIAL")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "INITIAL").trim());
            try {
                long l = Long.parseLong(string2);
                segmentOraclev9i.setSCInitialExtent(l);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initInitial : " + numberFormatException.getMessage());
            }
        }
    }

    private void initNext(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "NEXT")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "NEXT").trim());
            try {
                long l = Long.parseLong(string2);
                segmentOraclev9i.setSCNextExtent(l);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initNext : " + numberFormatException.getMessage());
            }
        }
    }

    private void initPCtIncrease(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "PCTINCREASE")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "PCTINCREASE").trim());
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev9i.setSCPctIncrease(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initPCtIncrease : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMinExtents(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "MINEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MINEXTENTS").trim());
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev9i.setSCMinExtents(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initMinExtents : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxExtents(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "MAXEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MAXEXTENTS").trim());
            segmentOraclev9i.setSCMaxExtents(string2);
        }
    }

    private void initFreeLists(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "FREELISTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "FREELISTS").trim());
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev9i.setSCFreeLists(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initFreeLists : " + numberFormatException.getMessage());
            }
        }
    }

    private void initFreeListGroups(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "GROUPS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "GROUPS").trim());
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev9i.setSCFreelistGroups(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initFreeListGroups : " + numberFormatException.getMessage());
            }
        }
    }

    private void initSegBufferPool(String string, SegmentOraclev9i segmentOraclev9i) {
        if (Token.hasToken(string, "BUFFER_POOL")) {
            String string2 = Token.getQuotedNameAfterToken(string, "BUFFER_POOL").trim();
            segmentOraclev9i.setSCBufferPool(string2);
        }
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1).trim();
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n *= 1024);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("SHCreateClusterOracle9i.getNumberOnly - Unable to parse value: " + string, numberFormatException);
            }
        }
        return string;
    }

    private void initSize(ClusterOraclev9i clusterOraclev9i) {
        if (Token.hasToken(this.statement, "SIZE")) {
            String string;
            String string2;
            String string3 = Token.getStringAfter(this.statement, "SIZE").toUpperCase();
            String string4 = string2 = Token.getFirstToken(string3);
            String string5 = "";
            if (string2.endsWith("K") || string2.endsWith("M")) {
                string4 = string2.substring(0, string2.length() - 1);
                string5 = string2.substring(string2.length() - 1);
            }
            try {
                clusterOraclev9i.setSize(Integer.parseInt(string4));
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initSize : " + numberFormatException.getMessage());
            }
            if ("".equalsIgnoreCase(string5) && ((string = Token.getTokenAfter(string3, string2)).equals("K") || string.equals("M"))) {
                string5 = string;
            }
            if (!"".equalsIgnoreCase(string5)) {
                clusterOraclev9i.setMeasureUnit(string5);
            }
        }
    }

    private void initTableSpace(ClusterOraclev9i clusterOraclev9i, StorageDesignOraclev9i storageDesignOraclev9i) {
        if (Token.hasToken(this.statement, "TABLESPACE")) {
            String string = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
            TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)storageDesignOraclev9i.getTableSpaceSet().getByName(string);
            if (tableSpaceOraclev9i != null) {
                clusterOraclev9i.setTableSpace(tableSpaceOraclev9i);
            }
        }
    }

    private void initIndex(ClusterOraclev9i clusterOraclev9i) {
        if (Token.hasToken(Token.getStringAfter(this.statement, Token.getTokenAfter(this.statement, "CLUSTER")), "INDEX")) {
            clusterOraclev9i.setIndexed("YES");
        } else {
            clusterOraclev9i.setIndexed("NO");
        }
    }

    private void initSingleTable(ClusterOraclev9i clusterOraclev9i) {
        if (Token.hasString(this.statement, "SINGLE TABLE")) {
            clusterOraclev9i.setSingleTable("YES");
        }
    }

    private void initHashKeys(ClusterOraclev9i clusterOraclev9i) {
        if (Token.hasToken(this.statement, "HASHKEYS")) {
            String string = Token.getTokenAfter(this.statement, "HASHKEYS").trim();
            try {
                int n = Integer.parseInt(string);
                clusterOraclev9i.setHashKeys(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateClusterOracle.initHashKeys : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong HASHKEYS format in statement " + this.statement);
            }
            if (Token.hasString(this.statement, "HASH IS")) {
                String string2 = Token.getStringAfter(this.statement, "HASH IS");
                if (Token.hasToken(string2, "PARALLEL")) {
                    string2 = Token.getStringBefore(string2, "PARALLEL");
                } else if (Token.hasToken(string2, "NOPARALLEL")) {
                    string2 = Token.getStringBefore(string2, "NOPARALLEL");
                } else if (Token.hasToken(string2, "ROWDEPENDENCIES")) {
                    string2 = Token.getStringBefore(string2, "ROWDEPENDENCIES");
                } else if (Token.hasToken(string2, "NOROWDEPENDENCIES")) {
                    string2 = Token.getStringBefore(string2, "NOROWDEPENDENCIES");
                } else if (Token.hasToken(string2, "CACHE")) {
                    string2 = Token.getStringBefore(string2, "CACHE");
                } else if (Token.hasToken(string2, "NOCACHE")) {
                    string2 = Token.getStringBefore(string2, "NOCACHE");
                }
                clusterOraclev9i.setHashExpression(string2);
            }
        }
    }

    private void initParallel(ClusterOraclev9i clusterOraclev9i) {
        if (Token.hasToken(this.statement, "PARALLEL")) {
            clusterOraclev9i.setParallel("YES");
        }
    }

    private void initCache(ClusterOraclev9i clusterOraclev9i) {
        if (Token.hasToken(this.statement, "CACHE")) {
            clusterOraclev9i.setCache("YES");
        }
    }
}

