/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateUserOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateUserOraclev10g.class);

    public SHCreateUserOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateUserOraclev10g.clearCR(string);
        if (Token.startsWithString(string2, "create user")) {
            try {
                this.parseUser(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateUserOraclev10g.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseUser(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOraclev10g storageDesignOraclev10g = (StorageDesignOraclev10g)this.design.getStorageDesign(rDBMSSite);
        boolean bl = false;
        if (storageDesignOraclev10g != null) {
            UserOraclev10g userOraclev10g;
            String string2 = Token.getNameAfterToken(this.statement, "USER", '\"', '\"').trim();
            Iterator iterator = storageDesignOraclev10g.getUserSet().iterator();
            while (iterator.hasNext()) {
                userOraclev10g = (UserOraclev10g)iterator.next();
                if (!userOraclev10g.getName().equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl && (userOraclev10g = (UserOraclev10g)storageDesignOraclev10g.getUserSet().createUser()) != null) {
                this.initName(userOraclev10g);
                this.initIdentified(userOraclev10g);
                this.initDefTableSpace(userOraclev10g, storageDesignOraclev10g);
                this.initTempTableSpace(userOraclev10g, storageDesignOraclev10g);
                this.initQuotaItems(userOraclev10g, storageDesignOraclev10g);
                this.initProfile(userOraclev10g);
                this.initPasswordExpire(userOraclev10g);
                this.initAccountLock(userOraclev10g);
                this.initSchemaObject(userOraclev10g);
                this.design.getRelationalDesign().stampModelObjectDDL(userOraclev10g);
            }
        }
    }

    private void initName(UserOraclev10g userOraclev10g) {
        String string = Token.getNameAfterToken(this.statement, "USER", '\"', '\"').trim();
        userOraclev10g.setName(string);
    }

    private void initIdentified(UserOraclev10g userOraclev10g) {
        if (Token.hasToken(this.statement, "IDENTIFIED")) {
            String string = Token.getTokenAfter(this.statement, "IDENTIFIED").trim();
            if ("BY".equalsIgnoreCase(string)) {
                String string2 = Token.getTokenAfter(this.statement, "BY").trim();
                if ("VALUES".equalsIgnoreCase(string2)) {
                    String string3 = Token.getNameAfterToken(this.statement, "VALUES", '\'', '\'').trim();
                    string2 = string2 + " '" + string3 + "'";
                }
                userOraclev10g.setAuthType(UserOracle.getAuthTypes()[0]);
                userOraclev10g.encodeIdentifier(string2);
            } else if ("GLOBALLY".equalsIgnoreCase(string)) {
                String string4 = Token.getNameAfterToken(this.statement, "AS", '\'', '\'').trim();
                userOraclev10g.setAuthType(UserOracle.getAuthTypes()[2]);
                userOraclev10g.encodeIdentifier("'" + string4 + "'");
            } else {
                userOraclev10g.setAuthType(UserOracle.getAuthTypes()[1]);
                String string5 = Token.getNameAfterToken(this.statement, "EXTERNALLY AS", '\'', '\'').trim();
                if (!"".equals(string5)) {
                    userOraclev10g.encodeIdentifier("'" + string5 + "'");
                }
            }
        }
    }

    private void initDefTableSpace(UserOraclev10g userOraclev10g, StorageDesignOraclev10g storageDesignOraclev10g) {
        String string;
        if (Token.hasToken(this.statement, "DEFAULT") && Token.getFirstToken(string = Token.getStringAfter(this.statement, "DEFAULT")).equalsIgnoreCase("TABLESPACE")) {
            string = Token.cutFirstToken(string);
            String string2 = Token.getFirstToken(string).trim();
            string2 = Token.getName(string2);
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOraclev10g.getTableSpaceSet().getByName(string2);
            if (tableSpaceOracle != null) {
                userOraclev10g.setDefTableSpace(tableSpaceOracle);
            }
        }
    }

    private void initTempTableSpace(UserOraclev10g userOraclev10g, StorageDesignOraclev10g storageDesignOraclev10g) {
        String string;
        if (Token.hasToken(this.statement, "TEMPORARY") && Token.getFirstToken(string = Token.getStringAfter(this.statement, "TEMPORARY")).equalsIgnoreCase("TABLESPACE")) {
            string = Token.cutFirstToken(string);
            String string2 = Token.getFirstToken(string).trim();
            string2 = Token.getName(string2);
            TemporaryTablespaceOracle temporaryTablespaceOracle = (TemporaryTablespaceOracle)storageDesignOraclev10g.getTemporaryTablespaceSet().getByName(string2);
            if (temporaryTablespaceOracle != null) {
                userOraclev10g.setTempTableSpace(temporaryTablespaceOracle);
            } else {
                userOraclev10g.setTempTSGroupName(string2);
            }
        }
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1).trim();
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n *= 1024);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("SHCreateUserOracle10g.getNumberOnly - Unable to parse value: " + string, numberFormatException);
            }
        }
        return string;
    }

    private void initQuotaItems(UserOraclev10g userOraclev10g, StorageDesignOraclev10g storageDesignOraclev10g) {
        String string = this.statement;
        while (Token.hasToken(string, "QUOTA")) {
            string = Token.getStringAfter(string, "QUOTA");
            QuotaItemOracle quotaItemOracle = storageDesignOraclev10g.getQuotaItemSet().createQuotaItem();
            quotaItemOracle.setUser(userOraclev10g);
            String string2 = this.getNumberOnly(Token.getFirstToken(string).trim());
            quotaItemOracle.setSize(string2);
            String string3 = Token.getTokenAfter(string, "ON").trim();
            string3 = Token.getName(string3);
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOraclev10g.getTableSpaceSet().getByName(string3);
            if (tableSpaceOracle != null) {
                quotaItemOracle.setTableSpace(tableSpaceOracle);
            }
            string = Token.getStringAfter(string, string3);
        }
    }

    private void initProfile(UserOraclev10g userOraclev10g) {
        if (Token.hasToken(this.statement, "PROFILE")) {
            String string = Token.getTokenAfter(this.statement, "PROFILE").trim();
            userOraclev10g.setProfile(string);
        }
    }

    private void initPasswordExpire(UserOraclev10g userOraclev10g) {
        if (Token.hasToken(this.statement, "EXPIRE")) {
            userOraclev10g.setPasswordExpire("YES");
        } else {
            userOraclev10g.setPasswordExpire("NO");
        }
    }

    private void initAccountLock(UserOraclev10g userOraclev10g) {
        if (Token.hasToken(this.statement, "ACCOUNT")) {
            String string = Token.getTokenAfter(this.statement, "ACCOUNT").trim();
            if ("LOCK".equalsIgnoreCase(string)) {
                userOraclev10g.setAccountLock("YES");
            } else {
                userOraclev10g.setAccountLock("NO");
            }
        }
    }

    private void initSchemaObject(UserOraclev10g userOraclev10g) {
        SchemaObject schemaObject;
        boolean bl = false;
        SchemaObjectSet schemaObjectSet = this.design.getRelationalDesign().getSchemaObjectSet();
        Iterator iterator = schemaObjectSet.iterator();
        while (iterator.hasNext()) {
            schemaObject = (SchemaObject)iterator.next();
            if (!schemaObject.getName().equals(userOraclev10g.getName())) continue;
            userOraclev10g.setSchemaObject(schemaObject);
            bl = true;
            break;
        }
        if (!bl) {
            schemaObject = schemaObjectSet.createSchemaObject(null);
            schemaObject.setName(userOraclev10g.getName());
            this.design.getRelationalDesign().stampModelObjectDDL(schemaObject);
            userOraclev10g.setSchemaObject(schemaObject);
        }
    }
}

