/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTemporaryTablespaceOraclev10g
extends DDLStatementHandler {
    private TemporaryTablespaceOraclev10g tempTS;
    private StorageDesignOraclev10g stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTemporaryTablespaceOraclev10g.class);

    public SHCreateTemporaryTablespaceOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTemporaryTablespaceOraclev10g.clearCR(string);
        if (Token.startsWithString(string2, "create temporary tablespace") || Token.startsWithString(string2, "create bigfile temporary tablespace") || Token.startsWithString(string2, "create smallfile temporary tablespace")) {
            try {
                this.parseTemporaryTablespace(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateTemporaryTablespaceOraclev10g.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseTemporaryTablespace(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(rDBMSSite);
        if (this.stoDesign != null) {
            this.tempTS = (TemporaryTablespaceOraclev10g)this.stoDesign.getTemporaryTablespaceSet().createTemporaryTablespace();
            if (this.tempTS != null) {
                this.initName(this.tempTS);
                this.initTempFiles();
                this.initTableSpaceGroup(this.tempTS);
                this.initExtent(this.tempTS);
                this.initFileType(this.tempTS);
                this.design.getRelationalDesign().stampModelObjectDDL(this.tempTS);
            }
        }
    }

    private void initTableSpaceGroup(TemporaryTablespaceOraclev10g temporaryTablespaceOraclev10g) {
        if (Token.hasString(this.statement, "TABLESPACE GROUP")) {
            String string = Token.getTokenAfter(this.statement, "GROUP").trim();
            string = Token.getName(string);
            temporaryTablespaceOraclev10g.setTableSpaceGroup(string);
        }
    }

    private void initName(TemporaryTablespaceOraclev10g temporaryTablespaceOraclev10g) {
        String string = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
        temporaryTablespaceOraclev10g.setName(string);
    }

    private void initTempFiles() {
        if (Token.hasToken(this.statement, "TEMPFILE")) {
            String[] stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String string = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "TEMPFILE"), stringArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                this.initTempFile(string2);
            }
        }
    }

    private void initTempFile(String string) {
        if (!"".equalsIgnoreCase(string)) {
            String string2;
            String string3;
            DataFileOraclev10g dataFileOraclev10g = (DataFileOraclev10g)this.stoDesign.getDataFileSet().createDataFile();
            this.design.getRelationalDesign().stampModelObjectDDL(dataFileOraclev10g);
            dataFileOraclev10g.setTemporaryTablespace(this.tempTS);
            if (string.startsWith("'")) {
                dataFileOraclev10g.setFileName(Token.getFirstName(string, '\'', '\''));
                this.tempTS.setOracleManagedFiles("NO");
            }
            if (Token.hasToken(string, "SIZE")) {
                string3 = Token.getTokenAfter(string, "SIZE");
                try {
                    dataFileOraclev10g.setSize(Long.parseLong(this.getNumberOnly(string3)));
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", numberFormatException);
                }
                string2 = this.getMeasureUnit(string3, string);
                dataFileOraclev10g.setMeasureUnit(string2);
            }
            if (Token.hasToken(string, "REUSE")) {
                dataFileOraclev10g.setReuse("YES");
            } else {
                dataFileOraclev10g.setReuse("NO");
            }
            if (Token.hasToken(string, "AUTOEXTEND")) {
                string3 = Token.getTokenAfter(string, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(string3)) {
                    dataFileOraclev10g.setAutoextend("ON");
                    if (Token.hasToken(string, "NEXT")) {
                        string2 = Token.getTokenAfter(string, "NEXT").trim();
                        try {
                            int n = Integer.parseInt(this.getNumberOnly(string2));
                            dataFileOraclev10g.setNextBlockSize(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", numberFormatException);
                        }
                    }
                    if (Token.hasToken(string, "MAXSIZE")) {
                        dataFileOraclev10g.setMaxSize(this.getNumberOnly(Token.getTokenAfter(string, "MAXSIZE").trim()));
                    }
                } else if ("OFF".equalsIgnoreCase(string3)) {
                    dataFileOraclev10g.setAutoextend("OFF");
                }
            }
        }
    }

    private String getNumberOnly(String string) {
        String string2 = string.toUpperCase();
        if (string2.endsWith("K") || string2.endsWith("M") || string2.endsWith("G") || string2.endsWith("T") || string2.endsWith("P") || string2.endsWith("E")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getMeasureUnit(String string, String string2) {
        String string3 = string.toUpperCase();
        if (string3.endsWith("K") || string3.endsWith("M") || string3.endsWith("G") || string3.endsWith("T") || string3.endsWith("P") || string3.endsWith("E")) {
            return string3.substring(string3.length() - 1);
        }
        string3 = Token.getTokenAfter(string2, string).toUpperCase();
        if (string3.equals("K") || string3.equals("M") || string3.equals("G") || string3.equals("T") || string3.equals("P") || string3.equals("E")) {
            return string3;
        }
        return "";
    }

    private void initExtent(TemporaryTablespaceOraclev10g temporaryTablespaceOraclev10g) {
        if (Token.hasToken(this.statement, "UNIFORM")) {
            String string = Token.getStringAfterToken(this.statement, "UNIFORM");
            String string2 = Token.getTokenAfter(string, "SIZE");
            try {
                temporaryTablespaceOraclev10g.setUniformSize(Long.parseLong(this.getNumberOnly(string2)));
                temporaryTablespaceOraclev10g.setMeasureUnitUniformSize(this.getMeasureUnit(string2, string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error(" Wrong syntax near " + string2 + "!");
            }
        }
    }

    private void initFileType(TemporaryTablespaceOraclev10g temporaryTablespaceOraclev10g) {
        String string = Token.getTokenAfter(this.statement, "CREATE");
        temporaryTablespaceOraclev10g.setFileType(string.toUpperCase());
    }
}

