/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHColumnElementsOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateTableOraclev9i;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class SHCreateTableOraclev10g
extends DDLStatementHandler
implements SectionConstants,
CreateTableHandler {
    private Table table = null;
    private RDBMSSite site = null;
    private StorageDesignOraclev10g storageDesign = null;
    private TableProxyOraclev10g tableProxy = null;
    private boolean createDomainsDuringImport;
    private String tableName;
    private ArrayList columns;
    protected List fkList;
    protected List refAtColumnList;
    protected List tableNodeList = new ArrayList();
    private String outSideBrackets;
    private String inSideBrackets;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateTableOraclev10g.class);
    private final String[] colPropsStartWords = new String[]{"COLUMN", "NESTED TABLE", "VARRAY", "XMLTYPE"};

    public SHCreateTableOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        block5: {
            String string2 = SHCreateTableOraclev10g.clearCR(string);
            if ((Token.startsWithString(string2, "create table") || Token.startsWithString(string2, "create global temporary table")) && string2.toLowerCase().indexOf("organization external") == -1) {
                try {
                    this.fkList = new ArrayList();
                    this.refAtColumnList = new ArrayList();
                    this.parseTable(string2);
                    FKRefNode fKRefNode = new FKRefNode();
                    fKRefNode.processedTable = this.table;
                    fKRefNode.fkStatements = this.fkList;
                    fKRefNode.refAtColumns = this.refAtColumnList;
                    this.tableNodeList.add(fKRefNode);
                    if (this.failed) {
                        this.importLog.addFailedStatement(SHCreateTableOraclev10g.FormatCR(string, "\n"));
                        break block5;
                    }
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception exception) {
                    LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                    this.importLog.addFailedStatement(SHCreateTableOraclev10g.FormatCR(string, "\n"));
                }
            } else {
                this.nextHandler(string);
            }
        }
    }

    public void parseTable(String string) {
        Object object;
        int n;
        this.setStatement(string);
        this.tableName = this.initTableName();
        this.table = this.design.getRelationalDesign().createTable();
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(this.site);
        this.tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.initUser();
        this.table.setName(this.tableName);
        this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        this.createDomainsDuringImport = this.design.getAppView().getSettings().isCreateDomainsDuringImport();
        String string2 = Token.getStringAfterToken(string, "OF").trim();
        String string3 = null;
        if ("".equalsIgnoreCase(string2)) {
            this.inSideBrackets = Token.getValBetweenBrackets(this.statement, 1).trim();
            this.outSideBrackets = Token.getValAfterBrackets(this.statement, 1).trim();
        } else {
            this.inSideBrackets = "";
            string3 = Token.getFirstToken(string2);
            this.outSideBrackets = Token.cutTokenFromFront(string2, string3);
        }
        boolean bl = false;
        if (string3 != null) {
            n = string3.indexOf(46);
            if (n > 0) {
                string3 = Token.getValAfterCharacter(string3, '.');
            }
            if (string3.startsWith("\"")) {
                string3 = Token.getValBetweenDoubleQuotes(string3);
            }
            if ((object = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string3)) != null) {
                this.table.setBasedOnStructuredType((StructuredType)object);
                bl = true;
                if (this.tableProxy.getIndexes().size() > 0) {
                    this.tableProxy.getIndexes().removeAll();
                }
            } else {
                LOGGER.error("Unable to find required Structured Type: " + string3);
            }
        }
        if (bl) {
            ModelIDObject modelIDObject;
            String string4;
            String string5;
            String string6 = Token.getValBetweenBrackets(string, 1);
            if (string6.length() > 0) {
                object = new StringTokenizer(string6, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string5 = Token.trimLeft(((StringTokenizer)object).nextToken());
                    string4 = Token.getFirstToken(string5);
                    int n2 = (string5 = string5.toUpperCase()).indexOf(" NOT ");
                    if (n2 < 0 || !string5.substring(n2 + 5).trim().startsWith("NULL") || (modelIDObject = (Column)this.table.getElementByName(string4)) == null) continue;
                    ((ContainedObject)modelIDObject).setNullsAllowed(false);
                }
            }
            if (Token.hasString(string.toUpperCase(), "OBJECT IDENTIFIER IS") && ((String)(object = Token.getStringAfter(string, "OBJECT IDENTIFIER IS"))).toUpperCase().startsWith("SYSTEM GENERATED")) {
                this.table.setUserDefinedOid(false);
            }
            if (Token.hasToken(string, "OIDINDEX")) {
                object = Token.getStringAfterToken(string, "OIDINDEX");
                string5 = Token.getTokenAfter((String)object, "OIDINDEX");
                if (!"".equalsIgnoreCase(string5 = Token.getStringBefore(string5, "(").trim())) {
                    // empty if block
                }
            }
            if ("XMLTYPE".equalsIgnoreCase(string3)) {
                if (Token.hasString(string.toUpperCase(), "XMLTYPE STORE AS")) {
                    object = Token.getStringAfter(string, "XMLTYPE STORE AS");
                    string5 = Token.getFirstToken((String)object);
                    if (string5.equalsIgnoreCase("OBJECT")) {
                        this.tableProxy.setStoreAs("OBJECT RELATIONAL");
                    } else {
                        String string7;
                        if (string5.equalsIgnoreCase("SECUREFILE")) {
                            object = Token.cutTokenFromFront((String)object, "SECUREFILE");
                            if (this.tableProxy instanceof TableProxyOraclev11g) {
                                ((TableProxyOraclev11g)this.tableProxy).setLobStorageType("SECUREFILE");
                            }
                        } else if (string5.equalsIgnoreCase("BASICFILE")) {
                            object = Token.cutTokenFromFront((String)object, "BASICFILE");
                            if (this.tableProxy instanceof TableProxyOraclev11g) {
                                ((TableProxyOraclev11g)this.tableProxy).setLobStorageType("BASICFILE");
                            }
                        }
                        if ((string5 = Token.getFirstToken((String)object)).equalsIgnoreCase("CLOB")) {
                            this.tableProxy.setStoreAs("CLOB");
                        } else if (string5.equalsIgnoreCase("BINARY")) {
                            this.tableProxy.setStoreAs("BINARY XML");
                        }
                        string4 = Token.getValBetweenBrackets((String)object, 1);
                        if (Token.hasToken(string4, "TABLESPACE") && !(string7 = Token.getQuotedNameAfterToken(string4, "TABLESPACE")).equals("")) {
                            modelIDObject = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string7);
                            if (modelIDObject == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                                modelIDObject = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)modelIDObject).setName(string7);
                                this.design.getRelationalDesign().stampModelObjectDDL(modelIDObject);
                            }
                            if (modelIDObject != null) {
                                this.tableProxy.setXmlTypeTableSpace((TableSpaceOracle)modelIDObject);
                            }
                        }
                        if (Token.hasToken(string4, "CHUNK")) {
                            try {
                                int n3 = Integer.parseInt(Token.getTokenAfter(string4, "CHUNK").trim());
                                this.tableProxy.setChunk(n3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHCreateTableOracle.parseTable : " + numberFormatException.getMessage());
                                this.importLog.addWarning("Wrong CHUNK format in statement " + string);
                            }
                        }
                        if (Token.hasToken(string4, "PCTVERSION")) {
                            try {
                                this.tableProxy.setOldVersions(ColumnProxyOraclev10g.getOldVersionChoices()[1]);
                                int n4 = Integer.parseInt(Token.getTokenAfter(string4, "PCTVERSION").trim());
                                this.tableProxy.setPCTVersion(n4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHCreateTableOracle.parseTable : " + numberFormatException.getMessage());
                                this.importLog.addWarning("Wrong PCTVERSION format in statement " + string);
                            }
                        } else if (Token.hasToken(string4, "RETENTION")) {
                            this.tableProxy.setOldVersions("RETENTION");
                        }
                        if (Token.hasToken(string4, "FREEPOOLS")) {
                            try {
                                int n5 = Integer.parseInt(Token.getTokenAfter(string4, "FREEPOOLS").trim());
                                this.tableProxy.setFreepools(n5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHCreateTableOracle.parseTable : ", numberFormatException);
                                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + string);
                            }
                        }
                        if (Token.hasString(string4.toUpperCase(), "STORAGE IN ROW")) {
                            String string8 = Token.getTokenBefore(string4, "STORAGE IN ROW");
                            this.tableProxy.setStorageInRow(string8);
                        }
                        if (Token.hasToken(string4, "CACHE")) {
                            if (Token.hasString(string4.toUpperCase(), "CACHE READS")) {
                                this.tableProxy.setXmlTypeCache("CACHE READS");
                            } else {
                                this.tableProxy.setXmlTypeCache("CACHE");
                            }
                        } else if (Token.hasToken(string4, "NOCACHE")) {
                            this.tableProxy.setXmlTypeCache("NOCACHE");
                        }
                        if (Token.hasToken(string4, "NOLOGGING")) {
                            this.tableProxy.setXmlTypeLogging("NO");
                        } else if (Token.hasToken(string4, "LOGGING")) {
                            this.tableProxy.setXmlTypeLogging("YES");
                        } else if (Token.hasToken(string4, "FILESYSTEM_LIKE_LOGGING")) {
                            this.tableProxy.setXmlTypeLogging("FILESYSTEM_LIKE_LOGGING");
                        }
                    }
                }
                if (!Token.hasToken(string, "XMLSCHEMAS") && Token.hasToken(string, "ELEMENT")) {
                    object = "";
                    string5 = Token.getQuotedNameAfterToken(string, "ELEMENT");
                    int n6 = string5.indexOf(35);
                    if (n6 > -1) {
                        object = string5.substring(0, n6);
                        string5 = string5.substring(n6 + 1);
                    } else if (Token.hasToken(string, "XMLSCHEMA")) {
                        object = Token.getQuotedNameAfterToken(string, "XMLSCHEMA");
                    }
                    this.tableProxy.setXmlSchemaUrl((String)object);
                    this.tableProxy.setXmlSchemaElement(string5);
                }
                if (this.tableProxy instanceof TableProxyOraclev11g) {
                    object = string.toUpperCase();
                    if (Token.hasString((String)object, "DISALLOW ANYSCHEMA")) {
                        ((TableProxyOraclev11g)this.tableProxy).setAllowAnySchema("NO");
                    } else if (Token.hasString((String)object, "ALLOW ANYSCHEMA")) {
                        ((TableProxyOraclev11g)this.tableProxy).setAllowAnySchema("YES");
                    }
                    if (Token.hasString((String)object, "DISALLOW NONSCHEMA")) {
                        ((TableProxyOraclev11g)this.tableProxy).setAllowNonSchema("NO");
                    } else if (Token.hasString((String)object, "ALLOW NONSCHEMA")) {
                        ((TableProxyOraclev11g)this.tableProxy).setAllowNonSchema("YES");
                    }
                }
            }
        }
        if (!bl) {
            this.columns = this.initColumns();
            for (n = 0; n < this.columns.size(); ++n) {
                TableProxyOracle tableProxyOracle;
                String string9;
                boolean bl2;
                String string10;
                TableCheckConstraintOracle tableCheckConstraintOracle;
                Object object2;
                object = (Map)this.columns.get(n);
                boolean bl3 = (Boolean)object.get("IS_CONSTRAINT");
                if (!bl3) {
                    this.initCol((Map)object);
                    continue;
                }
                boolean bl4 = (Boolean)object.get("PRIMARY KEY");
                if (bl4) {
                    this.initPrimaryKey((Map)object);
                    continue;
                }
                boolean bl5 = (Boolean)object.get("UNIQUE");
                if (bl5) {
                    this.initUniqueKey((Map)object);
                    continue;
                }
                boolean bl6 = (Boolean)object.get("HAS_CHECK_CONSTRAINT");
                if (!bl6) continue;
                String string11 = (String)object.get("CHECK_CONSTRAINT");
                String string12 = (String)object.get("CHECK");
                if (string11.equals("")) {
                    object2 = this.tableName;
                    if (((String)object2).length() > 24) {
                        object2 = ((String)object2).substring(0, 24);
                    }
                    string11 = "SYS_" + (String)object2 + this.table.getCheckConstraints().size();
                }
                object2 = this.table.createCheckConstraint(string11, string12);
                ((DesignObject)object2).setName(string11);
                this.table.addCheckConstraint((TableLevelConstraint)object2);
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                if (this.tableProxy == null || (tableCheckConstraintOracle = this.tableProxy.getTableConstraint((TableLevelConstraint)object2)) == null) continue;
                if (object.get("CHK_DEFERRABLE") != null) {
                    boolean bl7 = (Boolean)object.get("CHK_DEFERRABLE");
                    tableCheckConstraintOracle.setDeferrable(bl7 ? "YES" : "NO");
                }
                if ((string10 = (String)object.get("CHK_INITIALLY")) != null) {
                    tableCheckConstraintOracle.setInitially(string10);
                }
                if (object.get("CHK_DISABLE") != null) {
                    bl2 = (Boolean)object.get("CHK_DISABLE");
                    tableCheckConstraintOracle.setEnable(bl2 ? "NO" : "YES");
                }
                if (object.get("CHK_NOVALIDATE") != null) {
                    bl2 = (Boolean)object.get("CHK_NOVALIDATE");
                    tableCheckConstraintOracle.setValidate(bl2 ? "NO" : "YES");
                }
                if ((string9 = (String)object.get("CHK_EXCEPTIONS")) == null || (tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(string9)) == null) continue;
                tableCheckConstraintOracle.setExceptionsTable(tableProxyOracle);
            }
        }
        if (this.tableProxy != null) {
            int n7;
            this.tableProxy.setNameHasQuotes(this.nameHasQuotes());
            this.initTemporary();
            this.initOnCommit();
            String string13 = this.outSideBrackets;
            if (Token.hasToken(this.outSideBrackets, "PARTITION")) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "PARTITION");
            }
            object = this.outSideBrackets;
            if (Token.hasToken(this.outSideBrackets, "LOB")) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "LOB");
            }
            if (Token.hasToken(this.outSideBrackets, "XMLTYPE") && !"XMLTYPE".equalsIgnoreCase(string3)) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "XMLTYPE");
            }
            if (Token.hasToken(this.outSideBrackets, "VARRAY")) {
                this.outSideBrackets = Token.getStringBeforeToken(this.outSideBrackets, "VARRAY");
            }
            if (this.outSideBrackets.toUpperCase().indexOf("NESTED TABLE") > -1) {
                this.outSideBrackets = Token.getStringBefore(this.outSideBrackets, "NESTED TABLE");
            }
            if (this.outSideBrackets.length() < string13.length() && (n7 = string13.lastIndexOf(")")) > -1) {
                this.outSideBrackets = this.outSideBrackets + ' ' + string13.substring(n7 + 1).trim();
            }
            if (Token.hasToken(this.outSideBrackets, "CLUSTER")) {
                this.initCluster();
            } else {
                boolean bl8 = false;
                if (Token.hasToken(this.outSideBrackets, "ORGANIZATION")) {
                    String string14 = Token.getTokenAfter(this.outSideBrackets, "ORGANIZATION");
                    if (string14.equalsIgnoreCase("HEAP")) {
                        this.tableProxy.setOrganization("HEAP");
                    } else if (string14.equalsIgnoreCase("INDEX")) {
                        this.tableProxy.setOrganization("INDEX");
                        this.initIndexOrganizedTable();
                        bl8 = true;
                    }
                }
                if (!bl8) {
                    this.initTableSpace();
                    this.initSegment(this.outSideBrackets);
                    this.initCompression();
                }
            }
            this.initCache();
            this.outSideBrackets = object;
            this.initTableLobStorages();
            this.initColumnlProperties(this.outSideBrackets);
            this.outSideBrackets = string13;
            this.initPartitions();
            this.initParallel();
            this.initMonitoring();
            this.initRowDependency();
            this.initRowMovement();
        }
    }

    private void parseLine(String string) {
        ColumnProxyOraclev10g columnProxyOraclev10g;
        String string2 = Token.getFirstName(string, '\"', '\"');
        if (string2 != null && (columnProxyOraclev10g = (ColumnProxyOraclev10g)this.tableProxy.getColumnProxyByName(string2)) != null) {
            this.initSubstitutableColumnClause(string, columnProxyOraclev10g);
            if (Token.hasString(string.toUpperCase(), "STORE AS")) {
                String string3 = "STORE AS";
                if (Token.getTokenAfter(string.toUpperCase(), "STORE AS").equalsIgnoreCase("SECUREFILE")) {
                    string3 = "SECUREFILE";
                    if (columnProxyOraclev10g instanceof ColumnProxyOraclev11g) {
                        ((ColumnProxyOraclev11g)columnProxyOraclev10g).setLobStorageType("SECUREFILE");
                    }
                } else if (Token.getTokenAfter(string.toUpperCase(), "STORE AS").equalsIgnoreCase("BASICFILE")) {
                    string3 = "BASICFILE";
                    if (columnProxyOraclev10g instanceof ColumnProxyOraclev11g) {
                        ((ColumnProxyOraclev11g)columnProxyOraclev10g).setLobStorageType("BASICFILE");
                    }
                }
                if (Token.getTokenAfter(string.toUpperCase(), string3).equalsIgnoreCase("LOB")) {
                    String string4 = Token.getStringAfter(string, "LOB");
                    if (!string4.equals("") && !string4.startsWith("(")) {
                        columnProxyOraclev10g.setLobSegname(Token.getFirstName(string4, '\"', '\"'));
                    }
                } else {
                    String string5;
                    columnProxyOraclev10g.setNtStorageTable(Token.getFirstName(Token.getStringAfter(string, string3), '\"', '\"'));
                    if (Token.hasCloseAndOpenBrackets(Token.getStringAfter(string, string3))) {
                        string5 = Token.getValBetweenBrackets(Token.getStringAfter(string, string3), 1);
                        columnProxyOraclev10g.setAdditionalNTS(string5);
                    }
                    if (Token.hasString(string.toUpperCase(), "RETURN AS")) {
                        string5 = Token.getFirstToken(Token.getStringAfter(string, "RETURN AS"));
                        columnProxyOraclev10g.setNtReturn(string5);
                    }
                }
            }
        }
    }

    private void initSubstitutableColumnClause(String string) {
        ColumnProxyOraclev10g columnProxyOraclev10g;
        String string2 = Token.getFirstName(string, '\"', '\"');
        if (string2 != null && (columnProxyOraclev10g = (ColumnProxyOraclev10g)this.tableProxy.getColumnProxyByName(string2)) != null) {
            this.initSubstitutableColumnClause(string, columnProxyOraclev10g);
        }
    }

    private void initSubstitutableColumnClause(String string, ColumnProxyOraclev10g columnProxyOraclev10g) {
        String string2;
        if (Token.hasToken(string, "SUBSTITUTABLE")) {
            if (Token.hasString(string.toUpperCase(), "NOT SUBSTITUTABLE")) {
                columnProxyOraclev10g.setSubtitutable("NO");
            } else {
                columnProxyOraclev10g.setSubtitutable("YES");
            }
        } else if (Token.hasCloseAndOpenBrackets(string) && Token.hasToken(string2 = Token.getValBetweenBrackets(string, 1), "ONLY")) {
            String string3 = Token.getQuotedNameAfterToken(string2, "ONLY");
            columnProxyOraclev10g.setElementType(string3);
            Column column = (Column)columnProxyOraclev10g.getObject();
            column.setAllowSubtypeSubstitution(true);
            if (!column.getDataType().equals(string3)) {
                columnProxyOraclev10g.setSubtitutable("ONLY FOR TYPE");
            } else {
                columnProxyOraclev10g.setSubtitutable("YES");
            }
        }
    }

    private void initColumnlProperties(String string) {
        String string2 = Token.getStringToFirstMatch(string.toUpperCase(), this.colPropsStartWords);
        String string3 = string.substring(string2.length()).trim();
        while (string3.length() > 0) {
            String string4 = Token.getFirstToken(string3);
            if (string4.equalsIgnoreCase("NESTED") && string3.toUpperCase().startsWith("NESTED TABLE")) {
                string4 = "NESTED TABLE";
            }
            String string5 = string4;
            if (string4.equalsIgnoreCase("XMLTYPE") && string3.toUpperCase().startsWith("XMLTYPE COLUMN")) {
                string5 = "XMLTYPE COLUMN";
            }
            string3 = string3.substring(string5.length()).trim();
            String string6 = Token.getStringToFirstMatch(string3.toUpperCase(), this.colPropsStartWords);
            String string7 = string3.substring(0, string6.length());
            string3 = string3.substring(string7.length()).trim();
            if (string4.equalsIgnoreCase("COLUMN")) {
                this.initSubstitutableColumnClause(string7);
                continue;
            }
            if (string4.equalsIgnoreCase("NESTED TABLE") || string4.equalsIgnoreCase("VARRAY")) {
                this.parseLine(string7);
                continue;
            }
            if (!string4.equalsIgnoreCase("XMLTYPE")) continue;
            this.parseXmlTypeColumnProperties(string7);
        }
    }

    private void parseXmlTypeColumnProperties(String string) {
        ColumnProxyOraclev10g columnProxyOraclev10g;
        String string2 = Token.getFirstName(string, '\"', '\"');
        if (string2 != null && (columnProxyOraclev10g = (ColumnProxyOraclev10g)this.tableProxy.getColumnProxyByName(string2)) != null) {
            String string3;
            String string4;
            if (Token.hasString(string.toUpperCase(), "STORE AS")) {
                string4 = Token.getStringAfter(string, "STORE AS");
                string3 = Token.getFirstToken(string4);
                if (string3.equalsIgnoreCase("OBJECT")) {
                    columnProxyOraclev10g.setStoreAs("OBJECT RELATIONAL");
                } else {
                    if (string3.equalsIgnoreCase("SECUREFILE")) {
                        string4 = Token.cutTokenFromFront(string4, "SECUREFILE");
                        if (columnProxyOraclev10g instanceof ColumnProxyOraclev11g) {
                            ((ColumnProxyOraclev11g)columnProxyOraclev10g).setLobStorageType("SECUREFILE");
                        }
                    } else if (string3.equalsIgnoreCase("BASICFILE")) {
                        string4 = Token.cutTokenFromFront(string4, "BASICFILE");
                        if (columnProxyOraclev10g instanceof ColumnProxyOraclev11g) {
                            ((ColumnProxyOraclev11g)columnProxyOraclev10g).setLobStorageType("BASICFILE");
                        }
                    }
                    if ((string3 = Token.getFirstToken(string4)).equalsIgnoreCase("CLOB")) {
                        string4 = Token.cutTokenFromFront(string4, "CLOB");
                        columnProxyOraclev10g.setStoreAs("CLOB");
                    } else if (string3.equalsIgnoreCase("BINARY")) {
                        string3 = Token.getFirstToken(string4 = Token.cutTokenFromFront(string4, "BINARY"));
                        if (string3.equalsIgnoreCase("XML")) {
                            string4 = Token.cutTokenFromFront(string4, "XML");
                            columnProxyOraclev10g.setStoreAs("BINARY XML");
                        }
                    } else {
                        string4 = "";
                    }
                    if (!string4.equals("")) {
                        if (!string4.startsWith("(")) {
                            string4 = Token.cutFirstToken2(string4);
                        }
                        if (string4.startsWith("(")) {
                            String string5;
                            String string6 = Token.getValBetweenBrackets(string4, 1);
                            if (Token.hasToken(string6, "TABLESPACE") && !(string5 = Token.getQuotedNameAfterToken(string6, "TABLESPACE")).equals("")) {
                                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string5);
                                if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                                    tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    tableSpaceOraclev10g.setName(string5);
                                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                                }
                                if (tableSpaceOraclev10g != null) {
                                    columnProxyOraclev10g.setTablespace(tableSpaceOraclev10g);
                                }
                            }
                            this.initXmlTypeStorage(string6, columnProxyOraclev10g);
                        }
                    }
                }
            }
            if (!Token.hasToken(string, "XMLSCHEMAS") && Token.hasToken(string, "ELEMENT")) {
                string4 = "";
                string3 = Token.getQuotedNameAfterToken(string, "ELEMENT");
                int n = string3.indexOf(35);
                if (n > -1) {
                    string4 = string3.substring(0, n);
                    string3 = string3.substring(n + 1);
                } else if (Token.hasToken(string, "XMLSCHEMA")) {
                    string4 = Token.getQuotedNameAfterToken(string, "XMLSCHEMA");
                }
                columnProxyOraclev10g.setXmlSchemaUrl(string4);
                columnProxyOraclev10g.setXmlSchemaElement(string3);
            }
            if (columnProxyOraclev10g instanceof ColumnProxyOraclev11g) {
                string4 = string.toUpperCase();
                if (Token.hasString(string4, "DISALLOW ANYSCHEMA")) {
                    ((ColumnProxyOraclev11g)columnProxyOraclev10g).setAllowAnySchema("NO");
                } else if (Token.hasString(string4, "ALLOW ANYSCHEMA")) {
                    ((ColumnProxyOraclev11g)columnProxyOraclev10g).setAllowAnySchema("YES");
                }
                if (Token.hasString(string4, "DISALLOW NONSCHEMA")) {
                    ((ColumnProxyOraclev11g)columnProxyOraclev10g).setAllowNonSchema("NO");
                } else if (Token.hasString(string4, "ALLOW NONSCHEMA")) {
                    ((ColumnProxyOraclev11g)columnProxyOraclev10g).setAllowNonSchema("YES");
                }
            }
        }
    }

    private void initXmlTypeStorage(String string, ColumnProxyOraclev10g columnProxyOraclev10g) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, null, null, columnProxyOraclev10g);
            this.initNext(string2, null, null, columnProxyOraclev10g);
            this.initPCtIncrease(string2, null, null, columnProxyOraclev10g);
            this.initMinExtents(string2, null, null, columnProxyOraclev10g);
            this.initMaxExtents(string2, null, null, columnProxyOraclev10g);
            this.initFreeLists(string2, null, null, columnProxyOraclev10g);
            this.initFreeListGroups(string2, null, null, columnProxyOraclev10g);
            this.initSegBufferPool(string2, null, null, columnProxyOraclev10g);
        }
        this.initChunk(string, columnProxyOraclev10g);
        this.initRetention(string, columnProxyOraclev10g);
        this.initPctVersion(string, columnProxyOraclev10g);
        this.initFreePools(string, columnProxyOraclev10g);
        this.initStorageInRow(string, columnProxyOraclev10g);
        this.initLSCache(string, columnProxyOraclev10g);
        this.initLogging(string, columnProxyOraclev10g);
    }

    private void initChunk(String string, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "CHUNK")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "CHUNK").trim());
                columnProxyOraclev10g.setChunk(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initChunk : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong CHUNK format in statement " + this.statement);
            }
        }
    }

    private void initRetention(String string, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "RETENTION")) {
            columnProxyOraclev10g.setOldVersions("RETENTION");
        }
    }

    private void initFreePools(String string, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "FREEPOOLS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "FREEPOOLS").trim());
                columnProxyOraclev10g.setFreepools(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initFreePools : ", numberFormatException);
                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + this.statement);
            }
        }
    }

    private void initPctVersion(String string, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "PCTVERSION")) {
            try {
                columnProxyOraclev10g.setOldVersions(ColumnProxyOraclev10g.getOldVersionChoices()[1]);
                int n = Integer.parseInt(Token.getTokenAfter(string, "PCTVERSION").trim());
                columnProxyOraclev10g.setPCTVersion(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initPctVersion : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
            }
        }
    }

    private void initStorageInRow(String string, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasString(string.toUpperCase(), "STORAGE IN ROW")) {
            String string2 = Token.getTokenBefore(string, "STORAGE IN ROW");
            columnProxyOraclev10g.setStorageInRow(string2);
        }
    }

    private void initLSCache(String string, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "CACHE")) {
            if (Token.hasString(string.toUpperCase(), "CACHE READS")) {
                columnProxyOraclev10g.setCache("CACHE READS");
            } else {
                columnProxyOraclev10g.setCache("CACHE");
            }
        } else if (Token.hasToken(string, "NOCACHE")) {
            columnProxyOraclev10g.setCache("NOCACHE");
        }
    }

    private void initLogging(String string, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "NOLOGGING")) {
            columnProxyOraclev10g.setLogging("NO");
        } else if (Token.hasToken(string, "LOGGING")) {
            columnProxyOraclev10g.setLogging("YES");
        } else if (Token.hasToken(string, "FILESYSTEM_LIKE_LOGGING")) {
            columnProxyOraclev10g.setLogging("FILESYSTEM_LIKE_LOGGING");
        } else {
            columnProxyOraclev10g.setLogging("");
        }
    }

    private boolean nameHasQuotes() {
        String string = Token.getStringAfterToken(this.statement, "TABLE").trim();
        return string.startsWith("\"");
    }

    private String initTableName() {
        int n;
        String string = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        if (Token.hasString(string, "(")) {
            string = Token.getStringBefore(string, "(");
        }
        if ((n = string.indexOf(46)) > 0) {
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void initUser() {
        SchemaObject schemaObject;
        UserSetOracle userSetOracle = this.storageDesign.getUserSet();
        String string = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        String string2 = Token.getValBeforeCharacter(string, '.');
        UserOracle userOracle = (UserOracle)userSetOracle.getByName(string2);
        SchemaObjectSet schemaObjectSet = ((RelationalDesign)this.table.getDesignPart()).getSchemaObjectSet();
        if (userOracle == null && !string2.trim().equalsIgnoreCase("")) {
            userOracle = userSetOracle.createUser();
            userOracle.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(userOracle);
        }
        if ((schemaObject = (SchemaObject)schemaObjectSet.getByName(string2)) == null && !string2.trim().equalsIgnoreCase("")) {
            schemaObject = schemaObjectSet.createSchemaObject(null);
            schemaObject.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(schemaObject);
        }
        if (userOracle != null) {
            if (userOracle.getSchemaObject() == null) {
                userOracle.setSchemaObject(schemaObject);
            }
            if (userOracle.getSchemaObject() != schemaObject) {
                this.tableProxy.setUser(userOracle);
            }
        }
        if (schemaObject != null) {
            this.table.setSchemaObject(schemaObject);
        }
    }

    private ArrayList initColumns() {
        Object object;
        Object object2;
        Object object3;
        String string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = this.inSideBrackets;
        if (Token.hasToken(string2, "SUPPLEMENTAL")) {
            this.tableProxy.setSuplementalLogGroupName(Token.getTokenAfter(string2, "GROUP"));
            string = Token.getStringAfter(string2, "GROUP");
            object3 = Token.getValBetweenBrackets(string);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = Token.getFirstName(stringTokenizer.nextToken(), '\"', '\"');
                ColumnProxy columnProxy = this.tableProxy.getColumnProxyByName(string3);
                if (columnProxy == null) continue;
                this.tableProxy.setSuplementalLogColumns(columnProxy.getObjectID());
            }
            if (Token.getTokenAfter(string, ")").equalsIgnoreCase("ALWAYS")) {
                this.tableProxy.setSuplementalLogConditions("ALWAYS");
                object2 = Token.getStringAfter(string, "ALWAYS");
            } else {
                object2 = Token.getStringAfter(string, ")");
            }
            object = Token.getStringBeforeToken(string2, "SUPPLEMENTAL").trim();
            if (((String)object).endsWith(",")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            string2 = (String)object + (String)object2;
        }
        object = new SHColumnElementsOraclev10g();
        object2 = new StringTokenizer(string2, ",");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            string = ((StringTokenizer)object2).nextToken();
            if (Token.hasOpenBracket(string)) {
                object3 = new StringBuffer(string);
                while (Token.hasOpenBracket(string) && ((StringTokenizer)object2).hasMoreTokens()) {
                    ((StringBuffer)object3).append(",").append(((StringTokenizer)object2).nextToken());
                    string = ((StringBuffer)object3).toString();
                }
            }
            string = string.trim();
            object3 = this.tableProxy != null ? ((SHColumnElementsOraclev10g)object).getElementsColumn(string, this.tableProxy.getRDBMSType()) : (this.storageDesign != null ? ((SHColumnElementsOraclev10g)object).getElementsColumn(string, this.storageDesign.getRDBMSType()) : ((SHColumnElementsOraclev10g)object).getElementsColumn(string, StorageDesignOraclev10g.RDBMS_TYPE));
            if (Boolean.TRUE.equals(object3.get("IS_CONSTRAINT")) && string.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(string);
                continue;
            }
            arrayList.add(object3);
        }
        return arrayList;
    }

    private void initCol(Map map) {
        Object v;
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        Object object5;
        String string2;
        String string3 = (String)map.get("columnname");
        Column column = this.table.createColumn(string3);
        this.design.getRelationalDesign().stampModelObjectDDL(column);
        String string4 = (String)map.get("datatype");
        if (string4 != null) {
            string2 = (String)map.get("scale");
            String string5 = (String)map.get("size");
            String string6 = (String)map.get("precision");
            object5 = new String[]{string6, string2, string5};
            object4 = StandardDatatypeNames.getUsedDatatypeName(string4);
            object4 = StandardDatatypeNames.getTransformedDatatypeName((String)object4, this.getStorageDesign().getRDBMSType());
            object3 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)object4);
            if (this.createDomainsDuringImport) {
                string = DomainFactory.createDomainName((LogicalDatatype)object3, (String[])object5);
                object2 = this.getCorrespondingDomain(string);
                if (object2 != null) {
                    column.setDomain((Domain)object2);
                } else {
                    object = new StringBuffer("domain is null in SHCreateTableOracle.parseTable : ");
                    ((StringBuffer)object).append(string);
                    LOGGER.error(((StringBuffer)object).toString());
                    this.importLog.addError("Null domain occurred while creating " + this.tableName);
                }
            } else {
                column.setLogicalDatatype((LogicalDatatype)object3);
                column.setUse((short)1);
                column.setDataTypeParameter("scale", string2);
                column.setDataTypeParameter("precision", string6);
                column.setDataTypeParameter("size", string5);
            }
        } else {
            string2 = (String)map.get(NameElements.COL_STRUCTURED_TYPE);
            if (string2 != null && !"".equalsIgnoreCase(string2)) {
                boolean bl4 = Token.hasToken(string2, "REF");
                int n = (string2 = bl4 ? Token.getQuotedNameAfterToken(string2, "REF") : Token.getFirstName(string2, '\"', '\"')).indexOf(46);
                if (n > 0) {
                    string2 = Token.getValAfterCharacter(string2, '.');
                }
                if ((object5 = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string2)) != null) {
                    column.setStructuredType((StructuredType)object5);
                    column.setUse((short)3);
                    if (bl4) {
                        column.setReference(true);
                    }
                }
                if ((object4 = (CollectionType)this.design.getDataTypesDesign().getCollectionTypeSet().getByName(string2)) != null) {
                    column.setCollectionType((CollectionType)object4);
                    column.setUse((short)4);
                }
                if ((object3 = (DistinctType)this.design.getDataTypesDesign().getDistinctTypeSet().getByName(string2)) != null) {
                    column.setDistinctType((DistinctType)object3);
                    column.setUse((short)2);
                }
            }
        }
        boolean bl5 = (Boolean)map.get("COMPUTED");
        column.setComputed(bl5);
        if (bl5) {
            column.setFormulaDesc((String)map.get("FORMULA"));
        }
        column.setNullsAllowed(!(bl3 = ((Boolean)map.get("NOT NULL")).booleanValue()));
        boolean bl6 = (Boolean)map.get("PRIMARY KEY");
        if (bl6) {
            object5 = this.table.createIndex();
            ((Index)object5).add(column);
            ((KeyObject)object5).makePK();
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
        } else {
            boolean bl7 = (Boolean)map.get("UNIQUE");
            if (bl7) {
                object4 = this.table.createIndex();
                ((Index)object4).add(column);
                ((Index)object4).setIndexState("Unique Constraint");
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object4);
            }
        }
        if (bl3) {
            String string7 = (String)map.get("NN_CONSTRAINT_NAME");
            if (string7 != null && !string7.startsWith("SYS_C")) {
                column.setNotNullConstraintName(string7);
            }
            if (this.storageDesign != null && (object4 = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID())) != null) {
                if (map.get("NN_DEFERRABLE") != null) {
                    boolean bl8 = (Boolean)map.get("NN_DEFERRABLE");
                    ((ColumnProxyOracle)object4).setNncDeferrable(bl8 ? "YES" : "NO");
                }
                if ((object3 = (String)map.get("NN_INITIALLY")) != null) {
                    ((ColumnProxyOracle)object4).setNncInitially((String)object3);
                }
                if (map.get("NN_RELY") != null) {
                    boolean bl9 = (Boolean)map.get("NN_RELY");
                    ((ColumnProxyOracle)object4).setNncRely(bl9 ? "NO" : "YES");
                }
                if (map.get("NN_DISABLE") != null) {
                    boolean bl10 = (Boolean)map.get("NN_DISABLE");
                    ((ColumnProxyOracle)object4).setNncEnable(bl10 ? "NO" : "YES");
                }
                if (map.get("NN_NOVALIDATE") != null) {
                    boolean bl11 = (Boolean)map.get("NN_NOVALIDATE");
                    ((ColumnProxyOracle)object4).setNncValidate(bl11 ? "NO" : "YES");
                }
                if ((string = (String)map.get("NN_EXCEPTIONS")) != null && (object2 = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(string)) != null) {
                    ((ColumnProxyOracle)object4).setNncExceptionsTable((TableProxyOracle)object2);
                }
            }
        }
        if ((bl2 = ((Boolean)map.get("IS DEFAULT")).booleanValue()) && !"".equalsIgnoreCase((String)(object4 = (String)map.get("DEFAULT")))) {
            if (((String)object4).startsWith("'") || ((String)object4).toUpperCase().startsWith("N'") || ((String)object4).toUpperCase().startsWith("Q'") || ((String)object4).toUpperCase().startsWith("NQ'") || ((String)object4).startsWith("\"") || ((String)object4).equalsIgnoreCase("NULL") || ((String)object4).indexOf("(") > -1 || ((String)object4).equalsIgnoreCase("CURRENT_DATE") || ((String)object4).equalsIgnoreCase("CURRENT_TIMESTAMP") || ((String)object4).equalsIgnoreCase("DBTIMEZONE") || ((String)object4).equalsIgnoreCase("LOCALTIMESTAMP") || ((String)object4).equalsIgnoreCase("SESSIONTIMEZONE") || ((String)object4).equalsIgnoreCase("SYSDATE") || ((String)object4).equalsIgnoreCase("SYSTIMESTAMP") || ((String)object4).equalsIgnoreCase("UID") || ((String)object4).equalsIgnoreCase("USER")) {
                column.setDefaultValue((String)object4);
            } else {
                try {
                    Double.parseDouble((String)object4);
                    column.setDefaultValue((String)object4);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Bad default value for column " + column.getLongName());
                }
            }
        }
        if ((object4 = (String)map.get("REFERENCES")) != null) {
            object3 = new RefAtColNode();
            int n = ((String)object4).indexOf(46);
            if (n > 0) {
                object4 = Token.getValAfterCharacter((String)object4, '.');
            }
            ((RefAtColNode)object3).onDelete = (String)map.get("ON DELETE");
            ((RefAtColNode)object3).columnName = (String)map.get("columnname");
            ((RefAtColNode)object3).refColumn = (String)map.get("REFERENCED_COLUMN");
            ((RefAtColNode)object3).referencedTable = object4;
            ((RefAtColNode)object3).constraintName = (String)map.get("CONSTRAINT_NAME");
            this.refAtColumnList.add(object3);
        }
        if (bl = ((Boolean)map.get("HAS_CHECK_CONSTRAINT")).booleanValue()) {
            String string8 = (String)map.get("CHECK_CONSTRAINT");
            object2 = (String)map.get("CHECK");
            if (object2 != null) {
                this.initCheckConstraint((String)object2, string8, column);
                if (this.storageDesign != null && (object = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID())) != null) {
                    TableProxyOracle tableProxyOracle;
                    String string9;
                    boolean bl12;
                    String string10;
                    if (map.get("CHK_DEFERRABLE") != null) {
                        boolean bl13 = (Boolean)map.get("CHK_DEFERRABLE");
                        ((ColumnProxyOracle)object).setDeferrable(bl13 ? "YES" : "NO");
                    }
                    if ((string10 = (String)map.get("CHK_INITIALLY")) != null) {
                        ((ColumnProxyOracle)object).setInitially(string10);
                    }
                    if (map.get("CHK_DISABLE") != null) {
                        bl12 = (Boolean)map.get("CHK_DISABLE");
                        ((ColumnProxyOracle)object).setEnable(bl12 ? "NO" : "YES");
                    }
                    if (map.get("CHK_NOVALIDATE") != null) {
                        bl12 = (Boolean)map.get("CHK_NOVALIDATE");
                        ((ColumnProxyOracle)object).setValidate(bl12 ? "NO" : "YES");
                    }
                    if ((string9 = (String)map.get("CHK_EXCEPTIONS")) != null && (tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(string9)) != null) {
                        ((ColumnProxyOracle)object).setExceptionsTable(tableProxyOracle);
                    }
                }
            }
        }
        if ((v = map.get("WITH ROWID")) != null && (object2 = (ColumnProxyOracle)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID())) != null) {
            ((ColumnProxyOracle)object2).setWithRowId("YES");
        }
    }

    private void initPrimaryKey(Map map) {
        if (this.storageDesign != null) {
            CharSequence charSequence;
            Object object;
            Object object2;
            String string = (String)map.get("PKUK_CONSTRAINT_NAME");
            Index index = this.table.createIndex();
            if (string != null) {
                if ("".equals(string)) {
                    object2 = this.table.getDesign().getDLSettings().getNamingStandardRule();
                    object = this.table.getName();
                    charSequence = this.table.getAbbreviation();
                    if (charSequence == null || "".equals(charSequence)) {
                        charSequence = object;
                    }
                    string = ApplyNamingStandards.createPK_Name((String)object, (NamingStandardRule)object2, this.table.getDesignPart().getName(), (String)charSequence);
                }
                index.setName(string);
            }
            object2 = (String)map.get("VALUES");
            try {
                SHCreateTableOraclev9i.setColumnsForIndex(index, (String)object2, this.importLog);
                index.makePK();
                this.design.getRelationalDesign().stampModelObjectDDL(index);
            }
            catch (ObjectDoesNotExistException objectDoesNotExistException) {
                charSequence = new StringBuffer(objectDoesNotExistException.getMessage());
                ((StringBuffer)charSequence).append(" in SHCreateTableOracle.SetPK");
                LOGGER.error(((StringBuffer)charSequence).toString());
                this.importLog.addError("Columns for primary key " + index.getName() + " don't exist.");
                this.failed = true;
            }
            if (index != null) {
                object = (PKProxyOraclev10g)this.storageDesign.getPKProxySet().getProxy(index.getObjectID());
                boolean bl = (Boolean)map.get("IS_PK_CONSTRAINT");
                if (bl && object != null) {
                    boolean bl2;
                    TableProxyOracle tableProxyOracle;
                    String string2;
                    boolean bl3;
                    String string3;
                    if (map.get("PKUK_DEFERRABLE") != null) {
                        boolean bl4 = (Boolean)map.get("PKUK_DEFERRABLE");
                        ((PKProxyOracle)object).setDeferrable(bl4 ? "YES" : "NO");
                    }
                    if ((string3 = (String)map.get("PKUK_INITIALLY")) != null) {
                        ((PKProxyOracle)object).setInitially(string3);
                    }
                    if (map.get("PKUK_DISABLE") != null) {
                        bl3 = (Boolean)map.get("PKUK_DISABLE");
                        ((PKProxyOracle)object).setEnable(bl3 ? "NO" : "YES");
                    }
                    if (map.get("PKUK_NOVALIDATE") != null) {
                        bl3 = (Boolean)map.get("PKUK_NOVALIDATE");
                        ((PKProxyOracle)object).setValidate(bl3 ? "NO" : "YES");
                    }
                    if ((string2 = (String)map.get("PKUK_EXCEPTIONS")) != null && (tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(string2)) != null) {
                        ((PKProxyOracle)object).setExceptionsTable(tableProxyOracle);
                    }
                    if (bl2 = ((Boolean)map.get("USING INDEX")).booleanValue()) {
                        int n;
                        Object object3;
                        Object object4;
                        Object object5;
                        Object object6;
                        String string4;
                        AbstractStorageObjectOracle abstractStorageObjectOracle;
                        ((PKProxyOraclev10g)object).setUsingIndex("BY INDEX NAME");
                        if (map.get("BY CREATE INDEX STATEMENT") != null) {
                            ((PKProxyOraclev10g)object).setUsingIndex("BY CREATE INDEX STATEMENT");
                            ((PKProxyOraclev10g)object).setCreateIndexStatement((String)map.get("BY CREATE INDEX STATEMENT"));
                        } else if (map.get("GLOBAL") != null && ((Boolean)map.get("GLOBAL")).booleanValue()) {
                            String string5;
                            String string6;
                            abstractStorageObjectOracle = (IndexGlobalPartitionsListOraclev10g)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                            this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                            ((PKProxyOraclev10g)object).setIndexGlobalPL((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle);
                            ((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).setIndex((IndexProxy)object);
                            if (map.get("GLOBAL BY RANGE") != null && ((Boolean)map.get("GLOBAL BY RANGE")).booleanValue()) {
                                ((PKProxyOraclev10g)object).setUsingIndex("GLOBAL BY RANGE");
                            } else if (map.get("GLOBAL HASH PARTITIONED BY LIST") != null && ((Boolean)map.get("GLOBAL HASH PARTITIONED BY LIST")).booleanValue()) {
                                ((PKProxyOraclev10g)object).setUsingIndex("GLOBAL HASH PARTITIONED BY LIST");
                            } else if (map.get("GLOBAL HASH PARTITIONED BY QUANTITY") != null && ((Boolean)map.get("GLOBAL HASH PARTITIONED BY QUANTITY")).booleanValue()) {
                                ((PKProxyOraclev10g)object).setUsingIndex("GLOBAL HASH PARTITIONED BY QUANTITY");
                            }
                            string4 = (String)map.get("COLUMN_LIST");
                            ((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).setGlobalPartColumns(((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).columnNamesToColumnIDs(string4));
                            if (map.get("GLOBAL HASH PARTITIONED BY QUANTITY") != null && ((Boolean)map.get("GLOBAL HASH PARTITIONED BY QUANTITY")).booleanValue()) {
                                StringTokenizer stringTokenizer;
                                try {
                                    int n2 = Integer.parseInt((String)map.get("QUANTITY"));
                                    ((IndexGlobalPartitionsListOraclev10g)abstractStorageObjectOracle).setHashPQuantity(n2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    LOGGER.error("wrong format in SHCreateTableOraclev10g.initPrimaryKey : " + numberFormatException.getMessage());
                                    this.importLog.addWarning("Wrong QUANTITY format in statement " + this.statement);
                                }
                                string6 = (String)map.get("HASH TABLESPACES");
                                if (string6 != null && !string6.trim().equalsIgnoreCase("")) {
                                    stringTokenizer = new StringTokenizer(string6, ",");
                                    while (stringTokenizer.hasMoreTokens()) {
                                        string5 = Token.getName(stringTokenizer.nextToken().trim());
                                        object6 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string5);
                                        if (object6 == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                                            object6 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            ((TableSpaceOracle)object6).setName(string5);
                                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object6);
                                        }
                                        if (object6 == null) continue;
                                        ((IndexGlobalPartitionsListOraclev10g)abstractStorageObjectOracle).setHashPTableSpaces(((ModelIDObject)object6).getObjectID());
                                    }
                                }
                                if ((string6 = (String)map.get("OVERFLOW TABLESPACES")) != null && !string6.trim().equalsIgnoreCase("")) {
                                    stringTokenizer = new StringTokenizer(string6, ",");
                                    while (stringTokenizer.hasMoreTokens()) {
                                        string5 = Token.getName(stringTokenizer.nextToken().trim());
                                        object6 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string5);
                                        if (object6 == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                                            object6 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            ((TableSpaceOracle)object6).setName(string5);
                                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object6);
                                        }
                                        if (object6 == null) continue;
                                        ((IndexGlobalPartitionsListOraclev10g)abstractStorageObjectOracle).setHashPTableSpaces(((ModelIDObject)object6).getObjectID());
                                    }
                                }
                            } else {
                                string6 = (String)map.get("PARTITIONS");
                                int n3 = string6.toUpperCase().indexOf("PARTITION ");
                                if (n3 > -1) {
                                    string5 = string6.substring(n3);
                                    while (string5.toUpperCase().indexOf("PARTITION ") > -1) {
                                        String string7;
                                        if (string5.toUpperCase().indexOf("PARTITION ", 9) > -1) {
                                            object6 = string5.substring(0, string5.toUpperCase().indexOf("PARTITION ", 9));
                                            string5 = string5.substring(string5.toUpperCase().indexOf("PARTITION ", 9));
                                        } else {
                                            object6 = string5;
                                            string5 = "";
                                        }
                                        object6 = Token.cutFirstToken((String)object6);
                                        object5 = this.storageDesign.getIndexHashPartitionSet().createIndexHashPartition();
                                        object4 = Token.getFirstName((String)object6, '\"', '\"');
                                        ((StorageObject)object5).setName((String)object4);
                                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                                        ((IndexHashPartitionOracle)object5).setIndexGlobalPartList((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle);
                                        Object object7 = object6;
                                        if (Token.hasToken((String)object6, "LOB")) {
                                            object7 = Token.getStringBeforeToken((String)object7, "LOB");
                                        }
                                        if (Token.hasString(((String)object7).toUpperCase(), "OVERFLOW TABLESPACE")) {
                                            string7 = Token.getStringAfterToken((String)object7, "OVERFLOW");
                                            string7 = Token.getQuotedNameAfterToken(string7, "TABLESPACE");
                                            object7 = Token.getStringBefore((String)object7, "OVERFLOW TABLESPACE");
                                            object3 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string7);
                                            if (object3 == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                                                object3 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                                ((TableSpaceOracle)object3).setName(string7);
                                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object3);
                                            }
                                            if (object3 != null) {
                                                ((IndexHashPartitionOracle)object5).setOverflowTableSpace((TableSpaceOracle)object3);
                                            }
                                        }
                                        if (Token.hasToken((String)object7, "TABLESPACE")) {
                                            string7 = Token.getQuotedNameAfterToken((String)object7, "TABLESPACE");
                                            object3 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string7);
                                            if (object3 == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                                                object3 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                                ((TableSpaceOracle)object3).setName(string7);
                                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object3);
                                            }
                                            if (object3 != null) {
                                                ((IndexHashPartitionOracle)object5).setTableSpace((TableSpaceOracle)object3);
                                            }
                                        }
                                        if ((n = ((String)object6).toUpperCase().indexOf("LOB ")) <= -1) continue;
                                        object3 = ((String)object6).substring(n);
                                        while (((String)object3).toUpperCase().indexOf("LOB ") > -1) {
                                            TableSpaceOraclev10g tableSpaceOraclev10g;
                                            Object object8;
                                            if (((String)object3).toUpperCase().indexOf("LOB ", 3) > -1) {
                                                object8 = ((String)object3).substring(0, ((String)object3).toUpperCase().indexOf("LOB ", 3));
                                                object3 = ((String)object3).substring(((String)object3).toUpperCase().indexOf("LOB ", 3));
                                            } else {
                                                object8 = object3;
                                                object3 = "";
                                            }
                                            String string8 = Token.getFirstName(Token.getValBetweenBrackets((String)object8, 1), '\"', '\"');
                                            IndexHashPartitionLobItemOracle indexHashPartitionLobItemOracle = this.storageDesign.getIndexHashPartitionLobItemSet().createIndexHashPartitionLobItem();
                                            this.design.getRelationalDesign().stampModelObjectDDL(indexHashPartitionLobItemOracle);
                                            ColumnProxy columnProxy = this.tableProxy.getColumnProxyByName(string8);
                                            if (columnProxy != null) {
                                                indexHashPartitionLobItemOracle.setLobColumn(columnProxy);
                                            }
                                            indexHashPartitionLobItemOracle.setIndexHashPartition((IndexHashPartitionOracle)object5);
                                            String string9 = "STORE AS";
                                            String string10 = Token.getQuotedNameAfterToken((String)(object8 = Token.getStringAfter((String)object8, string9)), "TABLESPACE");
                                            if (string10.equals("")) continue;
                                            if (string10.indexOf(44) > -1) {
                                                string10 = string10.substring(0, string10.indexOf(44)).trim();
                                            }
                                            if ((tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string10)) == null && !"SYSTEM".equalsIgnoreCase(string10)) {
                                                tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                                tableSpaceOraclev10g.setName(string10);
                                                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                                            }
                                            if (tableSpaceOraclev10g == null) continue;
                                            indexHashPartitionLobItemOracle.setTableSpace(tableSpaceOraclev10g);
                                        }
                                    }
                                }
                            }
                        } else if (map.get("LOCAL") != null && ((Boolean)map.get("LOCAL")).booleanValue()) {
                            ((PKProxyOraclev10g)object).setUsingIndex("LOCAL PARTITIONED");
                        }
                        if (!((PKProxyOraclev10g)object).getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                            String string11;
                            String string12;
                            abstractStorageObjectOracle = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment();
                            this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                            string4 = (String)map.get("PCTFREE");
                            if (!"".equalsIgnoreCase(string4)) {
                                try {
                                    int n4 = Integer.parseInt(string4);
                                    ((SegmentOracle)abstractStorageObjectOracle).setPCTFree(n4);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string12 = (String)map.get("INITRANS"))) {
                                try {
                                    int n5 = Integer.parseInt(string12);
                                    ((SegmentOracle)abstractStorageObjectOracle).setInitrans(n5);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string11 = (String)map.get("MAXTRANS"))) {
                                try {
                                    int n6 = Integer.parseInt(string11);
                                    ((SegmentOracle)abstractStorageObjectOracle).setMaxTrans(n6);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            boolean bl5 = false;
                            if (map.get("STORAGE") != null) {
                                bl5 = (Boolean)map.get("STORAGE");
                            }
                            if (bl5) {
                                String string13;
                                String string14;
                                String string15;
                                object6 = (String)map.get("INITIAL");
                                if (!"".equalsIgnoreCase((String)object6)) {
                                    try {
                                        long l = Long.parseLong((String)object6);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCInitialExtent(l);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase((String)(object5 = (String)map.get("NEXT")))) {
                                    try {
                                        long l = Long.parseLong((String)object5);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCNextExtent(l);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase((String)(object4 = (String)map.get("PCTINCREASE")))) {
                                    try {
                                        int n7 = Integer.parseInt((String)object4);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCPctIncrease(n7);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(string15 = (String)map.get("MINEXTENTS"))) {
                                    try {
                                        n = Integer.parseInt(string15);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCMinExtents(n);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(string14 = (String)map.get("MAXEXTENTS"))) {
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCMaxExtents(string14);
                                }
                                if (!"".equalsIgnoreCase((String)(object3 = (String)map.get("FREELISTS")))) {
                                    try {
                                        int n8 = Integer.parseInt((String)object3);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCFreeLists(n8);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!"".equalsIgnoreCase(string13 = (String)map.get("GROUPS"))) {
                                    try {
                                        int n9 = Integer.parseInt(string13);
                                        ((SegmentOracle)abstractStorageObjectOracle).setSCFreelistGroups(n9);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                String string16 = (String)map.get("BUFFER_POOL");
                                if (!"".equalsIgnoreCase(string13)) {
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCBufferPool(string16);
                                }
                            }
                            if ((object6 = (String)map.get("TABLESPACE")) != null && !((String)object6).equals("")) {
                                object5 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName((String)object6);
                                if (object5 == null && !"SYSTEM".equalsIgnoreCase((String)object6)) {
                                    object5 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    ((TableSpaceOracle)object5).setName((String)object6);
                                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                                }
                                if (object5 != null) {
                                    ((PKProxyOracle)object).setTableSpace((TableSpaceOracle)object5);
                                }
                            }
                            if ((object5 = (String)map.get("LOGGING")) == null) {
                                object5 = "";
                            }
                            ((PKProxyOracle)object).setLogging((String)object5);
                            object4 = this.storageDesign.getSegmentSet().findEqual((SegmentOracle)abstractStorageObjectOracle);
                            ((PKProxyOracle)object).setIndexSegment((SegmentOracle)object4);
                        }
                    }
                }
            }
        }
    }

    private void initUniqueKey(Map map) {
        if (this.storageDesign != null) {
            UniqueOraclev10g uniqueOraclev10g;
            CharSequence charSequence;
            String string = (String)map.get("PKUK_CONSTRAINT_NAME");
            Index index = this.table.createIndex();
            if (string != null) {
                index.setName(string);
            }
            String string2 = (String)map.get("VALUES");
            try {
                SHCreateTableOraclev9i.setColumnsForIndex(index, string2, this.importLog);
                index.setIndexState("Unique Constraint");
                this.design.getRelationalDesign().stampModelObjectDDL(index);
            }
            catch (ObjectDoesNotExistException objectDoesNotExistException) {
                charSequence = new StringBuffer(objectDoesNotExistException.getMessage());
                charSequence.append(" in SHCreateTableOracle.SetUnique");
                LOGGER.error(charSequence.toString());
                this.importLog.addError("Columns for unique key " + index.getName() + " don't exist.");
                this.failed = true;
            }
            if (index != null && (uniqueOraclev10g = (UniqueOraclev10g)this.storageDesign.getUniqueSet().getProxy(index.getObjectID())) != null) {
                boolean bl;
                TableProxyOracle tableProxyOracle;
                String string3;
                boolean bl2;
                if (map.get("PKUK_DEFERRABLE") != null) {
                    boolean bl3 = (Boolean)map.get("PKUK_DEFERRABLE");
                    uniqueOraclev10g.setDeferrable(bl3 ? "YES" : "NO");
                }
                if ((charSequence = (String)map.get("PKUK_INITIALLY")) != null) {
                    uniqueOraclev10g.setInitially((String)charSequence);
                }
                if (map.get("PKUK_DISABLE") != null) {
                    bl2 = (Boolean)map.get("PKUK_DISABLE");
                    uniqueOraclev10g.setEnable(bl2 ? "NO" : "YES");
                }
                if (map.get("PKUK_NOVALIDATE") != null) {
                    bl2 = (Boolean)map.get("PKUK_NOVALIDATE");
                    uniqueOraclev10g.setValidate(bl2 ? "NO" : "YES");
                }
                if ((string3 = (String)map.get("PKUK_EXCEPTIONS")) != null && (tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(string3)) != null) {
                    uniqueOraclev10g.setExceptionsTable(tableProxyOracle);
                }
                if (bl = ((Boolean)map.get("USING INDEX")).booleanValue()) {
                    Object object;
                    Object object2;
                    String string4;
                    AbstractStorageObjectOracle abstractStorageObjectOracle;
                    uniqueOraclev10g.setUsingIndex("BY INDEX NAME");
                    if (map.get("BY CREATE INDEX STATEMENT") != null) {
                        uniqueOraclev10g.setUsingIndex("BY CREATE INDEX STATEMENT");
                        uniqueOraclev10g.setCreateIndexStatement((String)map.get("BY CREATE INDEX STATEMENT"));
                    } else if (map.get("GLOBAL") != null && ((Boolean)map.get("GLOBAL")).booleanValue()) {
                        String string5;
                        String string6;
                        abstractStorageObjectOracle = (IndexGlobalPartitionsListOraclev10g)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                        uniqueOraclev10g.setUsingIndexGlobalPL((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle);
                        ((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).setIndex(uniqueOraclev10g);
                        if (map.get("GLOBAL BY RANGE") != null && ((Boolean)map.get("GLOBAL BY RANGE")).booleanValue()) {
                            uniqueOraclev10g.setUsingIndex("GLOBAL BY RANGE");
                        } else if (map.get("GLOBAL HASH PARTITIONED BY LIST") != null && ((Boolean)map.get("GLOBAL HASH PARTITIONED BY LIST")).booleanValue()) {
                            uniqueOraclev10g.setUsingIndex("GLOBAL HASH PARTITIONED BY LIST");
                        } else if (map.get("GLOBAL HASH PARTITIONED BY QUANTITY") != null && ((Boolean)map.get("GLOBAL HASH PARTITIONED BY QUANTITY")).booleanValue()) {
                            uniqueOraclev10g.setUsingIndex("GLOBAL HASH PARTITIONED BY QUANTITY");
                        }
                        string4 = (String)map.get("COLUMN_LIST");
                        ((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).setGlobalPartColumns(((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle).columnNamesToColumnIDs(string4));
                        if (map.get("GLOBAL HASH PARTITIONED BY QUANTITY") != null && ((Boolean)map.get("GLOBAL HASH PARTITIONED BY QUANTITY")).booleanValue()) {
                            StringTokenizer stringTokenizer;
                            try {
                                int n = Integer.parseInt((String)map.get("QUANTITY"));
                                ((IndexGlobalPartitionsListOraclev10g)abstractStorageObjectOracle).setHashPQuantity(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("wrong format in SHCreateTableOraclev10g.initUniqueKey : " + numberFormatException.getMessage());
                                this.importLog.addWarning("Wrong QUANTITY format in statement " + this.statement);
                            }
                            string6 = (String)map.get("HASH TABLESPACES");
                            if (string6 != null && !string6.trim().equalsIgnoreCase("")) {
                                stringTokenizer = new StringTokenizer(string6, ",");
                                while (stringTokenizer.hasMoreTokens()) {
                                    string5 = Token.getName(stringTokenizer.nextToken().trim());
                                    object2 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string5);
                                    if (object2 == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                                        object2 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        ((TableSpaceOracle)object2).setName(string5);
                                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                                    }
                                    if (object2 == null) continue;
                                    ((IndexGlobalPartitionsListOraclev10g)abstractStorageObjectOracle).setHashPTableSpaces(((ModelIDObject)object2).getObjectID());
                                }
                            }
                            if ((string6 = (String)map.get("OVERFLOW TABLESPACES")) != null && !string6.trim().equalsIgnoreCase("")) {
                                stringTokenizer = new StringTokenizer(string6, ",");
                                while (stringTokenizer.hasMoreTokens()) {
                                    string5 = Token.getName(stringTokenizer.nextToken().trim());
                                    object2 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string5);
                                    if (object2 == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                                        object2 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        ((TableSpaceOracle)object2).setName(string5);
                                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                                    }
                                    if (object2 == null) continue;
                                    ((IndexGlobalPartitionsListOraclev10g)abstractStorageObjectOracle).setHashPTableSpaces(((ModelIDObject)object2).getObjectID());
                                }
                            }
                        } else {
                            string6 = (String)map.get("PARTITIONS");
                            int n = string6.toUpperCase().indexOf("PARTITION ");
                            if (n > -1) {
                                string5 = string6.substring(n);
                                while (string5.toUpperCase().indexOf("PARTITION ") > -1) {
                                    int n2;
                                    Object object3;
                                    String string7;
                                    if (string5.toUpperCase().indexOf("PARTITION ", 9) > -1) {
                                        object2 = string5.substring(0, string5.toUpperCase().indexOf("PARTITION ", 9));
                                        string5 = string5.substring(string5.toUpperCase().indexOf("PARTITION ", 9));
                                    } else {
                                        object2 = string5;
                                        string5 = "";
                                    }
                                    object2 = Token.cutFirstToken((String)object2);
                                    object = this.storageDesign.getIndexHashPartitionSet().createIndexHashPartition();
                                    String string8 = Token.getFirstName((String)object2, '\"', '\"');
                                    ((StorageObject)object).setName(string8);
                                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                                    ((IndexHashPartitionOracle)object).setIndexGlobalPartList((IndexGlobalPartitionsListOracle)abstractStorageObjectOracle);
                                    Object object4 = object2;
                                    if (Token.hasToken((String)object2, "LOB")) {
                                        object4 = Token.getStringBeforeToken((String)object4, "LOB");
                                    }
                                    if (Token.hasString(((String)object4).toUpperCase(), "OVERFLOW TABLESPACE")) {
                                        string7 = Token.getStringAfterToken((String)object4, "OVERFLOW");
                                        string7 = Token.getQuotedNameAfterToken(string7, "TABLESPACE");
                                        object4 = Token.getStringBefore((String)object4, "OVERFLOW TABLESPACE");
                                        object3 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string7);
                                        if (object3 == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                                            object3 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            ((TableSpaceOracle)object3).setName(string7);
                                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object3);
                                        }
                                        if (object3 != null) {
                                            ((IndexHashPartitionOracle)object).setOverflowTableSpace((TableSpaceOracle)object3);
                                        }
                                    }
                                    if (Token.hasToken((String)object4, "TABLESPACE")) {
                                        string7 = Token.getQuotedNameAfterToken((String)object4, "TABLESPACE");
                                        object3 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string7);
                                        if (object3 == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                                            object3 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            ((TableSpaceOracle)object3).setName(string7);
                                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object3);
                                        }
                                        if (object3 != null) {
                                            ((IndexHashPartitionOracle)object).setTableSpace((TableSpaceOracle)object3);
                                        }
                                    }
                                    if ((n2 = ((String)object2).toUpperCase().indexOf("LOB ")) <= -1) continue;
                                    object3 = ((String)object2).substring(n2);
                                    while (((String)object3).toUpperCase().indexOf("LOB ") > -1) {
                                        TableSpaceOraclev10g tableSpaceOraclev10g;
                                        Object object5;
                                        if (((String)object3).toUpperCase().indexOf("LOB ", 3) > -1) {
                                            object5 = ((String)object3).substring(0, ((String)object3).toUpperCase().indexOf("LOB ", 3));
                                            object3 = ((String)object3).substring(((String)object3).toUpperCase().indexOf("LOB ", 3));
                                        } else {
                                            object5 = object3;
                                            object3 = "";
                                        }
                                        String string9 = Token.getFirstName(Token.getValBetweenBrackets((String)object5, 1), '\"', '\"');
                                        IndexHashPartitionLobItemOracle indexHashPartitionLobItemOracle = this.storageDesign.getIndexHashPartitionLobItemSet().createIndexHashPartitionLobItem();
                                        this.design.getRelationalDesign().stampModelObjectDDL(indexHashPartitionLobItemOracle);
                                        ColumnProxy columnProxy = this.tableProxy.getColumnProxyByName(string9);
                                        if (columnProxy != null) {
                                            indexHashPartitionLobItemOracle.setLobColumn(columnProxy);
                                        }
                                        indexHashPartitionLobItemOracle.setIndexHashPartition((IndexHashPartitionOracle)object);
                                        String string10 = "STORE AS";
                                        String string11 = Token.getQuotedNameAfterToken((String)(object5 = Token.getStringAfter((String)object5, string10)), "TABLESPACE");
                                        if (string11.equals("")) continue;
                                        if (string11.indexOf(44) > -1) {
                                            string11 = string11.substring(0, string11.indexOf(44)).trim();
                                        }
                                        if ((tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string11)) == null && !"SYSTEM".equalsIgnoreCase(string11)) {
                                            tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            tableSpaceOraclev10g.setName(string11);
                                            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                                        }
                                        if (tableSpaceOraclev10g == null) continue;
                                        indexHashPartitionLobItemOracle.setTableSpace(tableSpaceOraclev10g);
                                    }
                                }
                            }
                        }
                    } else if (map.get("LOCAL") != null && ((Boolean)map.get("LOCAL")).booleanValue()) {
                        uniqueOraclev10g.setUsingIndex("LOCAL PARTITIONED");
                    }
                    if (!uniqueOraclev10g.getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        String string12;
                        String string13;
                        String string14;
                        abstractStorageObjectOracle = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment();
                        this.design.getRelationalDesign().stampModelObjectDDL(abstractStorageObjectOracle);
                        string4 = (String)map.get("PCTFREE");
                        if (!"".equalsIgnoreCase(string4)) {
                            try {
                                int n = Integer.parseInt(string4);
                                ((SegmentOracle)abstractStorageObjectOracle).setPCTFree(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(string14 = (String)map.get("INITRANS"))) {
                            try {
                                int n = Integer.parseInt(string14);
                                ((SegmentOracle)abstractStorageObjectOracle).setInitrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(string13 = (String)map.get("MAXTRANS"))) {
                            try {
                                int n = Integer.parseInt(string13);
                                ((SegmentOracle)abstractStorageObjectOracle).setMaxTrans(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (map.get("STORAGE") != null && ((Boolean)map.get("STORAGE")).booleanValue()) {
                            String string15;
                            String string16;
                            String string17;
                            String string18;
                            String string19 = (String)map.get("INITIAL");
                            if (!"".equalsIgnoreCase(string19)) {
                                try {
                                    long l = Long.parseLong(string19);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCInitialExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase((String)(object2 = (String)map.get("NEXT")))) {
                                try {
                                    long l = Long.parseLong((String)object2);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCNextExtent(l);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase((String)(object = (String)map.get("PCTINCREASE")))) {
                                try {
                                    int n = Integer.parseInt((String)object);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCPctIncrease(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string18 = (String)map.get("MINEXTENTS"))) {
                                try {
                                    int n = Integer.parseInt(string18);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCMinExtents(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string17 = (String)map.get("MAXEXTENTS"))) {
                                ((SegmentOracle)abstractStorageObjectOracle).setSCMaxExtents(string17);
                            }
                            if (!"".equalsIgnoreCase(string16 = (String)map.get("FREELISTS"))) {
                                try {
                                    int n = Integer.parseInt(string16);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCFreeLists(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(string15 = (String)map.get("GROUPS"))) {
                                try {
                                    int n = Integer.parseInt(string15);
                                    ((SegmentOracle)abstractStorageObjectOracle).setSCFreelistGroups(n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            String string20 = (String)map.get("BUFFER_POOL");
                            if (!"".equalsIgnoreCase(string15)) {
                                ((SegmentOracle)abstractStorageObjectOracle).setSCBufferPool(string20);
                            }
                        }
                        if ((string12 = (String)map.get("TABLESPACE")) != null && !string12.equals("")) {
                            object2 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string12);
                            if (object2 == null && !"SYSTEM".equalsIgnoreCase(string12)) {
                                object2 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)object2).setName(string12);
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                            }
                            if (object2 != null) {
                                uniqueOraclev10g.setTableSpace((TableSpaceOracle)object2);
                            }
                        }
                        if ((object2 = (String)map.get("LOGGING")) == null) {
                            object2 = "";
                        }
                        uniqueOraclev10g.setLogging((String)object2);
                        object = this.storageDesign.getSegmentSet().findEqual((SegmentOracle)abstractStorageObjectOracle);
                        uniqueOraclev10g.setIndexSegment((SegmentOracle)object);
                    }
                }
            }
        }
    }

    private void initCheckConstraint(String string, String string2, Column column) {
        CheckConstraint checkConstraint = new CheckConstraint();
        checkConstraint.add(this.storageDesign.getRDBMSType(), string);
        if (!"".equalsIgnoreCase(string2) && string2 != null) {
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        } else {
            String string3 = column.getName();
            if (string3.length() > 25) {
                string3 = string3.substring(0, 25);
            }
            string2 = string3 + "_CHCK";
            checkConstraint.setName(string2);
            column.setConstraintName("");
        }
        checkConstraint.setDesign(this.design);
        column.setUseDomainConstraints(false);
        column.setCheck(checkConstraint);
    }

    public Table getTable() {
        return this.table;
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1).trim();
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n *= 1024);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("SHCreateTableOracle10g.getNumberOnly - Unable to parse value: " + string, numberFormatException);
            }
        }
        return string;
    }

    private Domain getCorrespondingDomain(String string) {
        Domain domain = null;
        DomainSet domainSet = this.design.getDomainSet();
        Iterator iterator = domainSet.iterator();
        while (iterator.hasNext()) {
            Domain domain2 = (Domain)iterator.next();
            if (!domain2.getName().equalsIgnoreCase(string)) continue;
            domain = domain2;
            return domain;
        }
        return domain;
    }

    private void initTemporary() {
        if ("GLOBAL".equalsIgnoreCase(Token.getTokenAfter(this.statement, "CREATE"))) {
            this.tableProxy.setTemporary("YES");
        }
    }

    private void initOnCommit() {
        String string;
        if (Token.hasToken(this.outSideBrackets, "COMMIT") && (string = Token.getTokenAfter(this.outSideBrackets, "COMMIT").trim()).equalsIgnoreCase("DELETE")) {
            this.tableProxy.setTempPreserveRows("NO");
        }
    }

    private void initCluster() {
        ClusterOraclev10g clusterOraclev10g;
        String string = Token.getQuotedNameAfterToken(this.outSideBrackets, "CLUSTER");
        if (string.indexOf(46) > -1) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        if ((clusterOraclev10g = (ClusterOraclev10g)this.storageDesign.getClusterSet().getByName(string)) != null) {
            this.tableProxy.setCluster(clusterOraclev10g);
            String string2 = Token.getStringAfter(this.outSideBrackets, "CLUSTER");
            string2 = Token.getValBetweenBrackets(string2, 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = Token.getFirstName(stringTokenizer.nextToken(), '\"', '\"');
                ColumnProxy columnProxy = this.tableProxy.getColumnProxyByName(string3);
                if (columnProxy == null) continue;
                this.tableProxy.setClusterColumns(columnProxy.getObjectID());
            }
        }
    }

    private void initIndexOrganizedTable() {
        StorageObject storageObject;
        String string;
        String string2 = Token.getStringAfter(this.outSideBrackets, "ORGANIZATION");
        string2 = Token.cutFirstToken(string2);
        String string3 = "";
        if (Token.hasToken(string2, "OVERFLOW")) {
            string3 = Token.getStringAfterToken(string2, "OVERFLOW");
            string2 = Token.getStringBeforeToken(string2, "OVERFLOW");
        }
        this.initSegment(string2);
        if (Token.hasToken(string2, "PCTTHRESHOLD")) {
            string = Token.getTokenAfter(string2, "PCTTHRESHOLD");
            try {
                this.tableProxy.setIotPctThreshold(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong syntax near " + string2, numberFormatException);
                this.importLog.addWarning("Wrong PCTTHRESHOLD format in statement " + this.statement);
            }
        }
        if (Token.hasToken(string2, "COMPRESS")) {
            string = Token.getTokenAfter(string2, "COMPRESS");
            try {
                this.tableProxy.setIotCompress(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong syntax near " + string2, numberFormatException);
                this.importLog.addWarning("Wrong COMPRESS format in statement " + this.statement);
            }
        }
        if (Token.hasString(string2.toUpperCase(), "MAPPING TABLE")) {
            this.tableProxy.setIOTMappingTable("YES");
        }
        if (Token.hasToken(string2, "INCLUDING") && (storageObject = (ColumnProxyOraclev10g)this.tableProxy.getColumnProxyByName(string = Token.getQuotedNameAfterToken(string2, "INCLUDING"))) != null) {
            this.tableProxy.setIotIncluding((ColumnProxy)storageObject);
        }
        if (Token.hasToken(string2, "TABLESPACE")) {
            string = Token.getQuotedNameAfterToken(string2, "TABLESPACE");
            storageObject = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string);
            if (storageObject == null && !"SYSTEM".equalsIgnoreCase(string)) {
                storageObject = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                ((TableSpaceOracle)storageObject).setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(storageObject);
            }
            if (storageObject != null) {
                this.tableProxy.setTableSpace((TableSpaceOracle)storageObject);
            }
        }
        if (!string3.equals("")) {
            this.initOverflowSegment(string3);
        }
    }

    private void initOverflowSegment(String string) {
        SegmentOraclev10g segmentOraclev10g = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev10g = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev10g);
            this.initPctUsed(string, segmentOraclev10g);
            this.initInitrans(string, segmentOraclev10g);
            this.initMaxtrans(string, segmentOraclev10g);
            this.initStorage(string, segmentOraclev10g);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev10g);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev10g);
            this.tableProxy.setIotOverflowSegment(segmentOracle);
        }
    }

    private void initTableSpace() {
        if (Token.hasToken(this.outSideBrackets, "TABLESPACE")) {
            String string = Token.getQuotedNameAfterToken(this.outSideBrackets, "TABLESPACE");
            TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string);
            if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string)) {
                tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                tableSpaceOraclev10g.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
            }
            if (tableSpaceOraclev10g != null) {
                this.tableProxy.setTableSpace(tableSpaceOraclev10g);
            }
        }
    }

    private void initCompression() {
        if (Token.hasToken(this.outSideBrackets, "COMPRESS")) {
            this.tableProxy.setDataSegmentCompression("YES");
        }
    }

    private void initSegment(String string) {
        SegmentOraclev10g segmentOraclev10g = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev10g = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev10g);
            this.initPctUsed(string, segmentOraclev10g);
            this.initInitrans(string, segmentOraclev10g);
            this.initMaxtrans(string, segmentOraclev10g);
            this.initStorage(string, segmentOraclev10g);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev10g);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev10g);
            this.tableProxy.setSegment(segmentOracle);
        }
        this.initLogging(string);
    }

    private void initPctFree(String string, SegmentOraclev10g segmentOraclev10g) {
        String string2 = Token.getTokenAfter(string, "PCTFREE").trim();
        try {
            if (!"".equals(string2)) {
                int n = Integer.parseInt(string2);
                segmentOraclev10g.setPCTFree(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error("wrong format in SHCreateTableOracle.initPctFree : " + numberFormatException.getMessage());
            this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
        }
    }

    private void initPctUsed(String string, SegmentOraclev10g segmentOraclev10g) {
        if (Token.hasToken(string, "PCTUSED")) {
            String string2 = Token.getTokenAfter(string, "PCTUSED").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev10g.setPCTUsed(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initPctUsed : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong PCTUSED format in statement " + this.statement);
            }
        }
    }

    private void initInitrans(String string, SegmentOraclev10g segmentOraclev10g) {
        if (Token.hasToken(string, "INITRANS")) {
            String string2 = Token.getTokenAfter(string, "INITRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev10g.setInitrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initInitrans : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
            }
        }
    }

    private void initMaxtrans(String string, SegmentOraclev10g segmentOraclev10g) {
        if (Token.hasToken(string, "MAXTRANS")) {
            String string2 = Token.getTokenAfter(string, "MAXTRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOraclev10g.setMaxTrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initMaxtrans : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
            }
        }
    }

    private void initStorage(String string, SegmentOraclev10g segmentOraclev10g) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, segmentOraclev10g, null, null);
            this.initNext(string2, segmentOraclev10g, null, null);
            this.initPCtIncrease(string2, segmentOraclev10g, null, null);
            this.initMinExtents(string2, segmentOraclev10g, null, null);
            this.initMaxExtents(string2, segmentOraclev10g, null, null);
            this.initFreeLists(string2, segmentOraclev10g, null, null);
            this.initFreeListGroups(string2, segmentOraclev10g, null, null);
            this.initSegBufferPool(string2, segmentOraclev10g, null, null);
        }
    }

    private void initInitial(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "INITIAL")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "INITIAL").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCInitialExtent(l);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCInitialExtent(l);
                } else if (columnProxyOraclev10g != null) {
                    columnProxyOraclev10g.setSCInitialExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initInitial : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
            }
        }
    }

    private void initNext(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "NEXT")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "NEXT").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCNextExtent(l);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCNextExtent(l);
                } else if (columnProxyOraclev10g != null) {
                    columnProxyOraclev10g.setSCNextExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initNext : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
            }
        }
    }

    private void initPCtIncrease(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "PCTINCREASE")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "PCTINCREASE").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCPctIncrease(n);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCPctIncrease(n);
                } else if (columnProxyOraclev10g != null) {
                    columnProxyOraclev10g.setSCPctIncrease(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initPCtIncrease : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
            }
        }
    }

    private void initMinExtents(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "MINEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MINEXTENTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCMinExtents(n);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCMinExtents(n);
                } else if (columnProxyOraclev10g != null) {
                    columnProxyOraclev10g.setSCMinExtents(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initMinExtents : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
            }
        }
    }

    private void initMaxExtents(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "MAXEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MAXEXTENTS").trim());
            if (segmentOraclev10g != null) {
                segmentOraclev10g.setSCMaxExtents(string2);
            } else if (lobStorageOraclev10g != null) {
                lobStorageOraclev10g.setSCMaxExtents(string2);
            } else if (columnProxyOraclev10g != null) {
                columnProxyOraclev10g.setSCMaxExtents(string2);
            }
        }
    }

    private void initFreeLists(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "FREELISTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "FREELISTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCFreeLists(n);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCFreeLists(n);
                } else if (columnProxyOraclev10g != null) {
                    columnProxyOraclev10g.setSCFreeLists(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initFreeLists : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
            }
        }
    }

    private void initFreeListGroups(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "GROUPS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "GROUPS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOraclev10g != null) {
                    segmentOraclev10g.setSCFreelistGroups(n);
                } else if (lobStorageOraclev10g != null) {
                    lobStorageOraclev10g.setSCFreelistGroups(n);
                } else if (columnProxyOraclev10g != null) {
                    columnProxyOraclev10g.setSCFreelistGroups(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initFreeListGroups : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
            }
        }
    }

    private void initSegBufferPool(String string, SegmentOraclev10g segmentOraclev10g, LobStorageOraclev10g lobStorageOraclev10g, ColumnProxyOraclev10g columnProxyOraclev10g) {
        if (Token.hasToken(string, "BUFFER_POOL")) {
            String string2 = Token.getQuotedNameAfterToken(string, "BUFFER_POOL");
            if (segmentOraclev10g != null) {
                segmentOraclev10g.setSCBufferPool(string2);
            } else if (lobStorageOraclev10g != null) {
                lobStorageOraclev10g.setSCBufferPool(string2);
            } else if (columnProxyOraclev10g != null) {
                columnProxyOraclev10g.setSCBufferPool(string2);
            }
        }
    }

    private void initLogging(String string) {
        if (Token.hasToken(string, "NOLOGGING")) {
            this.tableProxy.setLogging("NO");
        } else if (Token.hasToken(string, "LOGGING")) {
            this.tableProxy.setLogging("YES");
        } else {
            this.tableProxy.setLogging("");
        }
    }

    private void initCache() {
        if (Token.hasToken(this.outSideBrackets, "CACHE")) {
            this.tableProxy.setCache("YES");
        }
    }

    private void initMonitoring() {
        if (Token.hasToken(this.outSideBrackets, "MONITORING")) {
            this.tableProxy.setMonitoring("YES");
        }
    }

    private void initRowMovement() {
        if (Token.hasString(this.outSideBrackets.toUpperCase(), "ROW MOVEMENT")) {
            String string = Token.getTokenBefore(this.outSideBrackets, "ROW MOVEMENT");
            this.tableProxy.setParttitionedRowMovement(string.toUpperCase());
        }
    }

    private void initParallel() {
        if (Token.hasToken(this.outSideBrackets, "PARALLEL")) {
            this.tableProxy.setParallel("YES");
            String string = Token.getTokenAfter(this.outSideBrackets, "PARALLEL").trim();
            try {
                Integer.parseInt(string);
                this.tableProxy.setDegree(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void initRowDependency() {
        if (Token.hasToken(this.outSideBrackets, "ROWDEPENDENCIES")) {
            this.tableProxy.setRowDependency("YES");
        }
    }

    protected void initPartitionsForSnapshotTable(String string, TableProxyOraclev10g tableProxyOraclev10g) {
        if (tableProxyOraclev10g != null) {
            this.outSideBrackets = string;
            this.tableProxy = tableProxyOraclev10g;
            this.table = (Table)tableProxyOraclev10g.getObject();
            this.storageDesign = (StorageDesignOraclev10g)tableProxyOraclev10g.getStorageDesign();
            this.initPartitions();
        }
    }

    private void initPartitions() {
        if (Token.hasString(this.outSideBrackets.toUpperCase(), "PARTITION BY")) {
            Object object;
            String string;
            PartitionListOraclev10g partitionListOraclev10g = (PartitionListOraclev10g)this.storageDesign.getPartitionListSet().createPartitionList();
            this.design.getRelationalDesign().stampModelObjectDDL(partitionListOraclev10g);
            partitionListOraclev10g.setTable(this.tableProxy);
            String string2 = Token.getStringAfter(this.outSideBrackets, "PARTITION BY");
            String string3 = Token.getFirstToken(string2);
            int n = string3.indexOf("(");
            if (n > -1) {
                string3 = string3.substring(0, n);
            }
            if (string3.equalsIgnoreCase("RANGE") || string3.equalsIgnoreCase("LIST") || string3.equalsIgnoreCase("HASH")) {
                string = Token.getValBetweenBrackets(string2, 1).trim();
                string2 = Token.getValAfterBrackets(string2, 1);
                object = new StringTokenizer(string, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    partitionListOraclev10g.setColumnList(Token.getName(((StringTokenizer)object).nextToken().trim()));
                }
            }
            if (string3.equalsIgnoreCase("RANGE")) {
                string = Token.getFirstToken(string2);
                if (string.equalsIgnoreCase("INTERVAL")) {
                    object = Token.getValBetweenBrackets(string2, 1).trim();
                    string2 = Token.getValAfterBrackets(string2, 1);
                    String string4 = "";
                    if (Token.startsWithString(string2, "STORE IN")) {
                        string4 = Token.getValBetweenBrackets(string2, 1);
                        string2 = Token.getValAfterBrackets(string2, 1);
                    }
                    if (partitionListOraclev10g instanceof PartitionListOraclev11g) {
                        ((PartitionListOraclev11g)partitionListOraclev10g).setIntervalExpression((String)object);
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string5 = Token.getName(stringTokenizer.nextToken().trim());
                            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string5);
                            if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                                tableSpaceOracle = this.storageDesign.getTableSpaceSet().createTableSpace();
                                tableSpaceOracle.setName(string5);
                                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                            }
                            if (tableSpaceOracle == null) continue;
                            ((PartitionListOraclev11g)partitionListOraclev10g).setIntervalTablespaceSet(tableSpaceOracle.getObjectID());
                        }
                    }
                }
                if (Token.hasString(string2.toUpperCase(), "SUBPARTITION BY HASH")) {
                    partitionListOraclev10g.setPartitionType("COMPOSITE BY HASH");
                    string2 = this.doSubPartByHash(string2, partitionListOraclev10g);
                } else if (Token.hasString(string2.toUpperCase(), "SUBPARTITION BY LIST")) {
                    partitionListOraclev10g.setPartitionType("COMPOSITE BY LIST");
                    string2 = this.doSubPartByList(string2, partitionListOraclev10g);
                } else {
                    partitionListOraclev10g.setPartitionType("RANGE");
                    if (Token.hasString(string2.toUpperCase(), "SUBPARTITION BY RANGE")) {
                        string2 = this.doSubPartByRange(string2, partitionListOraclev10g);
                    }
                }
                this.doRangePartitions(string2, partitionListOraclev10g, "RANGE");
            } else if (string3.equalsIgnoreCase("HASH")) {
                partitionListOraclev10g.setPartitionType("HASH BY LIST OF PARTITIONS");
                if (string2.charAt(0) == '(') {
                    string = Token.getValBetweenBrackets(string2, 1).trim();
                    object = new StringTokenizer(string, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        Object object2;
                        String string6;
                        Object object3 = ((StringTokenizer)object).nextToken();
                        while (Token.hasOpenBracket((String)object3) && ((StringTokenizer)object).hasMoreTokens()) {
                            object3 = (String)object3 + "," + ((StringTokenizer)object).nextToken();
                        }
                        if (!Token.hasToken((String)object3, "PARTITION")) continue;
                        String string7 = Token.getQuotedNameAfterToken((String)object3, "PARTITION");
                        HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)this.storageDesign.getHashPartitionSet().createHashPartition();
                        hashPartitionOraclev10g.setName(string7);
                        this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionOraclev10g);
                        hashPartitionOraclev10g.setPartitionList(partitionListOraclev10g);
                        String string8 = object3;
                        if (Token.hasToken(string8, "LOB")) {
                            string8 = Token.getStringBeforeToken(string8, "LOB");
                        }
                        if (string8.toUpperCase().indexOf("NESTED TABLE") > -1) {
                            string8 = Token.getStringBefore(string8, "NESTED TABLE");
                        }
                        String string9 = string8;
                        if (Token.hasToken(string8, "OVERFLOW")) {
                            string9 = Token.getStringBeforeToken(string8, "OVERFLOW");
                        }
                        if (!(string6 = Token.getQuotedNameAfterToken(string9, "TABLESPACE")).equals("")) {
                            object2 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string6);
                            if (object2 == null && !"SYSTEM".equalsIgnoreCase(string6)) {
                                object2 = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ((TableSpaceOracle)object2).setName(string6);
                                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                            }
                            if (object2 != null) {
                                hashPartitionOraclev10g.setTableSpace((TableSpaceOracle)object2);
                            }
                        }
                        while (Token.hasToken((String)object3, "LOB")) {
                            String string10;
                            object2 = Token.getStringAfter((String)object3, "LOB");
                            String string11 = Token.getFirstName(Token.getValBetweenBrackets((String)object2, 1), '\"', '\"');
                            HashPartitionLobItemOraclev10g hashPartitionLobItemOraclev10g = (HashPartitionLobItemOraclev10g)this.storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
                            hashPartitionLobItemOraclev10g.setName(string11);
                            this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionLobItemOraclev10g);
                            hashPartitionLobItemOraclev10g.setLobColumn(this.tableProxy.getColumnProxyByName(string11));
                            hashPartitionLobItemOraclev10g.setHashPartition(hashPartitionOraclev10g);
                            String string12 = "STORE AS";
                            if (Token.getTokenAfter(((String)object2).toUpperCase(), "STORE AS").equalsIgnoreCase("SECUREFILE")) {
                                string12 = "SECUREFILE";
                            } else if (Token.getTokenAfter(((String)object2).toUpperCase(), "STORE AS").equalsIgnoreCase("BASICFILE")) {
                                string12 = "BASICFILE";
                            }
                            object2 = Token.getStringAfter((String)object2, string12);
                            String string13 = Token.getStringBeforeToken((String)object2, "TABLESPACE");
                            if (string13.length() > 0 && !Token.hasToken(string13, "LOB") && !(string10 = Token.getQuotedNameAfterToken((String)object2, "TABLESPACE")).equals("")) {
                                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string10);
                                if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string10)) {
                                    tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                    tableSpaceOraclev10g.setName(string10);
                                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                                }
                                if (tableSpaceOraclev10g != null) {
                                    hashPartitionLobItemOraclev10g.setTableSpace(tableSpaceOraclev10g);
                                }
                            }
                            object3 = object2;
                        }
                    }
                } else if (Token.getFirstToken(string2).equalsIgnoreCase("PARTITIONS")) {
                    TableSpaceOracle tableSpaceOracle;
                    String string14;
                    StringTokenizer stringTokenizer;
                    partitionListOraclev10g.setPartitionType("HASH BY QUANTITY");
                    string2 = Token.cutTokenFromFront(string2, "PARTITIONS");
                    string = Token.getFirstToken(string2);
                    string2 = Token.cutTokenFromFront(string2, string);
                    try {
                        int n2 = Integer.parseInt(string);
                        partitionListOraclev10g.setHashPQuantity(n2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("wrong format in SHCreateTableOraclev10g.initPartitions : " + numberFormatException.getMessage());
                        this.importLog.addWarning("Wrong PARTITIONS format in statement " + this.statement);
                    }
                    if (Token.startsWithString(string2, "STORE IN")) {
                        String string15 = Token.getValBetweenBrackets(string2, 1);
                        string2 = Token.getValAfterBrackets(string2, 1);
                        stringTokenizer = new StringTokenizer(string15, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            string14 = Token.getName(stringTokenizer.nextToken().trim());
                            tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string14);
                            if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string14)) {
                                tableSpaceOracle = this.storageDesign.getTableSpaceSet().createTableSpace();
                                tableSpaceOracle.setName(string14);
                                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                            }
                            if (tableSpaceOracle == null) continue;
                            partitionListOraclev10g.setHashPTableSpaces(tableSpaceOracle.getObjectID());
                        }
                    }
                    if (Token.hasToken(string2, "OVERFLOW") && Token.startsWithString(string2 = Token.getStringAfterToken(string2, "OVERFLOW"), "STORE IN")) {
                        String string16 = Token.getValBetweenBrackets(string2, 1);
                        string2 = Token.getValAfterBrackets(string2, 1);
                        stringTokenizer = new StringTokenizer(string16, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            string14 = Token.getName(stringTokenizer.nextToken().trim());
                            tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string14);
                            if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string14)) {
                                tableSpaceOracle = this.storageDesign.getTableSpaceSet().createTableSpace();
                                tableSpaceOracle.setName(string14);
                                this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                            }
                            if (tableSpaceOracle == null) continue;
                            partitionListOraclev10g.setIOTOverflowHashPTSSet(tableSpaceOracle.getObjectID());
                        }
                    }
                }
            } else if (string3.equalsIgnoreCase("LIST")) {
                partitionListOraclev10g.setPartitionType("LIST");
                if (Token.hasString(string2.toUpperCase(), "SUBPARTITION BY HASH")) {
                    string2 = this.doSubPartByHash(string2, partitionListOraclev10g);
                } else if (Token.hasString(string2.toUpperCase(), "SUBPARTITION BY LIST")) {
                    string2 = this.doSubPartByList(string2, partitionListOraclev10g);
                } else if (Token.hasString(string2.toUpperCase(), "SUBPARTITION BY RANGE")) {
                    string2 = this.doSubPartByRange(string2, partitionListOraclev10g);
                }
                string = Token.getValBetweenBrackets(string2, 1).trim();
                string2 = Token.getValAfterBrackets(string2, 1).trim();
                object = new StringTokenizer(string, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string17;
                    String string18;
                    String string19 = ((StringTokenizer)object).nextToken();
                    while (Token.hasOpenBracket(string19) && ((StringTokenizer)object).hasMoreTokens()) {
                        string19 = string19 + "," + ((StringTokenizer)object).nextToken();
                    }
                    if (!Token.hasToken(string19, "PARTITION")) continue;
                    String string20 = Token.getQuotedNameAfterToken(string19, "PARTITION");
                    ListPartitionOraclev10g listPartitionOraclev10g = (ListPartitionOraclev10g)this.storageDesign.getListPartitionSet().createListPartition();
                    if (!string20.equalsIgnoreCase("VALUES")) {
                        listPartitionOraclev10g.setName(string20);
                    }
                    this.design.getRelationalDesign().stampModelObjectDDL(listPartitionOraclev10g);
                    listPartitionOraclev10g.setPartitionList(partitionListOraclev10g);
                    if (Token.hasToken(string19, "VALUES")) {
                        string18 = Token.getStringAfter(string19, "VALUES");
                        if ((string18 = Token.getValBetweenBrackets(string18, 1).trim()).equalsIgnoreCase("DEFAULT")) {
                            listPartitionOraclev10g.setColumns("DEFAULT");
                        } else {
                            listPartitionOraclev10g.setColumns(string18);
                        }
                    }
                    string18 = string19;
                    if (Token.hasToken(string19, "SUBPARTITION")) {
                        string18 = Token.getStringBeforeToken(string19, "SUBPARTITION");
                    }
                    if (Token.hasToken(string17 = string18, "LOB")) {
                        string17 = Token.getStringBeforeToken(string17, "LOB");
                    }
                    if (string17.toUpperCase().indexOf("NESTED TABLE") > -1) {
                        string17 = Token.getStringBefore(string17, "NESTED TABLE");
                    }
                    String string21 = string17;
                    if (Token.hasToken(string17, "OVERFLOW")) {
                        string21 = Token.getStringBeforeToken(string17, "OVERFLOW");
                    }
                    this.initPartSegment(string21, listPartitionOraclev10g);
                    String string22 = Token.getQuotedNameAfterToken(string21, "TABLESPACE");
                    if (!string22.equals("")) {
                        TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string22);
                        if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string22)) {
                            tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                            tableSpaceOraclev10g.setName(string22);
                            this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                        }
                        if (tableSpaceOraclev10g != null) {
                            listPartitionOraclev10g.setTablespace(tableSpaceOraclev10g);
                        }
                    }
                    if (Token.hasToken(string17, "LOGGING")) {
                        listPartitionOraclev10g.setLogging("YES");
                    } else if (Token.hasToken(string17, "NOLOGGING")) {
                        listPartitionOraclev10g.setLogging("NO");
                    } else {
                        listPartitionOraclev10g.setLogging("");
                    }
                    if (Token.hasToken(string17, "COMPRESS")) {
                        listPartitionOraclev10g.setDataSegmentCompression("YES");
                    } else if (Token.hasToken(string17, "NOCOMPRESS")) {
                        listPartitionOraclev10g.setDataSegmentCompression("NO");
                    }
                    this.initLobStorage(string18, listPartitionOraclev10g);
                    this.initSubPartitions(string19, listPartitionOraclev10g, partitionListOraclev10g.getSubpartitionType());
                }
            } else if (string3.equalsIgnoreCase("REFERENCE")) {
                if (partitionListOraclev10g instanceof PartitionListOraclev11g) {
                    partitionListOraclev10g.setPartitionType("REFERENCE");
                    this.processLocalForeignKeys();
                    string = Token.getValBetweenBrackets(string2, 1).trim();
                    ((PartitionListOraclev11g)partitionListOraclev10g).setRefConstraint(string);
                    string2 = Token.getValAfterBrackets(string2, 1);
                    this.doRangePartitions(string2, partitionListOraclev10g, "REFERENCE");
                }
            } else if (string3.equalsIgnoreCase("SYSTEM") && partitionListOraclev10g instanceof PartitionListOraclev11g) {
                partitionListOraclev10g.setPartitionType("SYSTEM");
                string = Token.getStringAfter(string2, "SYSTEM");
                if (Token.getFirstToken(string).equalsIgnoreCase("PARTITIONS")) {
                    object = Token.getFirstToken(Token.cutTokenFromFront(string, "PARTITIONS"));
                    try {
                        int n3 = Integer.parseInt((String)object);
                        ((PartitionListOraclev11g)partitionListOraclev10g).setSystemPartitions(n3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("wrong format in SHCreateTableOracle.initPartitions : " + numberFormatException.getMessage());
                        this.importLog.addWarning("Wrong PARTITION BY SYSTEM format in statement " + this.statement);
                    }
                } else {
                    this.doRangePartitions(string, partitionListOraclev10g, "SYSTEM");
                }
            }
            this.tableProxy.setPartitionList(partitionListOraclev10g);
        }
    }

    private String doSubPartByHash(String string, PartitionListOraclev10g partitionListOraclev10g) {
        block14: {
            block13: {
                partitionListOraclev10g.setSubpartitionType("HASH");
                string = Token.getStringAfter(string, "SUBPARTITION BY HASH");
                String string2 = Token.getValBetweenBrackets(string, 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    partitionListOraclev10g.setSubPartitionsColumnList(Token.getName(stringTokenizer.nextToken().trim()));
                }
                if (!Token.getFirstToken(string = Token.getValAfterBrackets(string, 1)).equalsIgnoreCase("SUBPARTITIONS")) break block13;
                string = Token.cutTokenFromFront(string, "SUBPARTITIONS");
                String string3 = Token.getFirstToken(string);
                string = Token.cutTokenFromFront(string, string3);
                try {
                    int n = Integer.parseInt(string3);
                    partitionListOraclev10g.setSubPartitionsQuantity(n);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateTableOracle.doSubPartByHash : " + numberFormatException.getMessage());
                    this.importLog.addWarning("Wrong SUBPARTITIONS format in statement " + this.statement);
                }
                if (!Token.startsWithString(string, "STORE IN")) break block14;
                String string4 = Token.getValBetweenBrackets(string, 1);
                string = Token.getValAfterBrackets(string, 1);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string5 = Token.getName(stringTokenizer2.nextToken().trim());
                    TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string5);
                    if (tableSpaceOracle == null && !"SYSTEM".equalsIgnoreCase(string5)) {
                        tableSpaceOracle = this.storageDesign.getTableSpaceSet().createTableSpace();
                        tableSpaceOracle.setName(string5);
                        this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOracle);
                    }
                    if (tableSpaceOracle == null) continue;
                    partitionListOraclev10g.setSubPartitionsTableSpaces(tableSpaceOracle.getObjectID());
                }
                break block14;
            }
            if (Token.getFirstToken(string).equalsIgnoreCase("SUBPARTITION") && Token.getFirstToken(Token.cutTokenFromFront(string, "SUBPARTITION")).equalsIgnoreCase("TEMPLATE")) {
                partitionListOraclev10g.setUseSubpartStorageTemplate("YES");
                String string6 = Token.getStringAfter(string, "TEMPLATE");
                if (!string6.startsWith("(")) {
                    String string7 = Token.getFirstToken(string6);
                    string = Token.cutTokenFromFront(string6, string7);
                    try {
                        int n = Integer.parseInt(string7);
                        partitionListOraclev10g.setSubPartitionsQuantity(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("wrong format in SHCreateTableOracle.doSubPartByHash : " + numberFormatException.getMessage());
                        this.importLog.addWarning("Wrong SUBPARTITION TEMPLATE format in statement " + this.statement);
                    }
                } else {
                    String string8 = Token.getValBetweenBrackets(string6, 1).trim();
                    string = Token.getValAfterBrackets(string6, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string9 = stringTokenizer.nextToken();
                        while (Token.hasOpenBracket(string9) && stringTokenizer.hasMoreTokens()) {
                            string9 = string9 + "," + stringTokenizer.nextToken();
                        }
                        if (!Token.hasToken(string9, "SUBPARTITION")) continue;
                        String string10 = Token.getQuotedNameAfterToken(string9, "SUBPARTITION");
                        HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)this.storageDesign.getHashPartitionSet().createHashPartition();
                        if (!(string10.equalsIgnoreCase("TABLESPACE") || string10.equalsIgnoreCase("OVERFLOW") || string10.equalsIgnoreCase("COMPRESS") || string10.equalsIgnoreCase("NOCOMPRESS") || string10.equalsIgnoreCase("LOB") || string10.equalsIgnoreCase("VARRAY"))) {
                            hashPartitionOraclev10g.setName(string10);
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionOraclev10g);
                        hashPartitionOraclev10g.setPartOfStorageTable(this.tableProxy);
                        this.initHashSubPartition(string9, hashPartitionOraclev10g);
                    }
                }
            }
        }
        return string;
    }

    private void initHashSubPartition(String string, HashPartitionOraclev10g hashPartitionOraclev10g) {
        Object object;
        String string2;
        String string3 = string;
        while (Token.hasToken(string3, "TABLESPACE")) {
            if (Token.hasOpenBracketNoClose(Token.getStringBeforeToken(string3, "TABLESPACE"))) {
                string3 = Token.getValAfterBrackets(string3, 1);
                continue;
            }
            string2 = Token.getQuotedNameAfterToken(string3, "TABLESPACE");
            if (string2.indexOf(",") > 0) {
                string2 = Token.getStringBefore(string2, ",").trim();
            }
            if (!string2.equals("")) {
                object = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string2);
                if (object == null && !"SYSTEM".equalsIgnoreCase(string2)) {
                    object = this.storageDesign.getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)object).setName(string2);
                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
                }
                if (object != null) {
                    if (Token.getTokenBefore(string3, "TABLESPACE").equalsIgnoreCase("OVERFLOW")) {
                        hashPartitionOraclev10g.setIotOverflowTablespace((TableSpaceOracle)object);
                    } else {
                        hashPartitionOraclev10g.setTableSpace((TableSpaceOracle)object);
                    }
                }
            }
            string3 = Token.getStringAfterToken(string3, "TABLESPACE");
        }
        while (Token.hasToken(string, "LOB")) {
            String string4;
            string2 = Token.getStringAfter(string, "LOB");
            object = Token.getFirstName(Token.getValBetweenBrackets(string2, 1), '\"', '\"');
            HashPartitionLobItemOraclev10g hashPartitionLobItemOraclev10g = (HashPartitionLobItemOraclev10g)this.storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
            hashPartitionLobItemOraclev10g.setName((String)object);
            this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionLobItemOraclev10g);
            hashPartitionLobItemOraclev10g.setLobColumn(this.tableProxy.getColumnProxyByName((String)object));
            hashPartitionLobItemOraclev10g.setHashPartition(hashPartitionOraclev10g);
            String string5 = "STORE AS";
            if (Token.getTokenAfter(string2.toUpperCase(), "STORE AS").equalsIgnoreCase("SECUREFILE")) {
                string5 = "SECUREFILE";
            } else if (Token.getTokenAfter(string2.toUpperCase(), "STORE AS").equalsIgnoreCase("BASICFILE")) {
                string5 = "BASICFILE";
            }
            string2 = Token.getStringAfter(string2, string5);
            String string6 = Token.getStringBeforeToken(string2, "TABLESPACE");
            if (string6.length() > 0 && !Token.hasToken(string6, "LOB") && !(string4 = Token.getQuotedNameAfterToken(string2, "TABLESPACE")).equals("")) {
                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string4);
                if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string4)) {
                    tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev10g.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                }
                if (tableSpaceOraclev10g != null) {
                    hashPartitionLobItemOraclev10g.setTableSpace(tableSpaceOraclev10g);
                }
            }
            string = string2;
        }
    }

    private String doSubPartByList(String string, PartitionListOraclev10g partitionListOraclev10g) {
        partitionListOraclev10g.setSubpartitionType("LIST");
        string = Token.getStringAfter(string, "SUBPARTITION BY LIST");
        String string2 = Token.getValBetweenBrackets(string, 1).trim();
        partitionListOraclev10g.setSubPartitionsColumnList(Token.getName(string2));
        string = Token.getValAfterBrackets(string, 1);
        if (Token.getFirstToken(string).equalsIgnoreCase("SUBPARTITION") && Token.getFirstToken(Token.cutTokenFromFront(string, "SUBPARTITION")).equalsIgnoreCase("TEMPLATE")) {
            partitionListOraclev10g.setUseSubpartStorageTemplate("YES");
            String string3 = Token.getStringAfter(string, "TEMPLATE");
            String string4 = Token.getValBetweenBrackets(string3, 1).trim();
            string = Token.getValAfterBrackets(string3, 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                while (Token.hasOpenBracket(string5) && stringTokenizer.hasMoreTokens()) {
                    string5 = string5 + "," + stringTokenizer.nextToken();
                }
                if (!Token.hasToken(string5, "SUBPARTITION")) continue;
                String string6 = Token.getQuotedNameAfterToken(string5, "SUBPARTITION");
                ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)this.storageDesign.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                if (!string6.equalsIgnoreCase("VALUES")) {
                    listStorageTemplatePartitionOraclev10g.setName(string6);
                }
                this.design.getRelationalDesign().stampModelObjectDDL(listStorageTemplatePartitionOraclev10g);
                listStorageTemplatePartitionOraclev10g.setPartOfStorageTable(this.tableProxy);
                this.initListSubPartition(string5, listStorageTemplatePartitionOraclev10g);
            }
        }
        return string;
    }

    private void initListSubPartition(String string, ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g) {
        Object object;
        String string2;
        String string3;
        if (Token.hasToken(string, "VALUES")) {
            string3 = Token.getStringAfter(string, "VALUES");
            if ((string3 = Token.getValBetweenBrackets(string3, 1).trim()).equalsIgnoreCase("DEFAULT")) {
                listStorageTemplatePartitionOraclev10g.setValueList("DEFAULT");
            } else {
                listStorageTemplatePartitionOraclev10g.setValueList(string3);
            }
        }
        if ((string3 = Token.getStringBeforeToken(string, "TABLESPACE")).length() > 0 && !Token.endsWithOpenBracket(string3) && !(string2 = Token.getQuotedNameAfterToken(string, "TABLESPACE")).equals("")) {
            if (string2.indexOf(",") > 0) {
                string2 = Token.getStringBefore(string2, ",").trim();
            }
            if ((object = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string2)) == null && !"SYSTEM".equalsIgnoreCase(string2)) {
                object = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                ((TableSpaceOracle)object).setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
            }
            if (object != null) {
                listStorageTemplatePartitionOraclev10g.setTablespace((TableSpaceOracle)object);
            }
        }
        if (Token.hasToken(string, "COMPRESS")) {
            listStorageTemplatePartitionOraclev10g.setDataSegmentCompression("YES");
        } else if (Token.hasToken(string, "NOCOMPRESS")) {
            listStorageTemplatePartitionOraclev10g.setDataSegmentCompression("NO");
        }
        while (Token.hasToken(string, "LOB")) {
            String string4;
            string2 = Token.getStringAfter(string, "LOB");
            object = Token.getFirstName(Token.getValBetweenBrackets(string2, 1), '\"', '\"');
            HashPartitionLobItemOraclev10g hashPartitionLobItemOraclev10g = (HashPartitionLobItemOraclev10g)this.storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
            hashPartitionLobItemOraclev10g.setName((String)object);
            this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionLobItemOraclev10g);
            hashPartitionLobItemOraclev10g.setLobColumn(this.tableProxy.getColumnProxyByName((String)object));
            hashPartitionLobItemOraclev10g.setListTemplatePartition(listStorageTemplatePartitionOraclev10g);
            String string5 = "STORE AS";
            if (Token.getTokenAfter(string2.toUpperCase(), "STORE AS").equalsIgnoreCase("SECUREFILE")) {
                string5 = "SECUREFILE";
            } else if (Token.getTokenAfter(string2.toUpperCase(), "STORE AS").equalsIgnoreCase("BASICFILE")) {
                string5 = "BASICFILE";
            }
            string2 = Token.getStringAfter(string2, string5);
            String string6 = Token.getStringBeforeToken(string2, "TABLESPACE");
            if (string6.length() > 0 && !Token.hasToken(string6, "LOB") && !(string4 = Token.getQuotedNameAfterToken(string2, "TABLESPACE")).equals("")) {
                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string4);
                if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string4)) {
                    tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev10g.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                }
                if (tableSpaceOraclev10g != null) {
                    hashPartitionLobItemOraclev10g.setTableSpace(tableSpaceOraclev10g);
                }
            }
            string = string2;
        }
    }

    private String doSubPartByRange(String string, PartitionListOraclev10g partitionListOraclev10g) {
        if (!(partitionListOraclev10g instanceof PartitionListOraclev11g)) {
            return Token.getValAfterBrackets(string, 1);
        }
        partitionListOraclev10g.setSubpartitionType("RANGE");
        string = Token.getStringAfter(string, "SUBPARTITION BY RANGE");
        String string2 = Token.getValBetweenBrackets(string, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            partitionListOraclev10g.setSubPartitionsColumnList(Token.getName(stringTokenizer.nextToken().trim()));
        }
        if (Token.getFirstToken(string = Token.getValAfterBrackets(string, 1)).equalsIgnoreCase("SUBPARTITION") && Token.getFirstToken(Token.cutTokenFromFront(string, "SUBPARTITION")).equalsIgnoreCase("TEMPLATE")) {
            partitionListOraclev10g.setUseSubpartStorageTemplate("YES");
            String string3 = Token.getStringAfter(string, "TEMPLATE");
            String string4 = Token.getValBetweenBrackets(string3, 1).trim();
            string = Token.getValAfterBrackets(string3, 1);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
            int n = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                ++n;
                String string5 = stringTokenizer2.nextToken();
                while (Token.hasOpenBracket(string5) && stringTokenizer2.hasMoreTokens()) {
                    string5 = string5 + "," + stringTokenizer2.nextToken();
                }
                if (!Token.hasToken(string5, "SUBPARTITION")) continue;
                String string6 = Token.getQuotedNameAfterToken(string5, "SUBPARTITION");
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)this.storageDesign.getPartitionSet().createPartition();
                if (!string6.equalsIgnoreCase("VALUES")) {
                    partitionOraclev11g.setName(string6);
                }
                this.design.getRelationalDesign().stampModelObjectDDL(partitionOraclev11g);
                partitionOraclev11g.setPartOfStorageTable(this.tableProxy);
                partitionOraclev11g.setPosition(n);
                this.initRangeSubPartition(string5, partitionOraclev11g);
            }
        }
        return string;
    }

    private void initRangeSubPartition(String string, PartitionOraclev10g partitionOraclev10g) {
        Object object;
        String string2;
        String string3;
        if (Token.hasToken(string, "VALUES")) {
            string3 = Token.getStringAfter(string, "VALUES");
            string3 = Token.getValBetweenBrackets(string3, 1).trim();
            partitionOraclev10g.setValueList(string3);
        }
        if (!((string3 = Token.getStringBeforeToken(string, "TABLESPACE")).length() <= 0 || Token.endsWithOpenBracket(string3) || (string2 = Token.getQuotedNameAfterToken(string, "TABLESPACE")).equals("") || Token.getTokenBefore(string, "TABLESPACE").equalsIgnoreCase("OVERFLOW"))) {
            if (string2.indexOf(",") > 0) {
                string2 = Token.getStringBefore(string2, ",").trim();
            }
            if ((object = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string2)) == null && !"SYSTEM".equalsIgnoreCase(string2)) {
                object = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                ((TableSpaceOracle)object).setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object);
            }
            if (object != null) {
                partitionOraclev10g.setTableSpace((TableSpaceOracle)object);
            }
        }
        if (Token.hasToken(string, "COMPRESS")) {
            partitionOraclev10g.setDataSegmentCompression("YES");
        } else if (Token.hasToken(string, "NOCOMPRESS")) {
            partitionOraclev10g.setDataSegmentCompression("NO");
        }
        while (Token.hasToken(string, "LOB")) {
            String string4;
            string2 = Token.getStringAfter(string, "LOB");
            object = Token.getFirstName(Token.getValBetweenBrackets(string2, 1), '\"', '\"');
            HashPartitionLobItemOraclev10g hashPartitionLobItemOraclev10g = (HashPartitionLobItemOraclev10g)this.storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
            hashPartitionLobItemOraclev10g.setName((String)object);
            this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionLobItemOraclev10g);
            hashPartitionLobItemOraclev10g.setLobColumn(this.tableProxy.getColumnProxyByName((String)object));
            hashPartitionLobItemOraclev10g.setRangePartition(partitionOraclev10g);
            String string5 = "STORE AS";
            if (Token.getTokenAfter(string2.toUpperCase(), "STORE AS").equalsIgnoreCase("SECUREFILE")) {
                string5 = "SECUREFILE";
            } else if (Token.getTokenAfter(string2.toUpperCase(), "STORE AS").equalsIgnoreCase("BASICFILE")) {
                string5 = "BASICFILE";
            }
            string2 = Token.getStringAfter(string2, string5);
            String string6 = Token.getStringBeforeToken(string2, "TABLESPACE");
            if (string6.length() > 0 && !Token.hasToken(string6, "LOB") && !(string4 = Token.getQuotedNameAfterToken(string2, "TABLESPACE")).equals("")) {
                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string4);
                if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string4)) {
                    tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev10g.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                }
                if (tableSpaceOraclev10g != null) {
                    hashPartitionLobItemOraclev10g.setTableSpace(tableSpaceOraclev10g);
                }
            }
            string = string2;
        }
    }

    private void doRangePartitions(String string, PartitionListOraclev10g partitionListOraclev10g, String string2) {
        String string3 = Token.getValBetweenBrackets(string, 1).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            String string5;
            ++n;
            String string6 = stringTokenizer.nextToken();
            while (Token.hasOpenBracket(string6) && stringTokenizer.hasMoreTokens()) {
                string6 = string6 + "," + stringTokenizer.nextToken();
            }
            if (!Token.hasToken(string6, "PARTITION")) continue;
            String string7 = Token.getQuotedNameAfterToken(string6, "PARTITION");
            PartitionOraclev10g partitionOraclev10g = (PartitionOraclev10g)this.storageDesign.getPartitionSet().createPartition();
            if (!string7.equalsIgnoreCase("VALUES")) {
                partitionOraclev10g.setName(string7);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(partitionOraclev10g);
            partitionOraclev10g.setPartitionList(partitionListOraclev10g);
            partitionOraclev10g.setPosition(n);
            if (string2.equals("RANGE")) {
                string6 = Token.getStringAfter(string6, "LESS THAN");
                string5 = Token.getValBetweenBrackets(string6, 1).trim();
                partitionOraclev10g.setValueList(string5);
                string6 = Token.getValAfterBrackets(string6, 1);
            }
            string5 = string6;
            if (Token.hasToken(string6, "SUBPARTITION")) {
                string5 = Token.getStringBeforeToken(string6, "SUBPARTITION");
            }
            if (Token.hasToken(string4 = string5, "LOB")) {
                string4 = Token.getStringBeforeToken(string4, "LOB");
            }
            if (string4.toUpperCase().indexOf("NESTED TABLE") > -1) {
                string4 = Token.getStringBefore(string4, "NESTED TABLE");
            }
            String string8 = string4;
            if (Token.hasToken(string4, "OVERFLOW")) {
                string8 = Token.getStringBeforeToken(string4, "OVERFLOW");
                this.initOverflowSegment(Token.getStringAfter(string4, "OVERFLOW"), partitionOraclev10g);
            }
            this.initPartSegment(string8, partitionOraclev10g);
            String string9 = Token.getQuotedNameAfterToken(string8, "TABLESPACE");
            if (!string9.equals("")) {
                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string9);
                if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string9)) {
                    tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev10g.setName(string9);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                }
                if (tableSpaceOraclev10g != null) {
                    partitionOraclev10g.setTableSpace(tableSpaceOraclev10g);
                }
            }
            if (Token.hasToken(string4, "LOGGING")) {
                partitionOraclev10g.setLogging("YES");
            } else if (Token.hasToken(string4, "NOLOGGING")) {
                partitionOraclev10g.setLogging("NO");
            } else {
                partitionOraclev10g.setLogging("");
            }
            if (Token.hasToken(string4, "COMPRESS")) {
                partitionOraclev10g.setDataSegmentCompression("YES");
            } else if (Token.hasToken(string4, "NOCOMPRESS")) {
                partitionOraclev10g.setDataSegmentCompression("NO");
            }
            this.initLobStorage(string5, partitionOraclev10g);
            this.initSubPartitions(string6, partitionOraclev10g, partitionListOraclev10g.getSubpartitionType());
        }
    }

    private void initPartSegment(String string, ListPartitionOraclev10g listPartitionOraclev10g) {
        SegmentOraclev10g segmentOraclev10g = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev10g = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev10g);
            this.initPctUsed(string, segmentOraclev10g);
            this.initInitrans(string, segmentOraclev10g);
            this.initMaxtrans(string, segmentOraclev10g);
            this.initStorage(string, segmentOraclev10g);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev10g);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev10g);
            listPartitionOraclev10g.setSegment(segmentOracle);
        }
    }

    private void initPartSegment(String string, PartitionOraclev10g partitionOraclev10g) {
        SegmentOraclev10g segmentOraclev10g = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev10g = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev10g);
            this.initPctUsed(string, segmentOraclev10g);
            this.initInitrans(string, segmentOraclev10g);
            this.initMaxtrans(string, segmentOraclev10g);
            this.initStorage(string, segmentOraclev10g);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev10g);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev10g);
            partitionOraclev10g.setSegment(segmentOracle);
        }
    }

    private void initSubPartitions(String string, AbstractStorageObjectOracle abstractStorageObjectOracle, String string2) {
        block19: {
            String string3;
            block20: {
                block18: {
                    string3 = string;
                    if (!"LIST".equalsIgnoreCase(string2)) break block18;
                    while (Token.hasToken(string3, "SUBPARTITION")) {
                        String string4 = Token.getQuotedNameAfterToken(string3, "SUBPARTITION");
                        String string5 = Token.getStringBeforeToken(string3 = Token.getStringAfter(string3, "SUBPARTITION"), "SUBPARTITION");
                        if (string5.length() == 0) {
                            string5 = string3;
                        }
                        ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)this.storageDesign.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                        if (!string4.equalsIgnoreCase("VALUES")) {
                            listStorageTemplatePartitionOraclev10g.setName(string4);
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(listStorageTemplatePartitionOraclev10g);
                        listStorageTemplatePartitionOraclev10g.setSubPartitionOf(abstractStorageObjectOracle);
                        this.initListSubPartition(string5, listStorageTemplatePartitionOraclev10g);
                    }
                    break block19;
                }
                if (!"HASH".equalsIgnoreCase(string2)) break block20;
                if (Token.hasToken(string, "SUBPARTITIONS")) {
                    try {
                        int n = Integer.parseInt(Token.getTokenAfter(string, "SUBPARTITIONS").trim());
                        if (abstractStorageObjectOracle instanceof PartitionOraclev10g) {
                            ((PartitionOraclev10g)abstractStorageObjectOracle).setSubPartitionsQuantity(n);
                        } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                            ((ListPartitionOraclev11g)abstractStorageObjectOracle).setSubPartitionsQuantity(n);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("wrong format in SHCreateTableOraclev10g.initSubPartitions : " + numberFormatException.getMessage());
                        this.importLog.addWarning("Wrong SUBPARTITIONS format in statement " + this.statement);
                    }
                    String string6 = Token.getStringAfter(string, "STORE IN");
                    String string7 = Token.getValBetweenBrackets(string6, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string8 = stringTokenizer.nextToken().trim();
                        TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(string8);
                        if (tableSpaceOracle == null) continue;
                        if (abstractStorageObjectOracle instanceof PartitionOraclev10g) {
                            ((PartitionOraclev10g)abstractStorageObjectOracle).setSubPartitionsTableSpaces(tableSpaceOracle.getObjectID());
                            continue;
                        }
                        if (!(abstractStorageObjectOracle instanceof ListPartitionOraclev11g)) continue;
                        ((ListPartitionOraclev11g)abstractStorageObjectOracle).setSubPartitionsTableSpaces(tableSpaceOracle.getObjectID());
                    }
                } else {
                    while (Token.hasToken(string3, "SUBPARTITION")) {
                        String string9 = Token.getQuotedNameAfterToken(string3, "SUBPARTITION");
                        String string10 = Token.getStringBeforeToken(string3 = Token.getStringAfter(string3, "SUBPARTITION"), "SUBPARTITION");
                        if (string10.length() == 0) {
                            string10 = string3;
                        }
                        HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)this.storageDesign.getHashPartitionSet().createHashPartition();
                        if (!(string9.equalsIgnoreCase("TABLESPACE") || string9.equalsIgnoreCase("OVERFLOW") || string9.equalsIgnoreCase("COMPRESS") || string9.equalsIgnoreCase("NOCOMPRESS") || string9.equalsIgnoreCase("LOB") || string9.equalsIgnoreCase("VARRAY"))) {
                            hashPartitionOraclev10g.setName(string9);
                        }
                        this.design.getRelationalDesign().stampModelObjectDDL(hashPartitionOraclev10g);
                        hashPartitionOraclev10g.setSubPartitionOf(abstractStorageObjectOracle);
                        this.initHashSubPartition(string10, hashPartitionOraclev10g);
                    }
                }
                break block19;
            }
            if (!"RANGE".equalsIgnoreCase(string2)) break block19;
            int n = 0;
            while (Token.hasToken(string3, "SUBPARTITION")) {
                ++n;
                String string11 = Token.getQuotedNameAfterToken(string3, "SUBPARTITION");
                String string12 = Token.getStringBeforeToken(string3 = Token.getStringAfter(string3, "SUBPARTITION"), "SUBPARTITION");
                if (string12.length() == 0) {
                    string12 = string3;
                }
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)this.storageDesign.getPartitionSet().createPartition();
                if (!string11.equalsIgnoreCase("VALUES")) {
                    partitionOraclev11g.setName(string11);
                }
                this.design.getRelationalDesign().stampModelObjectDDL(partitionOraclev11g);
                partitionOraclev11g.setSubPartitionOf(abstractStorageObjectOracle);
                partitionOraclev11g.setPosition(n);
                this.initRangeSubPartition(string12, partitionOraclev11g);
            }
        }
    }

    private void initTableLobStorages() {
        String string = this.outSideBrackets;
        while (Token.hasToken(string, "LOB")) {
            String string2;
            String string3;
            String string4;
            int n;
            LobStorageOraclev10g lobStorageOraclev10g = (LobStorageOraclev10g)this.storageDesign.getLobStorageSet().createLobStorage();
            this.design.getRelationalDesign().stampModelObjectDDL(lobStorageOraclev10g);
            lobStorageOraclev10g.setTable(this.tableProxy);
            String string5 = Token.getStringAfter(string, "LOB");
            String string6 = Token.getValBetweenBrackets(string5, 1).replaceAll("\"", "").trim();
            lobStorageOraclev10g.setColumn(string6);
            String string7 = "STORE AS";
            if (Token.getTokenAfter(string5.toUpperCase(), "STORE AS").equalsIgnoreCase("SECUREFILE")) {
                string7 = "SECUREFILE";
                if (lobStorageOraclev10g instanceof LobStorageOraclev11g) {
                    ((LobStorageOraclev11g)lobStorageOraclev10g).setLobStorageType("SECUREFILE");
                }
            } else if (Token.getTokenAfter(string5.toUpperCase(), "STORE AS").equalsIgnoreCase("BASICFILE")) {
                string7 = "BASICFILE";
                if (lobStorageOraclev10g instanceof LobStorageOraclev11g) {
                    ((LobStorageOraclev11g)lobStorageOraclev10g).setLobStorageType("BASICFILE");
                }
            }
            if ((n = (string4 = Token.getFirstToken(string5 = Token.getStringAfter(string5, string7))).indexOf("(")) >= 0) {
                string4 = string4.substring(0, n);
            }
            if (string4.length() > 0) {
                string4 = Token.getName(string4);
                lobStorageOraclev10g.setLobSegmentName(string4);
            }
            if (!(string3 = Token.getQuotedNameAfterToken(string2 = Token.getValBetweenBrackets(string5, 1).trim(), "TABLESPACE")).equals("")) {
                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string3);
                if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string3)) {
                    tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev10g.setName(string3);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                }
                if (tableSpaceOraclev10g != null) {
                    lobStorageOraclev10g.setTableSpace(tableSpaceOraclev10g);
                }
            }
            this.initLobStorageStorage(string2, lobStorageOraclev10g);
            string = string5;
        }
    }

    private void initLobStorage(String string, AbstractStorageObjectOracle abstractStorageObjectOracle) {
        if (Token.hasToken(string, "LOB")) {
            LobStorageOraclev10g lobStorageOraclev10g = (LobStorageOraclev10g)this.storageDesign.getLobStorageSet().createLobStorage();
            this.design.getRelationalDesign().stampModelObjectDDL(lobStorageOraclev10g);
            if (abstractStorageObjectOracle instanceof PartitionOraclev10g) {
                lobStorageOraclev10g.setPartition((PartitionOraclev10g)abstractStorageObjectOracle);
            } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev10g) {
                lobStorageOraclev10g.setListPartition((ListPartitionOraclev10g)abstractStorageObjectOracle);
            }
            String string2 = Token.getStringAfter(string, "LOB");
            String string3 = Token.getValBetweenBrackets(string2, 1).replaceAll("\"", "").trim();
            lobStorageOraclev10g.setColumn(string3);
            String string4 = "STORE AS";
            if (Token.getTokenAfter(string2.toUpperCase(), "STORE AS").equalsIgnoreCase("SECUREFILE")) {
                string4 = "SECUREFILE";
                if (lobStorageOraclev10g instanceof LobStorageOraclev11g) {
                    ((LobStorageOraclev11g)lobStorageOraclev10g).setLobStorageType("SECUREFILE");
                }
            } else if (Token.getTokenAfter(string2.toUpperCase(), "STORE AS").equalsIgnoreCase("BASICFILE")) {
                string4 = "BASICFILE";
                if (lobStorageOraclev10g instanceof LobStorageOraclev11g) {
                    ((LobStorageOraclev11g)lobStorageOraclev10g).setLobStorageType("BASICFILE");
                }
            }
            string2 = Token.getStringAfter(string2, string4);
            String string5 = Token.getTokenBefore(string2, "(").trim();
            string5 = Token.getName(string5);
            lobStorageOraclev10g.setName(string5);
            String string6 = Token.getValBetweenBrackets(string2, 1).trim();
            String string7 = Token.getQuotedNameAfterToken(string6, "TABLESPACE");
            if (!string7.equals("")) {
                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(string7);
                if (tableSpaceOraclev10g == null && !"SYSTEM".equalsIgnoreCase(string7)) {
                    tableSpaceOraclev10g = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpaceOraclev10g.setName(string7);
                    this.design.getRelationalDesign().stampModelObjectDDL(tableSpaceOraclev10g);
                }
                if (tableSpaceOraclev10g != null) {
                    lobStorageOraclev10g.setTableSpace(tableSpaceOraclev10g);
                }
            }
            this.initLobStorageStorage(string6, lobStorageOraclev10g);
        }
    }

    private void initOverflowSegment(String string, PartitionOraclev10g partitionOraclev10g) {
        SegmentOraclev10g segmentOraclev10g = null;
        if ((Token.hasToken(string, "PCTFREE") || Token.hasToken(string, "PCTUSED") || Token.hasToken(string, "INITRANS") || Token.hasToken(string, "MAXTRANS") || Token.hasToken(string, "STORAGE")) && (segmentOraclev10g = (SegmentOraclev10g)this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(string, segmentOraclev10g);
            this.initPctUsed(string, segmentOraclev10g);
            this.initInitrans(string, segmentOraclev10g);
            this.initMaxtrans(string, segmentOraclev10g);
            this.initStorage(string, segmentOraclev10g);
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOraclev10g);
            SegmentOracle segmentOracle = this.storageDesign.getSegmentSet().findEqual(segmentOraclev10g);
            partitionOraclev10g.setIOTOverflowSegment(segmentOracle);
        }
    }

    private void initLobStorageStorage(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, null, lobStorageOraclev10g, null);
            this.initNext(string2, null, lobStorageOraclev10g, null);
            this.initPCtIncrease(string2, null, lobStorageOraclev10g, null);
            this.initMinExtents(string2, null, lobStorageOraclev10g, null);
            this.initMaxExtents(string2, null, lobStorageOraclev10g, null);
            this.initFreeLists(string2, null, lobStorageOraclev10g, null);
            this.initFreeListGroups(string2, null, lobStorageOraclev10g, null);
            this.initSegBufferPool(string2, null, lobStorageOraclev10g, null);
        }
        this.initChunk(string, lobStorageOraclev10g);
        this.initRetention(string, lobStorageOraclev10g);
        this.initPctVersion(string, lobStorageOraclev10g);
        this.initFreePools(string, lobStorageOraclev10g);
        this.initStorageInRow(string, lobStorageOraclev10g);
        this.initLSCache(string, lobStorageOraclev10g);
        this.initLogging(string, lobStorageOraclev10g);
    }

    private void initChunk(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "CHUNK")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "CHUNK").trim());
                lobStorageOraclev10g.setChunk(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initChunk : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong CHUNK format in statement " + this.statement);
            }
        }
    }

    private void initRetention(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "RETENTION")) {
            lobStorageOraclev10g.setOldVersions("RETENTION");
        }
    }

    private void initFreePools(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "FREEPOOLS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "FREEPOOLS").trim());
                lobStorageOraclev10g.setFreepools(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initFreePools : ", numberFormatException);
                this.importLog.addWarning("Wrong FREEPOOLS format in statement " + this.statement);
            }
        }
    }

    private void initPctVersion(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "PCTVERSION")) {
            try {
                lobStorageOraclev10g.setOldVersions(LobStorageOracle.OLD_VERSIONS[1]);
                int n = Integer.parseInt(Token.getTokenAfter(string, "PCTVERSION").trim());
                lobStorageOraclev10g.setPCTVersion(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateTableOracle.initPctVersion : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
            }
        }
    }

    private void initStorageInRow(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasString(string.toUpperCase(), "STORAGE IN ROW")) {
            String string2 = Token.getTokenBefore(string, "STORAGE IN ROW");
            lobStorageOraclev10g.setStorageInRow(string2);
        }
    }

    private void initLSCache(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "CACHE")) {
            if (Token.hasString(string.toUpperCase(), "CACHE READS")) {
                lobStorageOraclev10g.setCache("CACHE READS");
            } else {
                lobStorageOraclev10g.setCache("CACHE");
            }
        } else if (Token.hasToken(string, "NOCACHE")) {
            lobStorageOraclev10g.setCache("NOCACHE");
        }
    }

    private void initLogging(String string, LobStorageOraclev10g lobStorageOraclev10g) {
        if (Token.hasToken(string, "NOLOGGING")) {
            lobStorageOraclev10g.setLogging("NO");
        } else if (Token.hasToken(string, "LOGGING")) {
            lobStorageOraclev10g.setLogging("YES");
        } else if (Token.hasToken(string, "FILESYSTEM_LIKE_LOGGING")) {
            lobStorageOraclev10g.setLogging("FILESYSTEM_LIKE_LOGGING");
        } else {
            lobStorageOraclev10g.setLogging("");
        }
    }

    private Table getReferencedTable(String string) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table table = (Table)tableSet.getByName(string);
        if (table != null) {
            return table;
        }
        this.importLog.addError("Table with name " + string + " does not exist.");
        throw new ObjectDoesNotExistException("Table with name " + string);
    }

    private boolean addForeignKey(String string, Table table) {
        String string2;
        int n;
        String string3 = null;
        if (Token.hasToken(string, "CONSTRAINT")) {
            string3 = Token.getTokenAfter(string, "CONSTRAINT");
        } else {
            string3 = Token.getTokenAfter(string, "KEY");
            n = string3.indexOf("(");
            if (n > 0) {
                string3 = string3.substring(0, n);
            } else if (n == 0) {
                string3 = null;
            }
        }
        if (string3 != null) {
            string3 = Token.removeQuotes(string3);
        }
        n = string.indexOf(41);
        String string4 = string.substring(0, n + 1).trim();
        String string5 = Token.getValBetweenBrackets(string4);
        List list = this.getColumnNames(string5);
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Column[] columnArray = (Column[])table.getElements();
        for (String string6 : list) {
            for (int i = 0; i < columnArray.length; ++i) {
                string2 = columnArray[i].getName().trim();
                if (!string6.equalsIgnoreCase(string2)) continue;
                arrayList.add(columnArray[i]);
            }
        }
        int n2 = string.toUpperCase().indexOf("REFERENCES");
        string = string.substring(n2);
        String string7 = Token.getQuotedNameAfterToken(string, "REFERENCES");
        string2 = Token.getValBeforeCharacter(string7, '.');
        String string8 = this.getNameFor(string7);
        string8 = Token.removeQuotes(string8);
        Table table2 = null;
        if (string2 != null && !"".equals(string2)) {
            string2 = Token.removeQuotes(string2);
            table2 = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string2, string8);
        }
        if (table2 == null) {
            table2 = this.getTableFor(string8);
        }
        if (table2 != null) {
            boolean bl = Token.hasString(string, "(");
            if (bl) {
                String string9 = Token.getValBetweenBrackets(string);
                List list2 = this.getColumnNames(string9);
                FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(table2, list2);
                if (index != null) {
                    FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                    this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                    if (string3 != null) {
                        fKIndexAssociation.setName(string3);
                        fKIndexAssociation.getLocalFKIndex().setName(string3);
                    }
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                    } else {
                        this.fixFKColumns(fKIndexAssociation, arrayList, index);
                    }
                    boolean bl2 = Token.hasToken(string, "DELETE");
                    if (bl2) {
                        String string10 = Token.getTokenAfter(string, "DELETE");
                        if (string10.equalsIgnoreCase("NO")) {
                            if (Token.getTokenAfter(string, "NO").equalsIgnoreCase("ACTION")) {
                                string10 = "NO ACTION";
                            }
                        } else if (string10.equalsIgnoreCase("SET") && Token.getTokenAfter(string, "SET").equalsIgnoreCase("NULL")) {
                            string10 = "SET NULL";
                        }
                        String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!string10.equalsIgnoreCase(stringArray[i])) continue;
                            fKIndexAssociation.setDeleteRule(stringArray[i]);
                            break;
                        }
                    }
                }
            } else {
                FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = (Index)table2.getPK();
                if (index != null) {
                    FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                    this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                    if (string3 != null) {
                        fKIndexAssociation.setName(string3);
                        fKIndexAssociation.getLocalFKIndex().setName(string3);
                    }
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                    } else {
                        this.fixFKColumns(fKIndexAssociation, arrayList, index);
                    }
                    boolean bl3 = Token.hasToken(string, "DELETE");
                    if (bl3) {
                        String string11 = Token.getTokenAfter(string, "DELETE");
                        if (string11.equalsIgnoreCase("NO")) {
                            if (Token.getTokenAfter(string, "NO").equalsIgnoreCase("ACTION")) {
                                string11 = "NO ACTION";
                            }
                        } else if (string11.equalsIgnoreCase("SET") && Token.getTokenAfter(string, "SET").equalsIgnoreCase("NULL")) {
                            string11 = "SET NULL";
                        }
                        String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!string11.equalsIgnoreCase(stringArray[i])) continue;
                            fKIndexAssociation.setDeleteRule(stringArray[i]);
                            break;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            string2 = Token.removeQuotes(string2);
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private String getNameFor(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            if (column.isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            Column column2 = (Column)index2.getElements()[n];
            fKIndexAssociation.swapAndRemoveFKColumn(column2, column, columnArray[n]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    Column getColumnByName(Table table, String string) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getName().equalsIgnoreCase(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    private boolean processRefAtColumn(RefAtColNode refAtColNode, Table table) {
        String string = this.getNameFor(refAtColNode.referencedTable);
        Table table2 = null;
        try {
            table2 = this.getReferencedTable(string);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
        if (table2 != null) {
            Index index;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (refAtColNode.refColumn != null) {
                arrayList.add(refAtColNode.refColumn);
                index = this.getUniqueIndexForColumnNames(table2, arrayList);
            } else {
                index = (Index)table2.getPK();
            }
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (refAtColNode.constraintName != null) {
                    fKIndexAssociation.setName(refAtColNode.constraintName);
                    fKIndexAssociation.getLocalFKIndex().setName(refAtColNode.constraintName);
                }
                ArrayList<Column> arrayList2 = new ArrayList<Column>();
                Column column = this.getColumnByName(table, refAtColNode.columnName);
                if (column != null) {
                    arrayList2.add(column);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fKIndexAssociation, arrayList2, index);
                    } else {
                        this.fixFKColumns(fKIndexAssociation, arrayList2, index);
                    }
                    if (refAtColNode.onDelete != null) {
                        String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!refAtColNode.onDelete.equalsIgnoreCase(stringArray[i])) continue;
                            fKIndexAssociation.setDeleteRule(stringArray[i]);
                            break;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void processLocalForeignKeys() {
        Object object;
        int n;
        for (n = this.fkList.size() - 1; n >= 0; --n) {
            object = (String)this.fkList.get(n);
            if (!this.addForeignKey((String)object, this.table)) continue;
            this.fkList.remove(n);
        }
        for (n = this.refAtColumnList.size() - 1; n >= 0; --n) {
            object = (RefAtColNode)this.refAtColumnList.get(n);
            if (!this.processRefAtColumn((RefAtColNode)object, this.table)) continue;
            this.refAtColumnList.remove(n);
        }
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode fKRefNode : this.tableNodeList) {
            Object object2;
            for (Object object2 : fKRefNode.fkStatements) {
                this.addForeignKey((String)object2, fKRefNode.processedTable);
            }
            object2 = fKRefNode.refAtColumns.iterator();
            while (object2.hasNext()) {
                this.processRefAtColumn((RefAtColNode)object2.next(), fKRefNode.processedTable);
            }
        }
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String constraintName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

