/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.RoleOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RoleOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRoleOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateRoleOraclev10g.class);

    public SHCreateRoleOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateRoleOraclev10g.clearCR(string);
        if (Token.startsWithString(string2, "create role")) {
            try {
                this.parseRole(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateRoleOraclev10g.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseRole(String string) {
        RoleOraclev10g roleOraclev10g;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOraclev10g storageDesignOraclev10g = (StorageDesignOraclev10g)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOraclev10g != null && (roleOraclev10g = (RoleOraclev10g)storageDesignOraclev10g.getRoleSet().createRole()) != null) {
            this.initName(roleOraclev10g);
            this.initIdentified(roleOraclev10g);
            this.design.getRelationalDesign().stampModelObjectDDL(roleOraclev10g);
        }
    }

    private void initName(RoleOraclev10g roleOraclev10g) {
        String string = Token.getQuotedNameAfterToken(this.statement, "ROLE").trim();
        roleOraclev10g.setName(string);
    }

    private void initIdentified(RoleOraclev10g roleOraclev10g) {
        if (Token.hasToken(this.statement, "NOT")) {
            roleOraclev10g.setIdentified("NO");
        } else {
            roleOraclev10g.setIdentified("YES");
            String string = Token.getTokenAfter(this.statement, "IDENTIFIED").trim();
            if ("BY".equalsIgnoreCase(string)) {
                String string2 = Token.getTokenAfter(this.statement, "BY").trim();
                roleOraclev10g.setAuthType(RoleOraclev9i.getAuthTypes()[0]);
                roleOraclev10g.encodePassword(string2);
            } else if ("USING".equalsIgnoreCase(string)) {
                roleOraclev10g.setAuthType(RoleOraclev9i.getAuthTypes()[3]);
                String string3 = Token.getStringAfter(this.statement, "USING").trim();
                int n = string3.indexOf(".");
                if (n != -1) {
                    roleOraclev10g.setSchema(string3.substring(0, n));
                    roleOraclev10g.setPack(string3.substring(n + 2));
                } else {
                    roleOraclev10g.setPack(string3);
                }
            } else {
                roleOraclev10g.setAuthType(string);
            }
        }
    }
}

