/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataBaseOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.RedoLogGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UndoTablespaceOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseOraclev10g
extends DDLStatementHandler {
    private DataBaseOraclev10g database;
    private StorageDesignOraclev10g stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateDatabaseOraclev10g.class);

    public SHCreateDatabaseOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateDatabaseOraclev10g.clearCR(string);
        if (Token.startsWithString(string2, "create database")) {
            try {
                this.parseDatabase(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateDatabaseOraclev10g.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseDatabase(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(rDBMSSite);
        if (this.stoDesign != null) {
            this.database = (DataBaseOraclev10g)this.stoDesign.getDataBaseSet().createDataBase();
            if (this.database != null) {
                String string2 = this.initDatabaseName();
                this.database.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(this.database);
                this.initUserSysPass();
                this.initUserSystemPass();
                this.initControlFileReuse();
                this.initLogFiles();
                this.initMaxLogFiles();
                this.initMaxLogHistory();
                this.initMaxDataFiles();
                this.initMaxInstances();
                this.initArchiveLog();
                this.initForceLogging();
                this.initCharacterSet();
                this.initNationalCharacterSet();
                this.initDataFiles();
                this.initSysAuxDatafiles();
                this.initTempTablespace();
                this.initUndoTablespace();
                this.initTimeZone();
            }
        }
    }

    private void initUserSysPass() {
        if (this.statement.toUpperCase().indexOf("USER SYS IDENTIFIED BY") > -1) {
            this.database.setPassForSYS(Token.getTokenAfter(this.statement, "USER SYS IDENTIFIED BY"));
        }
    }

    private void initUserSystemPass() {
        if (this.statement.toUpperCase().indexOf("USER SYSTEM IDENTIFIED BY") > -1) {
            this.database.setPassForSYSTEM(Token.getTokenAfter(this.statement, "USER SYSTEM IDENTIFIED BY"));
        }
    }

    private String initDatabaseName() {
        return Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
    }

    private void initControlFileReuse() {
        if (Token.hasToken(this.statement, "CONTROLFILE")) {
            this.database.setControlFileReuse("YES");
        }
    }

    private void initLogFiles() {
        if (Token.hasToken(this.statement, "LOGFILE")) {
            String[] stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String string = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "LOGFILE"), stringArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                RedoLogGroupOraclev10g redoLogGroupOraclev10g = this.initRedoLogGroup(string2);
                redoLogGroupOraclev10g.setDataBase(this.database);
            }
        }
    }

    private void initMaxLogFiles() {
        if (Token.hasToken(this.statement, "MAXLOGFILES")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXLOGFILES"));
                this.database.setMaxLogFiles(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateDatabaseOraclev10g.initMaxLogFiles : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong MAXLOGFILES format in statement " + this.statement);
            }
        }
    }

    private void initMaxLogHistory() {
        if (Token.hasToken(this.statement, "MAXLOGHISTORY")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXLOGHISTORY"));
                this.database.setMaxLogHistory(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateDatabaseOraclev10g.initMaxLogHistory : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong MAXLOGHISTORY format in statement " + this.statement);
            }
        }
    }

    private void initMaxDataFiles() {
        if (Token.hasToken(this.statement, "MAXDATAFILES")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXDATAFILES"));
                this.database.setMaxDataFiles(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateDatabaseOraclev10g.initMaxDataFiles : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong MAXDATAFILES format in statement " + this.statement);
            }
        }
    }

    private void initMaxInstances() {
        if (Token.hasToken(this.statement, "MAXINSTANCES")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(this.statement, "MAXINSTANCES"));
                this.database.setMaxInstances(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateDatabaseOraclev10g.initMaxInstances : " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong MAXINSTANCES format in statement " + this.statement);
            }
        }
    }

    private void initDataFiles() {
        if (Token.hasToken(this.statement, "DATAFILE", "SYSAUX")) {
            String[] stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String string = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE", "SYSAUX"), stringArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                DataFileOraclev10g dataFileOraclev10g = this.initDataFile(string2);
                dataFileOraclev10g.setDataBase(this.database);
            }
        }
    }

    private void initSysAuxDatafiles() {
        if (Token.hasString(this.statement, "SYSAUX DATAFILE")) {
            String[] stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String string = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "SYSAUX DATAFILE"), stringArray);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                DataFileOraclev10g dataFileOraclev10g = this.initDataFile(string2);
                dataFileOraclev10g.setDbForSysAuxFiles(this.database);
            }
        }
    }

    private void initArchiveLog() {
        if (Token.hasToken(this.statement, "ARCHIVELOG")) {
            this.database.setArchiveLog("YES");
        } else {
            this.database.setArchiveLog("NO");
        }
    }

    private void initForceLogging() {
        if (this.statement.toUpperCase().indexOf("FORCE LOGGING") > -1) {
            this.database.setForceLogging("YES");
        }
    }

    private void initCharacterSet() {
        if (Token.hasToken(this.statement, "CHARACTER") && !"NATIONAL".equalsIgnoreCase(Token.getTokenBefore(this.statement, "CHARACTER"))) {
            String string = Token.getTokenAfter(this.statement, "SET").trim();
            this.database.setCharacterSet(string);
        }
    }

    private void initNationalCharacterSet() {
        if (Token.hasToken(this.statement, "NATIONAL")) {
            String string = Token.getStringAfter(this.statement, "NATIONAL");
            String string2 = Token.getTokenAfter(string, "SET").trim();
            this.database.setNationalCharacterSet(string2);
        }
    }

    private void initTempTablespace() {
        if (this.statement.toUpperCase().indexOf("DEFAULT TEMPORARY TABLESPACE") > -1) {
            String string = Token.getQuotedNameAfterToken(this.statement, "DEFAULT TEMPORARY TABLESPACE");
            if (this.stoDesign.getTemporaryTablespaceSet().getByName(string) != null) {
                String[] stringArray;
                TemporaryTablespaceOraclev10g temporaryTablespaceOraclev10g = (TemporaryTablespaceOraclev10g)this.stoDesign.getTemporaryTablespaceSet().createTemporaryTablespace();
                temporaryTablespaceOraclev10g.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(temporaryTablespaceOraclev10g);
                this.database.setTempTablespace(temporaryTablespaceOraclev10g);
                if (Token.hasToken(this.statement, "TEMPFILE")) {
                    stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
                    String string2 = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), stringArray);
                    string2 = Token.getName(string2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        DataFileOraclev10g dataFileOraclev10g = this.initDataFile(string3);
                        dataFileOraclev10g.setTemporaryTablespace(temporaryTablespaceOraclev10g);
                    }
                }
                if (Token.hasToken(this.statement, "UNIFORM")) {
                    stringArray = Token.getStringAfterToken(this.statement, "UNIFORM");
                    stringArray = this.getNumberOnly(Token.getTokenAfter((String)stringArray, "SIZE").trim());
                    try {
                        temporaryTablespaceOraclev10g.setUniformSize(Long.parseLong((String)stringArray));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("wrong format in SHCreateDatabaseOraclev10g.initExtManagement : " + numberFormatException.getMessage());
                        this.importLog.addWarning("Wrong UNIFORM format in statement " + this.statement);
                    }
                }
            }
        }
    }

    private DataFileOraclev10g initDataFile(String string) {
        if (!"".equalsIgnoreCase(string)) {
            String string2;
            String string3;
            DataFileOraclev10g dataFileOraclev10g = (DataFileOraclev10g)this.stoDesign.getDataFileSet().createDataFile();
            this.design.getRelationalDesign().stampModelObjectDDL(dataFileOraclev10g);
            String string4 = Token.getValBetweenQuotes(string);
            dataFileOraclev10g.setFileName(string4);
            if (Token.hasToken(string, "SIZE")) {
                string3 = Token.getTokenAfter(string, "SIZE").trim();
                try {
                    long l = Long.parseLong(this.getNumberOnly(string3));
                    dataFileOraclev10g.setSize(l);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateDatabaseOraclev10g.initDataFile!", numberFormatException);
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                }
                string2 = this.getMeasureUnit(string3, string);
                dataFileOraclev10g.setMeasureUnit(string2);
            }
            if (Token.hasToken(string, "REUSE")) {
                dataFileOraclev10g.setReuse("YES");
            } else {
                dataFileOraclev10g.setReuse("NO");
            }
            if (Token.hasToken(string, "AUTOEXTEND")) {
                string3 = Token.getTokenAfter(string, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(string3)) {
                    dataFileOraclev10g.setAutoextend("ON");
                    if (Token.hasToken(string, "NEXT")) {
                        string2 = Token.getTokenAfter(string, "NEXT").trim();
                        try {
                            int n = Integer.parseInt(this.getNumberOnly(string2));
                            dataFileOraclev10g.setNextBlockSize(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("wrong format in SHCreateDatabaseOraclev10g.initDataFile!", numberFormatException);
                            this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                        }
                    }
                    if (Token.hasToken(string, "MAXSIZE")) {
                        dataFileOraclev10g.setMaxSize(this.getNumberOnly(Token.getTokenAfter(string, "MAXSIZE").trim()));
                    }
                } else if ("OFF".equalsIgnoreCase(string3)) {
                    dataFileOraclev10g.setAutoextend("OFF");
                }
            }
            return dataFileOraclev10g;
        }
        return null;
    }

    private RedoLogGroupOraclev10g initRedoLogGroup(String string) {
        if (!"".equalsIgnoreCase(string)) {
            RedoLogGroupOraclev10g redoLogGroupOraclev10g = (RedoLogGroupOraclev10g)this.stoDesign.getRedoLogGroupSet().createRedoLogGroup();
            this.design.getRelationalDesign().stampModelObjectDDL(redoLogGroupOraclev10g);
            String string2 = Token.getValBetweenQuotes(string);
            redoLogGroupOraclev10g.setFileName(string2);
            if (Token.hasToken(string, "SIZE")) {
                String string3 = Token.getTokenAfter(string, "SIZE").trim();
                try {
                    int n = Integer.parseInt(this.getNumberOnly(string3));
                    redoLogGroupOraclev10g.setSize(n);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateDatabaseOraclev10g.initRedoLogGroup!", numberFormatException);
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                }
                String string4 = this.getMeasureUnit(string3, string);
                redoLogGroupOraclev10g.setMeasureUnit(string4);
            }
            if (Token.hasToken(string, "REUSE")) {
                redoLogGroupOraclev10g.setReuse("YES");
            } else {
                redoLogGroupOraclev10g.setReuse("NO");
            }
            return redoLogGroupOraclev10g;
        }
        return null;
    }

    private String getMeasureUnit(String string, String string2) {
        String string3 = string.toUpperCase();
        if (string3.endsWith("K") || string3.endsWith("M") || string3.endsWith("G") || string3.endsWith("T") || string3.endsWith("P") || string3.endsWith("E")) {
            return string3.substring(string3.length() - 1);
        }
        string3 = Token.getTokenAfter(string2, string).toUpperCase();
        if (string3.equals("K") || string3.equals("M") || string3.equals("G") || string3.equals("T") || string3.equals("P") || string3.equals("E")) {
            return string3;
        }
        return "";
    }

    private String getNumberOnly(String string) {
        String string2 = string.toUpperCase();
        if (string2.endsWith("K") || string2.endsWith("M") || string2.endsWith("G") || string2.endsWith("T") || string2.endsWith("P") || string2.endsWith("E")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void initUndoTablespace() {
        if (this.statement.toUpperCase().indexOf("UNDO TABLESPACE") > -1) {
            String string = Token.getQuotedNameAfterToken(this.statement, "UNDO TABLESPACE");
            if (this.stoDesign.getUndoTablespaceSet().getByName(string) != null) {
                UndoTablespaceOraclev10g undoTablespaceOraclev10g = (UndoTablespaceOraclev10g)this.stoDesign.getUndoTablespaceSet().createTablespace();
                undoTablespaceOraclev10g.setName(string);
                this.database.setUndoTablespace(undoTablespaceOraclev10g);
                this.design.getRelationalDesign().stampModelObjectDDL(undoTablespaceOraclev10g);
                if (Token.getTokenAfter(this.statement, string).equalsIgnoreCase("DATAFILE")) {
                    String string2 = Token.getStringAfterToken(this.statement, string);
                    string2 = Token.cutFirstToken(string2);
                    String[] stringArray = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
                    String string3 = Token.getStringToFirstMatch(string2, stringArray);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        DataFileOraclev10g dataFileOraclev10g = this.initDataFile(string4);
                        dataFileOraclev10g.setUndoTablespace(undoTablespaceOraclev10g);
                    }
                }
            }
        }
    }

    private void initTimeZone() {
        if (Token.hasToken(this.statement, "TIME_ZONE")) {
            String string = Token.getStringAfterToken(this.statement, "TIME_ZONE");
            if ((string = Token.cutFirstToken(string)).startsWith("'")) {
                this.database.setTimeZone(Token.getValBetweenQuotationMarks(string));
            }
        }
    }
}

