/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.CollectionTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateCollectionTypeOraclev10g
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateCollectionTypeOraclev10g.class);
    private StorageDesignOracle storageDesign;

    public SHCreateCollectionTypeOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        this.statement = SHCreateCollectionTypeOraclev10g.clearCR(string);
        if ((Token.startsWithString(this.statement, "CREATE TYPE") && !Token.startsWithString(this.statement, "CREATE TYPE BODY") || Token.startsWithString(this.statement, "CREATE OR REPLACE TYPE") && !Token.startsWithString(this.statement, "CREATE OR REPLACE TYPE BODY")) && (Token.hasString(this.statement.toUpperCase(), " VARRAY ") || Token.hasString(this.statement.toUpperCase(), " VARRAY(") || Token.hasString(this.statement.toUpperCase(), " VARYING ARRAY") || Token.hasString(this.statement.toUpperCase(), " TABLE OF "))) {
            try {
                RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
                this.parseType(this.statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + this.statement + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateCollectionTypeOraclev10g.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseType(String string) {
        if (this.storageDesign != null) {
            String string2 = Token.getNameAfterToken(this.statement, "TYPE", '\"', '\"').trim();
            int n = string2.indexOf(46);
            String string3 = null;
            if (n > 0) {
                string3 = Token.getValBeforeCharacter(string2, '.');
                string2 = Token.getValAfterCharacter(string2, '.');
            }
            CollectionType collectionType = this.design.getDataTypesDesign().createCollectionType();
            CollectionTypeProxyOraclev10g collectionTypeProxyOraclev10g = (CollectionTypeProxyOraclev10g)this.storageDesign.getCollectionTypeProxySet().getProxy(collectionType.getObjectID());
            if (string3 != null && collectionTypeProxyOraclev10g != null) {
                UserOraclev10g userOraclev10g = (UserOraclev10g)this.storageDesign.getUserSet().getByName(string3);
                if (userOraclev10g == null) {
                    userOraclev10g = (UserOraclev10g)this.storageDesign.getUserSet().createUser();
                    userOraclev10g.setName(string3);
                    this.design.getRelationalDesign().stampModelObjectDDL(userOraclev10g);
                }
                collectionTypeProxyOraclev10g.setOwner(userOraclev10g);
            }
            collectionType.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(collectionType);
            if (Token.getTokenAfter(string, string2) != null) {
                this.initCollectionType(collectionType);
                this.initDataType(collectionType);
                this.initOid(collectionTypeProxyOraclev10g);
            }
        }
    }

    private void initCollectionType(CollectionType collectionType) {
        String string = this.statement.toUpperCase();
        if (Token.hasString(string, " VARRAY ") || Token.hasString(string, " VARRAY(") || Token.hasString(string, " VARYING ARRAY")) {
            collectionType.setArrayType();
            String string2 = Token.getValBetweenBrackets(this.statement, 1).trim();
            if (!"".equalsIgnoreCase(string2)) {
                try {
                    collectionType.setMaxElement(Integer.parseInt(string2));
                }
                catch (Exception exception) {}
            }
        } else {
            collectionType.setCollectionType();
        }
    }

    private void initDataType(CollectionType collectionType) {
        if (Token.hasToken(this.statement, "OF")) {
            String string;
            String string2 = Token.getStringAfterToken(this.statement, "OF");
            boolean bl = Token.getFirstToken(string2).equalsIgnoreCase("REF");
            if (bl) {
                string2 = Token.cutFirstToken(string2);
            }
            TypeElement typeElement = new TypeElement(collectionType.getDesignPart(), null);
            typeElement.setDesign(collectionType.getDesign());
            typeElement.setParent(collectionType);
            boolean bl2 = Token.hasCloseAndOpenBrackets(string2);
            if (bl2) {
                string = Token.getValBetweenBrackets(string2);
                string2 = Token.getStringBefore(string2, "(");
                int n = string.indexOf(",");
                if (n != -1) {
                    typeElement.setSize("");
                    typeElement.setPrecision(Integer.valueOf(string.substring(0, n).trim()));
                    typeElement.setScale(Integer.valueOf(string.substring(n + 1).trim()));
                } else if (string2.equalsIgnoreCase("NUMBER") || string2.equalsIgnoreCase("DECIMAL")) {
                    typeElement.setSize("");
                    typeElement.setScale(0);
                    typeElement.setPrecision(Integer.valueOf(string.trim()));
                } else {
                    typeElement.setScale(0);
                    typeElement.setPrecision(0);
                    typeElement.setSize(string.trim());
                }
            }
            collectionType.setElementType(typeElement);
            string2 = Token.getFirstName(string2, '\"', '\"');
            string = StandardDatatypeNames.getUsedDatatypeName(string2);
            LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), string);
            if (logicalDatatype != null && !string.equalsIgnoreCase("UNKNOWN")) {
                typeElement.setType(logicalDatatype);
            } else {
                String string3 = "";
                int n = string2.indexOf(46);
                if (n > 0) {
                    string3 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                }
                DesignObject designObject = null;
                if (!string3.equals("") && (designObject = typeElement.getDesign().getDataTypesDesign().getStructuredTypeSet().getBySchemaAndName(string3, string2)) == null) {
                    designObject = typeElement.getDesign().getDataTypesDesign().getCollectionTypeSet().getBySchemaAndName(string3, string2);
                }
                if (designObject == null && (designObject = typeElement.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(string2)) == null) {
                    designObject = typeElement.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(string2);
                }
                if (designObject != null) {
                    typeElement.setType(designObject);
                    if (bl) {
                        typeElement.setReference(true);
                    }
                }
            }
        }
    }

    private void initOid(CollectionTypeProxyOraclev10g collectionTypeProxyOraclev10g) {
        if (Token.hasToken(this.statement, "OID")) {
            String string = Token.getStringAfterToken(this.statement, "OID");
            string = Token.getValBetweenQuotes(string);
            collectionTypeProxyOraclev10g.setGlobalOid(string);
        }
    }
}

