/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateViewOracle
extends DDLStatementHandler
implements StatementsConstants {
    private static final Logger LOGGER = new Logger(SHCreateViewOracle.class);
    private AbstractView view;

    public SHCreateViewOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateViewOracle.clearCR(string);
        if (Token.startsWithString(string2, "CREATE VIEW") || Token.startsWithString(string2, "CREATE OR REPLACE VIEW") || Token.startsWithString(string2, "CREATE FORCE VIEW") || Token.startsWithString(string2, "CREATE NO FORCE VIEW") || Token.startsWithString(string2, "CREATE OR REPLACE FORCE VIEW") || Token.startsWithString(string2, "CREATE OR REPLACE NO FORCE VIEW")) {
            try {
                this.parseView(string2, string);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateViewOracle.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseView(String string, String string2) {
        TableViewProxyOracle tableViewProxyOracle;
        RDBMSSite rDBMSSite;
        StorageDesignOracle storageDesignOracle;
        this.statement = string;
        this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
        String string3 = Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
        int n = string3.indexOf("(");
        if (n > -1) {
            string3 = string3.substring(0, n);
        }
        this.initStructuredType();
        this.initUserDefinedSql(string2);
        if (this.view.getBasedOnStructuredType() == null) {
            this.initCols();
        }
        if ((storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite = this.design.getSelectedRDBMSSite())) != null && (tableViewProxyOracle = (TableViewProxyOracle)storageDesignOracle.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
            tableViewProxyOracle.setNameHasQuotes(this.nameHasQuotes());
            tableViewProxyOracle.setDefinition(string2);
            String string4 = Token.getStringBeforeToken(this.statement, "VIEW").toUpperCase();
            if (string4.endsWith("FORCE") && !string4.endsWith("NO FORCE")) {
                tableViewProxyOracle.setForce("YES");
            }
            String string5 = Token.getStringAfter(this.statement, "WITH");
            this.initCheckOption(tableViewProxyOracle, string5);
            this.initReadOnly(tableViewProxyOracle, string5);
            this.initConstraint(tableViewProxyOracle, string5);
            this.initOwner(tableViewProxyOracle);
        }
        this.view.setName(this.getNameOnly(string3));
        this.design.getRelationalDesign().stampModelObjectDDL(this.view);
    }

    private boolean nameHasQuotes() {
        String string = Token.getStringAfterToken(this.statement, "VIEW");
        return string.startsWith("\"");
    }

    private void initStructuredType() {
        String string = Token.getStringBefore(this.statement, "AS SELECT ");
        String string2 = Token.getNameAfterToken(string, "OF", '\"', '\"');
        if (!string2.equals("")) {
            Object object;
            ModelIDObject modelIDObject;
            Object object2;
            Object object3;
            StructuredType structuredType;
            int n = string2.indexOf(46);
            if (n > 0) {
                string2 = Token.getValAfterCharacter(string2, '.');
            }
            if ((structuredType = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(string2)) != null) {
                this.view.setBasedOnStructuredType(structuredType);
            } else {
                LOGGER.error("Unable to find required Structured Type: " + string2);
            }
            if (Token.hasToken(string, "UNDER")) {
                object3 = "";
                object2 = Token.getNameAfterToken(string, "UNDER", '\"', '\"');
                n = ((String)object2).indexOf(46);
                if (n > 0) {
                    object3 = ((String)object2).substring(0, n);
                    object2 = Token.getValAfterCharacter((String)object2, '.');
                }
                modelIDObject = null;
                if (!"".equals(object3)) {
                    modelIDObject = (AbstractView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName((String)object3, (String)object2);
                }
                if (modelIDObject == null) {
                    modelIDObject = (AbstractView)this.design.getRelationalDesign().getTableViewSet().getByName((String)object2);
                }
                if (modelIDObject != null) {
                    object = (ContainerView)((MultiShapedDesignObject)modelIDObject).getTopView();
                    ContainerView containerView = (ContainerView)this.view.getTopView();
                    if (object != null && containerView != null) {
                        TypeSubstitution typeSubstitution = this.design.getRelationalDesign().createTypeSubstitution();
                        this.design.getRelationalDesign().stampModelObjectDDL(typeSubstitution);
                        typeSubstitution.setChildCV(containerView);
                        typeSubstitution.setParentCV((ContainerView)object);
                        typeSubstitution.addToAllDPVs();
                    }
                }
            }
            if (Token.hasString(string, "WITH OBJECT IDENTIFIER") && (object2 = (StorageDesignOracle)this.design.getStorageDesign((RDBMSSite)(object3 = this.design.getSelectedRDBMSSite()))) != null && (modelIDObject = (TableViewProxyOracle)((StorageDesign)object2).getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                object = Token.getStringAfter(string, "WITH OBJECT IDENTIFIER");
                if (((String)object).toUpperCase().startsWith("DEFAULT")) {
                    ((TableViewProxyOracle)modelIDObject).setUseOID("DEFAULT");
                } else {
                    ((TableViewProxyOracle)modelIDObject).setUseOID("LIST OF ATTRIBUTES");
                    object = Token.getValBetweenBrackets((String)object);
                    object = ((String)object).replaceAll("\"", "");
                    ((TableViewProxyOracle)modelIDObject).setOidAttributes((String)object);
                }
            }
        }
    }

    private void initCheckOption(TableViewProxyOracle tableViewProxyOracle, String string) {
        if (string.toUpperCase().indexOf("CHECK OPTION") > -1) {
            tableViewProxyOracle.setCheckOption(true);
        } else {
            tableViewProxyOracle.setCheckOption(false);
        }
    }

    private void initReadOnly(TableViewProxyOracle tableViewProxyOracle, String string) {
        if (string.toUpperCase().indexOf("READ ONLY") > -1) {
            tableViewProxyOracle.setReadOnly("YES");
        } else {
            tableViewProxyOracle.setReadOnly("NO");
        }
    }

    private void initConstraint(TableViewProxyOracle tableViewProxyOracle, String string) {
        if (string.toUpperCase().indexOf("CONSTRAINT") > -1) {
            tableViewProxyOracle.setCheckOptionName(Token.getStringAfterToken(string, "CONSTRAINT"));
        }
    }

    private void initUserDefinedSql(String string) {
        this.view.setUserDefinedSQL(string);
        this.view.setUserDefined(true);
    }

    public void initCols() {
        String string;
        Object object;
        String string2;
        ArrayList<String> arrayList = null;
        this.statement = this.removeClosingBrackets(this.statement);
        String string3 = Token.getStringBefore(this.statement, "AS SELECT ");
        if (!Token.hasToken(string3, "OF") && Token.hasCloseAndOpenBrackets(string3) && !"".equalsIgnoreCase(string2 = Token.getValBetweenBrackets(string3, 1))) {
            arrayList = new ArrayList<String>();
            object = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken().trim();
                string = string4.toUpperCase();
                if (string.startsWith("CONSTRAINT ") || string.startsWith("UNIQUE ") || string.startsWith("PRIMARY ") || string.startsWith("FOREIGN ") || string.startsWith("CHECK ")) continue;
                arrayList.add(Token.getFirstName(string4, '\"', '\"'));
            }
        }
        if ((string2 = Token.getStringAfter(this.statement, "AS SELECT").trim()).equalsIgnoreCase("") && !this.isAsSelectOnly()) {
            string2 = Token.getStringAfter(this.statement, "SELECT").trim();
        }
        if (!string2.equals("")) {
            String string5;
            String string6;
            Object object2;
            object = "";
            if (Token.hasToken(string2, "FROM")) {
                int n = string2.toUpperCase().indexOf(" FROM ");
                string = string2.substring(0, n);
                object = string2.substring(n + 6);
                while (Token.tokenNumber(string, "(") > Token.tokenNumber(string, ")") && (n = string2.toUpperCase().indexOf(" FROM ", n + 1)) > -1) {
                    string = string2.substring(0, n);
                    object = string2.substring(n + 6);
                }
                string2 = string;
            }
            if (Token.hasToken((String)object, "WHERE")) {
                object = Token.getStringBeforeToken((String)object, "WHERE");
            }
            String[] stringArray = new String[]{"CONNECT", "START", "GROUP", "HAVING", "MODEL", "UNION", "INTERSECT", "MINUS", "ORDER"};
            string = Token.getStringToFirstMatch(((String)object).toUpperCase(), stringArray);
            object = ((String)object).substring(0, string.length());
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object2 = null;
                string6 = stringTokenizer.nextToken();
                string5 = Token.getFirstName(string6, '\"', '\"');
                String string7 = "";
                int n = string5.indexOf(46);
                if (n > -1) {
                    string7 = string5.substring(0, n);
                    string7 = Token.removeQuotes(string7);
                    string5 = string5.substring(n + 1);
                }
                string5 = Token.removeQuotes(string5);
                if (!"".equals(string7) && (object2 = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string7, string5)) == null) {
                    object2 = (TableView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(string7, string5);
                }
                if (object2 == null && (object2 = (Table)this.design.getRelationalDesign().getTableSet().getByName(string5)) == null) {
                    object2 = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string5);
                }
                if (object2 == null) continue;
                String string8 = "";
                int n2 = string6.indexOf(string5);
                if (n2 > -1) {
                    String string9 = string6.substring(n2 + string5.length());
                    if (string9.startsWith("\"")) {
                        string9 = string9.substring(1);
                    }
                    string8 = Token.getFirstName(string9, '\"', '\"');
                }
                if (string8.equals("")) {
                    string8 = string5;
                }
                this.view.addToContainers((ContainerObject)object2, string8);
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("ALL")) {
                string2 = Token.getStringAfterToken(string2, "ALL").trim();
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("DISTINCT")) {
                string2 = Token.getStringAfterToken(string2, "DISTINCT").trim();
            }
            if (Token.getFirstToken(string2).equalsIgnoreCase("UNIQUE")) {
                string2 = Token.getStringAfterToken(string2, "UNIQUE").trim();
            }
            object2 = new StringTokenizer(string2, ",");
            string6 = null;
            string5 = null;
            int n = 0;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                Object object3;
                Object object4;
                int n3;
                string6 = ((StringTokenizer)object2).nextToken().trim();
                string5 = null;
                StringBuffer stringBuffer = new StringBuffer(string6);
                while (((StringTokenizer)object2).hasMoreTokens() && Token.tokenNumber(string6, "(") > Token.tokenNumber(string6, ")")) {
                    stringBuffer.append(",").append(((StringTokenizer)object2).nextToken().trim());
                    string6 = stringBuffer.toString().trim();
                }
                boolean bl = false;
                if (!string6.endsWith("*") && (Token.hasCloseAndOpenBrackets(string6) || string6.indexOf(43) > -1 || string6.indexOf(45) > -1 || string6.indexOf(42) > -1 || string6.indexOf(47) > -1 || string6.indexOf("||") > -1 || Token.hasToken(string6, "PRIOR"))) {
                    bl = true;
                }
                if (Token.hasToken(string6, "AS")) {
                    string5 = Token.getNameAfterToken(string6, "AS", '\"', '\"');
                    string6 = Token.getStringBeforeToken(string6, "AS");
                    string6 = Token.encodeQuotedString(string6);
                } else if (!((string6 = Token.encodeQuotedString(string6)).indexOf(32) <= -1 || arrayList != null && bl)) {
                    if (string6.charAt(string6.length() - 1) == '\"') {
                        string5 = string6.substring(0, string6.length() - 1);
                        int n4 = string5.lastIndexOf(34);
                        string5 = string5.substring(n4) + "\"";
                        string6 = string6.substring(0, n4 - 1);
                    } else {
                        String string10 = Token.getLastToken(string6);
                        if (string10.indexOf(41) == -1 && !string10.equalsIgnoreCase("END")) {
                            string5 = string10;
                            string6 = string6.substring(0, string6.lastIndexOf(string10)).trim();
                        }
                    }
                }
                String string11 = "";
                if (!bl && (n3 = string6.lastIndexOf(46)) > -1) {
                    string11 = string6.substring(0, n3);
                    int n5 = string11.lastIndexOf(46);
                    if (n5 > -1) {
                        string11 = string11.substring(n5 + 1);
                    }
                    string11 = Token.removeQuotes(Token.decodeQuotedString(string11)).trim();
                    string6 = string6.substring(n3 + 1);
                }
                if ((string6 = Token.removeQuotes(Token.decodeQuotedString(string6))).equalsIgnoreCase("*")) {
                    for (AbstractView.ContainerHolder containerHolder : this.view.getUsedContainers()) {
                        ColumnView columnView;
                        Object object5 = containerHolder.getAlias();
                        if (!string11.equals("") && !string11.equalsIgnoreCase((String)object5)) continue;
                        object4 = containerHolder.getContainer();
                        if (object4 instanceof Table) {
                            object3 = ((ContainerObject)object4).getElementsCollection().iterator();
                            while (object3.hasNext()) {
                                Column column = (Column)object3.next();
                                columnView = new ColumnView(this.view.getDesignPart());
                                columnView.setReferencedColumn(column);
                                columnView.setName(column.getName());
                                columnView.setDesign(this.design);
                                columnView.setTable((Table)object4);
                                columnView.setTableAlias((String)object5);
                                columnView.setDataType(column.getDataType().toString());
                                columnView.setContainer(this.view);
                                this.view.add(columnView);
                                ++n;
                            }
                            continue;
                        }
                        if (!(object4 instanceof TableView)) continue;
                        object3 = ((TableView)object4).getColumns();
                        for (int i = 0; i < ((ContainedObject[])object3).length; ++i) {
                            columnView = (ColumnView)object3[i];
                            ColumnView columnView2 = new ColumnView(this.view.getDesignPart());
                            columnView2.setReferencedColumnView(columnView);
                            columnView2.setName(columnView.getName());
                            columnView2.setDesign(this.design);
                            columnView2.setView((TableView)object4);
                            columnView2.setTableAlias((String)object5);
                            columnView2.setDataType(columnView.getDataType());
                            columnView2.setContainer(this.view);
                            this.view.add(columnView2);
                            ++n;
                        }
                    }
                    continue;
                }
                if (string6.equalsIgnoreCase("")) continue;
                AbstractViewElement abstractViewElement = this.view.createViewElement(this.view.getDesignPart());
                abstractViewElement.setDesign(this.design);
                abstractViewElement.setExpression(string6);
                abstractViewElement.setContainer(this.view);
                this.design.getRelationalDesign().stampModelObjectDDL(abstractViewElement);
                this.view.add(abstractViewElement);
                if (!bl) {
                    for (Object object5 : this.view.getUsedContainers()) {
                        ContainedObject containedObject;
                        object4 = ((AbstractView.ContainerHolder)object5).getAlias();
                        if (!string11.equals("") && !string11.equalsIgnoreCase((String)object4) || (containedObject = ((ContainerObject)(object3 = ((AbstractView.ContainerHolder)object5).getContainer())).getElementByName(string6)) == null) continue;
                        if (containedObject instanceof Column) {
                            abstractViewElement.setReferencedColumn((Column)containedObject);
                            abstractViewElement.setTable((Table)object3);
                            break;
                        }
                        if (!(containedObject instanceof ColumnView)) break;
                        abstractViewElement.setReferencedColumnView(containedObject);
                        abstractViewElement.setView((TableView)object3);
                        break;
                    }
                }
                if (arrayList != null && n < arrayList.size()) {
                    string5 = (String)arrayList.get(n);
                }
                if (string5 != null) {
                    string5 = Token.removeQuotes(Token.decodeQuotedString(string5));
                    abstractViewElement.setName(string5);
                    abstractViewElement.setAlias(string5);
                } else {
                    abstractViewElement.setName(string6);
                    abstractViewElement.setAlias(string6);
                    abstractViewElement.setTableAlias(string11);
                }
                ++n;
            }
        }
    }

    private void initOwner(TableViewProxyOracle tableViewProxyOracle) {
        String string = Token.getValBeforeCharacter(Token.getQuotedNameAfterToken(this.statement, "VIEW").trim(), '.');
        if (string != null && !"".equals(string.trim())) {
            SchemaObjectSet schemaObjectSet;
            SchemaObject schemaObject;
            UserOracle userOracle = (UserOracle)((StorageDesignOracle)tableViewProxyOracle.getStorageDesign()).getUserSet().getByName(string);
            if (userOracle == null) {
                userOracle = (UserOracle)((StorageDesignOracle)tableViewProxyOracle.getStorageDesign()).getUserSet().createElement(null);
                userOracle.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(userOracle);
            }
            if ((schemaObject = (SchemaObject)(schemaObjectSet = ((RelationalDesign)this.view.getDesignPart()).getSchemaObjectSet()).getByName(string)) == null && !string.trim().equalsIgnoreCase("")) {
                schemaObject = schemaObjectSet.createSchemaObject(null);
                schemaObject.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(schemaObject);
            }
            if (userOracle != null) {
                if (userOracle.getSchemaObject() == null) {
                    userOracle.setSchemaObject(schemaObject);
                }
                if (userOracle.getSchemaObject() != schemaObject) {
                    tableViewProxyOracle.setUser(userOracle);
                }
            }
            this.view.setSchemaObject(schemaObject);
        }
    }

    public void setView(AbstractView abstractView) {
        this.view = abstractView;
    }

    private String removeClosingBrackets(String string) {
        int n = string.toLowerCase().indexOf(" as ");
        String string2 = "";
        String string3 = string;
        if (n > -1) {
            string2 = string.substring(0, n + 4);
            string3 = string.substring(n + 4).trim();
            if (string3.charAt(0) == '(') {
                string3 = Token.getValBetweenBrackets(string3);
            }
            string3 = string2 + string3;
        }
        return string3;
    }
}

