/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateUserOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateUserOracle.class);

    public SHCreateUserOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateUserOracle.clearCR(string);
        if (Token.startsWithString(string2, "create user")) {
            try {
                this.parseUser(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateUserOracle.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseUser(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        boolean bl = false;
        if (storageDesignOracle != null) {
            UserOracle userOracle;
            String string2 = Token.getQuotedNameAfterToken(this.statement, "USER").trim();
            Iterator iterator = storageDesignOracle.getUserSet().iterator();
            while (iterator.hasNext()) {
                userOracle = (UserOracle)iterator.next();
                if (!userOracle.getName().equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl && (userOracle = storageDesignOracle.getUserSet().createUser()) != null) {
                this.initName(userOracle);
                this.initIdentified(userOracle);
                this.initDefTableSpace(userOracle, storageDesignOracle);
                this.initTempTableSpace(userOracle, storageDesignOracle);
                this.initQuotaItems(userOracle, storageDesignOracle);
                this.initProfile(userOracle);
                this.initPasswordExpire(userOracle);
                this.initAccountLock(userOracle);
                this.initSchemaObject(userOracle);
                this.design.getRelationalDesign().stampModelObjectDDL(userOracle);
            }
        }
    }

    private void initName(UserOracle userOracle) {
        String string = Token.getQuotedNameAfterToken(this.statement, "USER").trim();
        userOracle.setName(string);
    }

    private void initIdentified(UserOracle userOracle) {
        if (Token.hasToken(this.statement, "IDENTIFIED")) {
            String string = Token.getTokenAfter(this.statement, "IDENTIFIED").trim();
            if ("BY".equalsIgnoreCase(string)) {
                String string2 = Token.getTokenAfter(this.statement, "BY").trim();
                if ("VALUES".equalsIgnoreCase(string2)) {
                    String string3 = Token.getNameAfterToken(this.statement, "VALUES", '\'', '\'').trim();
                    string2 = string2 + " '" + string3 + "'";
                }
                userOracle.setAuthType(UserOracle.getAuthTypes()[0]);
                userOracle.encodeIdentifier(string2);
            } else if ("GLOBALLY".equalsIgnoreCase(string)) {
                String string4 = Token.getNameAfterToken(this.statement, "AS", '\'', '\'').trim();
                userOracle.setAuthType(UserOracle.getAuthTypes()[2]);
                userOracle.encodeIdentifier("'" + string4 + "'");
            } else {
                userOracle.setAuthType(UserOracle.getAuthTypes()[1]);
            }
        }
    }

    private void initDefTableSpace(UserOracle userOracle, StorageDesignOracle storageDesignOracle) {
        String string;
        if (Token.hasToken(this.statement, "DEFAULT") && Token.getFirstToken(string = Token.getStringAfter(this.statement, "DEFAULT")).equalsIgnoreCase("TABLESPACE")) {
            string = Token.cutFirstToken(string);
            String string2 = Token.getFirstToken(string).trim();
            string2 = Token.getName(string2);
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string2);
            if (tableSpaceOracle != null) {
                userOracle.setDefTableSpace(tableSpaceOracle);
            }
        }
    }

    private void initTempTableSpace(UserOracle userOracle, StorageDesignOracle storageDesignOracle) {
        String string;
        if (Token.hasToken(this.statement, "TEMPORARY") && Token.getFirstToken(string = Token.getStringAfter(this.statement, "TEMPORARY")).equalsIgnoreCase("TABLESPACE")) {
            string = Token.cutFirstToken(string);
            String string2 = Token.getFirstToken(string).trim();
            string2 = Token.getName(string2);
            TemporaryTablespaceOracle temporaryTablespaceOracle = (TemporaryTablespaceOracle)storageDesignOracle.getTemporaryTablespaceSet().getByName(string2);
            if (temporaryTablespaceOracle != null) {
                userOracle.setTempTableSpace(temporaryTablespaceOracle);
            }
        }
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1).trim();
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n *= 1024);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("SHCreateUserOracle.getNumberOnly - Unable to parse value: " + string, numberFormatException);
            }
        }
        return string;
    }

    private void initQuotaItems(UserOracle userOracle, StorageDesignOracle storageDesignOracle) {
        String string = this.statement;
        while (Token.hasToken(string, "QUOTA")) {
            string = Token.getStringAfter(string, "QUOTA");
            QuotaItemOracle quotaItemOracle = storageDesignOracle.getQuotaItemSet().createQuotaItem();
            quotaItemOracle.setUser(userOracle);
            String string2 = this.getNumberOnly(Token.getFirstToken(string).trim());
            quotaItemOracle.setSize(string2);
            String string3 = Token.getTokenAfter(string, "ON").trim();
            string3 = Token.getName(string3);
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)storageDesignOracle.getTableSpaceSet().getByName(string3);
            if (tableSpaceOracle != null) {
                quotaItemOracle.setTableSpace(tableSpaceOracle);
            }
            string = Token.getStringAfter(string, string3);
        }
    }

    private void initProfile(UserOracle userOracle) {
        if (Token.hasToken(this.statement, "PROFILE")) {
            String string = Token.getTokenAfter(this.statement, "PROFILE").trim();
            userOracle.setProfile(string);
        }
    }

    private void initPasswordExpire(UserOracle userOracle) {
        if (Token.hasToken(this.statement, "EXPIRE")) {
            userOracle.setPasswordExpire("YES");
        } else {
            userOracle.setPasswordExpire("NO");
        }
    }

    private void initAccountLock(UserOracle userOracle) {
        if (Token.hasToken(this.statement, "ACCOUNT")) {
            String string = Token.getTokenAfter(this.statement, "ACCOUNT").trim();
            if ("LOCK".equalsIgnoreCase(string)) {
                userOracle.setAccountLock("YES");
            } else {
                userOracle.setAccountLock("NO");
            }
        }
    }

    private void initSchemaObject(UserOracle userOracle) {
        SchemaObject schemaObject;
        boolean bl = false;
        SchemaObjectSet schemaObjectSet = this.design.getRelationalDesign().getSchemaObjectSet();
        Iterator iterator = schemaObjectSet.iterator();
        while (iterator.hasNext()) {
            schemaObject = (SchemaObject)iterator.next();
            if (!schemaObject.getName().equals(userOracle.getName())) continue;
            userOracle.setSchemaObject(schemaObject);
            bl = true;
            break;
        }
        if (!bl) {
            schemaObject = schemaObjectSet.createSchemaObject(null);
            schemaObject.setName(userOracle.getName());
            userOracle.setSchemaObject(schemaObject);
            this.design.getRelationalDesign().stampModelObjectDDL(schemaObject);
        }
    }
}

