/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTriggerOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTriggerOracle.class);
    private TriggerOracle trigger;
    private StorageDesignOracle storageDesign;
    private String body = "";

    public SHCreateTriggerOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTriggerOracle.clearCR(string);
        if (Token.startsWithString(string2, "CREATE TRIGGER") || Token.startsWithString(string2, "CREATE OR REPLACE TRIGGER")) {
            this.parseTrigger(string2, string);
        } else {
            this.nextHandler(string);
        }
    }

    private void parseTrigger(String string, String string2) {
        try {
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
            if (this.storageDesign != null) {
                this.trigger = this.storageDesign.getTriggerSet().createTrigger();
                if (this.trigger != null) {
                    string = this.initTriggerName(string);
                    this.initTriggeringTime(string);
                    String string3 = this.initOnTable(string, string2);
                    this.initAction(string);
                    string = this.initReferencing(string3);
                    string = this.initScope(string);
                    this.initCondition(string);
                    this.initBody();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.trigger);
                    this.body = "";
                    this.trigger = null;
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + string + " for Oracle failed!", exception);
            this.importLog.addError("Parsing " + string + " for Oracle failed");
            this.importLog.addFailedStatement(SHCreateTriggerOracle.FormatCR(string2, "\n"));
        }
    }

    private String initTriggerName(String string) {
        String string2 = Token.getStringAfterToken(string, "TRIGGER");
        String string3 = Token.getFirstName(string2, '\"', '\"');
        int n = string3.indexOf(46);
        if (n > -1) {
            String string4 = string3.substring(0, n);
            UserOracle userOracle = (UserOracle)this.storageDesign.getUserSet().getByName(string4);
            if (userOracle != null) {
                this.trigger.setOwner(userOracle);
            }
            string3 = string3.substring(n + 1);
        }
        this.trigger.setName(string3);
        if (n > -1) {
            string2 = string2.substring(string2.indexOf(46) + 1);
        }
        if ((string2 = string2.substring(string2.indexOf(string3) + string3.length())).startsWith("\"")) {
            string2 = string2.substring(1);
        }
        return string2.trim();
    }

    private void initTriggeringTime(String string) {
        String string2 = Token.getFirstToken(string);
        if (string2.equalsIgnoreCase("BEFORE")) {
            this.trigger.setTriggerTime("BEFORE");
        } else if (string2.equalsIgnoreCase("AFTER")) {
            this.trigger.setTriggerTime("AFTER");
        } else if (string2.equalsIgnoreCase("INSTEAD")) {
            this.trigger.setTriggerTime("INSTEAD OF");
        } else {
            this.importLog.addError("Unknown triggering time for trigger " + this.trigger.getName());
        }
    }

    private void initAction(String string) {
        String string2 = this.trigger.getTriggerTime();
        if (string2 != null) {
            String string3 = Token.getStringAfter(string, string2);
            String string4 = Token.getStringBeforeToken(string3, "ON");
            if (Token.hasToken(string4, "INSERT")) {
                this.trigger.setActions("INSERT");
            }
            if (Token.hasToken(string4, "DELETE")) {
                this.trigger.setActions("DELETE");
            }
            if (Token.hasToken(string4, "UPDATE")) {
                this.trigger.setActions("UPDATE");
                String string5 = Token.getStringAfterToken(string4, "UPDATE");
                if (Token.getFirstToken(string5).equalsIgnoreCase("OF")) {
                    String string6 = Token.cutTokenFromFront(string5, "OF");
                    TableProxyOracle tableProxyOracle = this.trigger.getTable();
                    if (tableProxyOracle != null) {
                        String[] stringArray = string6.split(",");
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string7 = Token.getFirstName(stringArray[i], '\"', '\"');
                            ColumnProxy columnProxy = tableProxyOracle.getColumnProxyByName(string7);
                            if (columnProxy == null) continue;
                            this.trigger.setColumns(columnProxy.getObjectID());
                        }
                    }
                }
            }
        }
    }

    private String initOnTable(String string, String string2) throws ParseException {
        String string3 = Token.getStringAfterToken(string, "ON");
        boolean bl = string3.toUpperCase().startsWith("NESTED TABLE");
        if (bl) {
            string3 = Token.getStringAfterToken(string3, "OF");
        }
        String string4 = Token.getFirstName(string3, '\"', '\"');
        String string5 = "";
        int n = string4.indexOf(46);
        if (n > -1) {
            string5 = string4.substring(0, n);
            string4 = string4.substring(n + 1);
        }
        Table table = null;
        TableView tableView = null;
        if (string5 != "") {
            if (!bl) {
                table = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string5, string4);
            }
            if (table == null) {
                tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(string5, string4);
            }
        }
        if (table == null && tableView == null) {
            if (!bl) {
                table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string4);
            }
            if (table == null) {
                tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string4);
            }
        }
        if (table != null) {
            this.trigger.setTable((TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID()));
        } else if (tableView != null) {
            this.trigger.setView((TableViewProxyOracle)this.storageDesign.getTableViewProxySet().getProxy(tableView.getObjectID()));
        } else {
            String string6 = "Specified table or view on trigger " + this.trigger.getName() + " does not exist ";
            if (bl) {
                string6 = "Specified view on trigger " + this.trigger.getName() + " does not exist ";
            }
            this.importLog.addError(string6);
            throw new ParseException(string6);
        }
        string2 = Token.getStringAfter(string2, "TRIGGER");
        String string7 = this.trigger.getTriggerTime();
        if (string7 != null) {
            if (string7.equals("INSTEAD OF")) {
                string7 = "INSTEAD";
            }
            string2 = Token.getStringAfter(string2, string7);
        }
        string2 = Token.getStringAfter(string2, "ON");
        if (bl) {
            string2 = Token.getStringAfter(string2, "OF");
        }
        if (n > -1) {
            string2 = string2.substring(string2.indexOf(46) + 1);
        }
        if ((string2 = string2.substring(string2.indexOf(string4) + string4.length())).startsWith("\"")) {
            string2 = string2.substring(1);
        }
        this.body = string2.trim();
        if (n > -1) {
            string3 = string3.substring(string3.indexOf(46) + 1);
        }
        if ((string3 = string3.substring(string3.indexOf(string4) + string4.length())).startsWith("\"")) {
            string3 = string3.substring(1);
        }
        return string3.trim();
    }

    private String initReferencing(String string) {
        if (Token.hasToken(string, "REFERENCING")) {
            String string2 = Token.getStringAfter(string, "REFERENCING");
            while (true) {
                string = string2;
                String string3 = Token.getFirstToken(string2);
                String string4 = Token.getFirstToken(string2 = Token.cutTokenFromFront(string2, string3));
                boolean bl = string4.equalsIgnoreCase("AS");
                if (bl) {
                    string2 = Token.cutTokenFromFront(string2, "AS");
                    string4 = Token.getFirstToken(string2);
                }
                if (string4.equals("")) break;
                string2 = Token.cutTokenFromFront(string2, string4);
                if (string3.equalsIgnoreCase("OLD")) {
                    this.trigger.setRef_OLD_AS(string4);
                } else if (string3.equalsIgnoreCase("NEW")) {
                    this.trigger.setRef_NEW_AS(string4);
                } else {
                    if (!string3.equalsIgnoreCase("PARENT")) break;
                    this.trigger.setRef_PARENT_AS(string4);
                }
                this.body = Token.getStringAfter(this.body, string3);
                if (bl) {
                    this.body = Token.getStringAfter(this.body, "AS");
                }
                this.body = Token.getStringAfter(this.body, string4);
            }
        }
        return string;
    }

    private String initScope(String string) {
        String string2 = string;
        if (Token.getFirstToken(string2).equalsIgnoreCase("FOR") && Token.getFirstToken(string2 = Token.cutTokenFromFront(string2, "FOR")).equalsIgnoreCase("EACH") && Token.getFirstToken(string2 = Token.cutTokenFromFront(string2, "EACH")).equalsIgnoreCase("ROW")) {
            string2 = Token.cutTokenFromFront(string2, "ROW");
            this.trigger.setScope(TriggerOracle.SCOPE_TYPES[0]);
            this.body = Token.getStringAfter(this.body, "FOR");
            this.body = Token.getStringAfter(this.body, "EACH");
            this.body = Token.getStringAfter(this.body, "ROW");
            return string2;
        }
        this.trigger.setScope(TriggerOracle.SCOPE_TYPES[1]);
        return string;
    }

    private void initCondition(String string) {
        if (Token.getFirstToken(string).equalsIgnoreCase("WHEN")) {
            String string2 = Token.cutTokenFromFront(string, "WHEN");
            this.trigger.setCondition(Token.getValBetweenBrackets(string2, 1).trim());
            this.body = Token.getStringAfter(this.body, "WHEN");
            this.body = Token.getValAfterBrackets(this.body, 1).trim();
        }
    }

    private void initBody() {
        this.trigger.setBody(this.body);
    }
}

