/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.oracle.AggregateFunctionsOracle;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateTableOraclev9i;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSnapshotOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateSnapshotOracle.class);
    private SnapshotOracle snapshot;
    private StorageDesignOraclev9i storageDesign;
    private SHCreateTableOraclev9i shCreateTableOraclev9i = null;
    public static final String FAST = "FAST";
    public static final String COMPLETE = "COMPLETE";
    public static final String NEVER = "NEVER";

    public SHCreateSnapshotOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateSnapshotOracle.clearCR(string);
        if (Token.startsWithString(string2, "create snapshot ") || Token.startsWithString(string2, "create materialized view ")) {
            this.parseSnapshot(string2.replaceAll("\"", ""), string);
        } else {
            this.nextHandler(string);
        }
    }

    private void parseSnapshot(String string, String string2) {
        try {
            this.statement = string;
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(rDBMSSite);
            if (this.storageDesign != null) {
                this.snapshot = this.storageDesign.getSnapshotSet().createSnapshot();
                if (this.snapshot != null) {
                    this.initSnapshotName();
                    this.snapshot.setNameHasQuotes(this.nameHasQuotes());
                    if (Token.hasToken(string, "CLUSTER")) {
                        this.initCluster();
                    } else {
                        this.initSegment();
                    }
                    this.initSnapshotTable();
                    this.initPartitioning();
                    this.initParallelClause();
                    this.initPrebuild();
                    this.initUsingIndex();
                    this.initRefreshClause();
                    this.initForUpdate();
                    this.initQueryRewrite();
                    this.initSubquery(string2);
                    this.design.getRelationalDesign().stampModelObjectDDL(this.snapshot);
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (Exception exception) {
            LOGGER.error(" Parsing " + string + " for Oracle failed!", exception);
            this.importLog.addFailedStatement(string2);
        }
    }

    private boolean nameHasQuotes() {
        String string = Token.getTokenAfter(this.statement, "CREATE").equalsIgnoreCase("SNAPSHOT") ? Token.getStringAfterToken(this.statement, "SNAPSHOT") : Token.getStringAfterToken(this.statement, "VIEW");
        return string.startsWith("\"");
    }

    private void initSnapshotName() {
        String string = Token.getTokenAfter(this.statement, "CREATE").equalsIgnoreCase("SNAPSHOT") ? Token.getQuotedNameAfterToken(this.statement, "SNAPSHOT") : Token.getQuotedNameAfterToken(this.statement, "VIEW");
        int n = string.indexOf(46);
        if (n > -1) {
            String string2 = string.substring(0, n);
            UserOracle userOracle = (UserOracle)this.storageDesign.getUserSet().getByName(string2);
            if (userOracle == null && !string2.trim().equalsIgnoreCase("")) {
                userOracle = this.storageDesign.getUserSet().createUser();
                userOracle.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(userOracle);
            }
            this.snapshot.setUser(userOracle);
            string = string.substring(n + 1);
        }
        this.snapshot.setName(string);
    }

    private void initSegment() {
        SegmentOracle segmentOracle = null;
        if (Token.hasToken(this.statement, "PCTFREE") && (segmentOracle = this.storageDesign.getSegmentSet().createSegment()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(segmentOracle);
            this.initPhysicalAttributesClause(this.statement, segmentOracle);
            SegmentOracle segmentOracle2 = this.storageDesign.getSegmentSet().findEqual(segmentOracle);
            this.snapshot.setSegment(segmentOracle2);
        }
        this.initTableSpace();
        this.initLobStorage();
        this.initLogging();
        this.initCache();
    }

    private void initPhysicalAttributesClause(String string, SegmentOracle segmentOracle) {
        this.initPctFree(string, segmentOracle);
        this.initPctUsed(string, segmentOracle);
        this.initInitrans(string, segmentOracle);
        this.initMaxtrans(string, segmentOracle);
        this.initStorage(string, segmentOracle);
    }

    private void initPctFree(String string, SegmentOracle segmentOracle) {
        if (Token.hasToken(string, "PCTFREE")) {
            String string2 = Token.getTokenAfter(string, "PCTFREE").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOracle.setPCTFree(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPctFree: " + numberFormatException.getMessage());
            }
        }
    }

    private void initPctUsed(String string, SegmentOracle segmentOracle) {
        if (Token.hasToken(string, "PCTUSED")) {
            String string2 = Token.getTokenAfter(string, "PCTUSED").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOracle.setPCTUsed(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPctUsed: " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong PCTUSED format in statement " + this.statement);
            }
        }
    }

    private void initInitrans(String string, SegmentOracle segmentOracle) {
        if (Token.hasToken(string, "INITRANS")) {
            String string2 = Token.getTokenAfter(string, "INITRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOracle.setInitrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initInitrans: " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
            }
        }
    }

    private void initMaxtrans(String string, SegmentOracle segmentOracle) {
        if (Token.hasToken(string, "MAXTRANS")) {
            String string2 = Token.getTokenAfter(string, "MAXTRANS").trim();
            try {
                int n = Integer.parseInt(string2);
                segmentOracle.setMaxTrans(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initMaxtrans: " + numberFormatException.getMessage());
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
            }
        }
    }

    private void initStorage(String string, SegmentOracle segmentOracle) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, segmentOracle, null);
            this.initNext(string2, segmentOracle, null);
            this.initPCtIncrease(string2, segmentOracle, null);
            this.initMinExtents(string2, segmentOracle, null);
            this.initMaxExtents(string2, segmentOracle, null);
            this.initFreeLists(string2, segmentOracle, null);
            this.initFreeListGroups(string2, segmentOracle, null);
            this.initSegBufferPool(string2, segmentOracle, null);
        }
    }

    private void initTableSpace() {
        if (Token.hasToken(this.statement, "TABLESPACE")) {
            String string = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE");
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string);
            if (tableSpaceOracle != null) {
                this.snapshot.setTablespace(tableSpaceOracle);
            }
        }
    }

    private void initLogging() {
        if (Token.hasToken(this.statement, "NOLOGGING")) {
            this.snapshot.setLogging("NO");
        } else if (Token.hasToken(this.statement, "LOGGING")) {
            this.snapshot.setLogging("YES");
        }
    }

    private void initCache() {
        if (Token.hasToken(this.statement, "NOCACHE")) {
            this.snapshot.setCache("NO");
        } else if (Token.hasToken(this.statement, "CACHE")) {
            this.snapshot.setCache("YES");
        }
    }

    private void initLobStorage() {
        if (Token.hasToken(this.statement, "LOB")) {
            LobStorageOracle lobStorageOracle = this.storageDesign.getLobStorageSet().createLobStorage();
            this.design.getRelationalDesign().stampModelObjectDDL(lobStorageOracle);
            this.snapshot.setLobStorage(lobStorageOracle);
            lobStorageOracle.setSnapshot(this.snapshot);
            String string = Token.getStringAfter(this.statement, "LOB");
            String string2 = Token.getValBetweenBrackets(string, 1).replaceAll("\"", "").trim();
            lobStorageOracle.setColumn(string2);
            string = Token.getStringAfter(string, "STORE AS");
            String string3 = Token.getFirstToken(string).trim();
            if (!string3.equalsIgnoreCase("(")) {
                string3 = Token.getName(string3);
                lobStorageOracle.setName(string3);
            }
            String string4 = Token.getValBetweenBrackets(string, 1).trim();
            String string5 = Token.getQuotedNameAfterToken(string4, "TABLESPACE");
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string5);
            if (tableSpaceOracle != null) {
                lobStorageOracle.setTableSpace(tableSpaceOracle);
            }
            this.initLobStorageStorage(string4, lobStorageOracle);
        }
    }

    private void initLobStorageStorage(String string, LobStorageOracle lobStorageOracle) {
        String string2;
        if (Token.hasToken(string, "STORAGE") && Token.getFirstToken(string2 = Token.getStringAfter(string, "STORAGE")).equalsIgnoreCase("(")) {
            string2 = Token.getValBetweenBrackets(string2, 1).trim();
            this.initInitial(string2, null, lobStorageOracle);
            this.initNext(string2, null, lobStorageOracle);
            this.initPCtIncrease(string2, null, lobStorageOracle);
            this.initMinExtents(string2, null, lobStorageOracle);
            this.initMaxExtents(string2, null, lobStorageOracle);
            this.initFreeLists(string2, null, lobStorageOracle);
            this.initFreeListGroups(string2, null, lobStorageOracle);
            this.initSegBufferPool(string2, null, lobStorageOracle);
        }
        this.initChunk(string, lobStorageOracle);
        this.initRetention(string, lobStorageOracle);
        this.initPctVersion(string, lobStorageOracle);
        this.initFreePools(string, lobStorageOracle);
        this.initStorageInRow(string, lobStorageOracle);
        this.initLSCache(string, lobStorageOracle);
        this.initLogging(string, lobStorageOracle);
    }

    private void initChunk(String string, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "CHUNK")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "CHUNK").trim());
                lobStorageOracle.setChunk(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initChunk: ", numberFormatException);
                this.importLog.addWarning("Wrong CHUNK format in statement " + this.statement);
            }
        }
    }

    private void initPctVersion(String string, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "PCTVERSION")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "PCTVERSION").trim());
                lobStorageOracle.setPCTVersion(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPctVersion: ", numberFormatException);
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
            }
        }
    }

    private void initRetention(String string, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "RETENTION")) {
            lobStorageOracle.setOldVersions("RETENTION");
        }
    }

    private void initFreePools(String string, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "FREEPOOLS")) {
            try {
                int n = Integer.parseInt(Token.getTokenAfter(string, "FREEPOOLS").trim());
                lobStorageOracle.setFreepools(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTVERSION format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initFreePools: ", numberFormatException);
            }
        }
    }

    private void initStorageInRow(String string, LobStorageOracle lobStorageOracle) {
        if (Token.hasString(string, "STORAGE IN ROW")) {
            String string2 = Token.getTokenBefore(string, "STORAGE IN ROW");
            lobStorageOracle.setStorageInRow(string2);
        }
    }

    private void initLSCache(String string, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "CACHE")) {
            if (Token.hasString(string.toUpperCase(), "CACHE READS")) {
                lobStorageOracle.setCache("CACHE READS");
            } else {
                lobStorageOracle.setCache("CACHE");
            }
        } else if (Token.hasToken(string, "NOCACHE")) {
            lobStorageOracle.setCache("NOCACHE");
        }
    }

    private void initLogging(String string, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "NOLOGGING")) {
            lobStorageOracle.setLogging("NO");
        } else if (Token.hasToken(string, "LOGGING")) {
            lobStorageOracle.setLogging("YES");
        }
    }

    private void initInitial(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "INITIAL")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "INITIAL").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCInitialExtent(l);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCInitialExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initInitial: ", numberFormatException);
            }
        }
    }

    private void initNext(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "NEXT")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "NEXT").trim());
            try {
                long l = Long.parseLong(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCNextExtent(l);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCNextExtent(l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initNext: ", numberFormatException);
            }
        }
    }

    private void initPCtIncrease(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "PCTINCREASE")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "PCTINCREASE").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCPctIncrease(n);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCPctIncrease(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initPCtIncrease: ", numberFormatException);
            }
        }
    }

    private void initMinExtents(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "MINEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MINEXTENTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCMinExtents(n);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCMinExtents(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initMinExtents: ", numberFormatException);
            }
        }
    }

    private void initMaxExtents(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "MAXEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MAXEXTENTS").trim());
            if (segmentOracle != null) {
                segmentOracle.setSCMaxExtents(string2);
            } else {
                lobStorageOracle.setSCMaxExtents(string2);
            }
        }
    }

    private void initFreeLists(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "FREELISTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "FREELISTS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCFreeLists(n);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCFreeLists(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initFreeLists: ", numberFormatException);
            }
        }
    }

    private void initFreeListGroups(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "GROUPS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "GROUPS").trim());
            try {
                int n = Integer.parseInt(string2);
                if (segmentOracle != null) {
                    segmentOracle.setSCFreelistGroups(n);
                } else if (lobStorageOracle != null) {
                    lobStorageOracle.setSCFreelistGroups(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateSnapshotOracle.initFreeListGroups: ", numberFormatException);
            }
        }
    }

    private void initSegBufferPool(String string, SegmentOracle segmentOracle, LobStorageOracle lobStorageOracle) {
        if (Token.hasToken(string, "BUFFER_POOL")) {
            String string2 = Token.getQuotedNameAfterToken(string, "BUFFER_POOL").trim();
            if (segmentOracle != null) {
                segmentOracle.setSCBufferPool(string2);
            } else if (lobStorageOracle != null) {
                lobStorageOracle.setSCBufferPool(string2);
            }
        }
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1).trim();
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n *= 1024);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("SHCreateSnapshotOracle.getNumberOnly - Unable to parse value: " + string, numberFormatException);
            }
        }
        return string;
    }

    private void initCluster() {
        String string = Token.getQuotedNameAfterToken(this.statement, "CLUSTER");
        string = string.substring(string.lastIndexOf(46) + 1);
        ClusterOraclev9i clusterOraclev9i = (ClusterOraclev9i)this.storageDesign.getClusterSet().getByName(string);
        if (clusterOraclev9i != null) {
            this.snapshot.setCluster(clusterOraclev9i);
            String string2 = Token.getStringAfterToken(this.statement, "CLUSTER");
            string2 = Token.getValBetweenBrackets(string2, 1);
            this.snapshot.setClusterColumns(string2);
        }
    }

    private void initPartitioning() {
        int n = this.statement.toUpperCase().indexOf("PARTITION BY ");
        if (n > -1) {
            String string = this.statement.substring(n);
            if (Token.hasToken(string = Token.getStringBeforeToken(string, "AS"), "USING")) {
                string = Token.getStringBeforeToken(string, "USING");
            }
            if (this.shCreateTableOraclev9i == null) {
                this.shCreateTableOraclev9i = new SHCreateTableOraclev9i(this.design);
            }
            this.shCreateTableOraclev9i.initPartitionsForSnapshotTable(string, (TableProxyOraclev9i)this.snapshot.getImplementedTable());
        }
    }

    private void initParallelClause() {
        if (Token.hasToken(this.statement, "PARALLEL")) {
            this.snapshot.setParalelClause("YES");
        }
    }

    private void initPrebuild() {
        if (Token.hasToken(this.statement, "BUILD")) {
            this.snapshot.setBuild(Token.getTokenAfter(this.statement, "BUILD"));
        } else if (Token.hasString(this.statement.toUpperCase(), "ON PREBUILT TABLE")) {
            TableProxyOracle tableProxyOracle = ((TableProxySetOracle)this.storageDesign.getTableProxySet()).getByName(this.snapshot.getName());
            this.snapshot.setOnPrebuildTable(tableProxyOracle);
            if (Token.hasString(this.statement.toUpperCase(), "WITHOUT REDUCED PRECISION")) {
                this.snapshot.setReducedPrecision("NO");
            }
        }
    }

    private void initUsingIndex() {
        if (Token.hasString(this.statement.toUpperCase(), "USING INDEX")) {
            this.snapshot.setUseIndex("YES");
            int n = this.statement.toUpperCase().indexOf("USING INDEX TABLESPACE");
            if (n > -1) {
                TableSpaceOracle tableSpaceOracle;
                String string = this.statement.substring(n + 22).trim();
                string = Token.getFirstToken(string);
                if (!"".equalsIgnoreCase(string = Token.getName(string)) && (tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getByName(string)) != null) {
                    this.snapshot.setIndexTablespace(tableSpaceOracle);
                }
            } else {
                SegmentOracle segmentOracle = null;
                if (Token.hasToken(this.statement, "PCTFREE") && (segmentOracle = this.storageDesign.getSegmentSet().createSegment()) != null) {
                    this.design.getRelationalDesign().stampModelObjectDDL(segmentOracle);
                    String string = Token.getStringAfter(this.statement, "USING INDEX");
                    this.initPhysicalAttributesClause(string, segmentOracle);
                    SegmentOracle segmentOracle2 = this.storageDesign.getSegmentSet().findEqual(segmentOracle);
                    this.snapshot.setSegment(segmentOracle2);
                }
            }
        } else if (Token.hasString(this.statement.toUpperCase(), "USING NO INDEX")) {
            this.snapshot.setUseIndex("NO");
        }
    }

    private void initRefreshClause() {
        if (Token.hasToken(this.statement, "REFRESH")) {
            if (Token.getTokenBefore(this.statement, "REFRESH").equalsIgnoreCase(NEVER)) {
                this.snapshot.setRefresh(NEVER);
            } else {
                String string;
                this.snapshot.setRefresh("YES");
                String string2 = Token.getStringAfterToken(this.statement, "REFRESH");
                if (Token.hasToken(string2, FAST)) {
                    this.snapshot.setRefreshType(FAST);
                } else if (Token.hasToken(string2, COMPLETE)) {
                    this.snapshot.setRefreshType(COMPLETE);
                } else if (Token.hasToken(string2, "FORCE")) {
                    this.snapshot.setRefreshType("FORCE");
                }
                if (Token.hasString(string2.toUpperCase(), "ON COMMIT")) {
                    this.snapshot.setAction("ON COMMIT");
                } else if (Token.hasString(string2.toUpperCase(), "ON DEMAND")) {
                    this.snapshot.setAction("ON DEMAND");
                }
                if (Token.hasString(string2.toUpperCase(), "NEXT")) {
                    string = string2.substring(string2.toUpperCase().indexOf("NEXT") + 4).trim();
                    string = Token.getFirstToken(string);
                    this.snapshot.setNextDate(string);
                }
                if (Token.hasString(string2.toUpperCase(), "START")) {
                    string = string2.substring(string2.toUpperCase().indexOf("START") + 10).trim();
                    string = Token.getFirstToken(string);
                    this.snapshot.setStartDate(string);
                }
                if (Token.hasString(string2.toUpperCase(), "WITH ROWID")) {
                    this.snapshot.setWith("ROWID");
                }
                if (Token.hasString(string2.toUpperCase(), "USING")) {
                    if (Token.getTokenAfter(string2, "USING").equalsIgnoreCase("DEFAULT")) {
                        this.snapshot.setDefaultSegment("YES");
                    } else {
                        string = Token.getQuotedNameAfterToken(string2, "SEGMENT");
                        RollbackSegmentOracle rollbackSegmentOracle = (RollbackSegmentOracle)this.storageDesign.getRollbackSegmentSet().getByName(string);
                        if (rollbackSegmentOracle != null) {
                            this.snapshot.setRollbackSegment(rollbackSegmentOracle);
                        }
                    }
                    if (Token.hasToken(string2, "LOCAL")) {
                        this.snapshot.setSegmentType("LOCAL");
                    }
                }
            }
        }
    }

    private void initForUpdate() {
        if (Token.hasString(this.statement.toUpperCase(), "FOR UPDATE")) {
            this.snapshot.setForUpdate("YES");
        }
    }

    private void initQueryRewrite() {
        if (Token.hasString(this.statement.toUpperCase(), "QUERY REWRITE")) {
            this.snapshot.setQueryRewrite(Token.getTokenBefore(this.statement.toUpperCase(), "QUERY"));
        }
    }

    private void initSubquery(String string) {
        String string2 = Token.getStringAfter(string, "AS");
        int n = Token.getStringAfter(string2, "SELECT").length();
        if (n == 0) {
            string2 = "";
        } else {
            String string3;
            while ((string3 = Token.getStringAfter(string2, "AS")).length() > n) {
                string2 = string3;
            }
        }
        if (!"".equalsIgnoreCase(string2)) {
            this.snapshot.setSubquery(string2);
        }
    }

    private void initSnapshotTable() {
        try {
            Table table = this.storageDesign.getPhysicalDesign().createTable();
            TableProxyOracle tableProxyOracle = (TableProxyOracle)this.storageDesign.getProxy(table);
            UserOracle userOracle = this.snapshot.getUser();
            if (userOracle != null) {
                String string = userOracle.getName();
                SchemaObjectSet schemaObjectSet = ((RelationalDesign)table.getDesignPart()).getSchemaObjectSet();
                SchemaObject schemaObject = (SchemaObject)schemaObjectSet.getByName(string);
                if (schemaObject == null && !string.trim().equalsIgnoreCase("")) {
                    schemaObject = schemaObjectSet.createSchemaObject(null);
                    schemaObject.setName(string);
                    this.design.getRelationalDesign().stampModelObjectDDL(schemaObject);
                }
                if (userOracle.getSchemaObject() == null) {
                    userOracle.setSchemaObject(schemaObject);
                }
                if (userOracle.getSchemaObject() != schemaObject && tableProxyOracle != null) {
                    tableProxyOracle.setUser(userOracle);
                }
                table.setSchemaObject(schemaObject);
            }
            table.setName(this.snapshot.getName());
            this.design.getRelationalDesign().stampModelObjectDDL(table);
            table.setTypeID(this.storageDesign.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_SUMMARY).getTypeID());
            this.initColumns(table);
            if (tableProxyOracle != null) {
                tableProxyOracle.setSnapshot(this.snapshot);
            }
        }
        catch (Exception exception) {
            LOGGER.error("wrong format in SHCreateSnapshotOracle.initSnapshotTable: ", exception);
            this.importLog.addWarning("Unable to import Snapshot " + this.statement);
        }
    }

    public void initColumns(Table table) {
        String string;
        Object object;
        String string2;
        ArrayList<String> arrayList = null;
        this.statement = this.removeBracketsAroundSubquery(this.statement);
        String string3 = Token.getStringBefore(this.statement, "AS SELECT ");
        if (!Token.hasToken(string3, "OF") && Token.hasCloseAndOpenBrackets(string3) && !"".equalsIgnoreCase(string2 = Token.getValBetweenBrackets(string3, 1))) {
            arrayList = new ArrayList<String>();
            object = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                arrayList.add(Token.getFirstName(string, '\"', '\"'));
            }
        }
        if (!"".equalsIgnoreCase(string2 = Token.getStringAfter(this.statement, "SELECT"))) {
            String string4;
            String string5;
            Object object2;
            Object object3;
            object = string2;
            string = "";
            if (Token.hasToken((String)object, "FROM")) {
                int n = ((String)object).toUpperCase().indexOf(" FROM ");
                object3 = ((String)object).substring(0, n);
                string = ((String)object).substring(n + 6);
                while (Token.tokenNumber((String)object3, "(") > Token.tokenNumber((String)object3, ")") && (n = ((String)object).toUpperCase().indexOf(" FROM ", n + 1)) > -1) {
                    object3 = ((String)object).substring(0, n);
                    string = ((String)object).substring(n + 6);
                }
                object = object3;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            object3 = new HashMap();
            if (Token.hasToken(string, "WHERE")) {
                string = Token.getStringBeforeToken(string, "WHERE");
            }
            String[] stringArray = new String[]{"CONNECT", "START", "GROUP", "HAVING", "MODEL", "UNION", "INTERSECT", "MINUS", "ORDER"};
            String string6 = Token.getStringToFirstMatch(string.toUpperCase(), stringArray);
            string = string.substring(0, string6.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object2 = null;
                string5 = stringTokenizer.nextToken();
                string4 = Token.getFirstName(string5, '\"', '\"');
                String string7 = "";
                int n = string4.indexOf(46);
                if (n > -1) {
                    string7 = string4.substring(0, n);
                    string7 = Token.removeQuotes(string7);
                    string4 = string4.substring(n + 1);
                }
                string4 = Token.removeQuotes(string4);
                if (!"".equals(string7) && (object2 = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(string7, string4)) == null) {
                    object2 = (TableView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(string7, string4);
                }
                if (object2 == null && (object2 = (Table)this.design.getRelationalDesign().getTableSet().getByName(string4)) == null) {
                    object2 = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string4);
                }
                if (object2 == null) continue;
                String string8 = "";
                int n2 = string5.indexOf(string4);
                if (n2 > -1) {
                    String string9 = string5.substring(n2 + string4.length());
                    if (string9.startsWith("\"")) {
                        string9 = string9.substring(1);
                    }
                    string8 = Token.getFirstName(string9, '\"', '\"');
                }
                if (string8.equals("")) {
                    string8 = string4;
                }
                arrayList2.add(string8);
                object3.put(string8, object2);
            }
            if (Token.getFirstToken((String)object).equalsIgnoreCase("ALL")) {
                object = Token.getStringAfterToken((String)object, "ALL").trim();
            }
            if (Token.getFirstToken((String)object).equalsIgnoreCase("DISTINCT")) {
                object = Token.getStringAfterToken((String)object, "DISTINCT").trim();
            }
            if (Token.getFirstToken((String)object).equalsIgnoreCase("UNIQUE")) {
                object = Token.getStringAfterToken((String)object, "UNIQUE").trim();
            }
            object2 = new StringTokenizer((String)object, ",");
            string5 = null;
            string4 = null;
            int n = 0;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                Object object4;
                ContainerObject containerObject;
                int n3;
                string5 = ((StringTokenizer)object2).nextToken().trim();
                string4 = null;
                StringBuffer stringBuffer = new StringBuffer(string5);
                while (Token.tokenNumber(string5, "(") > Token.tokenNumber(string5, ")") && ((StringTokenizer)object2).hasMoreTokens()) {
                    stringBuffer.append(",").append(((StringTokenizer)object2).nextToken().trim());
                    string5 = stringBuffer.toString().trim();
                }
                boolean bl = false;
                if (!string5.endsWith("*") && (Token.hasCloseAndOpenBrackets(string5) || string5.indexOf(43) > -1 || string5.indexOf(45) > -1 || string5.indexOf(42) > -1 || string5.indexOf(47) > -1 || string5.indexOf("||") > -1 || Token.hasToken(string5, "PRIOR"))) {
                    bl = true;
                }
                if (Token.hasToken(string5, "AS")) {
                    string4 = Token.getNameAfterToken(string5, "AS", '\"', '\"');
                    string5 = Token.getStringBeforeToken(string5, "AS");
                    string5 = Token.encodeQuotedString(string5);
                } else if (!((string5 = Token.encodeQuotedString(string5)).indexOf(32) <= -1 || arrayList != null && bl)) {
                    if (string5.charAt(string5.length() - 1) == '\"') {
                        string4 = string5.substring(0, string5.length() - 1);
                        int n4 = string4.lastIndexOf(34);
                        string4 = string4.substring(n4) + "\"";
                        string5 = string5.substring(0, n4 - 1);
                    } else {
                        String string10 = Token.getLastToken(string5);
                        if (string10.indexOf(41) == -1 && !string10.equalsIgnoreCase("END")) {
                            string4 = string10;
                            string5 = string5.substring(0, string5.indexOf(string10)).trim();
                        }
                    }
                }
                String string11 = "";
                if (!bl && (n3 = string5.lastIndexOf(46)) > -1) {
                    string11 = string5.substring(0, n3);
                    int n5 = string11.lastIndexOf(46);
                    if (n5 > -1) {
                        string11 = string11.substring(n5 + 1);
                    }
                    string11 = Token.removeQuotes(Token.decodeQuotedString(string11)).trim();
                    string5 = string5.substring(n3 + 1);
                }
                if ((string5 = Token.removeQuotes(Token.decodeQuotedString(string5))).equalsIgnoreCase("*")) {
                    for (String string12 : arrayList2) {
                        Column column;
                        if (!string11.equals("") && !string11.equalsIgnoreCase(string12)) continue;
                        containerObject = (ContainerObject)object3.get(string12);
                        if (containerObject instanceof Table) {
                            object4 = (ContainedObject[])containerObject;
                            for (ContainedObject containedObject : object4.getElementsCollection()) {
                                String string13 = arrayList != null && n < arrayList.size() ? (String)arrayList.get(n) : containedObject.getName();
                                column = table.createColumn(string13);
                                this.design.getRelationalDesign().stampModelObjectDDL(column);
                                this.copyColumnDef((Column)containedObject, column);
                                ++n;
                            }
                            continue;
                        }
                        if (!(containerObject instanceof TableView)) continue;
                        object4 = ((TableView)containerObject).getColumns();
                        for (int i = 0; i < ((ContainedObject[])object4).length; ++i) {
                            ContainedObject containedObject;
                            containedObject = (ColumnView)object4[i];
                            String string14 = arrayList != null && n < arrayList.size() ? (String)arrayList.get(n) : containedObject.getName();
                            column = table.createColumn(string14);
                            this.design.getRelationalDesign().stampModelObjectDDL(column);
                            ++n;
                        }
                    }
                    continue;
                }
                if (string5.equalsIgnoreCase("")) continue;
                string4 = arrayList != null && n < arrayList.size() ? (String)arrayList.get(n) : (string4 != null && !string4.equals("") ? Token.removeQuotes(Token.decodeQuotedString(string4)) : string5);
                Column column = table.createColumn(string4);
                this.design.getRelationalDesign().stampModelObjectDDL(column);
                if (bl) {
                    if (this.isAggregateFunction(string5)) {
                        column.setSourceType("Aggregate");
                    } else {
                        column.setSourceType("Derived");
                    }
                    column.setFormulaDesc(string5);
                } else {
                    for (String string12 : arrayList2) {
                        if (!string11.equals("") && !string11.equalsIgnoreCase(string12)) continue;
                        containerObject = (ContainerObject)object3.get(string12);
                        object4 = containerObject.getElementByName(string5);
                        if (!(object4 instanceof Column)) break;
                        this.copyColumnDef((Column)object4, column);
                        break;
                    }
                }
                ++n;
            }
        }
    }

    private void copyColumnDef(Column column, Column column2) {
        short s = column.getUse();
        column2.setUse(s);
        if (s == 0) {
            column2.setDomain(column.getDomain());
        } else if (s == 1) {
            column2.setLogicalDatatype(column.getLogicalDatatype());
            column2.setDataTypeSize(column.getSize());
            column2.setDataTypePrecision(column.getPrecision());
            column2.setDataTypeScale(column.getScale());
        } else if (s == 3) {
            column2.setStructuredType(column.getStructuredType());
        } else if (s == 4) {
            column2.setCollectionType(column.getCollectionType());
        } else if (s == 2) {
            column2.setDistinctType(column.getDistinctType());
        }
        column2.setReference(column.isReference());
        column2.setNullsAllowed(column.getNullsAllowed());
    }

    private String removeBracketsAroundSubquery(String string) {
        int n = string.toUpperCase().indexOf(" AS ");
        String string2 = string;
        if (n > -1) {
            String string3 = string.substring(0, n + 4);
            String string4 = string.substring(n + 4).trim();
            if (string4.charAt(0) == '(') {
                string4 = Token.getValBetweenBrackets(string4);
            }
            string2 = string3 + string4;
        }
        return string2;
    }

    private boolean isAggregateFunction(String string) {
        String[] stringArray = AggregateFunctionsOracle.FUNCTIONS_V9;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.toUpperCase().startsWith(string2.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

