/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRollbackSegment
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateRollbackSegment.class);

    public SHCreateRollbackSegment(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateRollbackSegment.clearCR(string);
        if (Token.startsWithString(string2, "create rollback segment") || Token.startsWithString(string2, "create public rollback segment")) {
            try {
                this.parseRollbackSegment(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string2 + " for Oracle failed!", exception);
                this.importLog.addFailedStatement(SHCreateRollbackSegment.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseRollbackSegment(String string) {
        RollbackSegmentOracle rollbackSegmentOracle;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignOracle != null && (rollbackSegmentOracle = storageDesignOracle.getRollbackSegmentSet().createRollbackSegment()) != null) {
            this.initName(rollbackSegmentOracle);
            this.initTablespaces(rollbackSegmentOracle);
            this.initStorage(rollbackSegmentOracle);
            this.design.getRelationalDesign().stampModelObjectDDL(rollbackSegmentOracle);
        }
    }

    private void initName(RollbackSegmentOracle rollbackSegmentOracle) {
        String string = Token.getQuotedNameAfterToken(this.statement, "SEGMENT").trim();
        rollbackSegmentOracle.setName(string);
        if (Token.hasToken(this.statement, "PUBLIC")) {
            rollbackSegmentOracle.setPub("YES");
        }
    }

    private void initTablespaces(RollbackSegmentOracle rollbackSegmentOracle) {
        int n = this.statement.indexOf("TABLESPACE");
        if (n > -1) {
            String string = this.statement.substring(n);
            while (string.indexOf("TABLESPACE") > -1) {
                String string2;
                if (string.indexOf("TABLESPACE", 10) > -1) {
                    string2 = string.substring(0, string.indexOf("TABLESPACE", 10));
                    string = string.substring(string.indexOf("TABLESPACE", 10));
                    string2 = Token.cutFirstToken(string2);
                } else {
                    string2 = Token.getTokenAfter(string, "TABLESPACE");
                    string = "";
                }
                string2 = Token.getName(string2);
                rollbackSegmentOracle.setTablespaces(rollbackSegmentOracle.convertTSNamesToIDs(string2));
            }
        }
    }

    private void initStorage(RollbackSegmentOracle rollbackSegmentOracle) {
        String string;
        if (Token.hasToken(this.statement, "STORAGE") && Token.getFirstToken(string = Token.getStringAfter(this.statement, "STORAGE")).equalsIgnoreCase("(")) {
            string = Token.getValBetweenBrackets(string, 1).trim();
            this.initInitial(string, rollbackSegmentOracle);
            this.initNext(string, rollbackSegmentOracle);
            this.initMinExtents(string, rollbackSegmentOracle);
            this.initMaxExtents(string, rollbackSegmentOracle);
            this.initOptimal(string, rollbackSegmentOracle);
        }
    }

    private void initInitial(String string, RollbackSegmentOracle rollbackSegmentOracle) {
        if (Token.hasToken(string, "INITIAL")) {
            String string2;
            String string3;
            String string4 = Token.getStringAfter(string, "INITIAL").toUpperCase();
            String string5 = string3 = Token.getFirstToken(string4);
            String string6 = "";
            if (string3.endsWith("K") || string3.endsWith("M") || string3.endsWith("G") || string3.endsWith("T") || string3.endsWith("P") || string3.endsWith("E")) {
                string5 = string3.substring(0, string3.length() - 1);
                string6 = string3.substring(string3.length() - 1);
            }
            try {
                rollbackSegmentOracle.setSCInitialExtent(Integer.parseInt(string5));
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateRollbackSegment.initInitial: " + numberFormatException.getMessage());
            }
            if ("".equalsIgnoreCase(string6) && ((string2 = Token.getTokenAfter(string4, string3)).equals("K") || string2.equals("M") || string2.equals("G") || string2.equals("T") || string2.equals("P") || string2.equals("E"))) {
                string6 = string2;
            }
            rollbackSegmentOracle.setInitialSizeUnit(string6);
        }
    }

    private void initNext(String string, RollbackSegmentOracle rollbackSegmentOracle) {
        if (Token.hasToken(string, "NEXT")) {
            String string2;
            String string3;
            String string4 = Token.getStringAfter(string, "NEXT").toUpperCase();
            String string5 = string3 = Token.getFirstToken(string4);
            String string6 = "";
            if (string3.endsWith("K") || string3.endsWith("M") || string3.endsWith("G") || string3.endsWith("T") || string3.endsWith("P") || string3.endsWith("E")) {
                string5 = string3.substring(0, string3.length() - 1);
                string6 = string3.substring(string3.length() - 1);
            }
            try {
                rollbackSegmentOracle.setSCNextExtent(Integer.parseInt(string5));
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateRollbackSegment.initNext: " + numberFormatException.getMessage());
            }
            if ("".equalsIgnoreCase(string6) && ((string2 = Token.getTokenAfter(string4, string3)).equals("K") || string2.equals("M") || string2.equals("G") || string2.equals("T") || string2.equals("P") || string2.equals("E"))) {
                string6 = string2;
            }
            rollbackSegmentOracle.setNextSizeUnit(string6);
        }
    }

    private void initMinExtents(String string, RollbackSegmentOracle rollbackSegmentOracle) {
        if (Token.hasToken(string, "MINEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MINEXTENTS").trim());
            try {
                int n = Integer.parseInt(string2);
                rollbackSegmentOracle.setSCMinExtents(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateRollbackSegment.initMinExtents: " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxExtents(String string, RollbackSegmentOracle rollbackSegmentOracle) {
        if (Token.hasToken(string, "MAXEXTENTS")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "MAXEXTENTS").trim());
            rollbackSegmentOracle.setSCMaxExtents(string2);
        }
    }

    private void initOptimal(String string, RollbackSegmentOracle rollbackSegmentOracle) {
        if (Token.hasToken(string, "OPTIMAL")) {
            String string2 = this.getNumberOnly(Token.getTokenAfter(string, "OPTIMAL").trim());
            try {
                Integer.parseInt(string2);
                rollbackSegmentOracle.setScOptimal(string2);
            }
            catch (NumberFormatException numberFormatException) {
                rollbackSegmentOracle.setScOptimal("");
            }
        }
    }

    private String getNumberOnly(String string) {
        if (string.toUpperCase().endsWith("K")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.toUpperCase().endsWith("M")) {
            string = string.substring(0, string.length() - 1).trim();
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n *= 1024);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("SHCreateRollbackSegment.getNumberOnly - Unable to parse value: " + string, numberFormatException);
            }
        }
        return string;
    }
}

