/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2.v80;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.v80.SequenceDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSequenceDB2v80
extends DDLStatementHandler {
    private String userName;
    private String line;
    private static final Logger LOGGER = new Logger(SHCreateSequenceDB2v80.class);

    public SHCreateSequenceDB2v80(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateSequenceDB2v80.clearCR(string);
        this.line = string;
        if (Token.startsWithString(string2, "create sequence")) {
            this.parseSequence(string2.replaceAll("\"", ""));
        } else {
            this.nextHandler(string);
        }
    }

    public void parseSequence(String string) {
        SequenceDB2v80 sequenceDB2v80;
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        StorageDesignDB2v80 storageDesignDB2v80 = (StorageDesignDB2v80)this.design.getStorageDesign(rDBMSSite);
        if (storageDesignDB2v80 != null && (sequenceDB2v80 = (SequenceDB2v80)storageDesignDB2v80.getSequenceSet().createSequence()) != null) {
            try {
                this.initName(sequenceDB2v80);
                this.initOwner(sequenceDB2v80, storageDesignDB2v80);
                this.initDataType(sequenceDB2v80);
                this.initStartWith(sequenceDB2v80);
                this.initIncrementBy(sequenceDB2v80);
                this.initMaxValue(sequenceDB2v80);
                this.initMinValue(sequenceDB2v80);
                this.initCycle(sequenceDB2v80);
                this.initCache(sequenceDB2v80);
                this.initOrder(sequenceDB2v80);
                this.design.getRelationalDesign().stampModelObjectDDL(sequenceDB2v80);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error(" Parsing " + string + " for DB2 8.0 failed!", exception);
                this.importLog.addFailedStatement(SHCreateSequenceDB2v80.FormatCR(this.line, "\n"));
            }
        }
    }

    private void initName(SequenceDB2v80 sequenceDB2v80) {
        String string = Token.getTokenAfter(this.statement, "SEQUENCE").trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.userName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "SEQUENCE"), '.');
            string = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "SEQUENCE"), '.');
        }
        sequenceDB2v80.setName(string);
    }

    private void initOwner(SequenceDB2v80 sequenceDB2v80, StorageDesignDB2v80 storageDesignDB2v80) {
        if (this.userName != null) {
            Owner owner = (Owner)storageDesignDB2v80.getOwnerSet().getByName(this.userName);
            if (owner == null) {
                owner = (Owner)storageDesignDB2v80.getOwnerSet().createElement(null);
                owner.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            sequenceDB2v80.setOwner(owner);
        } else {
            sequenceDB2v80.setOwner(storageDesignDB2v80.getOwnerSet().getDefaultOwner());
        }
    }

    private void initDataType(SequenceDB2v80 sequenceDB2v80) throws ParseException {
        if (!Token.hasString(this.statement, "AS")) {
            throw new ParseException("wrong format in SHCreateSequenceDB2v80.initDataType : ");
        }
        String string = Token.getTokenAfter(this.statement, "AS").trim();
        sequenceDB2v80.setDatatype(string);
    }

    private void initStartWith(SequenceDB2v80 sequenceDB2v80) throws ParseException {
        if (Token.hasString(this.statement, "START")) {
            String string = Token.getTokenAfter(this.statement, "WITH").trim();
            try {
                int n = Integer.parseInt(string);
                sequenceDB2v80.setStartWith(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("wrong format in SHCreateSequenceDB2v80.initStartWith : " + numberFormatException.getMessage());
            }
        } else {
            throw new ParseException("wrong format in SHCreateSequenceDB2v80.initStartWith : ");
        }
    }

    private void initIncrementBy(SequenceDB2v80 sequenceDB2v80) {
        if (Token.hasToken(this.statement, "BY")) {
            String string = Token.getTokenAfter(this.statement, "BY").trim();
            try {
                int n = Integer.parseInt(string);
                sequenceDB2v80.setIncrementBy(n);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("wrong format in SHCreateSequenceDB2v80.initIncrementBy : " + numberFormatException.getMessage());
            }
        }
    }

    private void initMaxValue(SequenceDB2v80 sequenceDB2v80) {
        if (Token.hasToken(this.statement, "MAXVALUE")) {
            if (!Token.getTokenBefore(this.statement, "MAXVALUE").equalsIgnoreCase("NO")) {
                String string = Token.getTokenAfter(this.statement, "MAXVALUE").trim();
                try {
                    Integer.parseInt(string);
                    sequenceDB2v80.setMaxValue(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateSequenceOracle.initMaxValue : " + numberFormatException.getMessage());
                }
            } else {
                sequenceDB2v80.setMaxValue("NO");
            }
        } else {
            sequenceDB2v80.setMaxValue("NO");
        }
    }

    private void initMinValue(SequenceDB2v80 sequenceDB2v80) {
        if (Token.hasToken(this.statement, "MINVALUE")) {
            if (!Token.getTokenBefore(this.statement, "MINVALUE").equalsIgnoreCase("NO")) {
                String string = Token.getTokenAfter(this.statement, "MINVALUE").trim();
                try {
                    Integer.parseInt(string);
                    sequenceDB2v80.setMinValue(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateSequenceDB2v80.initMinValue : " + numberFormatException.getMessage());
                }
            } else {
                sequenceDB2v80.setMinValue("NO");
            }
        } else {
            sequenceDB2v80.setMinValue("NO");
        }
    }

    private void initCycle(SequenceDB2v80 sequenceDB2v80) {
        if (Token.hasToken(this.statement, "CYCLE")) {
            if (!Token.getTokenBefore(this.statement, "CYCLE").equalsIgnoreCase("NO")) {
                sequenceDB2v80.setCycle("YES");
            } else {
                sequenceDB2v80.setCycle("NO");
            }
        } else {
            sequenceDB2v80.setCycle("NO");
        }
    }

    private void initCache(SequenceDB2v80 sequenceDB2v80) {
        if (Token.hasToken(this.statement, "CACHE")) {
            if (!Token.getTokenBefore(this.statement, "CACHE").equalsIgnoreCase("NO")) {
                String string = Token.getTokenAfter(this.statement, "CACHE").trim();
                try {
                    int n = Integer.parseInt(string);
                    sequenceDB2v80.setCache(n);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("wrong format in SHCreateSequenceDB2v80.initCache : " + numberFormatException.getMessage());
                }
            } else {
                sequenceDB2v80.setCache(0);
            }
        } else {
            sequenceDB2v80.setCache(0);
        }
    }

    private void initOrder(SequenceDB2v80 sequenceDB2v80) {
        if (Token.hasToken(this.statement, "ORDER")) {
            if (!Token.getTokenBefore(this.statement, "ORDER").equalsIgnoreCase("NO")) {
                sequenceDB2v80.setOrder("YES");
            } else {
                sequenceDB2v80.setOrder("NO");
            }
        } else {
            sequenceDB2v80.setOrder("NO");
        }
    }
}

