/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2.v80;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.IndexProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TablePartitionDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexDB2v80
extends DDLStatementHandler {
    private Index index;
    private Table table;
    private String indexName = "";
    private StorageDesignDB2v80 stoDesign;
    private boolean unique;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateIndexDB2v80.class);
    boolean hasIntegrIndex = false;

    public SHCreateIndexDB2v80(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateIndexDB2v80.clearCR(string);
        if (Token.startsWithString(string2, "create index") || Token.startsWithString(string2, "create unique index") || Token.startsWithString(string2, "create unique where not null index") || Token.startsWithString(string2, "create type 2 index") || Token.startsWithString(string2, "create type 2 unique index") || Token.startsWithString(string2, "create type 2 unique where not null index") || Token.startsWithString(string2, "create type 1 index") || Token.startsWithString(string2, "create type 1 unique index") || Token.startsWithString(string2, "create type 1 unique where not null index")) {
            this.statement = string2;
            if (this.isTableIndex()) {
                try {
                    this.createIndex();
                    if (this.failed) {
                        this.importLog.addFailedStatement(SHCreateIndexDB2v80.FormatCR(string, "\n"));
                    } else {
                        this.importLog.incrementImportedStatements();
                    }
                }
                catch (Exception exception) {
                    this.importLog.addFailedStatement(SHCreateIndexDB2v80.FormatCR(string, "\n"));
                }
                this.index = null;
                this.table = null;
                this.indexName = "";
                this.stoDesign = null;
                this.unique = false;
                this.failed = false;
            } else {
                this.nextHandler(string);
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createIndex() {
        try {
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            this.stoDesign = (StorageDesignDB2v80)this.design.getStorageDesign(rDBMSSite);
            this.indexName = this.initIndexName();
            this.unique = Token.hasToken(this.statement, "UNIQUE");
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)this.stoDesign.getTableProxySet().getObjectGeneratedBy(this.table);
            this.hasIntegrIndex = tableProxyDB2.getIntegrityIndexes().size() > 0;
            List list = this.getColumnsName();
            if (this.table != null) {
                if (this.stoDesign != null && this.stoDesign.importStorageObjectsOnly()) {
                    this.index = this.table.getIndexByName(this.indexName);
                } else {
                    this.constructIndex(list.toArray(), this.makeNames(list));
                }
            }
            if (this.index != null) {
                IndexProxyDB2v80 indexProxyDB2v80;
                if (!this.stoDesign.importStorageObjectsOnly()) {
                    if (this.unique && !this.index.isPK() && !this.index.isUnique()) {
                        this.index.setIndexState("Unique Plain Index");
                    }
                    this.setColumnForIndex(list);
                }
                if (this.stoDesign != null && (indexProxyDB2v80 = (IndexProxyDB2v80)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    indexProxyDB2v80.setProcessedInDDLImport(true);
                    indexProxyDB2v80.setName(this.indexName);
                    StorageTemplateDB2 storageTemplateDB2 = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
                    this.design.getRelationalDesign().stampModelObjectDDL(storageTemplateDB2);
                    indexProxyDB2v80.setStorageTemplate(storageTemplateDB2);
                    this.initNotNull(indexProxyDB2v80);
                    int n = this.statement.indexOf(41);
                    String string = this.statement.substring(n + 1).trim();
                    int n2 = string.indexOf(40);
                    if (n2 > 0) {
                        string = string.substring(0, n2);
                    }
                    this.initCluster(indexProxyDB2v80, string);
                    this.initPadded(indexProxyDB2v80, string);
                    this.initUsingBlock(indexProxyDB2v80, string);
                    this.initFreeBlock(indexProxyDB2v80, string);
                    this.initGbpcacheBlock(indexProxyDB2v80, string);
                    this.initDefine(indexProxyDB2v80, string);
                    this.initPartition(indexProxyDB2v80);
                    this.initCluster(indexProxyDB2v80);
                    this.initBufferpool(indexProxyDB2v80);
                    this.initClose(indexProxyDB2v80);
                    this.initDefer(indexProxyDB2v80);
                    this.initPieceSize(indexProxyDB2v80);
                    this.initCopy(indexProxyDB2v80);
                    this.initOwner(indexProxyDB2v80);
                    StorageTemplateDB2 storageTemplateDB22 = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(indexProxyDB2v80.getStorageTemplate());
                    if (storageTemplateDB22 != indexProxyDB2v80.getStorageTemplate()) {
                        indexProxyDB2v80.setStorageTemplate(storageTemplateDB22);
                    }
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            StringBuffer stringBuffer = new StringBuffer(objectDoesNotExistException.getMessage());
            stringBuffer.append(" in SHCreateIndexDB2v80.createIndex");
            LOGGER.error(stringBuffer.toString(), objectDoesNotExistException);
            this.importLog.addError("Creating index for statement " + this.statement + " for DB2 failed");
            this.failed = true;
        }
    }

    public boolean columnsBelongToIndex(Object[] objectArray, Index index) {
        if (index != null) {
            ContainedObject[] containedObjectArray = index.getElements();
            if (containedObjectArray.length != objectArray.length) {
                return false;
            }
            for (int i = 0; i < containedObjectArray.length; ++i) {
                if (containedObjectArray[i].getName().equalsIgnoreCase((String)objectArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean columnsBelongToIndexWithSO(Object[] objectArray, Index index) {
        if (index != null) {
            ContainedObject[] containedObjectArray = index.getElements();
            if (containedObjectArray.length != objectArray.length) {
                return false;
            }
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                ColNameSortOrder colNameSortOrder = (ColNameSortOrder)objectArray[i];
                if (!column.getName().equalsIgnoreCase(colNameSortOrder.cname)) {
                    return false;
                }
                if (index.getColumnSortOrder(column).equalsIgnoreCase(colNameSortOrder.sortOrder)) continue;
                return false;
            }
        }
        return true;
    }

    private void constructIndex(Object[] objectArray, Object[] objectArray2) {
        Object object;
        int n;
        Object object2;
        if (this.unique && this.table.hasPK() && ((DesignObject)(object2 = (Index)this.table.getPK())).getName().equalsIgnoreCase(this.indexName)) {
            this.index = object2;
            return;
        }
        object2 = (Index[])this.table.getKeys();
        if (this.unique) {
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = object2[n];
                if (!((KeyObject)object).isUnique() || !((DesignObject)object).getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = object;
                return;
            }
        }
        for (n = 0; n < ((Object)object2).length; ++n) {
            object = object2[n];
            if (!((DesignObject)object).getName().equalsIgnoreCase(this.indexName) || !this.columnsBelongToIndexWithSO(objectArray, (Index)object)) continue;
            this.index = object;
            break;
        }
        if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
            this.index = this.table.createIndex();
            this.index.setName(this.indexName);
            this.design.getRelationalDesign().stampModelObjectDDL(this.index);
        }
    }

    private void initNotNull(IndexProxyDB2v80 indexProxyDB2v80) {
        boolean bl;
        if (!this.index.isPK() && (bl = Token.hasToken(this.statement, "WHERE"))) {
            indexProxyDB2v80.setWhereNotNull(true);
        }
    }

    private String initIndexName() {
        String string = Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        if (string.indexOf(46) > -1) {
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void setColumnForIndex(List list) throws ObjectDoesNotExistException {
        for (ColNameSortOrder colNameSortOrder : list) {
            Column column = (Column)this.table.getElementByName(colNameSortOrder.cname.trim());
            this.index.add(column);
            this.index.setColumnSortOrder(column, colNameSortOrder.sortOrder);
        }
    }

    private List getColumnsName() {
        int n = 0;
        ArrayList<ColNameSortOrder> arrayList = new ArrayList<ColNameSortOrder>();
        if (this.table != null) {
            n = this.table.getElements().length;
        }
        if (n > 0) {
            String string = Token.getValBetweenBrackets(this.statement, 1);
            boolean bl = Token.hasCloseAndOpenBrackets(string);
            if (bl) {
                this.index.setIndexExpression(string);
                return arrayList;
            }
            string = Token.getNamesOnly(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = "ASC";
                if (Token.getLastToken(string2).equalsIgnoreCase("ASC") || Token.getLastToken(string2).equalsIgnoreCase("DESC")) {
                    if (Token.getLastToken(string2).equalsIgnoreCase("DESC")) {
                        string3 = "DESC";
                    }
                    string2 = string2.substring(0, string2.lastIndexOf(32));
                }
                arrayList.add(new ColNameSortOrder(string2, string3));
            }
        }
        return arrayList;
    }

    private String getTableName() {
        int n;
        String string = Token.getNameAfterToken(this.statement, "ON", '\"', '\"');
        if (string.indexOf(40) > -1) {
            string = string.substring(0, string.indexOf(40));
        }
        if ((n = string.indexOf(46)) > 0) {
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void initUsingBlock(IndexProxyDB2v80 indexProxyDB2v80, String string) {
        boolean bl = Token.hasToken(string, "USING");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "USING").trim();
            if (string2.equalsIgnoreCase("VCAT")) {
                String string3 = Token.getTokenAfter(string, "VCAT").trim();
                Iterator iterator = this.stoDesign.getVCatSet().iterator();
                while (iterator.hasNext()) {
                    VCatDB2 vCatDB2 = (VCatDB2)iterator.next();
                    if (!vCatDB2.getName().equalsIgnoreCase(string3)) continue;
                    indexProxyDB2v80.getStorageTemplate().setVCat(vCatDB2);
                    break;
                }
            } else if (string2.equalsIgnoreCase("STOGROUP")) {
                String string4;
                String string5 = Token.getTokenAfter(string, "STOGROUP").trim();
                StorageGroupSetDB2 storageGroupSetDB2 = this.stoDesign.getStorageGroupSet();
                indexProxyDB2v80.getStorageTemplate().setStorageGroup(storageGroupSetDB2.getOrCreateStorageGroup(string5));
                try {
                    String string6;
                    string4 = Token.getTokenAfter(string, "PRIQTY").trim();
                    if (!string4.equals("")) {
                        int n = Integer.parseInt(string4);
                        indexProxyDB2v80.getStorageTemplate().setSgPriqty(n);
                    }
                    if (!(string6 = Token.getTokenAfter(string, "SECQTY").trim()).equals("")) {
                        int n = Integer.parseInt(string6);
                        indexProxyDB2v80.getStorageTemplate().setSgSeqty(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Wrong format in SHCreateIndex.initUsingBlock():", numberFormatException);
                    this.importLog.addWarning("Wrong using block format in statement " + this.statement);
                }
                string4 = Token.getTokenAfter(this.statement, "ERASE").trim();
                if (string4.equalsIgnoreCase("YES")) {
                    indexProxyDB2v80.getStorageTemplate().setSgErase(true);
                }
            }
        }
    }

    private void initFreeBlock(IndexProxyDB2v80 indexProxyDB2v80, String string) {
        try {
            String string2;
            String string3 = Token.getTokenAfter(string, "FREEPAGE").trim();
            if (!string3.equals("")) {
                int n = Integer.parseInt(string3);
                indexProxyDB2v80.getStorageTemplate().setFreePage(n);
            }
            if (!(string2 = Token.getTokenAfter(string, "PCTFREE").trim()).equals("")) {
                int n = Integer.parseInt(string2);
                indexProxyDB2v80.getStorageTemplate().setPctFree(n);
            } else {
                indexProxyDB2v80.getStorageTemplate().setPctFree(10);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error("Wrong format in SHCreateIndex.initFreeBlock:", numberFormatException);
            this.importLog.addWarning("Wrong free block format in statement " + this.statement);
        }
    }

    private void initGbpcacheBlock(IndexProxyDB2v80 indexProxyDB2v80, String string) {
        boolean bl = Token.hasToken(string, "GBPCACHE");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "GBPCACHE").trim().toUpperCase();
            String[] stringArray = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equalsIgnoreCase(stringArray[i])) continue;
                indexProxyDB2v80.getStorageTemplate().setGbCache(stringArray[i]);
            }
        }
    }

    private void initDefine(IndexProxyDB2v80 indexProxyDB2v80, String string) {
        boolean bl = Token.hasToken(string, "DEFINE");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "DEFINE").trim();
            if (string2.equalsIgnoreCase("YES")) {
                indexProxyDB2v80.getStorageTemplate().setDefine(true);
            } else {
                indexProxyDB2v80.getStorageTemplate().setDefine(false);
            }
        }
    }

    private void initCluster(IndexProxyDB2v80 indexProxyDB2v80, String string) {
        boolean bl = Token.hasToken(string, "CLUSTER");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "CLUSTER").trim();
            if (string2.equalsIgnoreCase("YES")) {
                indexProxyDB2v80.setClusteredDB2("YES");
            } else {
                indexProxyDB2v80.setClusteredDB2("NO");
            }
        }
    }

    private void initPadded(IndexProxyDB2v80 indexProxyDB2v80, String string) {
        boolean bl = Token.hasToken(string, "PADDED");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "PADDED").trim();
            if (string2.equalsIgnoreCase("YES")) {
                indexProxyDB2v80.setPadded("YES");
            } else {
                indexProxyDB2v80.setPadded("NO");
            }
        }
    }

    private void initBufferpool(IndexProxyDB2v80 indexProxyDB2v80) {
        String string = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim();
        BufferPoolSetDB2 bufferPoolSetDB2 = this.stoDesign.getBufferPoolSet();
        Iterator iterator = bufferPoolSetDB2.iterator();
        while (iterator.hasNext()) {
            BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)iterator.next();
            if (!bufferPoolDB2.getName().equalsIgnoreCase(string)) continue;
            indexProxyDB2v80.setBufferPool(bufferPoolDB2);
        }
    }

    private void initClose(IndexProxyDB2v80 indexProxyDB2v80) {
        String string = Token.getTokenAfter(this.statement, "CLOSE").trim();
        if (string.equalsIgnoreCase("NO")) {
            indexProxyDB2v80.setClose(false);
        }
    }

    private void initDefer(IndexProxyDB2v80 indexProxyDB2v80) {
        String string = Token.getTokenAfter(this.statement, "DEFER").trim();
        if (string.equalsIgnoreCase("YES")) {
            indexProxyDB2v80.setDefer(true);
        }
    }

    private void initCopy(IndexProxyDB2v80 indexProxyDB2v80) {
        String string = Token.getTokenAfter(this.statement, "COPY").trim();
        if (string.equalsIgnoreCase("YES")) {
            indexProxyDB2v80.setCopy(true);
        }
    }

    private void initPieceSize(IndexProxyDB2v80 indexProxyDB2v80) {
        String string = Token.getStringAfter(this.statement, "PIECESIZE").trim();
        if (!(string = Token.getStringBefore(string, "COPY").trim()).equals("")) {
            if (!string.endsWith("K") && string.endsWith("M") && string.endsWith("G")) {
                string = Token.getStringAfterToken(this.statement, "PIECESIZE");
                string = Token.getTokens(string, 1, 2);
            }
            if (string.endsWith("M")) {
                try {
                    int n = Integer.parseInt(string.substring(0, string.length() - 2));
                    string = String.valueOf(n *= 1024) + " K";
                }
                catch (NumberFormatException numberFormatException) {
                    string = "2097152 K";
                }
            } else if (string.endsWith("G")) {
                try {
                    int n = Integer.parseInt(string.substring(0, string.length() - 1).trim());
                    string = String.valueOf(n *= 0x100000) + " K";
                }
                catch (NumberFormatException numberFormatException) {
                    string = "2097152 K";
                }
            }
            indexProxyDB2v80.setPieceSize(string);
        }
    }

    private void initOwner(IndexProxyDB2v80 indexProxyDB2v80) {
        String string = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "INDEX").trim(), '.');
        if (!string.equalsIgnoreCase("")) {
            Owner owner = (Owner)((AbstractStorageDesignDB2)indexProxyDB2v80.getStorageDesign()).getOwnerSet().getByName(string);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)indexProxyDB2v80.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            indexProxyDB2v80.setOwner(owner);
        } else if (this.getOwner() != null) {
            indexProxyDB2v80.setOwner(this.getOwner());
        }
    }

    private boolean isTableIndex() {
        String string = this.getTableName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string);
        return this.table != null;
    }

    private void initCluster(IndexProxyDB2v80 indexProxyDB2v80) {
        boolean bl = Token.hasToken(this.statement, "CLUSTER");
        if (bl) {
            int n = this.statement.indexOf("CLUSTER");
            String string = this.statement.substring(n);
            if (!(string = Token.getValBetweenBrackets(string).trim()).equalsIgnoreCase("")) {
                Object object2;
                TableProxyDB2v80 tableProxyDB2v80 = (TableProxyDB2v80)indexProxyDB2v80.getTableProxy();
                Index index = indexProxyDB2v80.getIndex();
                for (Object object2 : index.getElementsCollection()) {
                    String string2 = index.getColumnSortOrder(object2);
                    tableProxyDB2v80.setPartitioningKey(((ModelIDObject)object2).getObjectID());
                    tableProxyDB2v80.setPartitioningKey(string2);
                }
                object2 = new StringTokenizer(string, ",");
                int n2 = 0;
                while (((StringTokenizer)object2).hasMoreElements()) {
                    String string3 = ((StringTokenizer)object2).nextToken().trim();
                    TablePartitionDB2v80 tablePartitionDB2v80 = (TablePartitionDB2v80)this.stoDesign.getTablePartitionSet().createTablePartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(tablePartitionDB2v80);
                    tablePartitionDB2v80.setPartNumber(++n2);
                    StorageTemplateDB2 storageTemplateDB2 = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
                    this.design.getRelationalDesign().stampModelObjectDDL(storageTemplateDB2);
                    tablePartitionDB2v80.setStorageTemplate(storageTemplateDB2);
                    tablePartitionDB2v80.setTable((TableProxyDB2)indexProxyDB2v80.getTableProxy());
                    this.initUsingBlockPart(string3, tablePartitionDB2v80);
                    this.initFreeBlockPart(string3, tablePartitionDB2v80);
                    this.initGbpcacheBlockPart(string3, tablePartitionDB2v80);
                    this.initConstantsBlockPart(string3, tablePartitionDB2v80);
                    StorageTemplateDB2 storageTemplateDB22 = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(tablePartitionDB2v80.getStorageTemplate());
                    if (storageTemplateDB22 == indexProxyDB2v80.getStorageTemplate()) continue;
                    tablePartitionDB2v80.setStorageTemplate(storageTemplateDB22);
                }
            }
        }
    }

    private void initPartition(IndexProxyDB2v80 indexProxyDB2v80) {
        boolean bl = Token.hasToken(this.statement, "PARTITION");
        if (bl) {
            String string;
            TableProxyDB2v80 tableProxyDB2v80 = (TableProxyDB2v80)indexProxyDB2v80.getTableProxy();
            Index index = indexProxyDB2v80.getIndex();
            for (Column column : index.getElementsCollection()) {
                string = index.getColumnSortOrder(column);
                tableProxyDB2v80.setPartitioningKey(column.getObjectID());
                tableProxyDB2v80.setPartitioningKey(string);
            }
            int n = this.statement.toUpperCase().indexOf("PARTITION BY");
            string = this.statement.substring(n);
            if (!(string = Token.getValBetweenBrackets(string).trim()).equalsIgnoreCase("")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n2 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    TablePartitionDB2v80 tablePartitionDB2v80 = (TablePartitionDB2v80)this.stoDesign.getTablePartitionSet().createTablePartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(tablePartitionDB2v80);
                    tablePartitionDB2v80.setPartNumber(++n2);
                    StorageTemplateDB2 storageTemplateDB2 = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
                    this.design.getRelationalDesign().stampModelObjectDDL(storageTemplateDB2);
                    tablePartitionDB2v80.setStorageTemplate(storageTemplateDB2);
                    tablePartitionDB2v80.setTable((TableProxyDB2)indexProxyDB2v80.getTableProxy());
                    this.initUsingBlockPart(string2, tablePartitionDB2v80);
                    this.initFreeBlockPart(string2, tablePartitionDB2v80);
                    this.initGbpcacheBlockPart(string2, tablePartitionDB2v80);
                    this.initConstantsBlockPart(string2, tablePartitionDB2v80);
                    StorageTemplateDB2 storageTemplateDB22 = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(tablePartitionDB2v80.getStorageTemplate());
                    if (storageTemplateDB22 == indexProxyDB2v80.getStorageTemplate()) continue;
                    tablePartitionDB2v80.setStorageTemplate(storageTemplateDB22);
                }
            }
        }
    }

    private void initUsingBlockPart(String string, TablePartitionDB2v80 tablePartitionDB2v80) {
        String string2 = Token.getTokenAfter(string, "USING").trim();
        if (string2.equalsIgnoreCase("VCAT")) {
            String string3 = Token.getTokenAfter(string, "VCAT").trim();
            VCatDB2 vCatDB2 = this.stoDesign.getVCatSet().getOrCreateVCat(string3);
            tablePartitionDB2v80.getStorageTemplate().setVCat(vCatDB2);
        } else if (string2.equalsIgnoreCase("STOGROUP")) {
            String string4;
            String string5 = Token.getTokenAfter(string, "STOGROUP").trim();
            StorageGroupSetDB2 storageGroupSetDB2 = this.stoDesign.getStorageGroupSet();
            tablePartitionDB2v80.getStorageTemplate().setStorageGroup(storageGroupSetDB2.getOrCreateStorageGroup(string5));
            try {
                String string6;
                string4 = Token.getTokenAfter(string, "PRIQTY").trim();
                if (!string4.equals("")) {
                    int n = Integer.parseInt(string4);
                    tablePartitionDB2v80.getStorageTemplate().setSgPriqty(n);
                }
                if (!(string6 = Token.getTokenAfter(string, "SECQTY").trim()).equals("")) {
                    int n = Integer.parseInt(string6);
                    tablePartitionDB2v80.getStorageTemplate().setSgSeqty(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initUsingBlockPart : ");
                stringBuffer.append(numberFormatException.getMessage());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addWarning("Wrong using block part format in statement " + this.statement);
            }
            string4 = Token.getTokenAfter(string, "ERASE").trim();
            if (string4.equalsIgnoreCase("YES")) {
                tablePartitionDB2v80.getStorageTemplate().setSgErase(true);
            }
        }
    }

    private void initFreeBlockPart(String string, TablePartitionDB2v80 tablePartitionDB2v80) {
        try {
            String string2;
            String string3 = Token.getTokenAfter(string, "FREEPAGE").trim();
            if (!string3.equals("")) {
                int n = Integer.parseInt(string3);
                tablePartitionDB2v80.getStorageTemplate().setFreePage(n);
            }
            if (!(string2 = Token.getTokenAfter(string, "PCTFREE").trim()).equals("")) {
                int n = Integer.parseInt(string2);
                tablePartitionDB2v80.getStorageTemplate().setPctFree(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong format in SHCreateTablespace.initFreeBlockPart : ");
            stringBuffer.append(numberFormatException.getMessage());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addWarning("Wrong using free block format in statement " + this.statement);
        }
    }

    private void initGbpcacheBlockPart(String string, TablePartitionDB2v80 tablePartitionDB2v80) {
        String string2 = Token.getTokenAfter(string, "GBPCACHE").trim().toUpperCase();
        if (!string2.equals("")) {
            String[] stringArray = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equalsIgnoreCase(stringArray[i])) continue;
                tablePartitionDB2v80.getStorageTemplate().setGbCache(stringArray[i]);
            }
        }
    }

    private void initConstantsBlockPart(String string, TablePartitionDB2v80 tablePartitionDB2v80) {
        String string2 = Token.getValBetweenBrackets(string).trim();
        if (!string2.equals("")) {
            tablePartitionDB2v80.setPartConstants(string2);
        }
    }

    private Object[] makeNames(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ColNameSortOrder colNameSortOrder : list) {
            arrayList.add(colNameSortOrder.cname);
        }
        return arrayList.toArray();
    }

    private class ColNameSortOrder {
        String cname;
        String sortOrder;

        ColNameSortOrder(String string, String string2) {
            this.sortOrder = string2;
            this.cname = string;
        }
    }
}

