/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2.v80;

import java.util.Arrays;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.db2.SHAlterTable;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterTableDB2v80
extends SHAlterTable {
    protected static final Logger LOGGER = new Logger(SHAlterTableDB2v80.class);

    public SHAlterTableDB2v80(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHAlterTableDB2v80.clearCR(string);
        if (Token.startsWithString(string2, "alter table") && (this.isUK(string2) || this.isPK(string2) || this.isFK(string2) || this.isCheck(string2))) {
            try {
                if (this.isPK(string2) || this.isUK(string2) || this.isFK(string2) || this.isCheck(string2)) {
                    this.parseAlterTable(string2);
                } else {
                    this.statemensList.add(string2);
                }
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for DB2 8.0 failed!", exception);
                this.importLog.addFailedStatement(SHAlterTableDB2v80.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    @Override
    public void parseAlterTable(String string2) {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (!abstractStorageDesignDB2.importStorageObjectsOnly()) {
            this.initTable(string2);
            if (this.table != null) {
                String[] stringArray = string2.split(" ADD ");
                if (stringArray.length == 1) {
                    stringArray = string2.split(" add ");
                }
                for (String string2 : Arrays.asList(stringArray)) {
                    if (this.isPK(string2)) {
                        this.initPK(string2);
                        continue;
                    }
                    if (this.isUK(string2)) {
                        this.initUnique(string2);
                        continue;
                    }
                    if (this.isFK(string2)) {
                        this.initForeignKey(string2);
                        continue;
                    }
                    if (!this.isCheck(string2)) continue;
                    this.initCheck(string2);
                }
            }
        }
    }

    @Override
    public void processForeignKeys() {
        for (String string : this.statemensList) {
            this.parseAlterTable(string);
        }
    }

    private void initCheck(String string) {
        String string2;
        this.statement = string;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        String string3 = null;
        if (Token.hasToken(this.statement.toUpperCase(), "CONSTRAINT")) {
            string3 = Token.getQuotedNameAfterToken(this.statement, "CONSTRAINT").trim();
        } else {
            string2 = this.table.getName();
            if (string2.length() > 123) {
                string2 = string2.substring(0, 123);
            }
            string3 = string2 + "_CK" + this.table.getCheckConstraints().size();
        }
        string2 = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK"), 1).trim();
        TableLevelConstraint tableLevelConstraint = this.table.createCheckConstraint(string3, string2);
        this.table.addCheckConstraint(tableLevelConstraint);
        this.design.getRelationalDesign().stampModelObjectDDL(tableLevelConstraint);
    }
}

