/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2.v80;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHColumnElementsDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateDistinctTypeDB2v80;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;

public class DomainHandlerReadDDLDB2v80
implements StatementsConstants,
SectionConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;
    private LogicalDatatypeFactory factoryLogical;

    public DomainHandlerReadDDLDB2v80(Design design) {
        this.design = design;
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    public void createDomains(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string = DDLStatementHandler.clearCR((String)iterator.next());
            if (Token.startsWithString(string = string.replaceAll("\"", ""), "create distinct type")) {
                SHCreateDistinctTypeDB2v80 sHCreateDistinctTypeDB2v80 = new SHCreateDistinctTypeDB2v80(this.design, this.factoryLogical);
                sHCreateDistinctTypeDB2v80.parseDistinctType(string);
            }
            boolean bl = false;
            if (string.indexOf("AS ( SELECT") > -1 || string.indexOf("AS (SELECT") > -1) {
                bl = true;
            }
            if (!Token.startsWithString(string, "create table") || bl) continue;
            ArrayList arrayList = this.getColumns(string);
            for (String string2 : arrayList) {
                this.createOneDomain(string2);
            }
        }
    }

    private ArrayList getColumns(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Token.getValBetweenBrackets(string, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose(string3)) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                while (Token.hasOpenBracketNoClose(string3) && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(", ").append(stringTokenizer.nextToken().trim());
                    string3 = stringBuffer.toString();
                }
            }
            arrayList.add(string3.trim());
        }
        return arrayList;
    }

    private void createOneDomain(String string) {
        SHColumnElementsDB2v80 sHColumnElementsDB2v80 = new SHColumnElementsDB2v80();
        boolean bl = false;
        if (Token.hasToken(string, "AS") && Token.hasToken(string, "SELECT")) {
            bl = true;
        }
        Map map = sHColumnElementsDB2v80.getElementsColumn(string, bl);
        String string2 = (String)map.get("datatype");
        String[] stringArray = new String[]{(String)map.get("precision"), (String)map.get("scale"), (String)map.get("size")};
        if (string2 != null) {
            String string3 = StandardDatatypeNames.getUsedDatatypeName(string2);
            LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignDB2v80.RDBMS_TYPE, string3);
            this.factory.getInstance(this.design, logicalDatatype, null, 2, stringArray, null);
        }
    }
}

