/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;

public class SHLabelOn
extends DDLStatementHandler {
    public SHLabelOn(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHLabelOn.clearCR(string);
        if (Token.startsWithString(string2, "label on")) {
            try {
                this.parseLabelOn(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHLabelOn.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseLabelOn(String string) {
        this.statement = string;
        String string2 = this.getNameOnly(Token.getTokenAfter(this.statement, "ON").trim());
        String string3 = Token.getStringAfter(this.statement, "IS").trim();
        string3 = Token.getValBetweenQuotationMarks(string3);
        if (string2.trim().equalsIgnoreCase("TABLE")) {
            RDBMSSite rDBMSSite;
            AbstractStorageDesignDB2 abstractStorageDesignDB2;
            TableProxyDB2 tableProxyDB2;
            string2 = this.getNameOnly(Token.getTokenAfter(this.statement, "TABLE").trim());
            Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string2);
            if (table != null && (tableProxyDB2 = (TableProxyDB2)(abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite = this.design.getSelectedRDBMSSite())).getTableProxySet().getProxy(table.getObjectID())) != null) {
                tableProxyDB2.setLabel(string3);
            }
        } else if (string2.trim().equalsIgnoreCase("COLUMN")) {
            RDBMSSite rDBMSSite;
            AbstractStorageDesignDB2 abstractStorageDesignDB2;
            ColumnProxyDB2 columnProxyDB2;
            Column column;
            string2 = Token.getTokenAfter(this.statement, "COLUMN").trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            if (stringTokenizer.countTokens() == 2) {
                string2 = string2.substring(string2.indexOf(46) + 1);
            }
            if ((column = (Column)this.design.getRelationalDesign().getColumnSet().getByName(string2)) != null && (columnProxyDB2 = (ColumnProxyDB2)(abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite = this.design.getSelectedRDBMSSite())).getColumnProxySet().getProxy(column.getObjectID())) != null) {
                columnProxyDB2.setLabel(string3);
            }
        } else {
            RDBMSSite rDBMSSite;
            AbstractStorageDesignDB2 abstractStorageDesignDB2;
            TableViewProxyDB2 tableViewProxyDB2;
            TableView tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string2);
            if (tableView != null && (tableViewProxyDB2 = (TableViewProxyDB2)(abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite = this.design.getSelectedRDBMSSite())).getTableViewProxySet().getProxy(tableView.getObjectID())) != null) {
                tableViewProxyDB2.setLabelOn(string3);
            }
        }
    }
}

