/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.OwnerSet;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsDB2;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxySetDB2;

public class SHGrant
extends DDLStatementHandler {
    private PermissionsDB2 permissions;
    private AbstractStorageDesignDB2 storageDesign;
    private TableProxyDB2 table = null;
    private TableViewProxyDB2 view = null;
    private AUXTableDB2 auxTable = null;

    public SHGrant(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHGrant.clearCR(string);
        if (Token.startsWithString(string2, "grant execute on procedure")) {
            try {
                this.parseGrantExecuteOnProcedure(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "grant use of")) {
            try {
                this.parseGrantUseOf(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "grant") && string2.toUpperCase().indexOf("ON DATABASE") > -1) {
            try {
                this.parseGrantDatabase(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
                this.importLog.addFailedStatement(string2);
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "grant") && (Token.hasToken(string2, "ARCHIVE") || Token.hasToken(string2, "BINDADD") || Token.hasToken(string2, "BINDAGENT") || Token.hasToken(string2, "BSDS") || Token.hasToken(string2, "CREATEALIAS") || Token.hasToken(string2, "CREATEDBA") || Token.hasToken(string2, "CREATEDBC") || Token.hasToken(string2, "CREATEMTAB") || Token.hasToken(string2, "CREATESG") || Token.hasToken(string2, "DISPLAY") || Token.hasToken(string2, "MONITOR1") || Token.hasToken(string2, "MONITOR2") || Token.hasToken(string2, "RECOVER") || Token.hasToken(string2, "STOPALL") || Token.hasToken(string2, "STOSPACE") || Token.hasToken(string2, "SYSADMIN") || Token.hasToken(string2, "SYSCTRL") || Token.hasToken(string2, "SYSOPR") || Token.hasToken(string2, "TRACE"))) {
            try {
                this.parseSystemPrivileges(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(string, "\n"));
            }
        } else if (Token.startsWithString(string2, "grant") && Token.hasToken(string2, "ON") && Token.hasToken(string2, "TO")) {
            try {
                this.grantPermissions(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHGrant.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseGrantUseOf(String string) {
        block18: {
            String string2;
            AbstractStorageDesignDB2 abstractStorageDesignDB2;
            block20: {
                block19: {
                    block17: {
                        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
                        abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
                        string2 = Token.getTokenAfter(string, "OF");
                        if (!string2.equalsIgnoreCase("BUFFERPOOL")) break block17;
                        String string3 = Token.getStringAfterToken(string, "BUFFERPOOL");
                        string3 = Token.getStringBeforeToken(string3, "TO");
                        String string4 = Token.getStringAfterToken(string, "TO");
                        boolean bl = false;
                        if (Token.hasToken(string4, "GRANT")) {
                            string4 = Token.getStringBeforeToken(string4, "WITH");
                            bl = true;
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)abstractStorageDesignDB2.getBufferPoolSet().getByName(stringTokenizer.nextToken().trim());
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
                            while (stringTokenizer2.hasMoreTokens()) {
                                String string5 = stringTokenizer2.nextToken().trim();
                                if (abstractStorageDesignDB2.getOwnerSet().getByName(string5) == null) {
                                    Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(null);
                                    owner.setName(string5);
                                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                                }
                                bufferPoolDB2.setUsers(string5);
                            }
                            if (!bl) continue;
                            bufferPoolDB2.setGrantOption("YES");
                        }
                        break block18;
                    }
                    if (!string2.equalsIgnoreCase("ALL")) break block19;
                    String string6 = Token.getStringAfterToken(string, "TO");
                    boolean bl = false;
                    if (Token.hasToken(string6, "GRANT")) {
                        string6 = Token.getStringBeforeToken(string6, "WITH");
                        bl = true;
                    }
                    Iterator iterator = abstractStorageDesignDB2.getBufferPoolSet().iterator();
                    while (iterator.hasNext()) {
                        BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)iterator.next();
                        StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string7 = stringTokenizer.nextToken().trim();
                            if (abstractStorageDesignDB2.getOwnerSet().getByName(string7) == null) {
                                Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(null);
                                owner.setName(string7);
                                this.design.getRelationalDesign().stampModelObjectDDL(owner);
                            }
                            bufferPoolDB2.setUsers(string7);
                        }
                        if (bl) {
                            bufferPoolDB2.setGrantOption("YES");
                        }
                        bufferPoolDB2.setAllBufferpools("YES");
                    }
                    break block18;
                }
                if (!string2.equalsIgnoreCase("STOGROUP")) break block20;
                String string8 = Token.getStringAfterToken(string, "STOGROUP");
                string8 = Token.getStringBeforeToken(string8, "TO");
                String string9 = Token.getStringAfterToken(string, "TO");
                boolean bl = false;
                if (Token.hasToken(string9, "GRANT")) {
                    string9 = Token.getStringBeforeToken(string9, "WITH");
                    bl = true;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string8, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    StorageGroupDB2 storageGroupDB2 = abstractStorageDesignDB2.getStorageGroupSet().getOrCreateStorageGroup(stringTokenizer.nextToken().trim());
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string9, ",");
                    while (stringTokenizer3.hasMoreTokens()) {
                        String string10 = stringTokenizer3.nextToken().trim();
                        Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string10);
                        if (owner == null) {
                            owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(null);
                            owner.setName(string10);
                            this.design.getRelationalDesign().stampModelObjectDDL(owner);
                        }
                        storageGroupDB2.setUsers(owner.getName());
                    }
                    if (!bl) continue;
                    storageGroupDB2.setGrantOption("YES");
                }
                break block18;
            }
            if (!string2.equalsIgnoreCase("TABLESPACE")) break block18;
            String string11 = Token.getStringAfterToken(string, "TABLESPACE");
            string11 = Token.getStringBeforeToken(string11, "TO");
            String string12 = Token.getStringAfterToken(string, "TO");
            boolean bl = false;
            if (Token.hasToken(string12, "GRANT")) {
                string12 = Token.getStringBeforeToken(string12, "WITH");
                bl = true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string11, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string13 = stringTokenizer.nextToken().trim();
                TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)abstractStorageDesignDB2.getTableSpaceSet().getByName(string13);
                StringTokenizer stringTokenizer4 = new StringTokenizer(string12, ",");
                while (stringTokenizer4.hasMoreTokens()) {
                    String string14 = stringTokenizer4.nextToken().trim();
                    if (abstractStorageDesignDB2.getOwnerSet().getByName(string14) == null) {
                        Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(null);
                        owner.setName(string14);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    tableSpaceDB2.setUsers(string14);
                }
                if (!bl) continue;
                tableSpaceDB2.setGrantOption("YES");
            }
        }
    }

    private void parseGrantExecuteOnProcedure(String string) {
        String string2 = Token.getStringAfterToken(string, "PROCEDURE");
        string2 = Token.getStringBeforeToken(string2, "TO");
        String string3 = Token.getStringAfterToken(string, "TO");
        boolean bl = false;
        if (Token.hasToken(string3, "GRANT")) {
            string3 = Token.getStringBeforeToken(string3, "WITH");
            bl = true;
        }
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            StoredProcedureDB2 storedProcedureDB2 = (StoredProcedureDB2)abstractStorageDesignDB2.getStoredProcedureSet().getByName(stringTokenizer.nextToken().trim());
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                String string4 = stringTokenizer2.nextToken().trim();
                if (abstractStorageDesignDB2.getOwnerSet().getByName(string4) == null) {
                    Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(null);
                    owner.setName(string4);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                storedProcedureDB2.setUsers(string4);
            }
            if (!bl) continue;
            storedProcedureDB2.setGrantOption("YES");
        }
    }

    private void parseGrantDatabase(String string) {
        String string2 = Token.getStringAfterToken(string, "GRANT");
        string2 = Token.getStringBeforeToken(string2, "ON");
        String string3 = Token.getStringAfterToken(string, "DATABASE");
        string3 = Token.getStringBeforeToken(string3, "TO");
        String string4 = Token.getStringAfterToken(string, "TO");
        boolean bl = false;
        if (Token.hasToken(string4, "GRANT")) {
            string4 = Token.getStringBeforeToken(string4, "WITH");
            bl = true;
        }
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            DataBaseDB2 dataBaseDB2 = (DataBaseDB2)abstractStorageDesignDB2.getDataBaseSet().getByName(string5);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                Owner owner;
                String string6 = stringTokenizer2.nextToken().trim();
                PrivilegesDB2 privilegesDB2 = this.getPrivileges(dataBaseDB2, string6);
                if (abstractStorageDesignDB2.getOwnerSet().getByName(string6) == null) {
                    owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(null);
                    owner.setName(string6);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                } else {
                    owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string6);
                }
                privilegesDB2.setUser(owner);
                StringTokenizer stringTokenizer3 = new StringTokenizer(string2, ",");
                while (stringTokenizer3.hasMoreTokens()) {
                    privilegesDB2.setSystemPrivileges(stringTokenizer3.nextToken().trim());
                }
                if (!bl) continue;
                privilegesDB2.setGrantOption("YES");
            }
        }
    }

    private void parseSystemPrivileges(String string) {
        String string2 = Token.getStringAfterToken(string, "GRANT");
        string2 = Token.getStringBeforeToken(string2, "TO");
        String string3 = Token.getStringAfterToken(string, "TO");
        boolean bl = false;
        if (Token.hasToken(string3, "GRANT")) {
            string3 = Token.getStringBeforeToken(string3, "WITH");
            bl = true;
        }
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Owner owner;
            String string4 = stringTokenizer.nextToken().trim();
            if (abstractStorageDesignDB2.getOwnerSet().getByName(string4) == null) {
                owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(null);
                owner.setName(string4);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            } else {
                owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string4);
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                owner.setSystemPrivileges(stringTokenizer2.nextToken().trim());
            }
            if (!bl) continue;
            owner.setGrantOption("YES");
        }
    }

    private PrivilegesDB2 getPrivileges(DataBaseDB2 dataBaseDB2, Object object) {
        PrivilegesDB2 privilegesDB2;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        Iterator iterator = abstractStorageDesignDB2.getPrivilegesSet().iterator();
        while (iterator.hasNext()) {
            privilegesDB2 = (PrivilegesDB2)iterator.next();
            if (privilegesDB2.getDb() != dataBaseDB2 || privilegesDB2.getUser() != object) continue;
            return privilegesDB2;
        }
        privilegesDB2 = abstractStorageDesignDB2.getPrivilegesSet().createPriv();
        privilegesDB2.setDb(dataBaseDB2);
        return privilegesDB2;
    }

    private void grantPermissions(String string) {
        this.statement = string.replaceAll("\"", "");
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            ArrayList arrayList = this.initUsers();
            StorageObject storageObject = this.initOn();
            if (storageObject != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.permissions = this.getPermissionForUser((StorageObject)arrayList.get(i), storageObject) != null ? this.getPermissionForUser((StorageObject)arrayList.get(i), storageObject) : this.storageDesign.getPermissionsSet().createPermissions();
                    if (this.permissions == null) continue;
                    this.initPrivileges();
                    this.initOnObject(storageObject);
                    this.initTo(arrayList.get(i));
                }
            }
        }
    }

    private PermissionsDB2 getPermissionForUser(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        PermissionsDB2 permissionsDB2 = null;
        while (iterator.hasNext()) {
            permissionsDB2 = (PermissionsDB2)iterator.next();
            if (permissionsDB2.getUser() != storageObject || permissionsDB2.getTable() != storageObject2 && permissionsDB2.getView() != storageObject2 && permissionsDB2.getAuxTable() != storageObject2) continue;
            return permissionsDB2;
        }
        return null;
    }

    private ArrayList initUsers() {
        ArrayList<Owner> arrayList = new ArrayList<Owner>();
        String string = Token.getStringAfter(this.statement, "TO").trim();
        if (Token.hasToken(string, "WITH")) {
            string = Token.getStringBeforeToken(string, "WITH");
        }
        if (!string.equalsIgnoreCase("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                Owner owner;
                string2 = stringTokenizer.nextToken().trim();
                OwnerSet ownerSet = this.storageDesign.getOwnerSet();
                if (ownerSet.getByName(string2) == null) {
                    owner = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                    owner.setName(string2);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                } else {
                    owner = (Owner)ownerSet.getByName(string2);
                }
                arrayList.add(owner);
            }
        }
        return arrayList;
    }

    private void initPrivileges() {
        Object object;
        String string = Token.getStringAfter(this.statement.toUpperCase(), "GRANT").trim();
        if (Token.hasCloseAndOpenBrackets(string = Token.getStringBeforeToken(string, "ON"))) {
            object = Token.getValBetweenBrackets(string).trim();
            string = Token.getStringBefore(string, "(").trim();
            this.initColumns((String)object, string);
        }
        if (this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1) {
            object = new StringTokenizer(string, ",");
            String string2 = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken().trim();
                this.permissions.setPrivilegesWithGrantOption(string2);
            }
        } else {
            object = new StringTokenizer(string, ",");
            String string3 = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken().trim();
                this.permissions.setPrivileges(string3);
            }
        }
    }

    private void initColumns(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if (string3.equalsIgnoreCase("") || this.table == null || this.table.getColumn(string3) == null) continue;
            string3 = string3 + ", " + string2;
            this.permissions.setColumnList(string3);
        }
    }

    private StorageObject initOn() {
        String string = Token.getStringAfterToken(this.statement, "ON").trim();
        if (string.toUpperCase().startsWith("TABLE")) {
            string = Token.cutFirstToken(string);
        }
        if ((string = Token.getStringBeforeToken(string, "TO")).indexOf(46) > -1) {
            string = string.substring(string.indexOf(46) + 1);
        }
        if (!(string = Token.getValBetweenSquareBrackets(string)).equalsIgnoreCase("")) {
            this.table = ((TableProxySetDB2)this.storageDesign.getTableProxySet()).getByName(string);
            if (this.table != null) {
                return this.table;
            }
            this.view = ((TableViewProxySetDB2)this.storageDesign.getTableViewProxySet()).getByName(string);
            if (this.view != null) {
                return this.view;
            }
            this.auxTable = (AUXTableDB2)this.storageDesign.getAUXTableSet().getByName(string);
            if (this.auxTable != null) {
                return this.auxTable;
            }
        }
        this.importLog.addError("Error in setting object of permission " + this.statement);
        return null;
    }

    private void initOnObject(StorageObject storageObject) {
        if (storageObject instanceof TableProxyDB2) {
            this.permissions.setTable((TableProxyDB2)storageObject);
        } else if (storageObject instanceof TableViewProxyDB2) {
            this.permissions.setView((TableViewProxyDB2)storageObject);
        } else if (storageObject instanceof AUXTableDB2) {
            this.permissions.setAuxTable((AUXTableDB2)storageObject);
        }
    }

    private void initTo(Object object) {
        String string = Token.getStringAfter(this.statement.toUpperCase(), "TO").trim();
        if (Token.hasToken(string, "WITH")) {
            string = Token.getStringBeforeToken(string, "WITH");
        }
        if (!string.equalsIgnoreCase("")) {
            if (object instanceof Owner) {
                this.permissions.setUser((Owner)object);
            }
        } else {
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }
}

