/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTriggerDB2
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTriggerDB2.class);
    private TriggerDB2 trigger;
    private String line;
    private AbstractStorageDesignDB2 storageDesign;

    public SHCreateTriggerDB2(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateTriggerDB2.clearCR(string);
        this.line = string;
        if (Token.startsWithString(string2, "create trigger")) {
            this.parseTrigger(string2.replaceAll("\"", ""));
        } else {
            this.nextHandler(string);
        }
    }

    private void parseTrigger(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (this.storageDesign != null) {
            this.trigger = this.storageDesign.getTriggerSet().createTrigger();
            if (this.trigger != null) {
                try {
                    this.initTriggerName();
                    this.initTriggeringTime();
                    this.initAction();
                    this.initOnTable();
                    this.initReferencing();
                    this.initScope();
                    this.initCondition();
                    this.initBody();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.trigger);
                    this.importLog.incrementImportedStatements();
                }
                catch (ParseException parseException) {
                    LOGGER.error("Parsing " + string + " for DB2 failed!");
                    this.importLog.addFailedStatement(SHCreateTriggerDB2.FormatCR(this.line, "\n"));
                }
            }
        }
    }

    private void initTriggerName() {
        String string = Token.getTokenAfter(this.statement, "TRIGGER").trim();
        if (string.indexOf(46) > -1) {
            String string2 = string.substring(0, string.indexOf(46));
            string2 = Token.getValBetweenSquareBrackets(string2);
            Owner owner = (Owner)this.storageDesign.getOwnerSet().getByName(string2);
            if (owner != null) {
                this.trigger.setOwner(owner);
            } else {
                Owner owner2 = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                owner2.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(owner2);
                this.trigger.setOwner(owner2);
            }
            string = string.substring(string.indexOf(46) + 1);
        } else {
            this.trigger.setOwner(this.storageDesign.getOwnerSet().getDefaultOwner());
        }
        this.trigger.setName(string);
    }

    private void initTriggeringTime() throws ParseException {
        if (Token.hasString(this.statement, "NO CASCADE BEFORE")) {
            this.trigger.setTriggerTime(TriggerDB2.TRIGGER_TIMES[0]);
        } else if (Token.hasString(this.statement, "AFTER")) {
            this.trigger.setTriggerTime(TriggerDB2.TRIGGER_TIMES[1]);
        } else {
            this.importLog.addError("Unknown triggering time for trigger " + this.trigger.getName());
            throw new ParseException("Error parsing triggering time for trigger " + this.trigger.getName() + "(DB2) ");
        }
    }

    private void initAction() throws ParseException {
        String string = this.trigger.getTriggerTime();
        if (string != null) {
            String string2 = Token.getStringAfter(this.statement, string);
            String string3 = Token.getTokenAfter(this.statement, string);
            this.trigger.setActions(string3);
            if (string3.equalsIgnoreCase("UPDATE")) {
                String string4 = Token.getFirstToken(string2 = Token.getStringAfter(string2, "UPDATE").trim()).trim();
                if (string4.equalsIgnoreCase("OF")) {
                    string2 = string2.substring(2, string2.indexOf(" ON "));
                    this.trigger.setColumns(string2);
                } else {
                    this.importLog.addError("Cannot find specified columns for UPDATE action while parsing trigger " + this.trigger.getName() + "(DB2)");
                    throw new ParseException("Cannot find specified columns for UPDATE action while parsing trigger " + this.trigger.getName() + "(DB2) ");
                }
            }
        }
    }

    private void initOnTable() throws ParseException {
        String string = this.statement.substring(this.statement.indexOf(" ON ") + 3).trim();
        string = Token.getFirstToken(string);
        String string2 = Token.getLastToken(string);
        if (((TableProxySetDB2)this.storageDesign.getTableProxySet()).getByName(string2) == null) {
            this.importLog.addError("Specified table on trigger " + this.trigger.getName() + "does not exist");
            throw new ParseException("Specified table on trigger " + this.trigger.getName() + "does not exist");
        }
        this.trigger.setTable(((TableProxySetDB2)this.storageDesign.getTableProxySet()).getByName(string2));
    }

    private void initReferencing() {
        if (Token.hasString(this.statement, "REFERENCING")) {
            String string;
            String string2 = Token.getStringAfter(this.statement, "REFERENCING");
            if (Token.hasString(string2, "OLD AS ")) {
                string = string2.substring(string2.indexOf("OLD AS ") + 6);
                this.trigger.setRef_OLD_AS(Token.getFirstToken(string));
            } else if (Token.hasString(string2, "OLD_AS ")) {
                string = string2.substring(string2.indexOf("OLD_AS ") + 6);
                this.trigger.setRef_OLD_AS(Token.getFirstToken(string));
            } else {
                string = Token.getStringAfter(string2, " OLD ").trim();
                if (!string.equalsIgnoreCase("") && !Token.getFirstToken(string).equalsIgnoreCase("TABLE")) {
                    this.trigger.setRef_OLD_AS(Token.getFirstToken(string));
                }
            }
            if (Token.hasString(string2, "NEW AS ")) {
                string = string2.substring(string2.indexOf("NEW AS ") + 6);
                this.trigger.setRef_NEW_AS(Token.getFirstToken(string));
            } else if (Token.hasString(string2, "NEW_AS ")) {
                string = string2.substring(string2.indexOf("NEW_AS ") + 6);
                this.trigger.setRef_NEW_AS(Token.getFirstToken(string));
            } else {
                string = Token.getStringAfter(string2, " NEW ").trim();
                if (!string.equalsIgnoreCase("") && !Token.getFirstToken(string).equalsIgnoreCase("TABLE")) {
                    this.trigger.setRef_NEW_AS(Token.getFirstToken(string));
                }
            }
            if (Token.hasString(string2, "OLD TABLE AS ")) {
                string = string2.substring(string2.indexOf("OLD TABLE AS ") + 13);
                this.trigger.setOLD_TABLE_AS(Token.getFirstToken(string));
            }
            if (Token.hasString(string2, "NEW TABLE AS ")) {
                string = string2.substring(string2.indexOf("NEW TABLE AS ") + 13);
                this.trigger.setNEW_TABLE_AS(Token.getFirstToken(string));
            }
        }
    }

    private void initScope() throws ParseException {
        if (Token.hasString(this.statement, "FOR EACH ROW")) {
            this.trigger.setScope(TriggerDB2.SCOPE_TYPES[0]);
        } else if (Token.hasString(this.statement, "FOR EACH STATEMENT")) {
            this.trigger.setScope(TriggerDB2.SCOPE_TYPES[1]);
        } else {
            this.importLog.addError("Scope is not specified on trigger " + this.trigger.getName());
            throw new ParseException("Scope is not specified on trigger " + this.trigger.getName());
        }
    }

    private void initCondition() {
        if (Token.hasString(this.statement, "WHEN")) {
            String string = Token.getStringAfter(this.statement, "WHEN");
            this.trigger.setCondition(Token.getValBetweenBrackets(string, 1).trim());
        }
    }

    private void initBody() throws ParseException {
        if (Token.hasString(this.statement, " BEGIN ATOMIC ")) {
            String string = Token.getStringAfter(this.statement, " BEGIN ATOMIC ").trim();
            if (string.endsWith("END")) {
                this.trigger.setBody(string.substring(0, string.length() - 3));
            } else {
                this.importLog.addError("Incorrect syntax of body on trigger " + this.trigger.getName());
                throw new ParseException("Incorrect syntax of body on trigger " + this.trigger.getName());
            }
        }
    }
}

