/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.db2.SHColumnElements;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.ConstraintType;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.ColumnProxyDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTable
extends DDLStatementHandler
implements SectionConstants,
CreateTableHandler {
    protected LogicalDatatypeFactory factoryLogicalDatatype = new LogicalDatatypeFactory();
    protected Table table = null;
    protected RDBMSSite site = null;
    protected StorageDesignDB2v70 storageDesign = null;
    protected TableProxyDB2 tableProxy = null;
    private boolean createDomainsDuringImport;
    protected String tableName;
    protected String ownerName = null;
    protected ArrayList columns;
    protected List fkList;
    protected List refAtColumnList;
    protected List tableNodeList = new ArrayList();
    protected String inTablespace;
    protected String inDatabase;
    protected String editproc;
    protected String validproc;
    protected String audit;
    protected String obid;
    protected boolean dataCapture;
    protected boolean restrict;
    protected String ccsid;
    protected String outSideBrackets;
    protected String inSideBrackets;
    private boolean failed = false;
    protected static final Logger LOGGER = new Logger(SHCreateTable.class);

    public SHCreateTable(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        block7: {
            String string2 = SHCreateTable.clearCR(string);
            if (!Token.startsWithString(string2, "create aux")) {
                if (Token.startsWithString(string2, "create table")) {
                    try {
                        this.fkList = new ArrayList();
                        this.refAtColumnList = new ArrayList();
                        this.parseTable(string2);
                        FKRefNode fKRefNode = new FKRefNode();
                        fKRefNode.processedTable = this.table;
                        fKRefNode.fkStatements = this.fkList;
                        fKRefNode.refAtColumns = this.refAtColumnList;
                        this.tableNodeList.add(fKRefNode);
                        if (this.failed) {
                            this.importLog.addFailedStatement(SHCreateTable.FormatCR(string, "\n"));
                            break block7;
                        }
                        this.importLog.incrementImportedStatements();
                    }
                    catch (Exception exception) {
                        LOGGER.error(" Parsing " + string2 + " for DB2 failed!", exception);
                        this.importLog.addFailedStatement(SHCreateTable.FormatCR(string, "\n"));
                    }
                } else {
                    this.nextHandler(string);
                }
            } else {
                this.nextHandler(string);
            }
        }
    }

    protected void parseTable(String string) {
        Object object;
        int n;
        this.setStatement(string);
        this.outSideBrackets = Token.getValOutsideBrackets(this.statement);
        this.inSideBrackets = Token.getValBetweenBrackets(this.statement);
        this.ownerName = null;
        this.tableName = this.initTableName();
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignDB2v70)this.design.getStorageDesign(this.site);
        if (this.storageDesign.importStorageObjectsOnly()) {
            this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(this.tableName);
        } else {
            this.table = this.design.getRelationalDesign().createTable();
            this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        }
        if (this.ownerName != null && !"".equals(this.ownerName)) {
            this.table.setSchema(this.ownerName);
        }
        this.table.setName(this.tableName);
        this.tableProxy = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.createDomainsDuringImport = this.storageDesign.getDesign().getAppView().getSettings().isCreateDomainsDuringImport();
        this.columns = this.initColumns();
        for (n = 0; n < this.columns.size(); ++n) {
            CharSequence charSequence;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            object = (Map)this.columns.get(n);
            boolean bl = (Boolean)object.get("IS_CONSTRAINT");
            if (!bl) {
                Object object6;
                ModelIDObject modelIDObject;
                Object object7;
                String string2;
                String string3 = (String)object.get("columnname");
                if (this.storageDesign.importStorageObjectsOnly()) {
                    object5 = (Column)this.table.getElementByName(string3);
                } else {
                    Object object8;
                    object5 = this.table.createColumn(string3);
                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object5);
                    string2 = (String)object.get("datatype");
                    object7 = (String)object.get("scale");
                    object4 = (String)object.get("size");
                    object3 = (String[])object.get("precision");
                    object2 = new String[]{object3, object7, object4};
                    charSequence = StandardDatatypeNames.getUsedDatatypeName(string2);
                    modelIDObject = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), (String)charSequence);
                    if (this.createDomainsDuringImport) {
                        Domain domain = null;
                        String string4 = (String)object.get("typename");
                        if (string4 != null) {
                            object8 = this.design.getDomainSet();
                            domain = (Domain)((DesignObjectSet)object8).getByName(string4);
                        }
                        object8 = "";
                        if (domain == null) {
                            object8 = DomainFactory.createDomainName((LogicalDatatype)modelIDObject, (String[])object2);
                            domain = this.getCorrespondingDomain((String)object8);
                        }
                        if (domain != null) {
                            ((Column)object5).setDomain(domain);
                        } else {
                            object6 = new StringBuffer("domain is null in SHCreateTable.parseTable: ");
                            ((StringBuffer)object6).append((String)object8);
                            LOGGER.error(((StringBuffer)object6).toString());
                            this.importLog.addError("Null domain occurred while creating " + this.tableName);
                        }
                    } else {
                        ((ContainedObjectWithDomain)object5).setLogicalDatatype((LogicalDatatype)modelIDObject);
                        ((ContainedObjectWithDomain)object5).setUse((short)1);
                        ((ContainedObjectWithDomain)object5).setDataTypeParameter("scale", (String)object7);
                        ((ContainedObjectWithDomain)object5).setDataTypeParameter("precision", (String)object3);
                        ((ContainedObjectWithDomain)object5).setDataTypeParameter("size", (String)object4);
                    }
                    boolean bl2 = (Boolean)object.get("NOT NULL");
                    ((ContainedObject)object5).setNullsAllowed(!bl2);
                    boolean bl3 = (Boolean)object.get("PRIMARY KEY");
                    if (bl3) {
                        object8 = this.table.createIndex();
                        ((Index)object8).add((ContainedObject)object5);
                        ((KeyObject)object8).makePK();
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object8);
                    } else {
                        boolean bl4 = (Boolean)object.get("UNIQUE");
                        if (bl4) {
                            object6 = this.table.createIndex();
                            ((Index)object6).add((ContainedObject)object5);
                            ((Index)object6).setIndexState("Unique Constraint");
                            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object6);
                        }
                    }
                }
                if (this.storageDesign != null) {
                    string2 = (String)object.get("FOR");
                    object7 = (String)object.get("DEFAULT");
                    object4 = (ColumnProxyDB2v70)this.storageDesign.getColumnProxySet().getProxy(((ModelIDObject)object5).getObjectID());
                    ((ColumnProxyDB2)object4).setBitData(string2);
                    object3 = ColumnProxyDB2.getDefaultValueChoices();
                    if (object7 != null) {
                        boolean bl5 = (Boolean)object.get("IS DEFAULT");
                        ((ColumnProxyDB2)object4).setDefault(bl5);
                        if (((String)object7).equalsIgnoreCase(object3[2]) || ((String)object7).equalsIgnoreCase((String)object3[3])) {
                            ((ColumnProxyDB2)object4).setDefaultValue((String)object7);
                        } else if (Token.hasCloseAndOpenBrackets((String)object7)) {
                            ((ColumnProxyDB2)object4).setDefaultValue((String)object3[4]);
                            ((ColumnProxyDB2)object4).setDefaultValueConstant((String)object7);
                        } else {
                            ((ColumnProxyDB2)object4).setDefaultValue((String)object3[1]);
                            ((ColumnProxyDB2)object4).setDefaultValueConstant((String)object7);
                            ((ContainedObjectWithDomain)object5).setDefaultValue((String)object7);
                        }
                    }
                    if ((object2 = (String)object.get("FIELDPROC")) != null) {
                        if (Token.hasCloseAndOpenBrackets((String)object2)) {
                            charSequence = Token.getValBetweenBrackets((String)object2).trim();
                            ((ColumnProxyDB2)object4).setConstant((String)charSequence);
                            object2 = Token.getValBeforeBrackets((String)object2).trim();
                        }
                        ((ColumnProxyDB2)object4).setProgram((String)object2);
                    }
                    if ((charSequence = (String)object.get("GENERATED")) != null) {
                        String string5;
                        CharSequence charSequence2;
                        String string6;
                        String string7;
                        String string8;
                        modelIDObject = this.storageDesign.getColumnIdentitySet().createColumnIdentity();
                        this.design.getRelationalDesign().stampModelObjectDDL(modelIDObject);
                        ((ColumnIdentityDB2)modelIDObject).setColumn((ColumnProxyDB2)object4);
                        for (int i = 0; i < ColumnIdentityDB2.getGenerateValues().length; ++i) {
                            String string9 = ColumnIdentityDB2.getGenerateValues()[i];
                            if (!((String)charSequence).equalsIgnoreCase(string9)) continue;
                            ((ColumnIdentityDB2)modelIDObject).setGenerate(string9);
                            break;
                        }
                        if ((string8 = (String)object.get("START")) != null) {
                            ((ColumnIdentityDB2)modelIDObject).setStartWith(string8);
                        }
                        if ((string7 = (String)object.get("INCREMENT")) != null) {
                            try {
                                int n2 = Integer.parseInt(string7);
                                ((ColumnIdentityDB2)modelIDObject).setIncrementBy(n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                object6 = new StringBuffer("wrong Format for Increment value in SHCreateTable -> Init Identity: ");
                                LOGGER.error(((StringBuffer)object6).toString(), numberFormatException);
                                this.importLog.addWarning("Wrong format for Increment value of table " + this.tableName);
                            }
                        }
                        if ((string6 = (String)object.get("CACHE")) != null) {
                            try {
                                int n3 = Integer.parseInt(string6);
                                ((ColumnIdentityDB2)modelIDObject).setCache(n3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                charSequence2 = new StringBuffer("wrong Format for Cache value in SHCreateTable -> Init Identity: ");
                                LOGGER.error(charSequence2.toString(), numberFormatException);
                                this.importLog.addWarning("Wrong format for Cache value of table " + this.tableName);
                            }
                        }
                        if ((object6 = object.get("CYCLE")) != null) {
                            boolean bl6 = (Boolean)object.get("CYCLE");
                            ((ColumnIdentityDB2)modelIDObject).setCycle(bl6);
                        }
                        if ((charSequence2 = (String)object.get("MAXVALUE")) != null) {
                            try {
                                Integer.parseInt((String)charSequence2);
                                ((ColumnIdentityDB2)modelIDObject).setMaxValue((String)charSequence2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                StringBuffer stringBuffer = new StringBuffer("wrong Format for MAXVALUE value in SHCreateTable -> Init Identity: ");
                                LOGGER.error(stringBuffer.toString(), numberFormatException);
                                this.importLog.addWarning("Wrong format for maxvalue value of table " + this.tableName);
                            }
                        }
                        if ((string5 = (String)object.get("MINVALUE")) != null) {
                            try {
                                Integer.parseInt(string5);
                                ((ColumnIdentityDB2)modelIDObject).setMinValue(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                StringBuffer stringBuffer = new StringBuffer("wrong Format for MINVALUE value in SHCreateTable -> Init Identity: ");
                                LOGGER.error(stringBuffer.toString(), numberFormatException);
                                this.importLog.addWarning("Wrong format for minvalue value of table " + this.tableName);
                            }
                        }
                        ((ColumnProxyDB2)object4).setColumnIdentity((ColumnIdentityDB2)modelIDObject);
                    }
                }
                if ((string2 = (String)object.get("REFERENCES")) != null) {
                    object7 = new RefAtColNode();
                    int n4 = string2.indexOf(46);
                    if (n4 > 0) {
                        string2 = Token.getValAfterCharacter(string2, '.');
                    }
                    ((RefAtColNode)object7).onDelete = (String)object.get("ON DELETE");
                    ((RefAtColNode)object7).columnName = (String)object.get("columnname");
                    ((RefAtColNode)object7).refColumn = (String)object.get("REFERENCED_COLUMN");
                    ((RefAtColNode)object7).referencedTable = string2;
                    this.refAtColumnList.add(object7);
                }
                object7 = (String)object.get("CONSTRAINT");
                object4 = (String)object.get("CHECK");
                if (object4 == null) continue;
                this.initCheckConstraint((String)object4, (String)object7, (Column)object5);
                continue;
            }
            object5 = (String)object.get("CONSTRAINT_NAME");
            boolean bl7 = (Boolean)object.get("PRIMARY KEY");
            if (bl7) {
                Index index;
                if (this.storageDesign.importStorageObjectsOnly()) {
                    index = (Index)this.table.getPK();
                } else {
                    index = this.table.createIndex();
                    this.design.getRelationalDesign().stampModelObjectDDL(index);
                }
                String string10 = null;
                if (!"".equalsIgnoreCase((String)object5)) {
                    int n5 = ((String)object5).indexOf(46);
                    if (n5 > 0) {
                        string10 = Token.getValBeforeCharacter((String)object5, '.');
                        object5 = Token.getValAfterCharacter((String)object5, '.');
                    }
                    if (!this.storageDesign.importStorageObjectsOnly()) {
                        index.setName((String)object5);
                    }
                } else {
                    if (this.tableName.length() > 15) {
                        this.tableName = this.tableName.substring(0, 15);
                    }
                    if (!this.storageDesign.importStorageObjectsOnly()) {
                        index.setName(this.tableName + "_PK");
                    }
                }
                object4 = (String)object.get("CONSTRAINT_VALUE");
                try {
                    if (!this.storageDesign.importStorageObjectsOnly()) {
                        SHCreateTable.setColumnsForIndexPK(index, (String)object4, this.importLog);
                        index.makePK();
                    }
                    if ((object3 = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID())) == null) continue;
                    ((RelationalObjectProxy)object3).setName(index.getName());
                    if (string10 == null) continue;
                    object2 = (Owner)this.storageDesign.getOwnerSet().getByName(string10);
                    if (object2 == null) {
                        object2 = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                        ((StorageObject)object2).setName(string10);
                        this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                    }
                    ((IndexProxyDB2)object3).setOwner((Owner)object2);
                }
                catch (ObjectDoesNotExistException objectDoesNotExistException) {
                    object2 = new StringBuffer(objectDoesNotExistException.getMessage());
                    ((StringBuffer)object2).append(" in SHCreateTable.parseTable: PRIMARY KEY");
                    LOGGER.error(((StringBuffer)object2).toString(), objectDoesNotExistException);
                    this.importLog.addError("Columns for primary key " + index.getName() + " don't exist.");
                    this.failed = true;
                }
                continue;
            }
            boolean bl8 = (Boolean)object.get("UNIQUE");
            if (bl8) {
                String string11 = null;
                if (!"".equalsIgnoreCase((String)object5)) {
                    int n6 = ((String)object5).indexOf(46);
                    if (n6 > 0) {
                        string11 = Token.getValBeforeCharacter((String)object5, '.');
                        object5 = Token.getValAfterCharacter((String)object5, '.');
                    }
                } else {
                    if (this.tableName.length() > 13) {
                        this.tableName = this.tableName.substring(0, 13);
                    }
                    object5 = this.tableName + "_UK" + this.table.getUKeys().size();
                }
                if (this.storageDesign.importStorageObjectsOnly()) {
                    object4 = this.table.getIndexByName((String)object5);
                } else {
                    object4 = this.table.createIndex();
                    ((DesignObject)object4).setName((String)object5);
                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object4);
                }
                if (!this.storageDesign.importStorageObjectsOnly()) {
                    object3 = (String)object.get("CONSTRAINT_VALUE");
                    try {
                        SHCreateTable.setColumnsForIndexPK((Index)object4, (String)object3, this.importLog);
                        ((Index)object4).setIndexState("Unique Constraint");
                    }
                    catch (ObjectDoesNotExistException objectDoesNotExistException) {
                        charSequence = new StringBuffer(objectDoesNotExistException.getMessage());
                        ((StringBuffer)charSequence).append(" in SHCreateTable.parseTable:UNIQUE");
                        LOGGER.error(((StringBuffer)charSequence).toString(), objectDoesNotExistException);
                        this.importLog.addError("Columns for unique key " + ((DesignObject)object4).getName() + " don't exist.");
                        this.failed = true;
                    }
                    ((Index)object4).setIndexState("Unique Constraint");
                }
                if ((object3 = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(((ModelIDObject)object4).getObjectID())) == null) continue;
                ((RelationalObjectProxy)object3).setName(((DesignObject)object4).getName());
                if (string11 == null) continue;
                object2 = (Owner)this.storageDesign.getOwnerSet().getByName(string11);
                if (object2 == null) {
                    object2 = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                    ((StorageObject)object2).setName(string11);
                    this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object2);
                }
                ((IndexProxyDB2)object3).setOwner((Owner)object2);
                continue;
            }
            boolean bl9 = (Boolean)object.get("CHECK");
            if (!bl9) continue;
            object4 = (String)object.get("CONSTRAINT_VALUE");
            if (this.tableName.length() > 13) {
                this.tableName = this.tableName.substring(0, 13);
            }
            object3 = this.table.createCheckConstraint(this.tableName + "_CK" + this.table.getCheckConstraints().size(), (String)object4);
            if (!"".equalsIgnoreCase((String)object5)) {
                ((DesignObject)object3).setName((String)object5);
            }
            this.table.addCheckConstraint((TableLevelConstraint)object3);
            this.design.getRelationalDesign().stampModelObjectDDL((ModelObject)object3);
        }
        this.initDatabaseTablespace();
        if (this.tableProxy != null) {
            TableSpaceSetDB2 tableSpaceSetDB2 = this.storageDesign.getTableSpaceSet();
            object = tableSpaceSetDB2.getOrCreateTablespace(this.inDatabase, this.inTablespace);
            this.tableProxy.setTableSpace((TableSpaceDB2)object);
            if (this.ownerName != null) {
                Owner owner = (Owner)((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().getByName(this.ownerName);
                if (owner == null) {
                    owner = (Owner)((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().createElement(null);
                    owner.setName(this.ownerName);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                this.tableProxy.setOwner(owner);
            } else if (this.getOwner() != null) {
                this.tableProxy.setOwner(this.getOwner());
            } else {
                this.tableProxy.setOwner(this.storageDesign.getOwnerSet().getDefaultOwner());
            }
        }
        this.editproc = this.initEditProc();
        if (this.tableProxy != null && !this.editproc.equals(" ") && this.editproc != null && !this.editproc.equals("")) {
            this.tableProxy.setEditProc(this.editproc);
        }
        this.validproc = this.initValidProc();
        if (this.tableProxy != null && !this.validproc.equals(" ") && this.validproc != null && !this.validproc.equals("")) {
            this.tableProxy.setValidProc(this.validproc);
        }
        this.audit = this.initAudit();
        if (this.tableProxy != null && !this.audit.equals(" ") && this.audit != null && !this.audit.equals("")) {
            this.tableProxy.setAudit(this.audit);
        }
        this.obid = this.initObid();
        if (this.tableProxy != null) {
            try {
                if (!this.obid.equals(" ") && this.obid != null && !this.obid.equals("")) {
                    this.tableProxy.setObid(Integer.parseInt(this.obid));
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new StringBuffer("wrong Format for Obid in SHCreateTable.parseTable : ");
                LOGGER.error(((StringBuffer)object).toString(), numberFormatException);
                this.importLog.addWarning("Wrong format in Obid in statement " + string);
            }
        }
        this.dataCapture = this.initDataCapture();
        if (this.tableProxy != null) {
            this.tableProxy.setDataCapture(this.dataCapture);
        }
        this.restrict = this.initWithRestrictOnDrop();
        if (this.tableProxy != null) {
            this.tableProxy.setDropRestrict(this.restrict);
        }
        this.ccsid = this.initCcsid();
        if (this.tableProxy != null) {
            for (n = 0; n < TableProxyDB2.getCcsidValues().length; ++n) {
                object = TableProxyDB2.getCcsidValues()[n];
                if (!this.ccsid.equalsIgnoreCase((String)object)) continue;
                this.tableProxy.setCcsid((String)object);
                break;
            }
        }
    }

    private String initTableName() {
        String string = Token.getNameAfterToken(this.outSideBrackets, "TABLE", '\"', '\"').trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.ownerName = Token.getValBeforeCharacter(string, '.');
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    public static void setColumnsForIndexPK(Index index, String string, ImportLogger importLogger) throws ObjectDoesNotExistException {
        if (index != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                arrayList.add(string2);
            }
            for (String string3 : arrayList) {
                Column column = (Column)index.getTable().getElementByName(string3);
                if (column != null) {
                    index.add(column);
                    continue;
                }
                importLogger.addError("Column for index " + index.getName() + " doesn't exist.");
                throw new ObjectDoesNotExistException("Column");
            }
        }
    }

    private void initDatabaseTablespace() {
        String string = Token.getTokenAfter(this.outSideBrackets, "IN");
        if (string.equalsIgnoreCase("DATABASE")) {
            this.inTablespace = "";
            this.inDatabase = "";
        } else if (string.indexOf(46) > 0) {
            this.inTablespace = Token.getValAfterCharacter(string, '.');
            this.inDatabase = Token.getValBeforeCharacter(string, '.');
        } else {
            this.inTablespace = string;
            this.inDatabase = "";
        }
    }

    private ArrayList initColumns() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.inSideBrackets;
        SHColumnElements sHColumnElements = new SHColumnElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose(string2)) {
                object = new StringBuffer(string2);
                while (Token.hasOpenBracketNoClose(string2) && stringTokenizer.hasMoreTokens()) {
                    ((StringBuffer)object).append(", ").append(stringTokenizer.nextToken().trim());
                    string2 = ((StringBuffer)object).toString().trim();
                }
            }
            if (Boolean.TRUE.equals((object = sHColumnElements.getElementsColumn(string2.trim())).get("IS_CONSTRAINT")) && string2.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(string2);
                continue;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private String initEditProc() {
        return Token.getTokenAfter(this.outSideBrackets, "EDITPROC").trim();
    }

    private String initValidProc() {
        return Token.getTokenAfter(this.outSideBrackets, "VALIDPROC").trim();
    }

    private String initAudit() {
        return Token.getTokenAfter(this.outSideBrackets, "AUDIT").trim();
    }

    private String initObid() {
        return Token.getTokenAfter(this.outSideBrackets, "OBID").trim();
    }

    private boolean initDataCapture() {
        String string = Token.getTokenAfter(this.outSideBrackets, "CAPTURE");
        return string.equalsIgnoreCase("CHANGES");
    }

    private boolean initWithRestrictOnDrop() {
        return Token.hasToken(this.outSideBrackets, "RESTRICT");
    }

    private String initCcsid() {
        return Token.getTokenAfter(this.outSideBrackets, "CCSID").trim();
    }

    private void initCheckConstraint(String string, String string2, Column column) {
        Object object;
        CheckConstraint checkConstraint = new CheckConstraint();
        this.design.getRelationalDesign().stampModelObjectDDL(checkConstraint);
        RDBMSTypeSet rDBMSTypeSet = this.design.getRDBMSTypeSet();
        Iterator iterator = rDBMSTypeSet.iterator();
        while (iterator.hasNext()) {
            object = (RDBMSType)iterator.next();
            if (object != StorageDesignDB2v70.RDBMS_TYPE) continue;
            checkConstraint.add((ConstraintType)object, string);
        }
        if (!"".equalsIgnoreCase(string2) && string2 != null) {
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        } else {
            object = column.getName();
            if (((String)object).length() > 13) {
                object = ((String)object).substring(0, 13);
            }
            string2 = (String)object + "_CHCK";
            checkConstraint.setName(string2);
            column.setConstraintName(string2);
        }
        checkConstraint.setDesign(column.getDesign());
        column.setUseDomainConstraints(false);
        column.setCheck(checkConstraint);
    }

    private Table getReferencedTable(String string) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table table = (Table)tableSet.getByName(string);
        if (table != null) {
            return table;
        }
        this.importLog.addError("Table with name " + string + " does not exist.");
        throw new ObjectDoesNotExistException("Table with name " + string);
    }

    public Table getTable() {
        return this.table;
    }

    private Domain getCorrespondingDomain(String string) {
        Domain domain = null;
        DomainSet domainSet = this.design.getDomainSet();
        Iterator iterator = domainSet.iterator();
        while (iterator.hasNext()) {
            Domain domain2 = (Domain)iterator.next();
            if (!domain2.getName().equalsIgnoreCase(string)) continue;
            domain = domain2;
            return domain;
        }
        return domain;
    }

    private void addForeignKey(String string, Table table) {
        block17: {
            Table table2;
            ArrayList<Column> arrayList;
            String string2;
            block18: {
                String string3;
                int n;
                string2 = null;
                if (Token.hasToken(string, "CONSTRAINT")) {
                    string2 = Token.getTokenAfter(string, "CONSTRAINT");
                } else {
                    string2 = Token.getTokenAfter(string, "KEY");
                    n = string2.indexOf("(");
                    if (n > 0) {
                        string2 = string2.substring(0, n);
                    } else if (n == 0) {
                        string2 = null;
                    }
                }
                n = string.indexOf(41);
                String string4 = string.substring(0, n + 1).trim();
                String string5 = Token.getValBetweenBrackets(string4);
                List list = this.getColumnNames(string5);
                arrayList = new ArrayList<Column>();
                Column[] columnArray = (Column[])table.getElements();
                for (String string6 : list) {
                    for (int i = 0; i < columnArray.length; ++i) {
                        string3 = columnArray[i].getName().trim();
                        if (!string6.equalsIgnoreCase(string3)) continue;
                        arrayList.add(columnArray[i]);
                    }
                }
                int n2 = string.toUpperCase().indexOf("REFERENCES");
                string = string.substring(n2);
                String string7 = Token.getTokenAfter(string, "REFERENCES");
                string3 = this.getNameFor(string7);
                table2 = this.getTableFor(string3 = Token.removeQuotes(string3));
                if (table2 == null) break block17;
                boolean bl = Token.hasString(string, "(");
                if (!bl) break block18;
                String string8 = Token.getValBetweenBrackets(string);
                List list2 = this.getColumnNames(string8);
                FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(table2, list2);
                if (index == null) break block17;
                FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (string2 != null) {
                    fKIndexAssociation.setName(string2);
                    fKIndexAssociation.getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl2 = Token.hasToken(string, "DELETE");
                if (!bl2) break block17;
                String string9 = Token.getTokenAfter(string, "DELETE").trim();
                String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string9.equalsIgnoreCase(stringArray[i])) continue;
                    fKIndexAssociation.setDeleteRule(stringArray[i]);
                    break block17;
                }
                break block17;
            }
            FKIndexAssociationReference fKIndexAssociationReference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
            Index index = (Index)table2.getPK();
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index, null, fKIndexAssociationReference);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                if (string2 != null) {
                    fKIndexAssociation.setName(string2);
                    fKIndexAssociation.getLocalFKIndex().setName(string2);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fKIndexAssociation, arrayList, index);
                } else {
                    this.fixFKColumns(fKIndexAssociation, arrayList, index);
                }
                boolean bl = Token.hasToken(string, "DELETE");
                if (bl) {
                    String string10 = Token.getTokenAfter(string, "DELETE").trim();
                    String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string10.equalsIgnoreCase(stringArray[i])) continue;
                        fKIndexAssociation.setDeleteRule(stringArray[i]);
                        break;
                    }
                }
            }
        }
    }

    private List getColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            string2 = Token.removeQuotes(string2);
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    private String getNameFor(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = null;
            do {
                String string3;
                string2 = string3 = stringTokenizer.nextToken().trim();
            } while (stringTokenizer.hasMoreTokens());
            int n2 = string2.indexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        int n3 = string.indexOf(59);
        if (n3 > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private Table getTableFor(String string) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator iterator = tableSet.iterator();
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    private void replaceAllColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            if (column.isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            Column column2 = (Column)index2.getElements()[n];
            fKIndexAssociation.swapAndRemoveFKColumn(column2, column, columnArray[n]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fKIndexAssociation, List list, Index index) {
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        Iterator iterator = list.iterator();
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index2.getContainerWithKeyObject().getName()).append(" index ").append(index2.getName()).append(" parent table ").append(index.getContainerWithKeyObject().getName());
            LOGGER.error(stringBuffer.toString());
            this.importLog.addError(stringBuffer.toString());
        }
        int n = -1;
        while (iterator.hasNext()) {
            if (++n == columnArray.length) {
                return;
            }
            Column column = (Column)iterator.next();
            column.addFKAssociation(columnArray[n], fKIndexAssociation);
            index2.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List list) {
        Column[] columnArray = (Column[])index.getElements();
        if (columnArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getName().equalsIgnoreCase((String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List list) {
        Index index = (Index)table.getPK();
        if (index != null && this.isIndexForColumnNames(index, list)) {
            return index;
        }
        Index[] indexArray = (Index[])table.getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(indexArray[i], list)) continue;
            return indexArray[i];
        }
        return null;
    }

    Column getColumnByName(Table table, String string) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getName().equalsIgnoreCase(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    private void processRefAtColumn(RefAtColNode refAtColNode, Table table) {
        String string = this.getNameFor(refAtColNode.referencedTable);
        Table table2 = null;
        try {
            table2 = this.getReferencedTable(string);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            LOGGER.error(objectDoesNotExistException);
            this.importLog.addError("Referenced table " + string + " of fereign key does not exist.");
            this.failed = true;
        }
        if (table2 != null) {
            Index index;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (refAtColNode.refColumn != null) {
                arrayList.add(refAtColNode.refColumn);
                index = this.getUniqueIndexForColumnNames(table2, arrayList);
            } else {
                index = (Index)table2.getPK();
            }
            if (index != null) {
                FKIndexAssociation fKIndexAssociation = table.addFK(index);
                this.design.getRelationalDesign().stampModelObjectDDL(fKIndexAssociation);
                ArrayList<Column> arrayList2 = new ArrayList<Column>();
                Column column = this.getColumnByName(table, refAtColNode.columnName);
                if (column != null) {
                    arrayList2.add(column);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fKIndexAssociation, arrayList2, index);
                    } else {
                        this.fixFKColumns(fKIndexAssociation, arrayList2, index);
                    }
                    if (refAtColNode.onDelete != null) {
                        String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!refAtColNode.onDelete.equalsIgnoreCase(stringArray[i])) continue;
                            fKIndexAssociation.setDeleteRule(stringArray[i]);
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode fKRefNode : this.tableNodeList) {
            Object object2;
            for (Object object2 : fKRefNode.fkStatements) {
                this.addForeignKey((String)object2, fKRefNode.processedTable);
            }
            object2 = fKRefNode.refAtColumns.iterator();
            while (object2.hasNext()) {
                this.processRefAtColumn((RefAtColNode)object2.next(), fKRefNode.processedTable);
            }
        }
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

