/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;

public class SHCreateSynonym
extends DDLStatementHandler {
    public SHCreateSynonym(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateSynonym.clearCR(string);
        if (Token.startsWithString(string2, "create synonym")) {
            try {
                this.parseSynonym(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHCreateSynonym.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseSynonym(String string) {
        this.statement = string;
        String string2 = this.getNameOnly(Token.getNameAfterToken(this.statement, "SYNONYM", '\"', '\"').trim());
        String string3 = this.getNameOnly(Token.getNameAfterToken(this.statement, "FOR", '\"', '\"').trim());
        Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string3);
        TableView tableView = null;
        AliasDB2 aliasDB2 = null;
        if (table == null) {
            tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string3);
        }
        if (table != null || tableView != null) {
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
            SynonymDB2 synonymDB2 = abstractStorageDesignDB2.getSynonymSet().createSynonym();
            synonymDB2.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(synonymDB2);
            if (table != null) {
                TableProxyDB2 tableProxyDB2 = (TableProxyDB2)abstractStorageDesignDB2.getTableProxySet().getProxy(table.getObjectID());
                synonymDB2.setTable(tableProxyDB2);
                if (this.getOwner() != null) {
                    synonymDB2.setOwner(this.getOwner());
                } else {
                    synonymDB2.setOwner(abstractStorageDesignDB2.getOwnerSet().getDefaultOwner());
                }
            } else {
                TableViewProxyDB2 tableViewProxyDB2 = (TableViewProxyDB2)abstractStorageDesignDB2.getTableViewProxySet().getProxy(tableView.getObjectID());
                synonymDB2.setView(tableViewProxyDB2);
                if (this.getOwner() != null) {
                    synonymDB2.setOwner(this.getOwner());
                } else {
                    synonymDB2.setOwner(abstractStorageDesignDB2.getOwnerSet().getDefaultOwner());
                }
            }
        } else {
            RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
            aliasDB2 = (AliasDB2)abstractStorageDesignDB2.getAliasSet().getByName(string3);
            if (aliasDB2 != null) {
                SynonymDB2 synonymDB2 = abstractStorageDesignDB2.getSynonymSet().createSynonym();
                synonymDB2.setName(string2);
                synonymDB2.setAlias(aliasDB2);
                synonymDB2.setOwner(this.getOwner());
                this.design.getRelationalDesign().stampModelObjectDDL(synonymDB2);
            }
        }
    }
}

