/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateStoredProcedureDB2
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateStoredProcedureDB2.class);

    public SHCreateStoredProcedureDB2(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateStoredProcedureDB2.clearCR(string);
        if (Token.startsWithString(string2, "create procedure")) {
            try {
                this.parseStoredProcedure(string2.replaceAll("\"", ""), string);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                LOGGER.error("Parsing " + string2 + " for DB2 failed!", exception);
                this.importLog.addFailedStatement(SHCreateStoredProcedureDB2.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void parseStoredProcedure(String string, String string2) {
        StoredProcedureDB2 storedProcedureDB2;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (abstractStorageDesignDB2 != null && (storedProcedureDB2 = abstractStorageDesignDB2.getStoredProcedureSet().createStoredProcedure()) != null) {
            this.initStoredProcedureName(abstractStorageDesignDB2, storedProcedureDB2, string);
            this.initBody(storedProcedureDB2, string2, string);
            this.design.getRelationalDesign().stampModelObjectDDL(storedProcedureDB2);
        }
    }

    private void initStoredProcedureName(AbstractStorageDesignDB2 abstractStorageDesignDB2, StoredProcedureDB2 storedProcedureDB2, String string) {
        String string2 = Token.getTokenAfter(string, "PROCEDURE");
        if (string2.indexOf(46) > -1) {
            String string3 = string2.substring(0, string2.indexOf(46));
            string3 = Token.getValBetweenSquareBrackets(string3);
            Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string3);
            if (owner != null) {
                storedProcedureDB2.setOwner(owner);
            } else {
                storedProcedureDB2.setOwner(abstractStorageDesignDB2.getOwnerSet().getDefaultOwner());
            }
            string2 = string2.substring(string2.indexOf(46) + 1);
        }
        storedProcedureDB2.setName(string2);
    }

    private void initBody(StoredProcedureDB2 storedProcedureDB2, String string, String string2) {
        String string3 = Token.getTokenAfter(string2, "PROCEDURE");
        String string4 = Token.getStringAfter(string, string3);
        storedProcedureDB2.setBody(string4);
    }
}

