/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;

public class SHCreateAlias
extends DDLStatementHandler {
    public SHCreateAlias(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateAlias.clearCR(string);
        if (Token.startsWithString(string2, "create alias")) {
            try {
                this.parseAlias(string2.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHCreateAlias.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseAlias(String string) {
        this.statement = string;
        String string2 = this.getNameOnly(Token.getTokenAfter(this.statement, "ALIAS").trim());
        String string3 = this.getNameOnly(Token.getTokenAfter(this.statement, "FOR").trim());
        Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(string3);
        TableView tableView = null;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (table == null) {
            tableView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(string3);
        }
        if (table != null || tableView != null) {
            AliasDB2 aliasDB2 = abstractStorageDesignDB2.getAliasSet().createAlias();
            aliasDB2.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(aliasDB2);
            if (table != null) {
                TableProxyDB2 tableProxyDB2 = (TableProxyDB2)abstractStorageDesignDB2.getTableProxySet().getProxy(table.getObjectID());
                String string4 = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "ALIAS").trim(), '.');
                if (!string4.equalsIgnoreCase("")) {
                    Owner owner = (Owner)((AbstractStorageDesignDB2)tableProxyDB2.getStorageDesign()).getOwnerSet().getByName(string4);
                    if (owner == null) {
                        owner = (Owner)((AbstractStorageDesignDB2)tableProxyDB2.getStorageDesign()).getOwnerSet().createElement(null);
                        owner.setName(string4);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    aliasDB2.setOwner(owner);
                } else if (this.getOwner() != null) {
                    aliasDB2.setOwner(this.getOwner());
                } else {
                    aliasDB2.setOwner(abstractStorageDesignDB2.getOwnerSet().getDefaultOwner());
                }
                aliasDB2.setTable(tableProxyDB2);
            } else if (tableView != null) {
                TableViewProxyDB2 tableViewProxyDB2 = (TableViewProxyDB2)abstractStorageDesignDB2.getTableViewProxySet().getProxy(tableView.getObjectID());
                String string5 = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "ALIAS").trim(), '.');
                if (!string5.equalsIgnoreCase("")) {
                    Owner owner = (Owner)((AbstractStorageDesignDB2)tableViewProxyDB2.getStorageDesign()).getOwnerSet().getByName(string5);
                    if (owner == null) {
                        owner = (Owner)((AbstractStorageDesignDB2)tableViewProxyDB2.getStorageDesign()).getOwnerSet().createElement(null);
                        owner.setName(string5);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    aliasDB2.setOwner(owner);
                }
                aliasDB2.setView(tableViewProxyDB2);
            }
        } else {
            StorageObject storageObject = (StorageObject)abstractStorageDesignDB2.getAliasSet().getByName(string3);
            if (storageObject != null) {
                AliasDB2 aliasDB2 = abstractStorageDesignDB2.getAliasSet().createAlias();
                aliasDB2.setName(string2);
                this.design.getRelationalDesign().stampModelObjectDDL(aliasDB2);
                String string6 = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "ALIAS").trim(), '.');
                if (!string6.equalsIgnoreCase("")) {
                    Owner owner = (Owner)((AbstractStorageDesignDB2)aliasDB2.getStorageDesign()).getOwnerSet().getByName(string6);
                    if (owner == null) {
                        owner = (Owner)((AbstractStorageDesignDB2)aliasDB2.getStorageDesign()).getOwnerSet().createElement(null);
                        owner.setName(string6);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    aliasDB2.setOwner(owner);
                }
                aliasDB2.setAnotherAlias((AliasDB2)storageObject);
            }
        }
    }
}

