/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.Iterator;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.ColumnProxySet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceSetDB2;

public class SHCreateAUXTable
extends DDLStatementHandler {
    private AUXTableDB2 auxTable;
    private AbstractStorageDesignDB2 stoDesign = null;
    private String ownerName = null;

    public SHCreateAUXTable(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        String string2 = SHCreateAUXTable.clearCR(string);
        if (Token.startsWithString(string2, "create aux table") || Token.startsWithString(string2, "create auxiliary table")) {
            try {
                this.parseAUXTable(string2);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception exception) {
                this.importLog.addFailedStatement(SHCreateAUXTable.FormatCR(string, "\n"));
            }
        } else {
            this.nextHandler(string);
        }
    }

    public void parseAUXTable(String string) {
        this.statement = string;
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (this.stoDesign != null) {
            this.auxTable = this.stoDesign.getAUXTableSet().createAUXTable();
            String string2 = this.initName();
            this.auxTable.setName(string2);
            this.design.getRelationalDesign().stampModelObjectDDL(this.auxTable);
            this.initOwner();
            this.initIN();
            TableProxyDB2 tableProxyDB2 = this.initStores();
            if (tableProxyDB2 != null) {
                this.auxTable.setTable(tableProxyDB2);
                this.initColumn();
                this.initPart();
            }
        }
    }

    private String initName() {
        String string = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        int n = string.indexOf(46);
        if (n > 0) {
            this.ownerName = Token.getValBeforeCharacter(string, '.');
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void initIN() {
        String string;
        if (Token.hasToken(this.statement, "IN") && !(string = Token.getTokenAfter(this.statement, "IN").trim()).equals("")) {
            int n = string.indexOf(46);
            if (n > 0) {
                string = Token.getValAfterCharacter(string, '.');
            }
            TableSpaceSetDB2 tableSpaceSetDB2 = this.stoDesign.getTableSpaceSet();
            Iterator iterator = tableSpaceSetDB2.iterator();
            while (iterator.hasNext()) {
                TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)iterator.next();
                if (!tableSpaceDB2.getName().equalsIgnoreCase(string)) continue;
                this.auxTable.setTableSpace(tableSpaceDB2);
                break;
            }
        }
    }

    private TableProxyDB2 initStores() {
        String string;
        if (Token.hasToken(this.statement, "STORES") && !(string = Token.getTokenAfter(this.statement, "STORES").trim()).equals("")) {
            int n = string.indexOf(46);
            if (n > 0) {
                string = Token.getValAfterCharacter(string, '.');
            }
            TableProxySet tableProxySet = this.stoDesign.getTableProxySet();
            Iterator iterator = tableProxySet.iterator();
            while (iterator.hasNext()) {
                TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
                if (!tableProxyDB2.getName().equalsIgnoreCase(string)) continue;
                return tableProxyDB2;
            }
        }
        return null;
    }

    private void initColumn() {
        String string;
        if (Token.hasToken(this.statement, "COLUMN") && !(string = Token.getTokenAfter(this.statement, "COLUMN").trim()).equals("")) {
            ColumnProxySet columnProxySet = this.stoDesign.getColumnProxySet();
            Iterator iterator = columnProxySet.iterator();
            while (iterator.hasNext()) {
                ColumnProxyDB2 columnProxyDB2 = (ColumnProxyDB2)iterator.next();
                if (!columnProxyDB2.getName().equalsIgnoreCase(string)) continue;
                this.auxTable.setColumn(columnProxyDB2);
                break;
            }
        }
    }

    private void initPart() {
        String string;
        if (Token.hasToken(this.statement, "PART") && !(string = Token.getTokenAfter(this.statement, "PART").trim()).equals("")) {
            try {
                int n = Integer.parseInt(string);
                this.auxTable.setPartNumber(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.importLog.addWarning("Invalid part for aux table " + this.auxTable);
            }
        }
    }

    private void initOwner() {
        if (this.ownerName != null && !this.ownerName.equalsIgnoreCase("")) {
            Owner owner = (Owner)this.stoDesign.getOwnerSet().getByName(this.ownerName);
            if (owner == null) {
                owner = (Owner)this.stoDesign.getOwnerSet().createElement(null);
                owner.setName(this.ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            this.auxTable.setOwner(owner);
        } else if (this.getOwner() != null) {
            this.auxTable.setOwner(this.getOwner());
        } else {
            this.auxTable.setOwner(this.stoDesign.getOwnerSet().getDefaultOwner());
        }
    }
}

