/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.Iterator;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateAUXIndex
extends DDLStatementHandler
implements StatementsConstants {
    private AUXTableIndexDB2 index;
    private AUXTableDB2 table;
    private String tableName;
    private String indexName = "";
    private AbstractStorageDesignDB2 stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateAUXIndex.class);

    public SHCreateAUXIndex(Design design) {
        super(design);
    }

    @Override
    public void handle(String string) {
        this.statement = SHCreateAUXIndex.clearCR(string);
        if (Token.startsWithString(this.statement, "create index") || Token.startsWithString(this.statement, "create unique index")) {
            if (this.isAUXIndex()) {
                try {
                    this.createIndex(this.statement);
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception exception) {
                    this.importLog.addFailedStatement(SHCreateAUXIndex.FormatCR(string, "\n"));
                }
            } else {
                this.nextHandler(string.replaceAll("\"", ""));
            }
        } else {
            this.nextHandler(string);
        }
    }

    private void createIndex(String string) {
        this.indexName = this.initIndexName();
        this.index = this.stoDesign.getAUXTableIndexSet().createAUXTableIndex();
        this.index.setAuxTable(this.table);
        this.index.setName(this.indexName);
        this.design.getRelationalDesign().stampModelObjectDDL(this.index);
        this.initOwner(this.index);
        StorageTemplateDB2 storageTemplateDB2 = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
        this.design.getRelationalDesign().stampModelObjectDDL(storageTemplateDB2);
        this.index.setStorageTemplate(storageTemplateDB2);
        this.initUsingBlock(this.index, string);
        this.initFreeBlock(this.index, string);
        this.initGbpcacheBlock(this.index, string);
        this.initBufferpool(this.index);
        this.initClose(this.index);
        this.initCopy(this.index);
        this.initPieceSize(this.index);
        StorageTemplateDB2 storageTemplateDB22 = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(this.index.getStorageTemplate());
        if (storageTemplateDB22 != this.index.getStorageTemplate()) {
            this.index.setStorageTemplate(storageTemplateDB22);
        }
    }

    private String getTableName() {
        int n;
        String string = Token.getNameAfterToken(this.statement, "ON", '\"', '\"');
        if (string.indexOf(40) > -1) {
            string = string.substring(0, string.indexOf(40));
        }
        if ((n = string.indexOf(46)) > 0) {
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private boolean isAUXIndex() {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        if (this.stoDesign != null) {
            this.tableName = this.getTableName();
            this.table = (AUXTableDB2)this.stoDesign.getAUXTableSet().getByName(this.tableName);
            if (this.table != null) {
                return true;
            }
        }
        return false;
    }

    private String initIndexName() {
        String string = Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        if (string.indexOf(46) > -1) {
            string = Token.getValAfterCharacter(string, '.');
        }
        return string;
    }

    private void initOwner(AUXTableIndexDB2 aUXTableIndexDB2) {
        String string = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "INDEX").trim(), '.');
        if (!string.equalsIgnoreCase("")) {
            Owner owner = (Owner)this.stoDesign.getOwnerSet().getByName(string);
            if (owner == null) {
                owner = (Owner)this.stoDesign.getOwnerSet().createElement(null);
                owner.setName(string);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            aUXTableIndexDB2.setOwner(owner);
        } else if (this.getOwner() != null) {
            aUXTableIndexDB2.setOwner(this.getOwner());
        } else {
            aUXTableIndexDB2.setOwner(this.stoDesign.getOwnerSet().getDefaultOwner());
        }
    }

    private void initUsingBlock(AUXTableIndexDB2 aUXTableIndexDB2, String string) {
        boolean bl = Token.hasToken(string, "USING");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "USING").trim();
            if (string2.equalsIgnoreCase("VCAT")) {
                String string3 = Token.getTokenAfter(string, "VCAT").trim();
                Iterator iterator = this.stoDesign.getVCatSet().iterator();
                while (iterator.hasNext()) {
                    VCatDB2 vCatDB2 = (VCatDB2)iterator.next();
                    if (!vCatDB2.getName().equalsIgnoreCase(string3)) continue;
                    aUXTableIndexDB2.getStorageTemplate().setVCat(vCatDB2);
                    break;
                }
            } else if (string2.equalsIgnoreCase("STOGROUP")) {
                String string4;
                String string5 = Token.getTokenAfter(string, "STOGROUP").trim();
                StorageGroupSetDB2 storageGroupSetDB2 = this.stoDesign.getStorageGroupSet();
                aUXTableIndexDB2.getStorageTemplate().setStorageGroup(storageGroupSetDB2.getOrCreateStorageGroup(string5));
                try {
                    String string6;
                    string4 = Token.getTokenAfter(string, "PRIQTY").trim();
                    if (!string4.equals("")) {
                        int n = Integer.parseInt(string4);
                        aUXTableIndexDB2.getStorageTemplate().setSgPriqty(n);
                    }
                    if (!(string6 = Token.getTokenAfter(string, "SECQTY").trim()).equals("")) {
                        int n = Integer.parseInt(string6);
                        aUXTableIndexDB2.getStorageTemplate().setSgSeqty(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Wrong format in SHCreateAUXIndex.initUsingBlock()", numberFormatException);
                    this.importLog.addWarning("Unknown using block for storage template of aux index" + aUXTableIndexDB2.getName());
                }
                string4 = Token.getTokenAfter(this.statement, "ERASE").trim();
                if (string4.equalsIgnoreCase("YES")) {
                    aUXTableIndexDB2.getStorageTemplate().setSgErase(true);
                }
            }
        }
    }

    private void initFreeBlock(AUXTableIndexDB2 aUXTableIndexDB2, String string) {
        boolean bl = Token.hasToken(string, "FREEPAGE");
        if (bl) {
            try {
                String string2;
                String string3 = Token.getTokenAfter(string, "FREEPAGE").trim();
                if (!string3.equals("")) {
                    int n = Integer.parseInt(string3);
                    aUXTableIndexDB2.getStorageTemplate().setFreePage(n);
                }
                if (!(string2 = Token.getTokenAfter(string, "PCTFREE").trim()).equals("")) {
                    int n = Integer.parseInt(string2);
                    aUXTableIndexDB2.getStorageTemplate().setPctFree(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Wrong format in SHCreateAUXIndex.initFreeBlock:", numberFormatException);
                this.importLog.addWarning("Unknown free block for storage template of aux index" + aUXTableIndexDB2.getName());
            }
        }
    }

    private void initGbpcacheBlock(AUXTableIndexDB2 aUXTableIndexDB2, String string) {
        boolean bl = Token.hasToken(string, "GBPCACHE");
        if (bl) {
            String string2 = Token.getTokenAfter(string, "GBPCACHE").trim().toUpperCase();
            String[] stringArray = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equalsIgnoreCase(stringArray[i])) continue;
                aUXTableIndexDB2.getStorageTemplate().setGbCache(stringArray[i]);
            }
        }
    }

    private void initBufferpool(AUXTableIndexDB2 aUXTableIndexDB2) {
        String string = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim();
        BufferPoolSetDB2 bufferPoolSetDB2 = this.stoDesign.getBufferPoolSet();
        Iterator iterator = bufferPoolSetDB2.iterator();
        while (iterator.hasNext()) {
            BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)iterator.next();
            if (!bufferPoolDB2.getName().equalsIgnoreCase(string)) continue;
            aUXTableIndexDB2.setBufferPool(bufferPoolDB2);
        }
    }

    private void initClose(AUXTableIndexDB2 aUXTableIndexDB2) {
        String string = Token.getTokenAfter(this.statement, "CLOSE").trim();
        if (string.equalsIgnoreCase("NO")) {
            aUXTableIndexDB2.setClose(false);
        }
    }

    private void initCopy(AUXTableIndexDB2 aUXTableIndexDB2) {
        String string = Token.getTokenAfter(this.statement, "COPY").trim();
        if (string.equalsIgnoreCase("YES")) {
            aUXTableIndexDB2.setCopy(true);
        }
    }

    private void initPieceSize(AUXTableIndexDB2 aUXTableIndexDB2) {
        String string = Token.getStringAfter(this.statement, "PIECESIZE").trim();
        if (!string.equals("")) {
            aUXTableIndexDB2.setPieceSize(string);
        }
    }
}

