/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.crest.imports.ddl.BaseDDLFileHandler;
import oracle.dbtools.crest.imports.parser.SQLCommand;
import oracle.dbtools.crest.imports.parser.ScriptParser;
import oracle.dbtools.crest.util.logging.Logger;

public class NewDDLFileHandler
extends BaseDDLFileHandler {
    private File file;
    private static final Logger LOGGER = new Logger(NewDDLFileHandler.class);

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public List getDDLStatements(int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            ScriptParser scriptParser = new ScriptParser(fileInputStream, n);
            scriptParser.parse();
            SQLCommand[] sQLCommandArray = scriptParser.getSqlStatements();
            for (int i = 0; i < sQLCommandArray.length; ++i) {
                if (sQLCommandArray[i].isComment()) continue;
                linkedList.add(sQLCommandArray[i].getSql());
            }
        }
        catch (IOException iOException) {
            LOGGER.error("ERROR reading file in NewDDLFileHandler", iOException);
        }
        return linkedList;
    }
}

