/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.db2.SHColumnElements;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;

public class DomainHandlerReadDDL
implements StatementsConstants,
SectionConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;
    private LogicalDatatypeFactory factoryLogical;

    public DomainHandlerReadDDL(Design design) {
        this.design = design;
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    public void createDomains(LinkedList linkedList) {
        for (String string : linkedList) {
            int n = string.toLowerCase().indexOf("create table ");
            if (n == -1) continue;
            ArrayList arrayList = this.getColumns(string);
            for (String string2 : arrayList) {
                this.createOneDomain(string2);
            }
        }
    }

    private ArrayList getColumns(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Token.getValBetweenBrackets(string, 1);
        int n = string2.indexOf("CONSTRAINT");
        if (n > -1) {
            if ((string2 = string2.substring(0, n).trim()).endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1).trim();
            }
        } else {
            int n2 = string2.indexOf("PRIMARY");
            if (n2 != -1) {
                String string3;
                String string4 = string2.substring(n2);
                int n3 = (string4 = Token.cutTokenFromFront(string4, "PRIMARY KEY")).indexOf("(");
                if (n3 == 0 && (string3 = (string2 = string2.substring(0, n2).trim()).substring(string2.length() - 1)).equals(",")) {
                    int n4 = string2.length() - 1;
                    string2 = string2.substring(0, n4);
                }
            } else {
                int n5 = string2.indexOf("UNIQUE");
                if (n5 != -1) {
                    String string5;
                    String string6 = string2.substring(n5);
                    int n6 = (string6 = Token.cutTokenFromFront(string6, "UNIQUE")).indexOf("(");
                    if (n6 == 0 && (string5 = (string2 = string2.substring(0, n5).trim()).substring(string2.length() - 1)).equals(",")) {
                        int n7 = string2.length() - 1;
                        string2 = string2.substring(0, n7);
                    }
                }
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string7 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose(string7)) {
                StringBuffer stringBuffer = new StringBuffer(string7);
                while (Token.hasOpenBracketNoClose(string7) && stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(", ").append(stringTokenizer.nextToken().trim());
                    string7 = stringBuffer.toString();
                }
            }
            arrayList.add(string7.trim());
        }
        return arrayList;
    }

    private void createOneDomain(String string) {
        SHColumnElements sHColumnElements = new SHColumnElements();
        Map map = sHColumnElements.getElementsColumn(string);
        String string2 = (String)map.get("datatype");
        String[] stringArray = new String[]{(String)map.get("precision"), (String)map.get("scale"), (String)map.get("size")};
        if (string2 != null) {
            String string3 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(string2);
            LogicalDatatype logicalDatatype = this.factoryLogical.searchLogicalDatatype(this.design, string3);
            this.factory.getInstance(this.design, logicalDatatype, null, 2, stringArray, null);
        }
    }
}

