/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.ddl.AbstractDDLObjectHandler;
import oracle.dbtools.crest.imports.ddl.DDLDesignObject;
import oracle.dbtools.crest.imports.ddl.DDLExtractionHandler;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class DDLRelationalDesign
extends AbstractDDLObjectHandler {
    public static final String OBJECT_TYPE = "PHYSICAL DESIGN";

    public DDLRelationalDesign(DDLExtractionHandler dDLExtractionHandler, ApplicationView applicationView) {
        super(dDLExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(List list) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (DDLDesignObject dDLDesignObject : list) {
            if (!dDLDesignObject.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            RelationalDesign relationalDesign = (RelationalDesign)dDLDesignObject.getSelectedRelDesign();
            if (!relationalDesign.isLoaded()) {
                relationalDesign.setShouldBeOpen(true);
                this.getDesign().setClosing(true);
                relationalDesign.clearDesignPart();
                this.getDesign().setClosing(false);
                relationalDesign.load();
                if (dDLDesignObject.getSelectedRelDesign() instanceof RelationalDesign) {
                    relationalDesign.setImportTo((RelationalDesign)dDLDesignObject.getSelectedRelDesign());
                    continue;
                }
                relationalDesign.setImportTo(null);
                continue;
            }
            RelationalDesign relationalDesign2 = (RelationalDesign)dDLDesignObject.getSelectedRelDesign();
            relationalDesign2.setShouldBeOpen(false);
        }
        return arrayList;
    }

    @Override
    public void generate(List list, ImportLogger importLogger) throws Exception {
        for (DDLDesignObject dDLDesignObject : list) {
            if (!dDLDesignObject.getType().equalsIgnoreCase(OBJECT_TYPE)) continue;
            RelationalDesign relationalDesign = (RelationalDesign)dDLDesignObject.getSelectedRelDesign();
            if (relationalDesign.getImportTo() == null) {
                relationalDesign.setName(relationalDesign.getName() + "_" + relationalDesign.getDesign().getName());
                RelationalDesign relationalDesign2 = this.getOldDesign().addRelationalDesign(relationalDesign.getName());
                relationalDesign2.setShouldEngineer(relationalDesign.getShouldEngineer());
                relationalDesign2.setComment(relationalDesign.getComment());
                relationalDesign.setImportTo(relationalDesign2);
            }
            this.importNotes(relationalDesign, relationalDesign.getImportTo());
            importLogger.incrementImportedStatements();
        }
    }

    private void importNotes(RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        for (int i = 0; i < relationalDesign.getNoteSet().size(); ++i) {
            Note note;
            Note note2 = (Note)relationalDesign.getNoteSet().getElement(i);
            if (relationalDesign2.getNoteSet().getByName(note2.getName()) != null) {
                if (!this.canImport()) continue;
                String string = this.getPrefix() + note2.getName();
                note = relationalDesign2.getNoteSet().createNote(null);
                note.copy(note);
                note.setText(note2.getText());
                note.setName(string);
                note.setImportedDesign(relationalDesign.getDesign());
                note.setImportedId(note2.getObjectID());
                continue;
            }
            note = relationalDesign2.getNoteSet().createNote(null);
            note.copy(note);
            note.setText(note2.getText());
            note.setImportedDesign(relationalDesign.getDesign());
            note.setImportedId(note2.getObjectID());
        }
    }
}

