/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.imports.DDLFileStamp;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.BaseDDLFileHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.DomainHandlerReadDDL;
import oracle.dbtools.crest.imports.ddl.db2.DomainHandlerReadDDLDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHAlterTable;
import oracle.dbtools.crest.imports.ddl.db2.SHCommentOn;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateAUXIndex;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateAUXTable;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateAlias;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateDatabase;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateDistinctTypeDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateIndex;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateStoragegroup;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateStoredProcedureDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateSynonym;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateTable;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateTablespace;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateTriggerDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateView;
import oracle.dbtools.crest.imports.ddl.db2.SHGrant;
import oracle.dbtools.crest.imports.ddl.db2.SHLabelOn;
import oracle.dbtools.crest.imports.ddl.db2.v80.DomainHandlerReadDDLDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHAlterTableDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateDistinctTypeDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateIndexDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateSequenceDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateTableDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateTablespaceDB2v80;
import oracle.dbtools.crest.imports.ddl.oracle.SHCommentOnOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateDimensionOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateDirectoryOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateFunctionOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreatePackageBodyOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreatePackageOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateRollbackSegment;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateSequenceOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateSnapshotOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateStoredProcedureOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateSynonymOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateTemporaryTablespaceOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateTriggerOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateUserOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateViewOracle;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.DomainHandlerReadDDLOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateClusterOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateCollectionTypeOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateDatabaseOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateDimensionOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateDiskGroupOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateExternalTableOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateRoleOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateSnapshotOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTableOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTablespaceOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTypeOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateUndoTablespaceOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateUserOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHGrantPermissionsOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.DomainHandlerReadDDLOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHAlterTableOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateClusterOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateCollectionTypeOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateContextOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateDatabaseOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateExternalTableOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateIndexOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateRoleOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateTableOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateTablespaceOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateTypeOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateUndoTablespaceOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHGrantPermissionsOraclev9i;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.DomainHandlerReadDDLSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAddDataTypeSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAlterDatabaseSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAlterTableSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDatabaseSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDefaultSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateIndexSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateLoginSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateRoleSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateRuleSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateStoredProcedureSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateTableSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateTriggerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateViewSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHExtendedPropertiesSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHGrantPermissionsSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHGrantPrivilegesSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.DomainHandlerReadDDLSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SCHCreateSchemaSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHAddDataTypeSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHAlterDatabaseSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHAlterTableSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateDatabaseSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateDefaultSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateIndexSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateLoginSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreatePartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreatePartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateRoleSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateRuleSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateStoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateSynonymSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateTableSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateTriggerSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateViewSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateXMLCollectionSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHExtendedPropertiesSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHGrantPermissionsSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHGrantPrivilegesSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.udb.DomainHandlerReadDDLUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHAlterTableUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCommentOnUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateAliasUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateBufferPoolUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateDatabaseUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateDistinctTypeUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateIndexUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateMethodUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateNodeGroupUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateSchemaUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateStoredProcedureUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTableUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTablespaceUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTriggerUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTypeUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateViewUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHGrantUDB;
import oracle.dbtools.crest.imports.ddl.udb.v81.DomainHandlerReadDDLUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHAlterTableUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateBufferPoolUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateDBPartitionGroupUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateDatabaseUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateIndexUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateSequenceUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateTableUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateTablespaceUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateTriggerUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateTypeUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateViewUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHGrantUDBv81;
import oracle.dbtools.crest.model.View;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.gui.swing.JListDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class DDLHandler {
    public static final int DB_TYPE_DB2v70 = 1;
    public static final int DB_TYPE_UDBv71 = 2;
    public static final int DB_TYPE_SQL_SERVER2K = 4;
    public static final int DB_TYPE_DB2v80 = 5;
    public static final int DB_TYPE_UDBv81 = 6;
    public static final int DB_TYPE_ORACLEv9i = 7;
    public static final int DB_TYPE_ORACLEv10g = 8;
    public static final int DB_TYPE_SQL_SERVERV2K5 = 9;
    public static final int DB_TYPE_ORACLEv11g = 10;
    private DDLStatementHandler chain;
    private DDLStatementHandlerSqlServer chainSqlServer;
    private Design design;
    private Design designDomains;
    private LinkedList statementCollection;
    private Map statementFileMap;
    private String databaseName;
    private ApplicationView view;
    private Object[] files;
    private String oldDesignPath;
    private StorageDesign storageDesign = null;
    private RelationalDesign relModel = null;
    private boolean swapTargetModel = false;
    private Design oldDesign;
    private boolean isNewModel = false;
    private boolean skipMergeDialog = false;
    private List oldStorageDesigns = null;
    private int dbType = 1;
    private RDBMSSite site;
    private ProgressDialog monitor;
    private static final Logger LOGGER = new Logger(DDLHandler.class);

    public DDLHandler(View view, RelationalDesign relationalDesign, boolean bl, boolean bl2) {
        this(view, relationalDesign, bl, bl2, null);
    }

    public DDLHandler(View view, RelationalDesign relationalDesign, boolean bl, boolean bl2, StorageDesign storageDesign) {
        if (view instanceof ApplicationView) {
            this.view = (ApplicationView)view;
        }
        this.storageDesign = storageDesign;
        this.relModel = relationalDesign;
        this.swapTargetModel = bl;
        this.skipMergeDialog = bl2;
        if (bl2) {
            this.design = this.view.getCurrentDesign();
            this.oldStorageDesigns = Arrays.asList(this.design.getRelationalDesign().getStorageDesignFactory().getOpenStorageDesigns());
        } else {
            this.oldDesign = this.view.getCurrentDesign();
            this.design = new Design((ApplicationView)view);
            this.oldStorageDesigns = Arrays.asList(this.oldDesign.getRelationalDesign().getStorageDesignFactory().getOpenStorageDesigns());
            ((ApplicationView)view).setCurrentDesign(this.design);
        }
        this.statementCollection = new LinkedList();
        this.statementFileMap = new TreeMap();
    }

    public void parse(Object[] objectArray, String string, String string2) {
        this.oldDesignPath = string2;
        this.databaseName = string;
        this.files = objectArray;
        this.statementCollection.clear();
        this.statementFileMap.clear();
        this.dbType = this.storageDesign != null ? this.getDDLTypeFor(this.storageDesign.getRDBMSSite()) : this.getDDLType();
        if (this.site == null) {
            LOGGER.error("Error getting RDBMS Site: DDLHandler.parse");
            return;
        }
        switch (this.dbType) {
            case 1: {
                this.buildDB2v70Chain();
                break;
            }
            case 2: {
                this.buildUDBv71Chain();
                break;
            }
            case 7: {
                this.buildOraclev9iChain();
                break;
            }
            case 8: {
                this.buildOraclev10gChain();
                break;
            }
            case 10: {
                this.buildOraclev10gChain();
                break;
            }
            case 4: {
                this.buildSqlServerChain();
                break;
            }
            case 5: {
                this.buildDB2v80Chain();
                break;
            }
            case 6: {
                this.buildUDBv81Chain();
                break;
            }
            case 9: {
                this.buildSqlServerv2k5Chain();
                break;
            }
            default: {
                this.buildDB2v70Chain();
            }
        }
        if (this.skipMergeDialog) {
            if (this.relModel == null && this.storageDesign == null) {
                RelationalDesign relationalDesign = this.design.addRelationalDesign(string);
                this.design.setRelationalDesign(relationalDesign);
                this.relModel = relationalDesign;
            } else {
                this.design.setRelationalDesign(this.relModel);
            }
            this.design.setSelectedRDBMSSite(this.site);
            this.designDomains = this.design;
            this.design.getStorageDesign(this.site);
            for (int i = 0; i < objectArray.length; ++i) {
                DDLFileStamp dDLFileStamp = new DDLFileStamp((File)objectArray[i], this.dbType);
                int n = this.design.getRelationalDesign().addImportDDLFileStamp(dDLFileStamp);
            }
            new Thread(new EmptyRunner()).start();
        } else {
            if (this.relModel == null && this.storageDesign == null) {
                RelationalDesign relationalDesign = this.oldDesign.addRelationalDesign(string);
                this.oldDesign.setRelationalDesign(relationalDesign);
                this.isNewModel = true;
            } else {
                this.oldDesign.setRelationalDesign(this.relModel);
                this.isNewModel = false;
            }
            if (this.relModel != null) {
                if (this.relModel.isVisible()) {
                    this.relModel.getMainView().getTabbedPane().setSelectedIndex(0);
                    this.view.setCurrentDPV(this.relModel.getMainView());
                } else {
                    this.relModel.setMainViewVisible(true);
                }
            }
            this.design.setSelectedRDBMSSite(this.site);
            this.oldDesign.setSelectedRDBMSSite(this.site);
            this.design.getRelationalDesign().setName(string);
            this.designDomains = this.design;
            this.design.setFileName(this.databaseName);
            this.design.getStorageDesign(this.site);
            for (int i = 0; i < objectArray.length; ++i) {
                DDLFileStamp dDLFileStamp = new DDLFileStamp((File)objectArray[i], this.dbType);
                int n = this.design.getRelationalDesign().addImportDDLFileStamp(dDLFileStamp);
            }
            new Thread(new Runner()).start();
        }
    }

    private void constructDomains() {
        try {
            if (this.dbType == 7) {
                DomainHandlerReadDDLOraclev9i domainHandlerReadDDLOraclev9i = new DomainHandlerReadDDLOraclev9i(this.designDomains);
                domainHandlerReadDDLOraclev9i.createDomains(this.statementCollection);
            } else if (this.dbType == 8) {
                DomainHandlerReadDDLOraclev10g domainHandlerReadDDLOraclev10g = new DomainHandlerReadDDLOraclev10g(this.designDomains);
                domainHandlerReadDDLOraclev10g.createDomains(this.statementCollection, StorageDesignOraclev10g.RDBMS_TYPE);
            } else if (this.dbType == 10) {
                DomainHandlerReadDDLOraclev10g domainHandlerReadDDLOraclev10g = new DomainHandlerReadDDLOraclev10g(this.designDomains);
                domainHandlerReadDDLOraclev10g.createDomains(this.statementCollection, StorageDesignOraclev11g.RDBMS_TYPE);
            } else if (this.dbType == 4) {
                DomainHandlerReadDDLSqlServer domainHandlerReadDDLSqlServer = new DomainHandlerReadDDLSqlServer(this.designDomains);
                domainHandlerReadDDLSqlServer.createDomains(this.statementCollection);
            } else if (this.dbType == 9) {
                DomainHandlerReadDDLSqlServerv2k5 domainHandlerReadDDLSqlServerv2k5 = new DomainHandlerReadDDLSqlServerv2k5(this.designDomains);
                domainHandlerReadDDLSqlServerv2k5.createDomains(this.statementCollection);
            } else if (this.dbType == 1) {
                DomainHandlerReadDDLDB2 domainHandlerReadDDLDB2 = new DomainHandlerReadDDLDB2(this.designDomains);
                domainHandlerReadDDLDB2.createDomains(this.statementCollection);
            } else if (this.dbType == 5) {
                DomainHandlerReadDDLDB2v80 domainHandlerReadDDLDB2v80 = new DomainHandlerReadDDLDB2v80(this.designDomains);
                domainHandlerReadDDLDB2v80.createDomains(this.statementCollection);
            } else if (this.dbType == 2) {
                DomainHandlerReadDDLUDB domainHandlerReadDDLUDB = new DomainHandlerReadDDLUDB(this.designDomains);
                domainHandlerReadDDLUDB.createDomains(this.statementCollection);
            } else if (this.dbType == 6) {
                DomainHandlerReadDDLUDBv81 domainHandlerReadDDLUDBv81 = new DomainHandlerReadDDLUDBv81(this.designDomains);
                domainHandlerReadDDLUDBv81.createDomains(this.statementCollection);
            } else {
                DomainHandlerReadDDL domainHandlerReadDDL = new DomainHandlerReadDDL(this.designDomains);
                domainHandlerReadDDL.createDomains(this.statementCollection);
            }
            this.designDomains.resetDomains();
        }
        catch (Exception exception) {
            LOGGER.error("Unable to create domains!", exception);
        }
    }

    private void parseFile(ImportLogger importLogger) {
        Object object;
        Object object2;
        this.design.setSelectedRDBMSSite(this.site);
        int n = 0;
        double d = 10.0;
        int n2 = this.statementCollection.size();
        Iterator iterator = this.statementCollection.iterator();
        if (this.dbType == 4 || this.dbType == 9) {
            this.chainSqlServer.setCurrentDB("");
            this.chainSqlServer.setImportLog(importLogger);
            while (iterator.hasNext()) {
                if (this.statementFileMap.get(n) != null) {
                    object2 = (String)this.statementFileMap.get(n);
                    int n3 = this.design.getRelationalDesign().findImportDDLFileStamp((String)object2);
                    this.design.getRelationalDesign().setImportDDLFileStampIndex(n3);
                }
                this.monitor.setNote(MessageFormat.format(Messages.getString("DDLHandler.ProcessingStatement"), ++n));
                this.monitor.setProgress((int)(d += 80.0 / (double)n2));
                object2 = (String)iterator.next();
                object = DDLStatementHandler.clearCR((String)object2).trim();
                if (((String)object).equalsIgnoreCase("GO")) {
                    importLogger.incrementImportedStatements();
                    continue;
                }
                if (((String)object).toUpperCase().startsWith("USE ")) {
                    this.chainSqlServer.setCurrentDB(Token.getNameAfterToken((String)object, "USE", '[', ']').trim());
                    importLogger.incrementImportedStatements();
                    continue;
                }
                try {
                    this.chainSqlServer.handle((String)object2);
                }
                catch (Exception exception) {
                    LOGGER.error("Unable to handle the line: " + (String)object2, exception);
                    this.chain.nextHandler((String)object2);
                }
            }
            object2 = this.chainSqlServer.getCreateTableHandler();
            object2.setImportLog(importLogger);
            if (object2 != null) {
                try {
                    object2.processForeignKeys();
                }
                catch (Exception exception) {
                    LOGGER.error("Unable to process ForeignKeys", exception);
                }
            }
            object = this.chainSqlServer.getAlterTableHandler();
            object.setImportLog(importLogger);
            if (object != null) {
                try {
                    object.processForeignKeys();
                }
                catch (Exception exception) {
                    LOGGER.error("Unable to process ForeignKeys", exception);
                }
            }
        } else {
            while (iterator.hasNext()) {
                if (this.statementFileMap.get(n) != null) {
                    object2 = (String)this.statementFileMap.get(n);
                    int n4 = this.design.getRelationalDesign().findImportDDLFileStamp((String)object2);
                    this.design.getRelationalDesign().setImportDDLFileStampIndex(n4);
                }
                this.monitor.setNote(MessageFormat.format(Messages.getString("DDLHandler.ProcessingStatement"), ++n));
                this.monitor.setProgress((int)(d += 80.0 / (double)n2));
                object2 = (String)iterator.next();
                if (1 == this.dbType || 5 == this.dbType) {
                    try {
                        this.processSQLIDSettings(this.chain, (String)object2, importLogger);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to process SQLID Settings: " + (String)object2, exception);
                        importLogger.addError("Unable to process SQLID Settings: " + (String)object2);
                        importLogger.addFailedStatement(DDLStatementHandler.FormatCR((String)object2, "\n"));
                    }
                } else if (2 == this.dbType || 6 == this.dbType) {
                    try {
                        this.processCurrentSchemaSettings(this.chain, (String)object2, importLogger);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Unable to process Set Current SCHEMA Settings: " + (String)object2, exception);
                        importLogger.addError("Unable to process Set Current SCHEMA Settings: " + (String)object2);
                        importLogger.addFailedStatement(DDLStatementHandler.FormatCR((String)object2, "\n"));
                    }
                }
                try {
                    this.chain.setImportLog(importLogger);
                    this.chain.handle((String)object2);
                }
                catch (Exception exception) {
                    LOGGER.error("Unable to handle the line: " + (String)object2, exception);
                    this.chain.nextHandler((String)object2);
                }
            }
            object2 = this.chain.getCreateTableHandler();
            if (object2 != null) {
                try {
                    object2.processForeignKeys();
                }
                catch (Exception exception) {
                    LOGGER.error("Unable to process ForeignKeys", exception);
                }
            }
            if ((object = this.chain.getAlterTableHandler()) != null) {
                try {
                    object.processForeignKeys();
                }
                catch (Exception exception) {
                    LOGGER.error("Unable to process ForeignKeys", exception);
                }
            }
            if (1 == this.dbType || 5 == this.dbType) {
                this.processDB2IntegrityIndexes();
            }
        }
        if (this.storageDesign == null) {
            this.monitor.setNote(Messages.getString("DDLHandler.RearrangeTypes"));
            this.monitor.setProgress(85);
            try {
                this.design.getDataTypesDesign().rearrangeTypes();
            }
            catch (Exception exception) {
                LOGGER.error("Unable to rearrange Types", exception);
            }
            this.monitor.setNote(Messages.getString("DDLHandler.RearrangeTables"));
            this.monitor.setProgress(90);
            try {
                ((DPVRelational)this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                object2 = this.design.getRelationalDesign().getMainView().getDisplays().iterator();
                while (object2.hasNext()) {
                    object = (DesignPartViewPlaceHolder)object2.next();
                    ((DPVRelational)((DesignPartViewPlaceHolder)object).getDesignPartView()).rearrangeNewDiagram();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Unable to rearrange Tables", exception);
            }
            this.monitor.setNote(Messages.getString("DDLHandler.RearrangeViews"));
            this.monitor.setProgress(93);
            try {
                this.fixFKSelfReferences();
            }
            catch (Exception exception) {
                LOGGER.error("Unable to fix FK SelfReferences", exception);
            }
            try {
                this.design.getRelationalDesign().createSubviewsOnSchema(this.design.getStorageDesign(this.design.getSelectedRDBMSSite()));
            }
            catch (Exception exception) {
                LOGGER.error("Unable to create subviews ", exception);
            }
        }
        this.monitor.setProgress(95);
        this.design.setDirty(true);
        this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setOpen(true);
        this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setTempModel(false);
        this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setDirty(true);
    }

    private void processDB2IntegrityIndexes() {
        RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
        Iterator iterator = abstractStorageDesignDB2.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            for (IndexProxyDB2 indexProxyDB2 : tableProxyDB2.getIntegrityIndexes()) {
                if (indexProxyDB2.isProcessedInDDLImport() || indexProxyDB2.getOwner() != null && !indexProxyDB2.getOwner().isNullInstance()) continue;
                indexProxyDB2.setOwner(((TableProxyDB2)indexProxyDB2.getTableProxy()).getOwner());
            }
        }
    }

    private void processSQLIDSettings(DDLStatementHandler dDLStatementHandler, String string, ImportLogger importLogger) {
        String string2 = string.toUpperCase().trim();
        if (string2.indexOf("--") != 0 && string2.indexOf("SET") > -1 && string2.indexOf("CURRENT") > -1 && string2.indexOf("SQLID") > -1) {
            int n;
            string2 = string;
            int n2 = string2.indexOf(59);
            if (n2 > -1) {
                string2 = string2.substring(0, n2);
            }
            if ((n = string2.indexOf(61)) > -1) {
                String string3 = string2.substring(n + 1).trim();
                if (string3.indexOf("'") <= -1) {
                    dDLStatementHandler.setOwner(null);
                } else if (!"".equalsIgnoreCase(string3 = string3.substring(1, string3.length() - 1))) {
                    RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
                    AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.design.getStorageDesign(rDBMSSite);
                    Owner owner = (Owner)abstractStorageDesignDB2.getOwnerSet().getByName(string3);
                    if (owner == null) {
                        owner = (Owner)abstractStorageDesignDB2.getOwnerSet().createElement(null);
                        owner.setName(string3);
                    }
                    dDLStatementHandler.setOwner(owner);
                } else {
                    dDLStatementHandler.setOwner(null);
                }
                importLogger.incrementImportedStatements();
            } else {
                dDLStatementHandler.setOwner(null);
            }
        }
    }

    private void processCurrentSchemaSettings(DDLStatementHandler dDLStatementHandler, String string, ImportLogger importLogger) {
        String string2 = string.toUpperCase().trim();
        if (string2.indexOf("--") != 0 && string2.indexOf("SET") > -1 && string2.indexOf("CURRENT") > -1 && string2.indexOf("SCHEMA") > -1) {
            int n;
            string2 = string;
            int n2 = string2.indexOf(59);
            if (n2 > -1) {
                string2 = string2.substring(0, n2);
            }
            if ((n = string2.indexOf(61)) > -1) {
                String string3 = string2.substring(n + 1);
                if (string3.indexOf("'") <= -1000) {
                    dDLStatementHandler.setOwner(null);
                } else if (!"".equalsIgnoreCase(string3 = Token.getName(string3.trim()).trim())) {
                    RDBMSSite rDBMSSite = this.design.getSelectedRDBMSSite();
                    StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.design.getStorageDesign(rDBMSSite);
                    Owner owner = (Owner)storageDesignUDB.getOwnerSet().getByName(string3);
                    if (owner == null) {
                        owner = (Owner)storageDesignUDB.getOwnerSet().createElement(null);
                        owner.setName(string3);
                    }
                    dDLStatementHandler.setOwner(owner);
                } else {
                    dDLStatementHandler.setOwner(null);
                }
                importLogger.incrementImportedStatements();
            } else {
                dDLStatementHandler.setOwner(null);
            }
        }
    }

    public int getDDLType() {
        if (this.view != null) {
            Object[] objectArray = this.view.getCurrentDesign().getRDBMSSiteSet().toSiteArray();
            this.site = (RDBMSSite)JListDialog.showDialog(this.view.getFrame(), Messages.getString("DDLHandler.SelectSite"), Messages.getString("DDLHandler.DatabaseSites"), objectArray);
            return this.getDDLTypeFor(this.site);
        }
        return 1;
    }

    private int getDDLTypeFor(RDBMSSite rDBMSSite) {
        if (rDBMSSite == null) {
            return 1;
        }
        this.site = rDBMSSite;
        int n = rDBMSSite.getType().getType();
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 9;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 10;
            }
        }
        return 1;
    }

    private void buildDB2v70Chain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateStoragegroup(this.design));
        this.chain.add(new SHCreateDatabase(this.design));
        this.chain.add(new SHCreateTablespace(this.design));
        this.chain.add(new SHCreateTable(this.design));
        this.chain.add(new SHCreateAUXTable(this.design));
        this.chain.add(new SHCreateIndex(this.design));
        this.chain.add(new SHCreateAUXIndex(this.design));
        this.chain.add(new SHAlterTable(this.design));
        this.chain.add(new SHCreateAlias(this.design));
        this.chain.add(new SHCreateSynonym(this.design));
        this.chain.add(new SHCreateView(this.design));
        this.chain.add(new SHCreateTriggerDB2(this.design));
        this.chain.add(new SHCreateStoredProcedureDB2(this.design));
        this.chain.add(new SHLabelOn(this.design));
        this.chain.add(new SHCommentOn(this.design));
        this.chain.add(new SHGrant(this.design));
        this.chain.add(new SHCreateDistinctTypeDB2(this.design));
    }

    private void buildUDBv71Chain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateTypeUDB(this.design));
        this.chain.add(new SHCreateMethodUDB(this.design));
        this.chain.add(new SHCreateBufferPoolUDB(this.design));
        this.chain.add(new SHCreateDatabaseUDB(this.design));
        this.chain.add(new SHCreateNodeGroupUDB(this.design));
        this.chain.add(new SHCreateTablespaceUDB(this.design));
        this.chain.add(new SHCreateSchemaUDB(this.design));
        this.chain.add(new SHCreateTableUDB(this.design));
        this.chain.add(new SHCreateIndexUDB(this.design));
        this.chain.add(new SHAlterTableUDB(this.design));
        this.chain.add(new SHCreateAliasUDB(this.design));
        this.chain.add(new SHCreateViewUDB(this.design));
        this.chain.add(new SHCreateTriggerUDB(this.design));
        this.chain.add(new SHCreateStoredProcedureUDB(this.design));
        this.chain.add(new SHCreateDistinctTypeUDB(this.design));
        this.chain.add(new SHGrantUDB(this.design));
        this.chain.add(new SHCommentOnUDB(this.design));
    }

    private void buildUDBv81Chain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateTypeUDBv81(this.design));
        this.chain.add(new SHCreateMethodUDB(this.design));
        this.chain.add(new SHCreateBufferPoolUDBv81(this.design));
        this.chain.add(new SHCreateDatabaseUDBv81(this.design));
        this.chain.add(new SHCreateDBPartitionGroupUDBv81(this.design));
        this.chain.add(new SHCreateTablespaceUDBv81(this.design));
        this.chain.add(new SHCreateSchemaUDB(this.design));
        this.chain.add(new SHCreateTableUDBv81(this.design));
        this.chain.add(new SHCreateIndexUDBv81(this.design));
        this.chain.add(new SHAlterTableUDBv81(this.design));
        this.chain.add(new SHCreateAliasUDB(this.design));
        this.chain.add(new SHCreateViewUDBv81(this.design));
        this.chain.add(new SHCreateTriggerUDBv81(this.design));
        this.chain.add(new SHCreateStoredProcedureUDB(this.design));
        this.chain.add(new SHCreateDistinctTypeUDB(this.design));
        this.chain.add(new SHGrantUDBv81(this.design));
        this.chain.add(new SHCreateSequenceUDBv81(this.design));
        this.chain.add(new SHCommentOnUDB(this.design));
    }

    private void buildOraclev9iChain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateCollectionTypeOraclev9i(this.design));
        this.chain.add(new SHCreateTypeOraclev9i(this.design));
        this.chain.add(new SHCreateDatabaseOraclev9i(this.design));
        this.chain.add(new SHCreateTablespaceOraclev9i(this.design));
        this.chain.add(new SHCreateTemporaryTablespaceOracle(this.design));
        this.chain.add(new SHCreateUndoTablespaceOraclev9i(this.design));
        this.chain.add(new SHCreateRollbackSegment(this.design));
        this.chain.add(new SHCreateRoleOraclev9i(this.design));
        this.chain.add(new SHCreateUserOracle(this.design));
        this.chain.add(new SHCreateClusterOraclev9i(this.design));
        this.chain.add(new SHCreateContextOraclev9i(this.design));
        this.chain.add(new SHCreateExternalTableOraclev9i(this.design));
        this.chain.add(new SHCreateTableOraclev9i(this.design));
        this.chain.add(new SHCreateSnapshotOracle(this.design));
        this.chain.add(new SHCreateIndexOraclev9i(this.design));
        this.chain.add(new SHAlterTableOraclev9i(this.design));
        this.chain.add(new SHCreateViewOracle(this.design));
        this.chain.add(new SHCreateDimensionOracle(this.design));
        this.chain.add(new SHCreateSequenceOracle(this.design));
        this.chain.add(new SHCreateSynonymOracle(this.design));
        this.chain.add(new SHCreateDirectoryOracle(this.design));
        this.chain.add(new SHCreateTriggerOracle(this.design));
        this.chain.add(new SHCreatePackageBodyOracle(this.design));
        this.chain.add(new SHCreatePackageOracle(this.design));
        this.chain.add(new SHCreateStoredProcedureOracle(this.design));
        this.chain.add(new SHCreateFunctionOracle(this.design));
        this.chain.add(new SHGrantPermissionsOraclev9i(this.design));
        this.chain.add(new SHCommentOnOracle(this.design));
    }

    private void buildOraclev10gChain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateCollectionTypeOraclev10g(this.design));
        this.chain.add(new SHCreateTypeOraclev10g(this.design));
        this.chain.add(new SHCreateDatabaseOraclev10g(this.design));
        this.chain.add(new SHCreateTablespaceOraclev10g(this.design));
        this.chain.add(new SHCreateTemporaryTablespaceOraclev10g(this.design));
        this.chain.add(new SHCreateUndoTablespaceOraclev10g(this.design));
        this.chain.add(new SHCreateRollbackSegment(this.design));
        this.chain.add(new SHCreateRoleOraclev10g(this.design));
        this.chain.add(new SHCreateUserOraclev10g(this.design));
        this.chain.add(new SHCreateClusterOraclev10g(this.design));
        this.chain.add(new SHCreateContextOraclev9i(this.design));
        this.chain.add(new SHCreateExternalTableOraclev10g(this.design));
        this.chain.add(new SHCreateTableOraclev10g(this.design));
        this.chain.add(new SHCreateSnapshotOraclev10g(this.design));
        this.chain.add(new SHCreateIndexOraclev9i(this.design));
        this.chain.add(new SHAlterTableOraclev10g(this.design));
        this.chain.add(new SHCreateViewOracle(this.design));
        this.chain.add(new SHCreateDimensionOraclev10g(this.design));
        this.chain.add(new SHCreateSequenceOracle(this.design));
        this.chain.add(new SHCreateSynonymOracle(this.design));
        this.chain.add(new SHCreateDirectoryOracle(this.design));
        this.chain.add(new SHCreateTriggerOracle(this.design));
        this.chain.add(new SHCreatePackageBodyOracle(this.design));
        this.chain.add(new SHCreatePackageOracle(this.design));
        this.chain.add(new SHCreateStoredProcedureOracle(this.design));
        this.chain.add(new SHCreateFunctionOracle(this.design));
        this.chain.add(new SHGrantPermissionsOraclev10g(this.design));
        this.chain.add(new SHCreateDiskGroupOraclev10g(this.design));
        this.chain.add(new SHCommentOnOracle(this.design));
    }

    private void buildSqlServerChain() {
        this.chainSqlServer = new DDLStatementHandlerSqlServer(this.design);
        System.gc();
        this.chainSqlServer.add(new SHCreateDatabaseSqlServer(this.design));
        this.chainSqlServer.add(new SHAlterDatabaseSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateLoginSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateRoleSqlServer(this.design));
        this.chainSqlServer.add(new SHGrantPrivilegesSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateRuleSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateTableSqlServer(this.design));
        this.chainSqlServer.add(new SHAlterTableSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateViewSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateIndexSqlServer(this.design));
        this.chainSqlServer.add(new SHGrantPermissionsSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateDefaultSqlServer(this.design));
        this.chainSqlServer.add(new SHExtendedPropertiesSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateTriggerSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateStoredProcedureSqlServer(this.design));
        this.chainSqlServer.add(new SHAddDataTypeSqlServer(this.design));
    }

    private void buildSqlServerv2k5Chain() {
        this.chainSqlServer = new DDLStatementHandlerSqlServer(this.design);
        System.gc();
        this.chainSqlServer.add(new SHCreateDatabaseSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHAlterDatabaseSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateLoginSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SCHCreateSchemaSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateXMLCollectionSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHAddDataTypeSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateRoleSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHGrantPrivilegesSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateRuleSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreatePartitionFunctionSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreatePartitionSchemeSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateTableSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHAlterTableSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateViewSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateIndexSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHGrantPermissionsSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateDefaultSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHExtendedPropertiesSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateTriggerSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateStoredProcedureSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateSynonymSqlServerv2k5(this.design));
    }

    private void buildDB2v80Chain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateStoragegroup(this.design));
        this.chain.add(new SHCreateDatabase(this.design));
        this.chain.add(new SHCreateTablespaceDB2v80(this.design));
        this.chain.add(new SHCreateTableDB2v80(this.design));
        this.chain.add(new SHCreateAUXTable(this.design));
        this.chain.add(new SHCreateIndexDB2v80(this.design));
        this.chain.add(new SHCreateAUXIndex(this.design));
        this.chain.add(new SHAlterTableDB2v80(this.design));
        this.chain.add(new SHCreateAlias(this.design));
        this.chain.add(new SHCreateSynonym(this.design));
        this.chain.add(new SHCreateView(this.design));
        this.chain.add(new SHCreateTriggerDB2(this.design));
        this.chain.add(new SHCreateStoredProcedureDB2(this.design));
        this.chain.add(new SHCreateSequenceDB2v80(this.design));
        this.chain.add(new SHLabelOn(this.design));
        this.chain.add(new SHCommentOn(this.design));
        this.chain.add(new SHGrant(this.design));
        this.chain.add(new SHCreateDistinctTypeDB2v80(this.design));
    }

    private void fixFKSelfReferences() {
        Iterator iterator = this.design.getRelationalDesign().getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            fKIndexAssociation.repairSelfReference();
            fKIndexAssociation.resetMandatoryUsingColumns();
        }
    }

    public int getStatementsCount() {
        return this.statementCollection.size();
    }

    private class EmptyRunner
    implements Runnable {
        private EmptyRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object;
                DDLHandler.this.relModel.setMainViewVisible(false);
                DDLHandler.this.design.setDisableTreeUpdate(true);
                ImportLogger importLogger = new ImportLogger();
                try {
                    if (DDLHandler.this.storageDesign != null) {
                        DDLHandler.this.storageDesign.setImportStorageObjectsOnly(true);
                    }
                    DDLHandler.this.monitor = new ProgressDialog(DDLHandler.this.view, "", 0, 100);
                    ApplicationView.canLogging = false;
                    try {
                        DDLHandler.this.view.setImporting(true);
                        DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.CollectDDLStatements"));
                        DDLHandler.this.monitor.setProgress(2);
                        object = BaseDDLFileHandler.geDDLFileHandler(DDLHandler.this.dbType);
                        for (int i = 0; i < DDLHandler.this.files.length; ++i) {
                            ((BaseDDLFileHandler)object).setFile((File)DDLHandler.this.files[i]);
                            DDLHandler.this.statementFileMap.put(DDLHandler.this.statementCollection.size(), ((File)DDLHandler.this.files[i]).getName());
                            DDLHandler.this.statementCollection.addAll(((BaseDDLFileHandler)object).getDDLStatements(DDLHandler.this.dbType));
                        }
                        DDLHandler.this.design.setPropagatePKChahges(false);
                        try {
                            if (DDLHandler.this.design.getAppView().getSettings().isCreateDomainsDuringImport()) {
                                DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.ConstructDomains"));
                                DDLHandler.this.monitor.setProgress(5);
                                DDLHandler.this.constructDomains();
                            }
                            DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.ParseFile"));
                            DDLHandler.this.monitor.setProgress(10);
                            DDLHandler.this.parseFile(importLogger);
                            DDLHandler.this.monitor.setProgress(100);
                            DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setOpen(true);
                            DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setTempModel(false);
                            DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).sortCollections();
                            System.gc();
                        }
                        finally {
                            if (DDLHandler.this.design != null) {
                                DDLHandler.this.design.setPropagatePKChahges(true);
                                DDLHandler.this.design.setDisableTreeUpdate(false);
                            }
                            DDLHandler.this.view.setImporting(false);
                        }
                    }
                    finally {
                        DDLHandler.this.view.setImporting(false);
                        DDLHandler.this.monitor.close();
                        ApplicationView.canLogging = true;
                        if (DDLHandler.this.storageDesign == null) {
                            DDLHandler.this.design.getDomainSet().sort();
                            DDLHandler.this.design.getDataTypesDesign().sortCollections();
                            DDLHandler.this.design.getRelationalDesign().sortCollections();
                        }
                        ApplicationView.log(Messages.getString("DDLHandler.ImportOfDDLFileFinished"));
                    }
                }
                catch (Throwable throwable) {
                    if (DDLHandler.this.storageDesign != null) {
                        DDLHandler.this.storageDesign.setImportStorageObjectsOnly(false);
                    }
                    DDLHandler.this.view.setCurrentDesign(DDLHandler.this.design);
                    DDLHandler.this.view.getCurrentDesign().setDesignPath(DDLHandler.this.oldDesignPath);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DDLHandler.this.relModel.setMainViewVisible(true);
                            DDLHandler.this.relModel.getMainView().getTabbedPane().setSelectedIndex(0);
                            if (DDLHandler.this.storageDesign == null) {
                                DDLHandler.this.view.centerDesign();
                            }
                            DDLHandler.this.relModel.getMainView().setDirty(true);
                        }
                    });
                    throw throwable;
                }
                if (DDLHandler.this.storageDesign != null) {
                    DDLHandler.this.storageDesign.setImportStorageObjectsOnly(false);
                }
                DDLHandler.this.view.setCurrentDesign(DDLHandler.this.design);
                DDLHandler.this.view.getCurrentDesign().setDesignPath(DDLHandler.this.oldDesignPath);
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (DDLHandler.this.design.getName().startsWith("Untitled")) {
                    DDLHandler.this.design.setFileName(DDLHandler.this.databaseName);
                }
                if (DDLHandler.this.view.getSettings().showImportLog()) {
                    object = new LogReport(DDLHandler.this.view);
                    ((LogReport)object).setLog(importLogger.generateDDLReport(DDLHandler.this.view, DDLHandler.this.getStatementsCount()));
                    ((LogReport)object).showModalDialog(new Dimension(750, 550));
                }
            }
            catch (Exception exception) {
                DDLHandler.this.view.setImporting(false);
                DDLHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + DDLHandler.this.databaseName, exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DDLHandler.UnableToImportTheFile"), Messages.getString("DDLHandler.ErrorImportingFile"), 0);
            }
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean bl;
                Object object;
                DDLHandler.this.design.setDisableTreeUpdate(true);
                DDLHandler.this.oldDesign.setDisableTreeUpdate(true);
                ImportLogger importLogger = new ImportLogger();
                try {
                    if (DDLHandler.this.storageDesign != null) {
                        DDLHandler.this.storageDesign.setImportStorageObjectsOnly(true);
                    }
                    DDLHandler.this.monitor = new ProgressDialog(DDLHandler.this.view, "", 0, 100);
                    ApplicationView.canLogging = false;
                    try {
                        DDLHandler.this.view.setImporting(true);
                        DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.CollectDDLStatements"));
                        DDLHandler.this.monitor.setProgress(2);
                        object = BaseDDLFileHandler.geDDLFileHandler(DDLHandler.this.dbType);
                        for (bl = false; bl < DDLHandler.this.files.length; bl += 1) {
                            ((BaseDDLFileHandler)object).setFile((File)DDLHandler.this.files[bl]);
                            DDLHandler.this.statementFileMap.put(DDLHandler.this.statementCollection.size(), ((File)DDLHandler.this.files[bl]).getName());
                            DDLHandler.this.statementCollection.addAll(((BaseDDLFileHandler)object).getDDLStatements(DDLHandler.this.dbType));
                        }
                        DDLHandler.this.design.setPropagatePKChahges(false);
                        try {
                            if (DDLHandler.this.design.getAppView().getSettings().isCreateDomainsDuringImport()) {
                                DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.ConstructDomains"));
                                DDLHandler.this.monitor.setProgress(5);
                                DDLHandler.this.constructDomains();
                            }
                            DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.ParseFile"));
                            DDLHandler.this.monitor.setProgress(10);
                            DDLHandler.this.parseFile(importLogger);
                            DDLHandler.this.monitor.setProgress(100);
                            DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setOpen(true);
                            DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setTempModel(false);
                            DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).sortCollections();
                            System.gc();
                        }
                        finally {
                            DDLHandler.this.design.setPropagatePKChahges(true);
                            DDLHandler.this.design.setDisableTreeUpdate(false);
                            DDLHandler.this.oldDesign.setDisableTreeUpdate(false);
                            DDLHandler.this.view.setImporting(false);
                        }
                    }
                    finally {
                        DDLHandler.this.view.setImporting(false);
                        DDLHandler.this.monitor.close();
                        ApplicationView.canLogging = true;
                        if (DDLHandler.this.storageDesign == null) {
                            DDLHandler.this.design.getDomainSet().sort();
                            DDLHandler.this.design.getDataTypesDesign().sortCollections();
                            DDLHandler.this.design.getRelationalDesign().sortCollections();
                        }
                        ApplicationView.log(Messages.getString("DDLHandler.ImportOfDDLFileFinished"));
                    }
                }
                finally {
                    if (DDLHandler.this.storageDesign != null) {
                        DDLHandler.this.storageDesign.setImportStorageObjectsOnly(false);
                    }
                }
                if (DDLHandler.this.view.getSettings().showImportLog()) {
                    object = new LogReport(DDLHandler.this.view);
                    ((LogReport)object).setLog(importLogger.generateDDLReport(DDLHandler.this.view, DDLHandler.this.getStatementsCount()));
                    ((LogReport)object).showModalDialog(new Dimension(750, 550));
                }
                object = DDLHandler.this.design.getRelationalDesign();
                bl = DDLHandler.this.relModel == null || DDLHandler.this.relModel.isEmpty();
                DDLHandler.this.design = DDLHandler.this.oldDesign;
                DDLHandler.this.view.setCurrentDesign(DDLHandler.this.design);
                DDLHandler.this.view.getCurrentDesign().setDesignPath(DDLHandler.this.oldDesignPath);
                DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setOpen(true);
                DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setTempModel(false);
                DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setDirty(true);
                try {
                    CompareModelsDialog compareModelsDialog;
                    PropertiesComparator.DDL_ONLY = true;
                    ModelChooserDialog.isSelectedDatabase = true;
                    if (DDLHandler.this.swapTargetModel) {
                        compareModelsDialog = new CompareModelsDialog(DDLHandler.this.view, DDLHandler.this.design.getRelationalDesign(), (RelationalDesign)object, bl, DDLHandler.this.isNewModel, true, DDLHandler.this.oldStorageDesigns);
                        compareModelsDialog.setImporting(true);
                    } else {
                        compareModelsDialog = new CompareModelsDialog(DDLHandler.this.view, (RelationalDesign)object, DDLHandler.this.design.getRelationalDesign(), bl, DDLHandler.this.isNewModel, false, DDLHandler.this.oldStorageDesigns);
                        compareModelsDialog.setImporting(true);
                    }
                    DDLHandler.this.view.setMerging(false);
                    compareModelsDialog.show();
                }
                finally {
                    PropertiesComparator.DDL_ONLY = false;
                }
                DDLHandler.this.view.setMerging(false);
            }
            catch (Exception exception) {
                DDLHandler.this.view.setImporting(false);
                DDLHandler.this.design = DDLHandler.this.oldDesign;
                DDLHandler.this.view.setCurrentDesign(DDLHandler.this.design);
                DDLHandler.this.view.getCurrentDesign().setDesignPath(DDLHandler.this.oldDesignPath);
                DDLHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + DDLHandler.this.databaseName, exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DDLHandler.UnableToImportTheFile"), Messages.getString("DDLHandler.ErrorImportingFile"), 0);
            }
        }
    }
}

