/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.BaseDDLFileHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.util.IdeUtil;

public class DDLFileHandler
extends BaseDDLFileHandler {
    public static final String ENCODED_CR = "$%@*$";
    public static final String ENCODED_CR_PATTERN = "\\$\\%\\@\\*\\$";
    private static final String CREATE_PACKAGE = "CREATE PACKAGE";
    private static final String CREATE_OR_REPLACE_PACKAGE = "CREATE OR REPLACE PACKAGE";
    private static final String CREATE_PACKAGE_BODY = "CREATE PACKAGE BODY";
    private static final String CREATE_OR_REPLACE_PACKAGE_BODY = "CREATE OR REPLACE PACKAGE BODY";
    private static final String CREATE_TYPE_BODY = "CREATE TYPE BODY";
    private static final String CREATE_OR_REPLACE_TYPE_BODY = "CREATE OR REPLACE TYPE BODY";
    private static final String CREATE_TRIGGER = "CREATE TRIGGER";
    private static final String CREATE_OR_REPLACE_TRIGGER = "CREATE OR REPLACE TRIGGER";
    private static final String CREATE_PROCEDURE = "CREATE PROCEDURE";
    private static final String CREATE_OR_REPLACE_PROCEDURE = "CREATE OR REPLACE PROCEDURE";
    private static final String BEGIN = "BEGIN";
    private static final String END = "END";
    private static final String LOOP = "LOOP";
    private static final String CREATE = "CREATE";
    private static final String FUNCTION = "FUNCTION";
    private static final String[] RESERVED_WORDS = new String[]{" TRIGGER "};
    private StreamTokenizer st;
    private InputStream is;
    private InputStreamReader isr;
    private BufferedReader in;
    private File file;
    private static Map oracleStartWithMap = new TreeMap();
    private static final Logger LOGGER = new Logger(DDLFileHandler.class);

    private void setBuffer() {
        try {
            this.is = new FileInputStream(this.file);
            this.isr = new InputStreamReader(this.is, IdeUtil.getIdeEncoding());
            this.in = new BufferedReader(this.isr);
            this.st = new StreamTokenizer(this.in);
            this.st.commentChar(45);
            this.st.slashStarComments(true);
            this.st.eolIsSignificant(true);
            this.st.wordChars(95, 95);
            this.st.wordChars(44, 44);
            this.st.wordChars(9, 9);
            this.st.wordChars(32, 32);
            this.st.wordChars(40, 41);
            this.st.wordChars(59, 59);
            this.st.wordChars(61, 61);
            this.st.wordChars(62, 62);
            this.st.wordChars(60, 60);
            this.st.wordChars(34, 34);
            this.st.wordChars(39, 39);
            this.st.wordChars(58, 58);
            this.st.wordChars(92, 92);
            this.st.wordChars(36, 36);
            this.st.wordChars(38, 38);
            this.st.wordChars(47, 47);
            this.st.wordChars(64, 64);
            this.st.wordChars(45, 45);
            this.st.wordChars(43, 43);
            this.st.wordChars(37, 37);
            this.st.wordChars(91, 91);
            this.st.wordChars(93, 93);
            this.st.wordChars(42, 42);
            this.st.wordChars(124, 124);
            this.st.wordChars(35, 35);
            this.st.wordChars(33, 33);
            this.st.wordChars(63, 63);
        }
        catch (IOException iOException) {
            LOGGER.error("ERROR reading file in DDLFileHandler.setBuffer()", iOException);
        }
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        this.setBuffer();
    }

    private boolean isValidEnd(int n, String string) {
        String string2 = DDLStatementHandler.clearCR(string).toUpperCase();
        if (string2.startsWith(CREATE)) {
            if (string.toUpperCase().indexOf(FUNCTION) > -1) {
                return !Token.hasToken(string, BEGIN);
            }
            if ((n == 7 || n == 8 || n == 10) && (string2.startsWith(CREATE_PROCEDURE) || string2.startsWith(CREATE_OR_REPLACE_PROCEDURE))) {
                return false;
            }
            if (n != 1 && n != 5 && n != 2 && n != 6) {
                for (int i = 0; i < RESERVED_WORDS.length; ++i) {
                    String string3 = RESERVED_WORDS[i];
                    if (string2.indexOf(string3) <= -1) continue;
                    return false;
                }
            }
        } else if (string2.startsWith(BEGIN)) {
            return false;
        }
        return true;
    }

    private String removeComments(String string) {
        try {
            int n = string.indexOf("--");
            if (n > -1) {
                if (n == 0) {
                    return "";
                }
                String string2 = string.substring(0, n - 1).trim();
                return string2;
            }
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("DDLFileHandler.removeComments()", exception);
            return "";
        }
    }

    private static void initStartWithMap() {
        oracleStartWithMap.put("APPEND", "APPEND");
        oracleStartWithMap.put("CHANGE", "CHANGE");
        oracleStartWithMap.put("CONNECT", "CONNECT");
        oracleStartWithMap.put("DEL", "DEL");
        oracleStartWithMap.put("INPUT", "INPUT");
        oracleStartWithMap.put("LIST", "LIST");
        oracleStartWithMap.put("EDIT", "EDIT");
        oracleStartWithMap.put("GET", "GET");
        oracleStartWithMap.put("REM", "REM");
        oracleStartWithMap.put("REMARK", "REMARK");
        oracleStartWithMap.put("SAV", "SAV");
        oracleStartWithMap.put("SAVE", "SAVE");
        oracleStartWithMap.put("STA", "STA");
        oracleStartWithMap.put("START", "START");
        oracleStartWithMap.put("WHENEVER", "WHENEVER");
        oracleStartWithMap.put("ACC", "ACC");
        oracleStartWithMap.put("ACCEPT", "ACCEPT");
        oracleStartWithMap.put("DEF", "DEF");
        oracleStartWithMap.put("DEFINE", "DEFINE");
        oracleStartWithMap.put("PAU", "PAU");
        oracleStartWithMap.put("PAUSE", "PAUSE");
        oracleStartWithMap.put("PROMPT", "PROMPT");
        oracleStartWithMap.put("UNDEF", "UNDEF");
        oracleStartWithMap.put("UNDEFINE", "UNDEFINE");
        oracleStartWithMap.put("PRINT", "PRINT");
        oracleStartWithMap.put("VAR", "VAR");
        oracleStartWithMap.put("VARIABLE", "VARIABLE");
        oracleStartWithMap.put("SET", "SET");
        oracleStartWithMap.put("SHOW", "SHOW");
    }

    private String getDDLStatement(int n) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.nextToken().trim();
        if (n == 7 || n == 8 || n == 10) {
            String string2 = Token.getFirstToken(string.trim().toUpperCase());
            while ((string.trim().startsWith("--") || oracleStartWithMap.get(string2) != null) && string.trim() != "") {
                string = this.nextToken().trim();
                string2 = Token.getFirstToken(string.trim().toUpperCase());
            }
        } else {
            while (string.trim().startsWith("--") && string.trim() != "") {
                string = this.nextToken().trim();
            }
        }
        block11: while (!"".equalsIgnoreCase(string)) {
            int n2;
            int n3;
            String string3;
            bl = false;
            int n4 = string.indexOf(59);
            if (n4 > -1 && ((string3 = stringBuffer.toString() + string).indexOf(34) > -1 || string3.indexOf(39) > -1)) {
                String string4 = string3.substring(0, string3.lastIndexOf(59));
                n3 = 0;
                while (n3 == 0) {
                    int n5 = string4.indexOf(34);
                    int n6 = n5 >= 0 ? n5 : string4.length();
                    int n7 = string4.substring(0, n6).indexOf(39);
                    if (n7 >= 0) {
                        string4 = string4.substring(n7 + 1);
                        n2 = string4.indexOf(39);
                    } else if (n5 >= 0) {
                        string4 = string4.substring(n5 + 1);
                        n2 = string4.indexOf(34);
                    } else {
                        n2 = -1;
                        n3 = 1;
                    }
                    if (n2 >= 0) {
                        string4 = string4.substring(n2 + 1);
                        continue;
                    }
                    if (n3 != 0) continue;
                    n4 = -1;
                    n3 = 1;
                }
            }
            int n8 = -1;
            int n9 = string.indexOf(47);
            if (n9 > -1 && Token.isBetweenQuotes(string, "/")) {
                n9 = -1;
            }
            n3 = -1;
            if (Token.hasToken(string.trim(), "GO")) {
                n8 = 0;
            }
            if (string.trim().toUpperCase().startsWith(END)) {
                n3 = 0;
            }
            n2 = -1;
            switch (n) {
                case 7: {
                    String string5;
                    String string6 = DDLStatementHandler.clearCR(stringBuffer.toString());
                    string6 = Token.replaceAll(string6, " ", " ").trim().toUpperCase();
                    if (string6.startsWith(CREATE_PACKAGE) || string6.startsWith(CREATE_OR_REPLACE_PACKAGE) || string6.startsWith(CREATE_PACKAGE_BODY) || string6.startsWith(CREATE_OR_REPLACE_PACKAGE_BODY) || string6.startsWith(CREATE_TRIGGER) || string6.startsWith(CREATE_OR_REPLACE_TRIGGER) || string6.startsWith(CREATE_PROCEDURE) || string6.startsWith(CREATE_OR_REPLACE_PROCEDURE) || string6.startsWith("BEGIN ")) {
                        bl = true;
                        if (n9 >= 0) {
                            n2 = n9;
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                        if (n3 >= 0 && this.matchNumberEndPackage(stringBuffer.toString() + string, END) == this.matchNumber(stringBuffer.toString(), BEGIN)) {
                            stringBuffer.append(string);
                            string = this.nextToken().trim();
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                    } else if (string6.startsWith(CREATE_TYPE_BODY) || string6.startsWith(CREATE_OR_REPLACE_TYPE_BODY)) {
                        String string7;
                        bl = true;
                        if (n9 >= 0) {
                            n2 = n9;
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                        if ((n3 >= 0 || string.toUpperCase().equals(END)) && this.matchNumberToken(string7 = DDLStatementHandler.clearCR(stringBuffer.toString() + string), END) == this.matchNumberToken(string7, BEGIN) + this.numberOf(stringBuffer.toString(), "IF ") + this.numberOf(stringBuffer.toString(), "LOOP ") + this.numberOf(stringBuffer.toString(), "CASE ") + 1) {
                            stringBuffer.append(string);
                            string = this.nextToken().trim();
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                    } else if (!this.isValidEnd(7, stringBuffer.toString())) {
                        if (n9 == string.trim().length() - 1) {
                            n2 = n9;
                            if (string.trim().length() != 1) continue block11;
                            string = this.nextToken().trim();
                            break;
                        }
                        if (n3 >= 0 && this.matchNumberPointComma(stringBuffer.toString(), END) == this.matchNumber(stringBuffer.toString(), BEGIN) - 1) {
                            stringBuffer.append(string);
                            string = this.nextToken().trim();
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                    }
                    if (!(n4 < 0 || !this.isValidEnd(7, stringBuffer.toString()) || string6.startsWith(CREATE_PACKAGE) || string6.startsWith(CREATE_OR_REPLACE_PACKAGE) || string6.startsWith(CREATE_PACKAGE_BODY) || string6.startsWith(CREATE_OR_REPLACE_PACKAGE_BODY) || string6.startsWith(CREATE_TYPE_BODY) || string6.startsWith(CREATE_OR_REPLACE_TYPE_BODY) || string6.startsWith(CREATE_TRIGGER) || string6.startsWith(CREATE_OR_REPLACE_TRIGGER) || string6.startsWith(CREATE_PROCEDURE) || string6.startsWith(CREATE_OR_REPLACE_PROCEDURE) || string6.startsWith("BEGIN "))) {
                        n2 = n4;
                    }
                    if (!(n9 != string.trim().length() - 1 || !this.isValidEnd(7, stringBuffer.toString()) || string6.startsWith(CREATE_PACKAGE) || string6.startsWith(CREATE_OR_REPLACE_PACKAGE) || string6.startsWith(CREATE_PACKAGE_BODY) || string6.startsWith(CREATE_OR_REPLACE_PACKAGE_BODY) || string6.startsWith(CREATE_TYPE_BODY) || string6.startsWith(CREATE_OR_REPLACE_TYPE_BODY) || string6.startsWith(CREATE_TRIGGER) || string6.startsWith(CREATE_OR_REPLACE_TRIGGER) || string6.startsWith(CREATE_PROCEDURE) || string6.startsWith(CREATE_OR_REPLACE_PROCEDURE) || string6.startsWith("BEGIN "))) {
                        n2 = n9;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n2 == -1) {
                        stringBuffer.append(string);
                        if (string.endsWith(";")) {
                            stringBuffer.append('\n');
                        } else {
                            stringBuffer.append(" ");
                        }
                        string = this.nextToken().trim();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        String string8 = Token.getFirstToken(string.trim().toUpperCase());
                        while ((string.trim().startsWith("--") || !bl && string8.equalsIgnoreCase("SET") || oracleStartWithMap.get(string8) != null) && string != "") {
                            string = this.nextToken().trim();
                            string8 = Token.getFirstToken(string.trim().toUpperCase());
                        }
                        string5 = stringBuffer2.toString();
                        if ("".equalsIgnoreCase(string5)) continue block11;
                        stringBuffer2.delete(0, stringBuffer2.length() - 1);
                        string = stringBuffer2.append('\n').append(string5).append('\n').append(string).toString();
                        break;
                    }
                    if (stringBuffer.toString().equalsIgnoreCase("")) {
                        string = this.nextToken().trim();
                        break;
                    }
                    return stringBuffer.toString().trim();
                }
                case 8: 
                case 10: {
                    String string5;
                    String string9 = DDLStatementHandler.clearCR(stringBuffer.toString()).toUpperCase();
                    if (string9.startsWith(CREATE_PACKAGE) || string9.startsWith(CREATE_OR_REPLACE_PACKAGE) || string9.startsWith(CREATE_PACKAGE_BODY) || string9.startsWith(CREATE_OR_REPLACE_PACKAGE_BODY) || string9.startsWith(CREATE_TRIGGER) || string9.startsWith(CREATE_OR_REPLACE_TRIGGER) || string9.startsWith(CREATE_PROCEDURE) || string9.startsWith(CREATE_OR_REPLACE_PROCEDURE) || string9.startsWith("BEGIN ")) {
                        bl = true;
                        if (n9 >= 0) {
                            n2 = n9;
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                        if (n3 >= 0 && this.matchNumberEndPackage(stringBuffer.toString() + string, END) == this.matchNumber(stringBuffer.toString(), BEGIN)) {
                            stringBuffer.append(string);
                            string = this.nextToken().trim();
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                    } else if (Token.startsWithString(string9, CREATE_TYPE_BODY) || Token.startsWithString(string9, CREATE_OR_REPLACE_TYPE_BODY)) {
                        String string10;
                        bl = true;
                        if (n9 >= 0) {
                            n2 = n9;
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                        if ((n3 >= 0 || string.toUpperCase().equals(END)) && this.matchNumberToken(string10 = DDLStatementHandler.clearCR(stringBuffer.toString() + string), END) == this.matchNumberToken(string10, BEGIN) + this.numberOf(stringBuffer.toString(), "IF ") + this.numberOf(stringBuffer.toString(), "LOOP ") + this.numberOf(stringBuffer.toString(), "CASE ") + 1) {
                            stringBuffer.append(string);
                            string = this.nextToken().trim();
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                    } else if (!this.isValidEnd(8, stringBuffer.toString()) && n3 >= 0) {
                        if (n9 == string.trim().length() - 1) {
                            n2 = n9;
                            if (string.trim().length() != 1) continue block11;
                            string = this.nextToken().trim();
                            break;
                        }
                        if (this.matchNumberPointComma(stringBuffer.toString(), END) == this.matchNumber(stringBuffer.toString(), BEGIN) - 1) {
                            stringBuffer.append(string);
                            string = this.nextToken().trim();
                            stringBuffer.append(string);
                            return stringBuffer.toString().trim();
                        }
                    }
                    if (!(n4 < 0 || !this.isValidEnd(8, stringBuffer.toString()) || Token.startsWithString(string9, CREATE_PACKAGE) || Token.startsWithString(string9, CREATE_OR_REPLACE_PACKAGE) || Token.startsWithString(string9, CREATE_PACKAGE_BODY) || Token.startsWithString(string9, CREATE_OR_REPLACE_PACKAGE_BODY) || Token.startsWithString(string9, CREATE_TYPE_BODY) || Token.startsWithString(string9, CREATE_OR_REPLACE_TYPE_BODY) || Token.startsWithString(string9, CREATE_TRIGGER) || Token.startsWithString(string9, CREATE_OR_REPLACE_TRIGGER) || Token.startsWithString(string9, CREATE_PROCEDURE) || Token.startsWithString(string9, CREATE_OR_REPLACE_PROCEDURE) || Token.startsWithString(string9, BEGIN))) {
                        n2 = n4;
                    }
                    if (!(n9 != string.trim().length() - 1 || !this.isValidEnd(8, stringBuffer.toString()) || Token.startsWithString(string9, CREATE_PACKAGE) || Token.startsWithString(string9, CREATE_OR_REPLACE_PACKAGE) || Token.startsWithString(string9, CREATE_PACKAGE_BODY) || Token.startsWithString(string9, CREATE_OR_REPLACE_PACKAGE_BODY) || Token.startsWithString(string9, CREATE_TYPE_BODY) || Token.startsWithString(string9, CREATE_OR_REPLACE_TYPE_BODY) || Token.startsWithString(string9, CREATE_TRIGGER) || Token.startsWithString(string9, CREATE_OR_REPLACE_TRIGGER) || Token.startsWithString(string9, CREATE_PROCEDURE) || Token.startsWithString(string9, CREATE_OR_REPLACE_PROCEDURE) || Token.startsWithString(string9, BEGIN))) {
                        n2 = n9;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n2 == -1) {
                        stringBuffer.append(string);
                        if (string.endsWith(";")) {
                            stringBuffer.append('\n');
                        } else {
                            stringBuffer.append(" ");
                        }
                        string = this.nextToken().trim();
                        StringBuffer stringBuffer3 = new StringBuffer();
                        String string11 = Token.getFirstToken(string.trim().toUpperCase());
                        while ((string.trim().startsWith("--") || !bl && string11.equalsIgnoreCase("SET") || oracleStartWithMap.get(string11) != null) && string != "") {
                            string = this.nextToken().trim();
                            string11 = Token.getFirstToken(string.trim().toUpperCase());
                        }
                        string5 = stringBuffer3.toString();
                        if ("".equalsIgnoreCase(string5)) continue block11;
                        stringBuffer3.delete(0, stringBuffer3.length() - 1);
                        string = stringBuffer3.append('\n').append(string5).append('\n').append(string).toString();
                        break;
                    }
                    if (stringBuffer.toString().equalsIgnoreCase("")) {
                        string = this.nextToken().trim();
                        break;
                    }
                    return stringBuffer.toString().trim();
                }
                case 1: {
                    if (!this.isValidEnd(1, stringBuffer.toString()) && n3 >= 0 && this.matchNumberPointComma(stringBuffer.toString(), END) == this.matchNumber(stringBuffer.toString(), BEGIN) - 1) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n4 >= 0 && this.isValidEnd(1, stringBuffer.toString())) {
                        n2 = n4;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n2 == -1) {
                        stringBuffer.append(string);
                        stringBuffer.append(" ");
                        string = this.nextToken().trim();
                        StringBuffer stringBuffer4 = new StringBuffer();
                        while (string.trim().startsWith("--") && string != "") {
                            string = this.nextToken().trim();
                        }
                        String string12 = stringBuffer4.toString();
                        if ("".equalsIgnoreCase(string12)) continue block11;
                        stringBuffer4.delete(0, stringBuffer4.length() - 1);
                        string = stringBuffer4.append('\n').append(string12).append('\n').append(string).toString();
                        break;
                    }
                    if (stringBuffer.toString().trim().equalsIgnoreCase("")) {
                        string = this.nextToken().trim();
                        break;
                    }
                    return stringBuffer.toString().trim();
                }
                case 5: {
                    if (!this.isValidEnd(5, stringBuffer.toString()) && n3 >= 0 && this.matchNumberPointComma(stringBuffer.toString(), END) == this.matchNumber(stringBuffer.toString(), BEGIN) - 1) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n4 >= 0 && this.isValidEnd(5, stringBuffer.toString())) {
                        n2 = n4;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n2 == -1) {
                        stringBuffer.append(string);
                        stringBuffer.append(" ");
                        string = this.nextToken().trim();
                        StringBuffer stringBuffer5 = new StringBuffer();
                        while (string.trim().startsWith("--") && string != "") {
                            string = this.nextToken().trim();
                        }
                        String string13 = stringBuffer5.toString();
                        if ("".equalsIgnoreCase(string13)) continue block11;
                        stringBuffer5.delete(0, stringBuffer5.length() - 1);
                        string = stringBuffer5.append('\n').append(string13).append('\n').append(string).toString();
                        break;
                    }
                    if (stringBuffer.toString().trim().equalsIgnoreCase("")) {
                        string = this.nextToken().trim();
                        break;
                    }
                    return stringBuffer.toString().trim();
                }
                case 2: {
                    if (!this.isValidEnd(2, stringBuffer.toString()) && n3 >= 0 && this.matchNumberPointComma(stringBuffer.toString(), END) == this.matchNumber(stringBuffer.toString(), BEGIN) - 1) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n4 >= 0 && this.isValidEnd(2, stringBuffer.toString())) {
                        n2 = n4;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n2 == -1) {
                        stringBuffer.append(string);
                        stringBuffer.append(" ");
                        string = this.nextToken().trim();
                        StringBuffer stringBuffer6 = new StringBuffer();
                        while (string.trim().startsWith("--") && string != "") {
                            string = this.nextToken().trim();
                        }
                        String string14 = stringBuffer6.toString();
                        if ("".equalsIgnoreCase(string14)) continue block11;
                        stringBuffer6.delete(0, stringBuffer6.length() - 1);
                        string = stringBuffer6.append('\n').append(string14).append('\n').append(string).toString();
                        break;
                    }
                    if (stringBuffer.toString().trim().equalsIgnoreCase("")) {
                        string = this.nextToken().trim();
                        break;
                    }
                    return stringBuffer.toString().trim();
                }
                case 6: {
                    if (!this.isValidEnd(6, stringBuffer.toString()) && n3 >= 0 && this.matchNumberPointComma(stringBuffer.toString(), END) == this.matchNumber(stringBuffer.toString(), BEGIN) - 1) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n4 >= 0 && this.isValidEnd(6, stringBuffer.toString())) {
                        n2 = n4;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n2 == -1) {
                        stringBuffer.append(string);
                        stringBuffer.append(" ");
                        string = this.nextToken().trim();
                        StringBuffer stringBuffer7 = new StringBuffer();
                        while (string.trim().startsWith("--") && string != "") {
                            string = this.nextToken().trim();
                        }
                        String string15 = stringBuffer7.toString();
                        if ("".equalsIgnoreCase(string15)) continue block11;
                        stringBuffer7.delete(0, stringBuffer7.length() - 1);
                        string = stringBuffer7.append('\n').append(string15).append('\n').append(string).toString();
                        break;
                    }
                    if (stringBuffer.toString().trim().equalsIgnoreCase("")) {
                        string = this.nextToken().trim();
                        break;
                    }
                    return stringBuffer.toString().trim();
                }
                case 4: {
                    if (n4 >= 0) {
                        n2 = n4;
                    } else if (n8 > -1) {
                        n2 = n8;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n2 == -1) {
                        stringBuffer.append(string);
                        stringBuffer.append(" ");
                        string = this.nextToken().trim();
                        StringBuffer stringBuffer8 = new StringBuffer();
                        while (string.trim().startsWith("--") && string != "") {
                            string = this.nextToken().trim();
                        }
                        String string16 = stringBuffer8.toString();
                        if ("".equalsIgnoreCase(string16)) continue block11;
                        stringBuffer8.delete(0, stringBuffer8.length() - 1);
                        string = stringBuffer8.append('\n').append(string16).append('\n').append(string).toString();
                        break;
                    }
                    return stringBuffer.toString().trim();
                }
                default: {
                    if (n4 >= 0) {
                        n2 = n4;
                    } else if (n8 > -1) {
                        n2 = n8;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(string);
                        return stringBuffer.toString().trim();
                    }
                    if (n2 == -1) {
                        stringBuffer.append(string);
                        stringBuffer.append(" ");
                        string = this.nextToken().trim();
                        StringBuffer stringBuffer9 = new StringBuffer();
                        while (string.trim().startsWith("--") && string != "") {
                            string = this.nextToken().trim();
                        }
                        String string17 = stringBuffer9.toString();
                        if ("".equalsIgnoreCase(string17)) continue block11;
                        stringBuffer9.delete(0, stringBuffer9.length() - 1);
                        string = stringBuffer9.append('\n').append(string17).append('\n').append(string).toString();
                        break;
                    }
                    return stringBuffer.toString().trim();
                }
            }
        }
        return "";
    }

    @Override
    public List getDDLStatements(int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = this.getDDLStatement(n);
        string = Token.replaceAll(string, "\t", " ");
        string = Token.replaceAll(string, String.valueOf('\u2019'), "'");
        string = Token.replaceAll(string, "`", "'");
        if (n == 7 || n == 8 || n == 10) {
            if (string.endsWith(";") || string.endsWith("/")) {
                string = string.substring(0, string.length() - 1).trim();
            }
            while (!string.equals("")) {
                if (!string.trim().startsWith("--") && !DDLStatementHandler.clearCR(string).trim().equalsIgnoreCase("")) {
                    linkedList.addLast(string);
                }
                string = this.getDDLStatement(n);
                string = Token.replaceAll(string, "\t", " ");
                string = Token.replaceAll(string, String.valueOf('\u2019'), "'");
                if (!(string = Token.replaceAll(string, "`", "'")).endsWith(";") && !string.endsWith("/")) continue;
                string = string.substring(0, string.length() - 1).trim();
            }
        } else {
            if (string.endsWith(";")) {
                string = string.substring(0, string.length() - 1).trim();
            }
            while (!string.equals("")) {
                if (!string.startsWith("--") && !DDLStatementHandler.clearCR(string).trim().equalsIgnoreCase("")) {
                    linkedList.addLast(string);
                }
                string = this.getDDLStatement(n);
                string = Token.replaceAll(string, "\t", " ");
                string = Token.replaceAll(string, String.valueOf('\u2019'), "'");
                if (!(string = Token.replaceAll(string, "`", "'")).endsWith(";")) continue;
                string = string.substring(0, string.length() - 1).trim();
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
                this.isr.close();
                this.is.close();
            }
            catch (IOException iOException) {
                LOGGER.error("ERROR closing file in DDLFileHandler.getDDLStatements()", iOException);
            }
        }
        return linkedList;
    }

    private String nextToken() {
        String string = "";
        try {
            while (string == "" && this.st.nextToken() != -1) {
                if (this.st.ttype == -3) {
                    string = this.st.sval;
                }
                if (this.st.ttype == -2) {
                    int n = new Double(this.st.nval).intValue();
                    string = Integer.toString(n);
                }
                if (this.st.ttype == 10) {
                    string = ENCODED_CR;
                }
                if (string.trim().startsWith("--") || string.toUpperCase().trim().startsWith("REM\t") || string.toUpperCase().trim().startsWith("REM ") || string.equalsIgnoreCase("REM")) {
                    string = "";
                    continue;
                }
                if (string.indexOf("/*") <= -1) continue;
                StringBuffer stringBuffer = new StringBuffer();
                if (string.indexOf("*/") > -1) {
                    stringBuffer.append(string.substring(0, string.indexOf("/*")).trim());
                    stringBuffer.append(' ').append(string.substring(string.lastIndexOf("*/") + 2, string.length()).trim());
                    stringBuffer.append(ENCODED_CR);
                } else {
                    stringBuffer.append(string.substring(0, string.indexOf("/*")));
                    string = "";
                    boolean bl = string.indexOf("*/") == -1;
                    int n = 1;
                    int n2 = 0;
                    while (bl && this.st.nextToken() != -1) {
                        if (this.st.ttype == -3) {
                            string = this.st.sval;
                        }
                        if (this.st.ttype == -2) {
                            int n3 = new Double(this.st.nval).intValue();
                            string = Integer.toString(n3);
                        }
                        if (this.st.ttype == 10) {
                            string = ENCODED_CR;
                        }
                        boolean bl2 = bl = string.indexOf("*/") == -1;
                        if (string.indexOf("/*") > -1) {
                            ++n;
                        }
                        if (string.indexOf("*/") > -1) {
                            ++n2;
                        }
                        if (n <= n2) continue;
                        bl = true;
                    }
                    if (string.indexOf("*/") > -1) {
                        stringBuffer.append(' ').append(string.substring(string.lastIndexOf("*/") + 2));
                    }
                    stringBuffer.append(ENCODED_CR);
                }
                string = stringBuffer.toString();
            }
        }
        catch (IOException iOException) {
            LOGGER.error("ERROR reading file in DDLFileHandler.nextToken()", iOException);
        }
        return this.removeComments(string);
    }

    private int matchNumber(String string, String string2) {
        int n = 0;
        while (string.toUpperCase().indexOf(string2.toUpperCase()) > -1) {
            ++n;
            string = string.substring(string.toUpperCase().indexOf(string2.toUpperCase()) + string2.length());
        }
        return n;
    }

    private int numberOf(String string, String string2) {
        int n = 0;
        int n2 = string.toUpperCase().indexOf(ENCODED_CR + string2.toUpperCase());
        while (n2 > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n2));
            stringBuffer.append(' ').append(string.substring(n2 + ENCODED_CR.length(), string.length()).trim());
            string = stringBuffer.toString();
            n2 = string.toUpperCase().indexOf(ENCODED_CR + string2.toUpperCase());
        }
        while (string.toUpperCase().indexOf(' ' + string2.toUpperCase()) > -1) {
            if (!Token.getStringBefore(string, ' ' + string2).trim().toUpperCase().endsWith(END)) {
                ++n;
            }
            string = string.substring(string.toUpperCase().indexOf(' ' + string2.toUpperCase()) + string2.length() + 1);
        }
        return n;
    }

    private int matchNumberPointComma(String string, String string2) {
        int n = 0;
        while (string.toUpperCase().indexOf(string2.toUpperCase()) > -1) {
            if (!Token.getFirstToken(string = string.substring(string.toUpperCase().indexOf(string2.toUpperCase()) + 1)).equalsIgnoreCase(";")) continue;
            ++n;
        }
        return n;
    }

    private int matchNumberEndPackage(String string, String string2) {
        int n = 0;
        String string3 = Token.getStringAfter(string, "PACKAGE");
        if (Token.getFirstToken(string3).equalsIgnoreCase("BODY")) {
            string3 = Token.cutFirstToken(string3);
        }
        if ((string3 = Token.getFirstToken(string3)).indexOf(46) > -1) {
            string3 = string3.substring(string3.lastIndexOf(46) + 1);
        }
        while (string.toUpperCase().indexOf(string2.toUpperCase()) > -1) {
            string = string.substring(string.toUpperCase().indexOf(string2.toUpperCase()));
            if (!Token.getFirstToken(string = Token.cutFirstToken(string)).equalsIgnoreCase(";") && !Token.getFirstToken(string).equalsIgnoreCase(string3) && !Token.getFirstToken(string).equalsIgnoreCase(string3 + ";")) continue;
            ++n;
        }
        return n;
    }

    private int matchNumberToken(String string, String string2) {
        int n = 0;
        String string3 = "";
        if (Token.hasToken(string, string2)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken().trim();
                if (!string3.equalsIgnoreCase(string2)) continue;
                ++n;
            }
        }
        return n;
    }

    static {
        DDLFileHandler.initStartWithMap();
    }
}

