/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.ddl.DDLExtractionHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public abstract class AbstractDDLObjectHandler {
    protected DDLExtractionHandler ddlExtractionHandler;
    protected ApplicationView view;
    private List importList = new ArrayList();
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    protected int count = 0;
    private int maxTablePerRow;
    protected boolean notEmpty = false;
    private Design design;

    public AbstractDDLObjectHandler(DDLExtractionHandler dDLExtractionHandler, ApplicationView applicationView) {
        this.ddlExtractionHandler = dDLExtractionHandler;
        this.view = applicationView;
        this.design = applicationView.getCurrentDesign();
    }

    public abstract String getType();

    public abstract void generate(List var1, ImportLogger var2) throws Exception;

    public List extract(List list) throws Exception {
        return new ArrayList();
    }

    public Design getDesign() {
        return this.design;
    }

    public StorageDesign getStorageDesign() {
        return this.getDesign().getRelationalDesign().getStorageDesign();
    }

    public ApplicationView getView() {
        return this.view;
    }

    public DDLExtractionHandler getDdlExtractionHandler() {
        return this.ddlExtractionHandler;
    }

    public Design getOldDesign() {
        return this.getDdlExtractionHandler().getOldDesign();
    }

    public boolean canImport() {
        return this.view.getSettings().getRenameStrategy() != 0;
    }

    public String getPrefix() {
        if (this.view.getSettings().getRenameStrategy() == 1) {
            return this.getDesign().getName() + "_";
        }
        return this.view.getSettings().getCustomPrefix();
    }

    public List getImportList() {
        return this.importList;
    }

    public void addToImportList(Object object) {
        this.importList.add(object);
    }

    public void clearImportList() {
        this.importList.clear();
    }

    protected void resetAllObjects() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.notEmpty = false;
        this.count = 0;
    }

    protected void moveGraphical(RelationalDesign relationalDesign, RelationalDesign relationalDesign2, DesignObject designObject, DesignObject designObject2) {
        float f = (float)Math.sqrt(relationalDesign.getTableSet().size());
        this.maxTablePerRow = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        Rectangle2D rectangle2D = relationalDesign2.getMainView().getWorkSpace().getDiagramBounds();
        TopView topView = designObject.getTopView();
        Dimension dimension = designObject2.getTopView().getSize();
        if (this.count == 0) {
            this.top = (int)((double)((int)rectangle2D.getHeight()) + dimension.getHeight());
            this.left = 20;
        }
        ++this.count;
        this.width = (int)dimension.getWidth();
        this.height = (int)Math.max(dimension.getHeight(), (double)this.height);
        if (topView.getCellView() != null) {
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), designObject2.getTopView().getSize()));
        } else {
            topView.setBounds(new Rectangle(new Point(this.left, this.top), designObject2.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    protected void moveGraphical(LogicalDesign logicalDesign, LogicalDesign logicalDesign2, DesignObject designObject, DesignObject designObject2) {
        float f = (float)Math.sqrt(logicalDesign.getEntitySet().size());
        this.maxTablePerRow = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        Rectangle2D rectangle2D = logicalDesign2.getMainView().getWorkSpace().getDiagramBounds();
        TopView topView = designObject.getTopView();
        Dimension dimension = designObject2.getTopView().getSize();
        if (this.count == 0) {
            this.top = (int)((double)((int)rectangle2D.getHeight()) + dimension.getHeight());
            this.left = 20;
        }
        ++this.count;
        this.width = (int)dimension.getWidth();
        this.height = (int)Math.max(dimension.getHeight(), (double)this.height);
        if (topView.getCellView() != null) {
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), designObject2.getTopView().getSize()));
        } else {
            topView.setBounds(new Rectangle(new Point(this.left, this.top), designObject2.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    protected void setObjectBounds(DesignObject designObject, DesignObject designObject2) {
        if (designObject2.getTopView().getCellView() != null && designObject.getTopView().getBounds() != null) {
            designObject2.getTopView().getCellView().setNewBounds(designObject.getTopView().getBounds());
        } else if (designObject2.getTopView() != null && designObject.getTopView().getBounds() != null) {
            designObject2.getTopView().setBounds(designObject.getTopView().getBounds());
        }
    }
}

