/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.cwddesigner.CWDDesignObj;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDPrefixObject;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionController;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.cwddesign.DesignHandler;
import oracle.dbtools.crest.model.design.compare.cwddesign.MergingCWDDesigns;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.cwddesign.CompareCWDDesignsDialog;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class CWDExtractionController {
    private static final Logger LOGGER = new Logger(ODExtractionController.class);
    private ApplicationView view;
    private Design tempDesign;
    private Design design;
    private CWDPrefixObject prefix;
    private ProgressDialog monitor;
    private DesignHandler designHandler;

    public CWDExtractionController(ApplicationView applicationView) {
        this.view = applicationView;
        this.design = applicationView.getCurrentDesign();
    }

    public CWDExtractionHandler getExtractionHandler() {
        return CWDExtractionHandler.getInstance(this.view, this.getOldDesign());
    }

    public void initDesignHandler(List list, List list2) {
        this.designHandler = new DesignHandler(this.getTempDesign(), this.getOldDesign());
        for (CWDDesignObj cWDDesignObj : list) {
            if (!cWDDesignObj.isSelected()) continue;
            if (cWDDesignObj.getModel() instanceof RelationalDesign) {
                if (cWDDesignObj.getImportTo() instanceof RelationalDesign) {
                    this.designHandler.addRelationalModelMap((RelationalDesign)cWDDesignObj.getModel(), (RelationalDesign)cWDDesignObj.getImportTo());
                    continue;
                }
                this.designHandler.addNewRelational((RelationalDesign)cWDDesignObj.getModel());
                continue;
            }
            if (!(cWDDesignObj.getModel() instanceof LogicalDesign)) continue;
            this.designHandler.setLogicalIsSelected(true);
        }
        for (CWDDesignObj cWDDesignObj : list2) {
            if (!cWDDesignObj.isSelected()) continue;
            this.designHandler.addSubView((DesignPartViewPlaceHolder)cWDDesignObj.getObject());
        }
    }

    public void insertDesign() {
        new Thread(new Runner2()).start();
    }

    public void insertDesign(List list) {
        new Thread(new Runner(list)).start();
    }

    private void resetAutoRoute(DesignPartView designPartView) {
        if (designPartView.isAutoRoute()) {
            designPartView.getWorkSpace().updateSettings();
        }
    }

    public void showRelationalSubViews() {
        Iterator iterator = this.design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!relationalDesign.isLoaded()) continue;
            relationalDesign.setMainViewVisible(true);
            this.resetAutoRoute(relationalDesign.getMainView());
            Iterator iterator2 = relationalDesign.getDesignSubviews().iterator();
            while (iterator2.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator2.next();
                if (!designPartViewPlaceHolder.getDesignPartView().mustBeVisible()) continue;
                designPartViewPlaceHolder.setVisible(true);
                this.resetAutoRoute(designPartViewPlaceHolder.getDesignPartView());
            }
        }
    }

    public Design getOldDesign() {
        return this.design;
    }

    public ApplicationView getApplicationView() {
        return this.view;
    }

    public void setApplicationView(ApplicationView applicationView) {
        this.view = applicationView;
    }

    public List loadDesign(List list) throws Exception {
        this.getExtractionHandler().clearCWDHObjects();
        return this.getExtractionHandler().getODObjects(list);
    }

    public void loadTempDesign(File file) throws Exception {
        String string = ".dmd";
        String string2 = file.getParentFile().getAbsolutePath();
        String string3 = file.getName();
        int n = string3.lastIndexOf(".");
        if (n > -1) {
            string = string3.substring(n);
        }
        String string4 = FileUtils.removeExt(file.getName());
        ApplicationView applicationView = this.getApplicationView();
        this.tempDesign = new Design(applicationView);
        this.tempDesign.setOldRepositoryType(".xml".equalsIgnoreCase(string));
        this.tempDesign.setCompressedDesign(".dmdz".equalsIgnoreCase(string));
        this.tempDesign.setFileName(string4);
        this.tempDesign.setDesignPath(string2);
        ProgressDialog progressDialog = null;
        this.tempDesign.getBusinessInfoDesign().setLoaded(false);
        this.tempDesign.getLogicalDesign().setLoaded(false);
        applicationView.setCurrentDesign(this.tempDesign);
        applicationView.setDesignName(String.valueOf(string4));
        applicationView.getPersistenceManager().setAppView(applicationView);
        if (this.tempDesign.isOldRepositoryType()) {
            applicationView.getPersistenceManager().setAppView(applicationView);
            applicationView.getPersistenceManager().read((Object)string4, this.tempDesign, progressDialog);
            applicationView.getPersistenceManager().readSystemInit(this.tempDesign);
            this.tempDesign.loadDomainFiles();
            this.tempDesign.loadRDBMSSites();
        } else {
            applicationView.getXMLTransformationManager().openDesign(this.tempDesign, file);
            applicationView.getPersistenceManager().readSystemInit(this.tempDesign);
            applicationView.getXMLTransformationManager().loadDomains(this.tempDesign);
        }
    }

    public List getDPObject() {
        ArrayList<CWDDesignObj> arrayList = new ArrayList<CWDDesignObj>();
        LogicalDesign logicalDesign = this.tempDesign.getLogicalDesign();
        CWDDesignObj cWDDesignObj = new CWDDesignObj(false, logicalDesign, this.getOldDesign().getLogicalDesign(), "Logical Model");
        arrayList.add(cWDDesignObj);
        for (int i = 0; i < this.tempDesign.getRelationalDesigns().size(); ++i) {
            RelationalDesign relationalDesign = (RelationalDesign)this.tempDesign.getRelationalDesigns().getElement(i);
            cWDDesignObj = new CWDDesignObj(false, relationalDesign, "New Relational", "Relational Model");
            arrayList.add(cWDDesignObj);
        }
        return arrayList;
    }

    public void removeTempDesign() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                CWDExtractionController.this.tempDesign = null;
                CWDExtractionController.this.getApplicationView().setCurrentDesign(CWDExtractionController.this.design);
                System.gc();
            }
        });
        thread.start();
    }

    public Design getTempDesign() {
        return this.tempDesign;
    }

    public void setTempDesign(Design design) {
        this.tempDesign = design;
    }

    public CWDPrefixObject getPrefix() {
        if (this.prefix == null) {
            this.prefix = new CWDPrefixObject();
            this.prefix.setForEntity(this.view.getSettings().getEntityPrefix());
            this.prefix.setForTable(this.view.getSettings().getTablePrefix());
            this.prefix.setForView(this.view.getSettings().getTableViewPrefix());
        }
        return this.prefix;
    }

    public void setPrefix(CWDPrefixObject cWDPrefixObject) {
        if (cWDPrefixObject != null) {
            this.view.getSettings().setEntityPrefix(cWDPrefixObject.getForEntity());
            this.view.getSettings().setTablePrefix(cWDPrefixObject.getForTable());
            this.view.getSettings().setTableViewPrefix(cWDPrefixObject.getForView());
        }
    }

    public String getCustomPrefix() {
        return this.view.getSettings().getCustomPrefix();
    }

    public void setCustomPrefix(String string) {
        this.view.getSettings().setCustomPrefix(string);
    }

    private void importRDBMSSites(Design design) {
        String string = design.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append("_RDBMSSites");
        String string2 = stringBuffer.toString();
        RDBMSSiteSet rDBMSSiteSet = (RDBMSSiteSet)design.getAppView().getPersistenceManager().read((Object)string2, design, false);
        Iterator iterator = rDBMSSiteSet.iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            this.getOldDesign().getRDBMSSiteSet().add(rDBMSSite);
        }
    }

    private class Runner
    implements Runnable {
        List selectedObjects;

        public Runner(List list) {
            this.selectedObjects = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CWDExtractionController.this.design.closeAllDiagrams();
                CWDExtractionController.this.design.setDisableTreeUpdate(true);
                ImportLogger importLogger = new ImportLogger();
                try {
                    CWDExtractionController.this.monitor = new ProgressDialog(CWDExtractionController.this.view, "", 0, 100);
                    try {
                        CWDExtractionController.this.design.setPropagatePKChahges(false);
                        CWDExtractionController.this.design.setDisableTreeUpdate(true);
                        try {
                            CWDExtractionController.this.monitor.setProgress(5);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.GenerateDesign"));
                            CWDExtractionController.this.monitor.setProgress(10);
                            CWDExtractionController.this.getApplicationView().enableControls(false);
                            CWDExtractionController.this.importRDBMSSites(CWDExtractionController.this.tempDesign);
                            CWDExtractionController.this.getExtractionHandler().generateDesign(this.selectedObjects, importLogger);
                            CWDExtractionController.this.design.fixGeneratorIds(CWDExtractionController.this.getTempDesign());
                            CWDExtractionController.this.getApplicationView().enableControls(true);
                            ApplicationView.loading = false;
                            CWDExtractionController.this.view.setCurrentDesign(CWDExtractionController.this.design);
                            CWDExtractionController.this.design.getLogicalDesign().setMainViewVisible(false);
                            for (int i = 0; i < CWDExtractionController.this.design.getRelationalDesigns().size(); ++i) {
                                RelationalDesign relationalDesign = (RelationalDesign)CWDExtractionController.this.design.getRelationalDesigns().getElement(i);
                                relationalDesign.setMainViewVisible(false);
                            }
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeTypes"));
                            CWDExtractionController.this.monitor.setProgress(80);
                            try {
                                CWDExtractionController.this.design.getDataTypesDesign().rearrangeTypes();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Unable to rearrange Types", exception);
                            }
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeEntities"));
                            CWDExtractionController.this.monitor.setProgress(85);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeTables"));
                            CWDExtractionController.this.monitor.setProgress(90);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeViews"));
                            CWDExtractionController.this.monitor.setProgress(93);
                            CWDExtractionController.this.monitor.setProgress(95);
                            CWDExtractionController.this.design.setDirty(true);
                            CWDExtractionController.this.monitor.setProgress(100);
                            CWDExtractionController.this.view.synchronizeTitle();
                            System.gc();
                        }
                        finally {
                            CWDExtractionController.this.getExtractionHandler().clearCWDHObjects();
                            if (CWDExtractionController.this.design != null) {
                                CWDExtractionController.this.design.setPropagatePKChahges(true);
                                CWDExtractionController.this.design.setDisableTreeUpdate(false);
                            }
                        }
                    }
                    finally {
                        CWDExtractionController.this.tempDesign.clearAll(false);
                        CWDExtractionController.this.monitor.close();
                        CWDExtractionController.this.view.clearTree();
                    }
                    CWDExtractionController.this.removeTempDesign();
                }
                catch (Throwable throwable) {
                    CWDExtractionController.this.removeTempDesign();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CWDExtractionController.this.design.getLogicalDesign().setMainViewVisible(true);
                            CWDExtractionController.this.resetAutoRoute(CWDExtractionController.this.design.getLogicalDesign().getMainView());
                            Iterator iterator = CWDExtractionController.this.design.getLogicalDesign().getDesignSubviews().iterator();
                            while (iterator.hasNext()) {
                                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                                if (!designPartViewPlaceHolder.getDesignPartView().mustBeVisible()) continue;
                                designPartViewPlaceHolder.setVisible(true);
                                CWDExtractionController.this.resetAutoRoute(designPartViewPlaceHolder.getDesignPartView());
                            }
                            CWDExtractionController.this.showRelationalSubViews();
                            CWDExtractionController.this.design.setDisableTreeUpdate(false);
                            CWDExtractionController.this.view.centerDesign();
                            for (int i = 0; i < CWDExtractionController.this.design.getRelationalDesigns().size(); ++i) {
                                RelationalDesign relationalDesign = (RelationalDesign)CWDExtractionController.this.design.getRelationalDesigns().getElement(i);
                                if (relationalDesign.getTableSet().size() > 0) {
                                    CWDExtractionController.this.view.setCurrentDPV(relationalDesign.getMainView());
                                    break;
                                }
                                CWDExtractionController.this.view.setCurrentDPV(CWDExtractionController.this.design.getLogicalDesign().getMainView());
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (CWDExtractionController.this.view.getSettings().showImportLog()) {
                    LogReport logReport = new LogReport(CWDExtractionController.this.view);
                    logReport.setLog(importLogger.generateDDLReport(CWDExtractionController.this.view, this.selectedObjects.size()));
                    logReport.showDialog(new Dimension(750, 550));
                }
            }
            catch (Exception exception) {
                CWDExtractionController.this.design.destroyAll(false);
                CWDExtractionController.this.design = null;
                LOGGER.error("Error Generate Design: " + CWDExtractionController.this.view.getDesignName(), exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CWDExtractionController.UnableToGenerateDesign"), Messages.getString("CWDExtractionController.ErrorGenerateDesign"), 0);
            }
        }
    }

    private class Runner2
    implements Runnable {
        private Runner2() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CWDExtractionController.this.design.closeAllDiagrams();
                CWDExtractionController.this.design.setDisableTreeUpdate(true);
                try {
                    CWDExtractionController.this.monitor = new ProgressDialog(CWDExtractionController.this.view, "", 0, 100);
                    try {
                        CWDExtractionController.this.design.setPropagatePKChahges(false);
                        CWDExtractionController.this.design.setDisableTreeUpdate(true);
                        try {
                            RelationalDesign relationalDesign;
                            Object object2;
                            CWDExtractionController.this.monitor.setProgress(5);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.GenerateDesign"));
                            CWDExtractionController.this.getApplicationView().enableControls(false);
                            boolean bl = false;
                            CWDExtractionController.this.designHandler.getModelsToDeleteOnCancel().clear();
                            for (Object object2 : CWDExtractionController.this.designHandler.getNewRelationals()) {
                                relationalDesign = CWDExtractionController.this.designHandler.getTargetDesign().addRelationalDesign(((RelationalDesign)object2).getName());
                                CWDExtractionController.this.designHandler.addRelationalModelMap((RelationalDesign)object2, relationalDesign);
                                CWDExtractionController.this.designHandler.getModelsToDeleteOnCancel().add(relationalDesign);
                            }
                            if ((CWDExtractionController.this.designHandler.isLogicalIsSelected() || CWDExtractionController.this.designHandler.getSourceRelationalModels().size() > 0) && (bl = ((CompareCWDDesignsDialog)(object2 = new CompareCWDDesignsDialog(CWDExtractionController.this.getApplicationView(), CWDExtractionController.this.designHandler, CWDExtractionController.this.monitor))).showDialog()) && ((CompareCWDDesignsDialog)object2).getObjectsMap() != null && ((CompareCWDDesignsDialog)object2).getComparatorsMap() != null) {
                                new MergingCWDDesigns().execute(CWDExtractionController.this.designHandler, ((CompareCWDDesignsDialog)object2).getComparatorsMap(), ((CompareCWDDesignsDialog)object2).getObjectsMap(), CWDExtractionController.this.monitor);
                            }
                            CWDExtractionController.this.getApplicationView().enableControls(true);
                            ApplicationView.loading = false;
                            CWDExtractionController.this.view.setCurrentDesign(CWDExtractionController.this.design);
                            CWDExtractionController.this.design.getLogicalDesign().setMainViewVisible(false);
                            for (int i = 0; i < CWDExtractionController.this.design.getRelationalDesigns().size(); ++i) {
                                relationalDesign = (RelationalDesign)CWDExtractionController.this.design.getRelationalDesigns().getElement(i);
                                relationalDesign.setMainViewVisible(false);
                            }
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.RearrangeTypes"));
                            CWDExtractionController.this.monitor.setProgress(90);
                            CWDExtractionController.this.importRDBMSSites(CWDExtractionController.this.tempDesign);
                            CWDExtractionController.this.design.setDirty(true);
                            CWDExtractionController.this.monitor.setNote(Messages.getString("CWDExtractionController.ClearTemporaryObjects"));
                            CWDExtractionController.this.monitor.setProgress(100);
                            CWDExtractionController.this.view.synchronizeTitle();
                        }
                        finally {
                            if (CWDExtractionController.this.design != null) {
                                CWDExtractionController.this.design.setPropagatePKChahges(true);
                                CWDExtractionController.this.design.setDisableTreeUpdate(false);
                            }
                        }
                    }
                    finally {
                        CWDExtractionController.this.getExtractionHandler().clearCWDHObjects();
                        CWDExtractionController.this.tempDesign.clearAll(false);
                        CWDExtractionController.this.monitor.close();
                        CWDExtractionController.this.view.clearTree();
                        System.gc();
                    }
                    CWDExtractionController.this.removeTempDesign();
                }
                catch (Throwable throwable) {
                    CWDExtractionController.this.removeTempDesign();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CWDExtractionController.this.design.getLogicalDesign().setMainViewVisible(true);
                            CWDExtractionController.this.resetAutoRoute(CWDExtractionController.this.design.getLogicalDesign().getMainView());
                            Iterator iterator = CWDExtractionController.this.design.getLogicalDesign().getDesignSubviews().iterator();
                            while (iterator.hasNext()) {
                                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                                if (!designPartViewPlaceHolder.getDesignPartView().mustBeVisible()) continue;
                                designPartViewPlaceHolder.setVisible(true);
                                CWDExtractionController.this.resetAutoRoute(designPartViewPlaceHolder.getDesignPartView());
                            }
                            CWDExtractionController.this.showRelationalSubViews();
                            CWDExtractionController.this.design.setDisableTreeUpdate(false);
                            CWDExtractionController.this.view.centerDesign();
                            for (int i = 0; i < CWDExtractionController.this.design.getRelationalDesigns().size(); ++i) {
                                RelationalDesign relationalDesign = (RelationalDesign)CWDExtractionController.this.design.getRelationalDesigns().getElement(i);
                                if (relationalDesign.getTableSet().size() > 0) {
                                    CWDExtractionController.this.view.setCurrentDPV(relationalDesign.getMainView());
                                    break;
                                }
                                CWDExtractionController.this.view.setCurrentDPV(CWDExtractionController.this.design.getLogicalDesign().getMainView());
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception exception) {
                CWDExtractionController.this.design.destroyAll(false);
                CWDExtractionController.this.design = null;
                LOGGER.error("Error Generate Design: " + CWDExtractionController.this.view.getDesignName(), exception);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CWDExtractionController.UnableToGenerateDesign"), Messages.getString("CWDExtractionController.ErrorGenerateDesign"), 0);
            }
        }
    }
}

