/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionHandler;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class CWDBusinessInfoDesign
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DATATYPE_DESIGN";

    public CWDBusinessInfoDesign(CWDExtractionHandler cWDExtractionHandler, ApplicationView applicationView) {
        super(cWDExtractionHandler, applicationView);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(List list, ImportLogger importLogger) throws Exception {
        this.importDocuments();
        this.importEmails();
        this.importPhones();
        this.importLocations();
        this.importResources();
        this.importContacts();
        this.importPhones();
    }

    private void importContacts() {
        for (int i = 0; i < this.getDesign().getBusinessInfoDesign().getContactSet().size(); ++i) {
            BIContact bIContact;
            BIContact bIContact2 = (BIContact)this.getDesign().getBusinessInfoDesign().getContactSet().getElement(i);
            if (this.getOldDesign().getBusinessInfoDesign().getContactSet().getByName(bIContact2.getName()) != null) {
                bIContact = this.getOldDesign().getBusinessInfoDesign().createContact();
                bIContact2.copy(bIContact);
                this.getCwdExtractionHandler().addToImportedObjects(bIContact2.getObjectID(), bIContact);
                bIContact.setImportedDesign(this.getDesign());
                bIContact.setImportedId(bIContact2.getObjectID());
                continue;
            }
            bIContact = this.getOldDesign().getBusinessInfoDesign().createContact();
            bIContact2.copy(bIContact);
            this.getCwdExtractionHandler().addToImportedObjects(bIContact2.getObjectID(), bIContact);
            bIContact.setImportedDesign(this.getDesign());
            bIContact.setImportedId(bIContact2.getObjectID());
        }
    }

    private void importResources() {
        for (int i = 0; i < this.getDesign().getBusinessInfoDesign().getUrlSet().size(); ++i) {
            BIResourceLocator bIResourceLocator;
            BIResourceLocator bIResourceLocator2 = (BIResourceLocator)this.getDesign().getBusinessInfoDesign().getUrlSet().getElement(i);
            if (this.getOldDesign().getBusinessInfoDesign().getResPartySet().getByName(bIResourceLocator2.getName()) != null) {
                bIResourceLocator = this.getOldDesign().getBusinessInfoDesign().createUrl();
                bIResourceLocator2.copy(bIResourceLocator);
                bIResourceLocator2.setName(this.getPrefix() + bIResourceLocator2.getName());
                bIResourceLocator.setImportedDesign(this.getDesign());
                bIResourceLocator.setImportedId(bIResourceLocator2.getObjectID());
                continue;
            }
            bIResourceLocator = this.getOldDesign().getBusinessInfoDesign().createUrl();
            bIResourceLocator2.copy(bIResourceLocator);
            this.getCwdExtractionHandler().addToImportedObjects(bIResourceLocator2.getObjectID(), bIResourceLocator);
            bIResourceLocator.setImportedDesign(this.getDesign());
            bIResourceLocator.setImportedId(bIResourceLocator2.getObjectID());
        }
    }

    private void importLocations() {
        for (int i = 0; i < this.getDesign().getBusinessInfoDesign().getLocationSet().size(); ++i) {
            BILocation bILocation;
            BILocation bILocation2 = (BILocation)this.getDesign().getBusinessInfoDesign().getLocationSet().getElement(i);
            if (this.getOldDesign().getBusinessInfoDesign().getLocationSet().getByName(bILocation2.getName()) != null) {
                bILocation = this.getOldDesign().getBusinessInfoDesign().createLocation();
                bILocation2.copy(bILocation);
                bILocation2.setName(this.getPrefix() + bILocation2.getName());
                bILocation.setImportedDesign(this.getDesign());
                bILocation.setImportedId(bILocation2.getObjectID());
                continue;
            }
            bILocation = this.getOldDesign().getBusinessInfoDesign().createLocation();
            bILocation2.copy(bILocation);
            bILocation.setImportedDesign(this.getDesign());
            bILocation.setImportedId(bILocation2.getObjectID());
        }
    }

    private void importPhones() {
        for (int i = 0; i < this.getDesign().getBusinessInfoDesign().getPhoneSet().size(); ++i) {
            BIPhone bIPhone;
            BIPhone bIPhone2 = (BIPhone)this.getDesign().getBusinessInfoDesign().getPhoneSet().getElement(i);
            if (this.getOldDesign().getBusinessInfoDesign().getPhoneSet().getByName(bIPhone2.getName()) != null) {
                bIPhone = this.getOldDesign().getBusinessInfoDesign().createPhone();
                bIPhone2.copy(bIPhone);
                bIPhone.setImportedDesign(this.getDesign());
                bIPhone.setImportedId(bIPhone2.getObjectID());
                continue;
            }
            bIPhone = this.getOldDesign().getBusinessInfoDesign().createPhone();
            bIPhone2.copy(bIPhone);
            bIPhone.setImportedDesign(this.getDesign());
            bIPhone.setImportedId(bIPhone2.getObjectID());
        }
    }

    private void importEmails() {
        for (int i = 0; i < this.getDesign().getBusinessInfoDesign().getEmailSet().size(); ++i) {
            BIEmail bIEmail;
            BIEmail bIEmail2 = (BIEmail)this.getDesign().getBusinessInfoDesign().getEmailSet().getElement(i);
            if (this.getOldDesign().getBusinessInfoDesign().getEmailSet().getByName(bIEmail2.getName()) != null) {
                bIEmail = this.getOldDesign().getBusinessInfoDesign().createEmail();
                bIEmail2.copy(bIEmail);
                bIEmail.setName(this.getPrefix() + bIEmail2.getName());
                bIEmail.setImportedDesign(this.getDesign());
                bIEmail.setImportedId(bIEmail2.getObjectID());
                continue;
            }
            bIEmail = this.getOldDesign().getBusinessInfoDesign().createEmail();
            bIEmail2.copy(bIEmail);
            bIEmail.setImportedDesign(this.getDesign());
            bIEmail.setImportedId(bIEmail2.getObjectID());
        }
    }

    private void importDocuments() {
        for (int i = 0; i < this.getDesign().getBusinessInfoDesign().getDocumentSet().size(); ++i) {
            BIDocument bIDocument;
            BIDocument bIDocument2 = (BIDocument)this.getDesign().getBusinessInfoDesign().getDocumentSet().getElement(i);
            if (this.getOldDesign().getBusinessInfoDesign().getDocumentSet().getByName(bIDocument2.getName()) != null) {
                bIDocument = this.getOldDesign().getBusinessInfoDesign().createDocument();
                bIDocument2.copy(bIDocument);
                bIDocument.setName(this.getPrefix() + bIDocument2.getName());
                this.getCwdExtractionHandler().addToImportedObjects(bIDocument2.getObjectID(), bIDocument);
                bIDocument.setImportedDesign(this.getDesign());
                bIDocument.setImportedId(bIDocument2.getObjectID());
                continue;
            }
            bIDocument = this.getOldDesign().getBusinessInfoDesign().createDocument();
            bIDocument2.copy(bIDocument);
            this.getCwdExtractionHandler().addToImportedObjects(bIDocument2.getObjectID(), bIDocument);
            bIDocument.setImportedDesign(this.getDesign());
            bIDocument.setImportedId(bIDocument2.getObjectID());
        }
    }

    @Override
    public List extract(List list) throws Exception {
        if (!this.getDesign().getBusinessInfoDesign().isLoaded()) {
            if (this.getDesign().isOldRepositoryType()) {
                this.getDesign().getBusinessInfoDesign().load();
            } else {
                this.getDesign().getAppView().getXMLTransformationManager().openDesignPart(this.getDesign().getBusinessInfoDesign());
            }
        }
        return new ArrayList();
    }
}

