/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cubeviews;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.cubeviews.CVConstants;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsImporter;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CubeViewsImporter_8_1
extends CubeViewsImporter
implements CVConstants {
    private ArrayList attributes = new ArrayList();
    private ArrayList measures = new ArrayList();
    private ArrayList hierarchies = new ArrayList();
    private ArrayList dimensions = new ArrayList();
    private ArrayList joins = new ArrayList();
    private ArrayList cubemodels = new ArrayList();
    private DomainFactory factory = new DomainFactory();
    private LogicalDatatypeFactory factoryLogical = new LogicalDatatypeFactory();
    static int COLUMN = 0;
    static int ATTRIBUTE = 1;
    static int MEASURE = 2;

    public CubeViewsImporter_8_1(Design design) {
        super(design);
    }

    @Override
    public void parseXMLDocument(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("attribute");
        this.processAttributes(nodeList);
        nodeList = element.getElementsByTagName("measure");
        this.processMeasures(nodeList);
        nodeList = element.getElementsByTagName("join");
        this.processJoins(nodeList);
        nodeList = element.getElementsByTagName("facts");
        this.processFacts(nodeList);
        nodeList = element.getElementsByTagName("hierarchy");
        this.processHierarchies(nodeList);
        nodeList = element.getElementsByTagName("dimension");
        this.processDimensions(nodeList);
        nodeList = element.getElementsByTagName("cubeModel");
        this.processCubeModel(nodeList);
    }

    public static Element getFirstChildByTagName(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    private void processAttributes(NodeList nodeList) {
        this.attributes.clear();
        int n = nodeList.getLength();
        EntitySet entitySet = this.getDesign().getLogicalDesign().getEntitySet();
        for (int i = 0; i < n; ++i) {
            Object object;
            Attribute attribute;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("businessName");
            String string2 = element.getAttribute("name");
            String string3 = element.getAttribute("schema");
            NodeList nodeList2 = element.getElementsByTagName("sqlExpression");
            Element element2 = (Element)nodeList2.item(0);
            String string4 = element2.getAttribute("template");
            Element element3 = (Element)element2.getElementsByTagName("column").item(0);
            String string5 = element3.getAttribute("name");
            String string6 = element3.getAttribute("tableName");
            Entity entity = (Entity)entitySet.getByName(string6);
            if (entity == null) {
                entity = this.getDesign().getLogicalDesign().createEntity(string6);
            }
            if ((attribute = (Attribute)entity.getElementByName(string5)) == null) {
                attribute = entity.createAttribute(string5);
            }
            if (attribute.getLogicalDatatype().getName().equalsIgnoreCase("unknown") && string4.equalsIgnoreCase("{$$1}") && (object = (Element)element.getElementsByTagName("datatype").item(0)) != null) {
                String string7 = object.getAttribute("name");
                String string8 = object.getAttribute("length");
                String string9 = object.getAttribute("scale");
                String string10 = object.getAttribute("nullable");
                if (string10.equalsIgnoreCase("no")) {
                    attribute.setNullsAllowed(false);
                } else {
                    attribute.setNullsAllowed(true);
                }
                Domain domain = this.createDomain(string7, "DB2/UDB 8.1", string8, string9);
                attribute.setDomain(domain);
            }
            object = new HelpNode(string2);
            ((HelpNode)object).bName = string;
            ((HelpNode)object).colName = string5;
            ((HelpNode)object).tableName = string6;
            ((HelpNode)object).schema = string3;
            ((HelpNode)object).attribute = attribute;
            this.attributes.add(object);
        }
    }

    private KeyObject getKey(Entity entity, List list) {
        int n;
        DesignObject[] designObjectArray;
        KeyObject keyObject = entity.getPK();
        if (keyObject != null && (designObjectArray = keyObject.getElements()).length == list.size()) {
            n = 0;
            for (int i = 0; i < list.size() && designObjectArray[i] == list.get(i); ++i) {
                ++n;
            }
            if (n == designObjectArray.length) {
                return keyObject;
            }
        }
        designObjectArray = entity.getKeys();
        for (n = 0; n < designObjectArray.length; ++n) {
            ContainedObject[] containedObjectArray;
            KeyObject keyObject2 = (KeyObject)designObjectArray[n];
            if (keyObject == keyObject2 || (containedObjectArray = keyObject2.getElements()).length != list.size()) continue;
            int n2 = 0;
            for (int i = 0; i < list.size() && containedObjectArray[i] == list.get(i); ++i) {
                ++n2;
            }
            if (n2 != containedObjectArray.length) continue;
            return keyObject2;
        }
        return null;
    }

    private void processJoins(NodeList nodeList) {
        this.joins.clear();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("businessName");
            String string2 = element.getAttribute("name");
            String string3 = element.getAttribute("schema");
            String string4 = element.getAttribute("cardinality");
            String[] stringArray = string4.split(":");
            String string5 = stringArray[0];
            String string6 = stringArray[1];
            NodeList nodeList2 = element.getElementsByTagName("leftAttributeRef");
            NodeList nodeList3 = element.getElementsByTagName("rightAttributeRef");
            int n4 = nodeList2.getLength();
            if (n4 != (n3 = nodeList3.getLength()) || n4 <= 0) continue;
            Relation relation = null;
            HelpNode helpNode = new HelpNode(string2);
            KeyObject keyObject = null;
            KeyObject keyObject2 = null;
            Entity entity = null;
            Entity entity2 = null;
            Element element2 = (Element)nodeList2.item(0);
            Element element3 = (Element)nodeList3.item(0);
            Attribute attribute = this.findAttributeByName(element2.getAttribute("name"));
            entity = (Entity)attribute.getContainer();
            Attribute attribute2 = this.findAttributeByName(element3.getAttribute("name"));
            entity2 = (Entity)attribute2.getContainer();
            boolean bl = false;
            relation = this.getDesign().getLogicalDesign().getRelationSet().getRelationBetween(entity, entity2);
            if (relation == null) {
                relation = this.getDesign().getLogicalDesign().createRelation();
                bl = true;
            }
            if (string5.equalsIgnoreCase("n") && string6.equalsIgnoreCase("1")) {
                helpNode.chEntity = entity;
                helpNode.parEntity = entity2;
            }
            if (string5.equalsIgnoreCase("1") && string6.equalsIgnoreCase("n")) {
                helpNode.chEntity = entity2;
                helpNode.parEntity = entity;
            }
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
            for (n2 = 0; n2 < n4; ++n2) {
                element2 = (Element)nodeList2.item(n2);
                element3 = (Element)nodeList3.item(n2);
                attribute = this.findAttributeByName(element2.getAttribute("name"));
                attribute2 = this.findAttributeByName(element3.getAttribute("name"));
                if (attribute != null) {
                    arrayList.add(attribute);
                }
                if (attribute2 == null) continue;
                arrayList2.add(attribute2);
            }
            if (string5.equalsIgnoreCase("1") && (keyObject = this.getKey(entity, arrayList)) == null) {
                keyObject = entity.createCandidateKey();
            }
            if (string6.equalsIgnoreCase("1") && (keyObject2 = this.getKey(entity2, arrayList2)) == null) {
                keyObject2 = entity2.createCandidateKey();
            }
            for (n2 = 0; n2 < n4; ++n2) {
                attribute2 = (Attribute)arrayList2.get(n2);
                if (string5.equalsIgnoreCase("1")) {
                    keyObject.add(attribute);
                }
                if (string6.equalsIgnoreCase("1")) {
                    keyObject2.add(attribute2);
                }
                if (string5.equalsIgnoreCase("n") && string6.equalsIgnoreCase("1")) {
                    attribute.setReferedAttribute(attribute2.getObjectID());
                    attribute.setGeneratorID(relation.getObjectID());
                }
                if (!string5.equalsIgnoreCase("1") || !string6.equalsIgnoreCase("n")) continue;
                attribute2.setReferedAttribute(attribute.getObjectID());
                attribute2.setGeneratorID(relation.getObjectID());
            }
            if (string5.equalsIgnoreCase("1") && string6.equalsIgnoreCase("n")) {
                keyObject.setPK(true);
                keyObject.setName(keyObject.getContainerWithKeyObject().getName() + "_PK");
            }
            if (string5.equalsIgnoreCase("n") && string6.equalsIgnoreCase("1")) {
                keyObject2.setPK(true);
                keyObject2.setName(keyObject2.getContainerWithKeyObject().getName() + "_PK");
            }
            if (bl) {
                relation.setTargetEntity(entity2);
                relation.setSourceEntity(entity);
                relation.setSourceTV((TVEntity)entity.getTopView());
                relation.setTargetTV((TVEntity)entity2.getTopView());
                relation.setFireCardinalityChange(false);
                relation.setOptionalSource(false);
                relation.setOptionalTarget(false);
                if (string5.equalsIgnoreCase("n")) {
                    relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[0]);
                } else {
                    relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
                }
                relation.setFireCardinalityChange(true);
                if (string6.equalsIgnoreCase("n")) {
                    relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
                } else {
                    relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[1]);
                }
                ((TVRelation)relation.getTopView()).addConnection();
            }
            helpNode.bName = string;
            helpNode.relation = relation;
            helpNode.schema = string3;
            this.joins.add(helpNode);
        }
    }

    private Attribute findAttributeByName(String string) {
        HelpNode helpNode = this.findNodeByName(this.attributes, string);
        if (helpNode != null) {
            Entity entity = (Entity)this.getDesign().getLogicalDesign().getEntitySet().getByName(helpNode.tableName);
            return (Attribute)entity.getElementByName(helpNode.colName);
        }
        return null;
    }

    private void processMeasures(NodeList nodeList) {
        this.measures.clear();
        int n = nodeList.getLength();
        EntitySet entitySet = this.getDesign().getLogicalDesign().getEntitySet();
        for (int i = 0; i < n; ++i) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Element element = (Element)nodeList.item(i);
            String string2 = element.getAttribute("businessName");
            String string3 = element.getAttribute("name");
            String string4 = element.getAttribute("schema");
            NodeList nodeList2 = element.getElementsByTagName("sqlExpression");
            Element element2 = (Element)nodeList2.item(0);
            List list = this.getNameList(element2);
            String string5 = element2.getAttribute("template");
            Element element3 = (Element)element2.getElementsByTagName("column").item(0);
            String string6 = "";
            String string7 = "";
            if (element3 != null) {
                string6 = element3.getAttribute("name");
                string7 = element3.getAttribute("tableName");
                object3 = (Entity)entitySet.getByName(string7);
                if (object3 == null) {
                    object3 = this.getDesign().getLogicalDesign().createEntity(string7);
                }
                if (string6 != null) {
                    Element element4;
                    object2 = (Attribute)((ContainerObject)object3).getElementByName(string6);
                    if (object2 == null) {
                        object2 = ((Entity)object3).createAttribute(string6);
                    }
                    if (((Attribute)object2).getLogicalDatatype().getName().equalsIgnoreCase("unknown") && string5.equalsIgnoreCase("{$$1}") && (element4 = (Element)element.getElementsByTagName("datatype").item(0)) != null) {
                        String string8 = element4.getAttribute("name");
                        object = element4.getAttribute("length");
                        string = element4.getAttribute("scale");
                        String string9 = element4.getAttribute("nullable");
                        if (string9.equalsIgnoreCase("no")) {
                            ((Attribute)object2).setNullsAllowed(false);
                        } else {
                            ((Attribute)object2).setNullsAllowed(true);
                        }
                        Domain domain = this.createDomain(string8, "DB2/UDB 8.1", (String)object, string);
                        ((Attribute)object2).setDomain(domain);
                    }
                }
            }
            object3 = new HelpNode(string3);
            object2 = element.getElementsByTagName("aggregation");
            int n2 = object2.getLength();
            for (int j = 0; j < n2; ++j) {
                object = (Element)object2.item(j);
                string = "";
                if (object == null) continue;
                string = object.getAttribute("function");
                ((HelpNode)object3).aggrFunctions.add(string);
            }
            ((HelpNode)object3).bName = string2;
            ((HelpNode)object3).colName = string6;
            ((HelpNode)object3).tableName = string7;
            ((HelpNode)object3).schema = string4;
            ((HelpNode)object3).helpNode2List = list;
            ((HelpNode)object3).template = string5;
            this.measures.add(object3);
        }
    }

    private List getNameList(Element element) {
        ArrayList<HelpNode2> arrayList = new ArrayList<HelpNode2>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            HelpNode2 helpNode2;
            String string;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equals("column")) {
                string = ((Element)node).getAttribute("name");
                helpNode2 = new HelpNode2(string, COLUMN);
                helpNode2.tablename = ((Element)node).getAttribute("tableName");
                arrayList.add(helpNode2);
                continue;
            }
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("measureRef")) continue;
            string = ((Element)node).getAttribute("name");
            helpNode2 = new HelpNode2(string, MEASURE);
            arrayList.add(helpNode2);
        }
        return arrayList;
    }

    private void processFacts(NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Entity entity;
            Object object;
            HelpNode helpNode;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("name");
            Cube cube = this.getDesign().getMultidimensionalDesign().createCube();
            cube.setName(string);
            NodeList nodeList2 = element.getElementsByTagName("attributeRef");
            Element element2 = (Element)nodeList2.item(0);
            if (element2 != null && (helpNode = this.findNodeByName(this.attributes, (String)(object = element2.getAttribute("name")))) != null && helpNode.tableName != null && (entity = (Entity)this.getDesign().getLogicalDesign().getEntitySet().getByName(helpNode.tableName)) != null) {
                cube.setFactEntity(entity);
            }
            object = element.getElementsByTagName("measureRef");
            int n2 = object.getLength();
            for (int j = 0; j < n2; ++j) {
                Element element3 = (Element)object.item(j);
                String string2 = element3.getAttribute("name");
                HelpNode helpNode2 = this.findNodeByName(this.measures, string2);
                if (helpNode2 == null) continue;
                Measure measure = this.getDesign().getMultidimensionalDesign().createMeasure();
                measure.setName(helpNode2.name);
                this.addAggrFunctions(measure, helpNode2.aggrFunctions);
                cube.addMeasure(measure);
                this.processSQLExpr(measure, helpNode2.helpNode2List, helpNode2.template, cube.getFactEntity());
            }
        }
    }

    private void addAggrFunctions(Measure measure, List list) {
        for (String string : list) {
            Measure.AggregateFunction aggregateFunction = measure.createAggregateFunction(string);
            aggregateFunction.measureAlias = measure.getName();
            measure.getAggregateFunctions().add(aggregateFunction);
        }
        if (list.size() > 0) {
            measure.setDefaultAggregationFunction((Measure.AggregateFunction)measure.getAggregateFunctions().get(0));
        }
    }

    private void processSQLExpr(Measure measure, List list, String string, ContainerObject containerObject) {
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            HelpNode2 helpNode2 = (HelpNode2)list.get(i);
            if (i == 0 && helpNode2.type == COLUMN && list.size() == 1) {
                if (containerObject != null && (object = containerObject.getElementByName(helpNode2.name)) != null) {
                    measure.getAttributes().add(object);
                }
                return;
            }
            object = "{$$" + Integer.toString(i + 1) + "}";
            String string2 = this.noBrackets(helpNode2.name);
            string = this.replace(string, (String)object, string2);
        }
        measure.setFormula(true);
        measure.setFormula(string);
    }

    private String replace(String string, String string2, String string3) {
        String string4 = string;
        int n = string2.length();
        int n2 = string4.indexOf(string2);
        while (n2 > -1) {
            String string5 = n2 == 0 ? "" : string4.substring(0, n2);
            string4 = string5 + string3 + string4.substring(n2 + n);
            n2 = string4.indexOf(string2);
        }
        return string4;
    }

    private void processHierarchies(NodeList nodeList) {
        this.hierarchies.clear();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("businessName");
            String string2 = element.getAttribute("name");
            String string3 = element.getAttribute("schema");
            NodeList nodeList2 = element.getElementsByTagName("attributeRelationshipRef");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Level> arrayList2 = new ArrayList<Level>();
            ArrayList<Link> arrayList3 = new ArrayList<Link>();
            int n2 = nodeList2.getLength();
            for (int j = n2 - 1; j > -1; --j) {
                Element element2 = (Element)nodeList2.item(j);
                object = element2.getAttribute("name");
                arrayList.add((String)object);
            }
            NodeList nodeList3 = element.getElementsByTagName("attributeRef");
            int n3 = nodeList3.getLength();
            object = null;
            for (int j = n3 - 1; j > -1; --j) {
                Object object2;
                Object object3;
                Element element3 = (Element)nodeList3.item(j);
                String string4 = element3.getAttribute("name");
                HelpNode helpNode = this.findNodeByName(this.attributes, string4);
                if (helpNode == null) continue;
                Level level = (Level)this.getDesign().getMultidimensionalDesign().getLevelSet().getByName(helpNode.name);
                Entity entity = (Entity)this.getDesign().getLogicalDesign().getEntitySet().getByName(helpNode.tableName);
                if (level == null) {
                    level = this.getDesign().getMultidimensionalDesign().createLevel();
                    if (entity != null) {
                        level.setLevelEntity(entity);
                        Attribute attribute = (Attribute)entity.getElementByName(string4);
                        level.addToLevelKey(attribute);
                    }
                    level.setName(helpNode.name);
                }
                arrayList2.add(level);
                for (String string5 : arrayList) {
                    Attribute attribute;
                    object3 = string5.split("--");
                    if (((String[])object3).length <= 1 || !helpNode.name.equalsIgnoreCase(object3[0])) continue;
                    object2 = object3[1];
                    if (entity == null || (attribute = (Attribute)entity.getElementByName((String)object2)) == null) continue;
                    level.addDescriptiveAttribute(new SlowChangingAttribute(level, attribute));
                }
                if (object != null) {
                    Link link = ((AbstractMDObject)object).getFirstLinkToTarget(level);
                    if (link == null) {
                        object3 = (AbstractMDTV)((AbstractMDObject)object).getTopView();
                        object2 = (AbstractMDTV)level.getTopView();
                        if (object3 != null && object2 != null) {
                            Link link2 = this.getDesign().getMultidimensionalDesign().createLink();
                            link2.setSourceTV((AbstractMDTV)object3);
                            link2.setTargetTV((AbstractMDTV)object2);
                            ((TVLink)link2.getTopView()).addConnection();
                            arrayList3.add(link2);
                        }
                    } else {
                        arrayList3.add(link);
                    }
                }
                object = level;
            }
            HelpNode helpNode = new HelpNode(string2);
            helpNode.bName = string;
            helpNode.levels = arrayList2;
            helpNode.links = arrayList3;
            helpNode.schema = string3;
            this.hierarchies.add(helpNode);
        }
    }

    private void processDimensions(NodeList nodeList) {
        this.dimensions.clear();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("businessName");
            String string2 = element.getAttribute("name");
            String string3 = element.getAttribute("schema");
            String string4 = element.getAttribute("type");
            Dimension dimension = this.getDesign().getMultidimensionalDesign().createDimension();
            dimension.setName(string2);
            if (string4.equalsIgnoreCase("time")) {
                dimension.setTimeDimension(true);
            }
            NodeList nodeList2 = element.getElementsByTagName("hierarchyRef");
            HelpNode helpNode = new HelpNode(string2);
            helpNode.dimension = dimension;
            int n2 = nodeList2.getLength();
            ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
            for (int j = 0; j < n2; ++j) {
                object3 = (Element)nodeList2.item(j);
                object2 = object3.getAttribute("name");
                object = this.findNodeByName(this.hierarchies, (String)object2);
                arrayList.add(((HelpNode)object).levels);
            }
            Level level = this.findLowestLevel(arrayList);
            object2 = dimension.getFirstLinkToTarget(level);
            if (object2 == null && level != null) {
                object3 = (AbstractMDTV)dimension.getTopView();
                object = (AbstractMDTV)level.getTopView();
                if (object3 != null && object != null) {
                    object2 = this.getDesign().getMultidimensionalDesign().createLink();
                    ((Link)object2).setSourceTV((AbstractMDTV)object3);
                    ((Link)object2).setTargetTV((AbstractMDTV)object);
                    ((TVLink)((Link)object2).getTopView()).addConnection();
                }
            }
            for (int j = 0; j < n2; ++j) {
                Object object4;
                Element element2 = (Element)nodeList2.item(j);
                object = element2.getAttribute("name");
                HelpNode helpNode2 = this.findNodeByName(this.hierarchies, (String)object);
                Level level2 = (Level)helpNode2.levels.get(0);
                if (level2 != level && (object4 = level.getFirstLinkToTarget(level2)) == null) {
                    AbstractMDTV abstractMDTV = (AbstractMDTV)level.getTopView();
                    AbstractMDTV abstractMDTV2 = (AbstractMDTV)level2.getTopView();
                    if (abstractMDTV != null && abstractMDTV2 != null) {
                        object4 = this.getDesign().getMultidimensionalDesign().createLink();
                        ((Link)object4).setSourceTV(abstractMDTV);
                        ((Link)object4).setTargetTV(abstractMDTV2);
                        ((TVLink)((Link)object4).getTopView()).addConnection();
                    }
                }
                object4 = element.getElementsByTagName("joinRef");
                int n3 = object4.getLength();
                for (int k = 0; k < n3; ++k) {
                    Element element3 = (Element)object4.item(k);
                    String string5 = element3.getAttribute("name");
                    HelpNode helpNode3 = this.findNodeByName(this.joins, string5);
                    if (helpNode3 == null) continue;
                    for (Link link : helpNode2.links) {
                        Level level3 = (Level)link.getSourceMDObject();
                        Level level4 = (Level)link.getTargetMDObject();
                        if (level3.getLevelEntity() != helpNode3.chEntity || level4.getLevelEntity() != helpNode3.parEntity) continue;
                        List list = level4.getLevelKey();
                        List list2 = level4.getDescriptiveAttributes();
                        for (int i2 = 0; i2 < list.size(); ++i2) {
                            list2.add(i2, list.get(i2));
                        }
                        list.clear();
                        list.addAll(helpNode3.parEntity.getPK().getElementsCollection());
                        List list3 = link.getRollupLink().getChildToParentAttributes();
                        list3.clear();
                        for (Attribute attribute : helpNode3.chEntity.getAttributes()) {
                            if (!attribute.getGeneratorID().equalsIgnoreCase(helpNode3.relation.getObjectID())) continue;
                            list3.add(attribute);
                        }
                    }
                }
            }
            helpNode.bName = string;
            helpNode.schema = string3;
            this.dimensions.add(helpNode);
        }
    }

    private Level findLowestLevel(List list) {
        Level level = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            List list2 = (List)list.get(i);
            level = (Level)list2.get(0);
            for (int j = 0; j < n; ++j) {
                List list3;
                if (i == j || (list3 = (List)list.get(j)).indexOf(level) <= 0) continue;
                level = null;
                break;
            }
            if (level == null) continue;
            return level;
        }
        return level;
    }

    private void processCubeModel(NodeList nodeList) {
        this.cubemodels.clear();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("businessName");
            String string2 = element.getAttribute("name");
            String string3 = element.getAttribute("schema");
            NodeList nodeList2 = element.getElementsByTagName("factsRef");
            if (nodeList2.getLength() == 1) {
                object = (Element)nodeList2.item(0);
                String string4 = object.getAttribute("name");
                Cube cube = (Cube)this.getDesign().getMultidimensionalDesign().getCubeSet().getByName(string4);
                if (cube != null) {
                    NodeList nodeList3 = element.getElementsByTagName("dimensionInfo");
                    int n2 = nodeList3.getLength();
                    for (int j = 0; j < n2; ++j) {
                        ContainedObject[] containedObjectArray;
                        Object object2;
                        Element element2 = (Element)nodeList3.item(j);
                        NodeList nodeList4 = element2.getElementsByTagName("dimensionRef");
                        Element element3 = (Element)nodeList4.item(0);
                        NodeList nodeList5 = element2.getElementsByTagName("joinRef");
                        Element element4 = (Element)nodeList5.item(0);
                        HelpNode helpNode = this.findNodeByName(this.dimensions, element3.getAttribute("name"));
                        HelpNode helpNode2 = this.findNodeByName(this.joins, element4.getAttribute("name"));
                        if (helpNode2 == null || helpNode == null) continue;
                        Link link = cube.getFirstLinkToTarget(helpNode.dimension);
                        if (link == null) {
                            object2 = (AbstractMDTV)cube.getTopView();
                            containedObjectArray = (ContainedObject[])helpNode.dimension.getTopView();
                            if (object2 != null && containedObjectArray != null) {
                                link = this.getDesign().getMultidimensionalDesign().createLink();
                                link.setSourceTV((AbstractMDTV)object2);
                                link.setTargetTV((AbstractMDTV)containedObjectArray);
                                ((TVLink)link.getTopView()).addConnection();
                            }
                        } else {
                            object2 = link.getRollupLink().getChildToParentAttributes();
                            object2.clear();
                            if (cube.getFactEntity() != null) {
                                containedObjectArray = cube.getFactEntity().getElements();
                                for (int k = 0; k < containedObjectArray.length; ++k) {
                                    ContainedObject containedObject = containedObjectArray[k];
                                    if (!containedObject.getGeneratorID().equalsIgnoreCase(helpNode2.relation.getObjectID())) continue;
                                    object2.add(containedObject);
                                }
                            }
                        }
                        this.setLevelKeys(helpNode.dimension, helpNode2.parEntity);
                    }
                }
            }
            object = new HelpNode(string2);
            ((HelpNode)object).bName = string;
            ((HelpNode)object).schema = string3;
            this.cubemodels.add(object);
        }
    }

    private void setLevelKeys(Dimension dimension, Entity entity) {
        Iterator iterator = dimension.getHierarchies().iterator();
        while (iterator.hasNext()) {
            Level level;
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            if (hierarchy.getLevels().size() <= 0 || (level = (Level)hierarchy.getLevels().get(0)).getLevelEntity() != entity) continue;
            List list = level.getLevelKey();
            List list2 = level.getDescriptiveAttributes();
            for (int i = 0; i < list.size(); ++i) {
                list2.add(i, list.get(i));
            }
            list.clear();
            list.addAll(entity.getPK().getElementsCollection());
            return;
        }
    }

    private String noBrackets(String string) {
        int n = string.indexOf(40);
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private HelpNode findNodeByName(ArrayList arrayList, String string) {
        for (HelpNode helpNode : arrayList) {
            if (!helpNode.name.equalsIgnoreCase(string)) continue;
            return helpNode;
        }
        return null;
    }

    private Domain createDomain(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[3];
        if (string != null) {
            String string5 = string.toUpperCase();
            if (string4.equalsIgnoreCase("0") && (string5.indexOf("CHAR") > -1 || string5.indexOf("GRAPHIC") > -1 || string5.indexOf("BLOB") > -1)) {
                stringArray[2] = string3;
            } else {
                stringArray[0] = string3;
                stringArray[1] = string4;
            }
            String string6 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(string);
            LogicalDatatype logicalDatatype = this.factoryLogical.searchLogicalDatatype(this.getDesign(), string6);
            return this.factory.getInstance(this.getDesign(), logicalDatatype, null, 3, stringArray, null);
        }
        return null;
    }

    class HelpNode2 {
        int type = -1;
        String name;
        String tablename;

        HelpNode2(String string, int n) {
            this.name = string;
            this.type = n;
        }
    }

    class HelpNode {
        String name;
        String colName;
        String tableName;
        String funcName;
        String bName;
        String schema;
        ArrayList levels = new ArrayList();
        ArrayList links = new ArrayList();
        List helpNode2List = new ArrayList();
        String template = "";
        Relation relation;
        Level level;
        Cube cube;
        List aggrFunctions = new ArrayList();
        boolean calculatedAttribute = false;
        Attribute attribute;
        Entity chEntity;
        Entity parEntity;
        Dimension dimension;

        HelpNode(String string) {
            this.name = string;
        }
    }
}

