/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cubeviews;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsImporter;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsImporter_8_1;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsImporter_8_2;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.ide.Ide;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CubeViewsHandler {
    private ApplicationView appView;
    private Design design;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;

    public CubeViewsHandler(ApplicationView applicationView) {
        this.appView = applicationView;
        this.design = applicationView.getCurrentDesign();
    }

    public void parse(File file) {
        block18: {
            if (file.isFile()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    InputSource inputSource = new InputSource(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = null;
                    try {
                        documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        // empty catch block
                    }
                    if (documentBuilder == null) break block18;
                    try {
                        Document document;
                        Element element;
                        this.design.setDisableTreeUpdate(true);
                        String string = file.getName();
                        int n = string.indexOf(".xml");
                        String string2 = string.substring(0, n);
                        if (!this.isImportToCurrent()) {
                            this.design.setName(string2);
                            this.design.setFileName(string2);
                        }
                        if ((element = (document = documentBuilder.parse(inputSource)).getDocumentElement()) != null) {
                            String string3;
                            String string4;
                            String string5 = element.getAttribute("version");
                            if (this.checkForCV(string5, string4 = element.getTagName(), string3 = element.getAttribute("xmlns:olap"))) {
                                Object object;
                                if (!this.design.getMultidimensionalDesign().isEmpty()) {
                                    object = this.design.addMultidimensionalDesign(string2);
                                    this.design.setMultidimensionalDesign((MultidimensionalDesign)object);
                                } else {
                                    this.design.getMultidimensionalDesign().setName(string2);
                                }
                                if (string5 != null && string5.startsWith("8.1")) {
                                    object = new CubeViewsImporter_8_1(this.design);
                                    ((CubeViewsImporter)object).parseXMLDocument(document);
                                } else if (string5 != null && string5.startsWith("8.2")) {
                                    object = new CubeViewsImporter_8_2(this.design);
                                    ((CubeViewsImporter)object).parseXMLDocument(document);
                                }
                                this.rearrangeTables();
                                ((DPVMultidimensional)this.design.getMultidimensionalDesign().getMainView()).rearrangeDiagram(true);
                                if (string5 != null && string5.startsWith("8.2")) {
                                    this.design.getMultidimensionalDesign().normalizeHierarchies();
                                }
                                this.design.setDisableTreeUpdate(false);
                                this.appView.clearTree();
                                this.design.getMultidimensionalDesign().getCompactDiagram().generateDiagram();
                                this.design.getMultidimensionalDesign().setMainViewVisible(true);
                            } else {
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CubeViewsHandler.ThisIsNotCubeViewsMetadataFile"), Messages.getString("CubeViewsHandler.Error"), 0);
                            }
                            break block18;
                        }
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CubeViewsHandler.ThisIsNotCubeViewsMetadataFile"), Messages.getString("CubeViewsHandler.Error"), 0);
                    }
                    catch (SAXException sAXException) {
                    }
                    catch (IOException iOException) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    boolean checkForCV(String string, String string2, String string3) {
        if (string == null || !string.startsWith("8.1") && !string.startsWith("8.2")) {
            return false;
        }
        if (string2 == null || !string2.equalsIgnoreCase("olap:metadata")) {
            return false;
        }
        return string3 != null && string3.equalsIgnoreCase("http://www.ibm.com/olap");
    }

    private void rearrangeTables() {
        EntitySet entitySet = this.design.getLogicalDesign().getEntitySet();
        if (entitySet.size() > 0) {
            Iterator iterator = entitySet.iterator();
            float f = (float)Math.sqrt(entitySet.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            ++l;
            while (iterator.hasNext()) {
                ContainerWithKeyObject containerWithKeyObject = (ContainerWithKeyObject)iterator.next();
                TopView topView = containerWithKeyObject.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dimension = this.getTableSize(containerWithKeyObject);
                this.width = dimension.width;
                this.height = Math.max(dimension.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 50;
                this.height = 25;
            }
        }
    }

    private Dimension getTableSize(ContainerWithKeyObject containerWithKeyObject) {
        int n;
        int n2 = 35;
        int n3 = 25;
        int n4 = containerWithKeyObject.getElements().length;
        n3 += n4 * 14;
        if (containerWithKeyObject.getKeys().length > 0 && !this.allKeysAreFK(containerWithKeyObject.getKeys())) {
            n3 += 4;
            for (n = 0; n < containerWithKeyObject.getKeys().length; ++n) {
                if (containerWithKeyObject.getKeys()[n].isFK()) continue;
                n3 += 14;
            }
        }
        n = 1;
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)containerWithKeyObject.getElement(i);
            int n6 = containedObjectWithDomain.getName().length() * 7;
            int n7 = containedObjectWithDomain.getDataType().toString().length() * 7;
            n = Math.max(n6, n);
            n5 = Math.max(n7, n5);
        }
        if (n == 1) {
            n = containerWithKeyObject.getName().length() * 7;
        }
        return new Dimension(n2 + n + n5, n3);
    }

    private boolean allKeysAreFK(KeyObject[] keyObjectArray) {
        boolean bl = true;
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isImportToCurrent() {
        return this.design.isImportToCurrent();
    }
}

