/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports;

import java.util.StringTokenizer;
import oracle.dbtools.crest.util.logging.Logger;

public class Token {
    public static final String ENCODED_STR = "`~`";
    public static final String TOKEN_SEPARATORS = " ()";
    public static final String SPACE_SEPARATOR = " ";
    private static final Logger LOGGER = new Logger(Token.class);

    public static boolean hasToken(String string, String string2) {
        String string3 = string2.trim();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            while (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equalsIgnoreCase(string3)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            LOGGER.error("Error in hasToken:", exception);
            return false;
        }
    }

    public static boolean hasToken(String string, String string2, String string3) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            String string4 = "";
            String string5 = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                if (string6.equals(SPACE_SEPARATOR)) continue;
                string5 = string4;
                string4 = string6;
                if (!string4.equalsIgnoreCase(string2) || string5.equalsIgnoreCase(string3)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            LOGGER.error("Error in hasToken:", exception);
            return false;
        }
    }

    public static int tokenNumber(String string, String string2) {
        int n = 0;
        while (string.indexOf(string2) > -1) {
            ++n;
            string = string.substring(string.indexOf(string2) + string2.length());
        }
        return n;
    }

    public static boolean hasString(String string, String string2) {
        try {
            return string.indexOf(string2) > -1;
        }
        catch (Exception exception) {
            LOGGER.error("Error in hasString:", exception);
            return false;
        }
    }

    public static String getLastToken(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(SPACE_SEPARATOR)) continue;
                string2 = string3;
            }
            return string2.trim();
        }
        catch (Exception exception) {
            LOGGER.error("Error in getLastToken:", exception);
            return "";
        }
    }

    public static String getFirstToken(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(SPACE_SEPARATOR)) continue;
                return string2;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error in getFirstToken:", exception);
        }
        return "";
    }

    public static boolean isBetweenQuotes(String string, String string2) {
        int n;
        int n2 = string.indexOf(string2);
        int n3 = string.indexOf(39);
        if (n3 > -1 && n3 < n2 && (n = string.indexOf(39, n2)) > -1) {
            return true;
        }
        n3 = string.indexOf(34);
        return n3 > -1 && n3 < n2 && (n = string.indexOf(34, n2)) > -1;
    }

    public static String getTokenBefore(String string, String string2) {
        try {
            String string3 = "";
            String string4 = string2.trim();
            if (string4.indexOf(SPACE_SEPARATOR) > 0) {
                int n = string.toUpperCase().indexOf(string2.toUpperCase());
                if (n > -1) {
                    string3 = Token.getLastToken(string.substring(0, n));
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (string5.equals(SPACE_SEPARATOR)) continue;
                    if (string5.equalsIgnoreCase(string4)) break;
                    string3 = string5;
                }
            }
            return string3.trim();
        }
        catch (Exception exception) {
            LOGGER.error("Error in getTokenBefore:", exception);
            return "";
        }
    }

    public static String getStringBefore(String string, String string2) {
        try {
            int n = string.toUpperCase().indexOf(string2.toUpperCase());
            if (n > -1) {
                return string.substring(0, n).trim();
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getStringBefore:", exception);
            return "";
        }
    }

    public static String getStringBeforeToken(String string, String string2) {
        try {
            String string3 = string.toUpperCase();
            String string4 = string2.trim().toUpperCase();
            int n = string4.length();
            int n2 = 0;
            int n3 = 0;
            while (n3 > -1) {
                n3 = string3.indexOf(string4, n2);
                if (!(n3 <= -1 || n3 != 0 && string3.charAt(n3 - 1) != ' ' || n3 + n != string3.length() && string3.charAt(n3 + n) != ' ')) {
                    return string.substring(0, n3).trim();
                }
                n2 = n3 + 1;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error in getStringBeforeToken:", exception);
        }
        return "";
    }

    public static String getStringAfter(String string, String string2) {
        try {
            if ("".equalsIgnoreCase(string2)) {
                return "";
            }
            int n = string2.length();
            int n2 = string.toUpperCase().indexOf(string2.toUpperCase());
            while (n2 > -1) {
                if ((n2 == 0 || Token.isSeparator(string.charAt(n2 - 1))) && (string.length() == n2 + n || Token.isSeparator(string.charAt(n2 + n)))) {
                    return string.substring(n2 + n).trim();
                }
                n2 = string.toUpperCase().indexOf(string2.toUpperCase(), n2 + n);
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getStringAfter:", exception);
            return "";
        }
    }

    public static boolean isSeparator(char c) {
        return Character.isWhitespace(c) || c == '(' || c == ')' || c == ',' || c == '\"' || c == '[' || c == ']' || c == '\'';
    }

    public static String getStringAfter(String string, String string2, String string3) {
        try {
            int n = string.toUpperCase().indexOf(string2.toUpperCase() + SPACE_SEPARATOR);
            if (n > -1) {
                String string4 = string.substring(n);
                if (Token.getLastToken(string4).equalsIgnoreCase(string3)) {
                    Token.getStringAfter(string.substring(n + string2.length()).trim(), string2, string3);
                }
                return string.substring(n + string2.length()).trim();
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getStringAfter:", exception);
            return "";
        }
    }

    public static String getStringAfterToken(String string, String string2) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = string2.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (bl) {
                    stringBuffer.append(string4);
                    continue;
                }
                if (!string4.equalsIgnoreCase(string3)) continue;
                bl = true;
            }
            return stringBuffer.toString().trim();
        }
        catch (Exception exception) {
            LOGGER.error("Error in getStringAfterToken:", exception);
            return "";
        }
    }

    public static String getToken(String string, int n) {
        try {
            string = string.replaceAll("[\n]", SPACE_SEPARATOR);
            StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            String string2 = "";
            int n2 = 1;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(SPACE_SEPARATOR)) continue;
                if (n2 > n) break;
                string2 = string3;
                ++n2;
            }
            if (n2 < n) {
                string2 = "";
            }
            return string2.trim();
        }
        catch (Exception exception) {
            LOGGER.error("Error in getToken:", exception);
            return "";
        }
    }

    public static String getTokenAfter(String string, String string2, String string3) {
        try {
            string = string.replaceAll("[\n]", SPACE_SEPARATOR);
            StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
            String string4 = "";
            block2: while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (!string5.equalsIgnoreCase(string2)) continue;
                while (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    if (string5.equals(SPACE_SEPARATOR)) continue;
                    string4 = string5;
                    break block2;
                }
                break block2;
            }
            return string4.trim();
        }
        catch (Exception exception) {
            LOGGER.error("Error in getTokenAfter:", exception);
            return "";
        }
    }

    public static String getTokens(String string, int n, int n2) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            StringBuffer stringBuffer = new StringBuffer("");
            int n3 = 1;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(SPACE_SEPARATOR)) continue;
                if (n3 >= n && n3 <= n2) {
                    stringBuffer.append(string2).append(SPACE_SEPARATOR);
                }
                ++n3;
            }
            return stringBuffer.toString().trim();
        }
        catch (Exception exception) {
            LOGGER.error("Error in getTokens:", exception);
            return "";
        }
    }

    public static boolean endsWithOpenBracket(String string) {
        try {
            if (string != null) {
                int n;
                int n2 = string.lastIndexOf("(");
                return n2 > (n = string.lastIndexOf(")"));
            }
            return false;
        }
        catch (Exception exception) {
            LOGGER.error("Error in endsWithOpenBracket:", exception);
            return false;
        }
    }

    public static boolean hasOpenBracketNoClose(String string) {
        try {
            if (string != null) {
                int n = string.lastIndexOf("(");
                int n2 = string.lastIndexOf(")");
                return n >= 0 && n2 == -1 || n2 < n;
            }
            return false;
        }
        catch (Exception exception) {
            LOGGER.error("Error in hasOpenBracketNoClose:", exception);
            return false;
        }
    }

    public static boolean hasOpenBracket(String string) {
        try {
            int n;
            int n2 = 0;
            int n3 = 0;
            if (string != null && (n = string.indexOf("(")) >= 0) {
                String string2 = string;
                while (n >= 0) {
                    ++n2;
                    string2 = string2.substring(n + 1);
                    n = string2.indexOf("(");
                }
                int n4 = string.indexOf(")");
                if (n4 >= 0) {
                    string2 = string;
                    while (n4 >= 0) {
                        ++n3;
                        string2 = string2.substring(n4 + 1);
                        n4 = string2.indexOf(")");
                    }
                }
            }
            return n2 > n3;
        }
        catch (Exception exception) {
            LOGGER.error("Error in hasOpenBracket:", exception);
            return false;
        }
    }

    public static int getCloseBracketIndex(String string) {
        try {
            int n = 0;
            int n2 = 0;
            if (string != null) {
                int n3 = string.indexOf("(");
                int n4 = string.indexOf(")");
                if (n3 >= 0 && n4 > 0) {
                    for (int i = n3; i < string.length(); ++i) {
                        if (string.charAt(i) == '(') {
                            ++n;
                        } else if (string.charAt(i) == ')') {
                            ++n2;
                        }
                        if (n != n2) continue;
                        return i;
                    }
                }
            }
            return -1;
        }
        catch (Exception exception) {
            LOGGER.error("Error in getCloseBracketIndex:", exception);
            return -1;
        }
    }

    public static boolean hasCloseAndOpenBrackets(String string) {
        try {
            if (string != null) {
                int n = string.lastIndexOf("(");
                int n2 = string.lastIndexOf(")");
                return n >= 0 && n2 > 0;
            }
            return false;
        }
        catch (Exception exception) {
            LOGGER.error("Error in hasCloseAndOpenBrackets:", exception);
            return false;
        }
    }

    public static boolean hasCloseBracket(String string) {
        try {
            if (string != null) {
                int n = string.lastIndexOf(")");
                return n >= 0;
            }
            return false;
        }
        catch (Exception exception) {
            LOGGER.error("Error in hasCloseBracket:", exception);
            return false;
        }
    }

    public static String getValBetweenBrackets(String string) {
        try {
            if (string != null) {
                int n = string.indexOf("(");
                int n2 = string.lastIndexOf(")");
                if (n > -1 && n2 > -1) {
                    if (n < string.length()) {
                        return string.substring(n + 1, n2).trim();
                    }
                    return string.substring(n, n2).trim();
                }
                return "";
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBetweenBrackets:", exception);
            return "";
        }
    }

    public static String getValBetweenQuotes(String string) {
        try {
            if (string != null && !"".equalsIgnoreCase(string)) {
                int n = string.indexOf(39);
                int n2 = string.indexOf(39, n + 1);
                if (n > -1 && n2 > -1) {
                    if (n < string.length()) {
                        return string.substring(n + 1, n2).trim();
                    }
                    return string.substring(n, n2).trim();
                }
                return string;
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBetweenQuotes:", exception);
            return "";
        }
    }

    public static String getValBetweenDoubleQuotes(String string) {
        try {
            if (string != null && !"".equalsIgnoreCase(string)) {
                int n = string.indexOf(34);
                int n2 = string.indexOf(34, n + 1);
                if (n > -1 && n2 > -1) {
                    if (n < string.length()) {
                        return string.substring(n + 1, n2).trim();
                    }
                    return string.substring(n, n2).trim();
                }
                return string;
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBetweenDoubleQuotes:", exception);
            return "";
        }
    }

    public static String getValBetweenBrackets(String string, int n) {
        try {
            if (string != null && !string.equalsIgnoreCase("")) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (int i = 1; i <= n; ++i) {
                    n2 = string.indexOf(40, n4);
                    n3 = string.indexOf(40, n2 + 1);
                    n4 = string.indexOf(41, n2);
                    while (n3 < n4 && n3 != -1) {
                        n3 = string.indexOf(40, n3 + 1);
                        n4 = string.indexOf(41, n4 + 1);
                    }
                }
                if (n2 == n4) {
                    return "";
                }
                return string.substring(n2 + 1, n4);
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBetweenBrackets:", exception);
            return "";
        }
    }

    public static String getValBetweenQuotationMarks(String string) {
        try {
            if (string != null && string.indexOf(39) == 0 && string.indexOf(39, 1) == string.length() - 1) {
                return string.substring(1, string.length() - 1);
            }
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBetweenQuotationMarks:", exception);
            return "";
        }
    }

    public static String getValBetweenQuotationMarks2(String string) {
        try {
            if (string != null && (string.indexOf(39) == 0 || string.indexOf(8217) == 0)) {
                int n = string.indexOf(39, 1);
                if (n <= 0) {
                    n = string.indexOf(8217, 1);
                }
                return string.substring(1, n).trim();
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBetweenQuotationMarks:", exception);
            return "";
        }
    }

    public static String getValBetweenSquareBrackets(String string) {
        try {
            if (string != null && string.indexOf(91) == 0 && string.indexOf(93, 1) == string.length() - 1) {
                return string.substring(1, string.length() - 1);
            }
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBetweenSquareBrackets:", exception);
            return "";
        }
    }

    public static String getValBetweenFirstQuotationMarks(String string) {
        try {
            if (string != null && string.indexOf(39) > -1) {
                int n = string.indexOf(39);
                String string2 = string.substring(n + 1);
                int n2 = string2.indexOf(39);
                return string.substring(n + 1, n2 + n + 1).trim();
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBetweenQuotationMarks:", exception);
            return "";
        }
    }

    public static String getValAfterBrackets(String string, int n) {
        try {
            if (string != null) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (int i = 1; i <= n; ++i) {
                    n2 = string.indexOf(40, n4);
                    n3 = string.indexOf(40, n2 + 1);
                    n4 = string.indexOf(41, n2);
                    while (n3 < n4 && n3 != -1) {
                        n3 = string.indexOf(40, n3 + 1);
                        n4 = string.indexOf(41, n4 + 1);
                    }
                }
                return string.substring(n4 + 1).trim();
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValAfterBrackets:", exception);
            return "";
        }
    }

    public static String getValOutsideBrackets(String string) {
        try {
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = string.indexOf(40);
                int n2 = string.lastIndexOf(41);
                if (n != -1 && n2 != -1) {
                    stringBuffer.append(string.substring(0, n));
                    stringBuffer.append(' ');
                    stringBuffer.append(string.substring(n2 + 1, string.length()));
                }
                return stringBuffer.toString();
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValOutsideBrackets:", exception);
            return "";
        }
    }

    public static String getValBeforeBrackets(String string) {
        try {
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = string.indexOf(40);
                int n2 = string.lastIndexOf(41);
                if (n != -1 && n2 != -1) {
                    stringBuffer.append(string.substring(0, n));
                }
                return stringBuffer.toString().trim();
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBeforeBrackets:", exception);
            return "";
        }
    }

    public static boolean isTokenEqualTo(String string, int n, String string2) {
        try {
            return Token.getToken(string, n).equalsIgnoreCase(string2);
        }
        catch (Exception exception) {
            LOGGER.error("Error in isTokenEqualTo:", exception);
            return false;
        }
    }

    public static String getTokenAfter(String string, String string2) {
        try {
            String string3;
            block11: {
                string3 = "";
                if (string2.indexOf(SPACE_SEPARATOR) > 0) {
                    int n;
                    String[] stringArray = string2.split(SPACE_SEPARATOR);
                    int n2 = n = 1;
                    string3 = Token.getToken(string, n);
                    boolean bl = false;
                    while (!bl && !"".equals(string3)) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!(string3 = Token.getToken(string, n2++)).equalsIgnoreCase(stringArray[i])) {
                                bl = false;
                                break;
                            }
                            bl = true;
                        }
                        if (bl) {
                            string3 = Token.getToken(string, n2);
                            continue;
                        }
                        n2 = ++n;
                    }
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (!string4.equalsIgnoreCase(string2)) continue;
                        while (stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken();
                            if (string4.equals(SPACE_SEPARATOR)) continue;
                            string3 = string4;
                            break block11;
                        }
                        break;
                    }
                }
            }
            if (string3.endsWith(";")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            return string3;
        }
        catch (Exception exception) {
            LOGGER.error("Error in getTokenAfter:", exception);
            return "";
        }
    }

    public static String removeChar(String string, char c) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    private static boolean bracketsEquals(String string, char c, char c2) {
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf(c);
        while (n3 > -1) {
            ++n;
            n3 = string.indexOf(c, n3 + 1);
        }
        if (c != c2) {
            n3 = string.indexOf(c2);
            while (n3 > -1) {
                ++n2;
                n3 = string.indexOf(c2, n3 + 1);
            }
            return n == n2;
        }
        return n % 2 == 0;
    }

    public static String getFirstTextLiteral(String string) {
        if (string.length() > 1) {
            int n = 0;
            char c = Character.toUpperCase(string.charAt(0));
            if (c == 'N') {
                n = 1;
                c = Character.toUpperCase(string.charAt(1));
            }
            if (c == '\'') {
                int n2 = string.indexOf(39, n + 1);
                if (n2 > -1) {
                    boolean bl = true;
                    while (bl) {
                        int n3;
                        bl = false;
                        if (string.length() <= n2 + 1 || string.charAt(n2 + 1) != '\'' || (n3 = string.indexOf(39, n2 + 2)) <= -1) continue;
                        n2 = n3;
                        bl = true;
                    }
                    return string.substring(0, n2 + 1);
                }
            } else if (string.substring(n).toUpperCase().startsWith("Q'") && string.length() > n + 2) {
                int n4;
                int n5 = n4 = string.charAt(n + 2);
                if (n4 == 91) {
                    n5 = 93;
                } else if (n4 == 123) {
                    n5 = 125;
                } else if (n4 == 60) {
                    n5 = 62;
                } else if (n4 == 40) {
                    n5 = 41;
                }
                int n6 = string.indexOf((char)n5 + "'", n);
                if (n6 > -1) {
                    return string.substring(0, n6 + 2);
                }
            }
        }
        return "";
    }

    public static String getQuotedNameAfterToken(String string, String string2) {
        return Token.getNameAfterToken(string, string2, '\"', '\"');
    }

    public static String getNameAfterToken(String string, String string2, char c, char c2) {
        return Token.getFirstName(Token.getStringAfter(string, string2), c, c2);
    }

    public static String getFirstName(String string, char c, char c2) {
        try {
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), TOKEN_SEPARATORS, true);
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.indexOf(c) > -1 && !Token.bracketsEquals(string2, c, c2)) {
                    String string3;
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        string2 = string2 + string3;
                        if (string3.indexOf(c2) <= -1) continue;
                        break;
                    }
                    if (!Token.bracketsEquals(string2, c, c2) && string2.indexOf("." + c) > -1) {
                        while (stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                            string2 = string2 + string3;
                            if (string3.indexOf(c2) <= -1) continue;
                            break;
                        }
                    }
                }
                if (string2.endsWith(";")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string2 = Token.removeChar(string2, c);
                if (c2 != c) {
                    string2 = Token.removeChar(string2, c2);
                }
            }
            return string2;
        }
        catch (Exception exception) {
            LOGGER.error("Error in getFirstName:", exception);
            return "";
        }
    }

    public static String getValBeforeCharacter(String string, char c) {
        try {
            if (string != null) {
                int n = string.indexOf(c);
                if (n != -1) {
                    return string.substring(0, n);
                }
                return "";
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValBeforeCharacter:", exception);
            return "";
        }
    }

    public static String getValAfterCharacter(String string, char c) {
        try {
            if (string != null) {
                int n = string.lastIndexOf(c);
                if (n != -1) {
                    return string.substring(n + 1, string.length());
                }
                return "";
            }
            return "";
        }
        catch (Exception exception) {
            LOGGER.error("Error in getValAfterCharacter:", exception);
            return "";
        }
    }

    public static String cutTokenFromFront(String string, String string2) {
        try {
            int n = string2.length();
            String string3 = string.trim().substring(n).trim();
            return string3;
        }
        catch (Exception exception) {
            LOGGER.error("Error in cutTokenFromFront:", exception);
            return "";
        }
    }

    public static String cutFirstToken(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, TOKEN_SEPARATORS, true);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (bl) {
                    if (string2.equals(SPACE_SEPARATOR)) continue;
                    bl = false;
                    continue;
                }
                stringBuffer.append(string2);
            }
            return stringBuffer.toString().trim();
        }
        catch (Exception exception) {
            LOGGER.error("Error in cutFirstToken:", exception);
            return "";
        }
    }

    public static String cutFirstToken2(String string) {
        try {
            String string2 = Token.getFirstToken(string);
            int n = string.indexOf(string2);
            if (n > -1) {
                String string3 = Token.trimLeft(string.substring(n + string2.length()));
                return string3;
            }
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("Error in cutFirstToken2:", exception);
            return "";
        }
    }

    public static String replaceFirst(String string, String string2, String string3) {
        try {
            int n = string.toUpperCase().indexOf(string2.toUpperCase());
            if (n > -1) {
                String string4 = string.substring(0, n).trim();
                String string5 = string.substring(n + string2.length()).trim();
                return string4 + SPACE_SEPARATOR + string3 + SPACE_SEPARATOR + string5;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error in replaceFirst:", exception);
        }
        return string;
    }

    public static String replaceAll(String string, String string2, String string3) {
        try {
            String[] stringArray = string.split(string2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (i == 0) {
                    stringBuffer.append(string4);
                    continue;
                }
                stringBuffer.append(string3).append(string4);
            }
            return stringBuffer.toString().trim();
        }
        catch (Exception exception) {
            LOGGER.error("Error in replaceAll:", exception);
            return string;
        }
    }

    public static String getStringToFirstMatch(String string, String[] stringArray) {
        try {
            String string2 = SPACE_SEPARATOR + string + SPACE_SEPARATOR;
            String string3 = "";
            int n = 999999;
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = string2.indexOf(SPACE_SEPARATOR + stringArray[i] + SPACE_SEPARATOR);
                if (n2 <= -1 || n2 >= n) continue;
                string3 = stringArray[i];
                n = n2;
            }
            if (!"".equalsIgnoreCase(string3)) {
                return Token.getStringBefore(string, string3);
            }
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("Error in getStringToFirstMatch:", exception);
            return "";
        }
    }

    public static String getName(String string) {
        int n;
        if ((string = string.trim()).startsWith("\"") && (n = string.indexOf("\"", 1)) > -1) {
            return string.substring(1, n);
        }
        return string;
    }

    public static String getNamesOnly(String string) {
        CharSequence charSequence = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            CharSequence charSequence2;
            CharSequence charSequence3 = stringTokenizer.nextToken().trim();
            if (Token.hasOpenBracketNoClose((String)charSequence3)) {
                charSequence2 = new StringBuffer((String)charSequence3);
                while (Token.hasOpenBracketNoClose((String)charSequence3) && stringTokenizer.hasMoreTokens()) {
                    ((StringBuffer)charSequence2).append(", ").append(stringTokenizer.nextToken().trim());
                    charSequence3 = ((StringBuffer)charSequence2).toString().trim();
                }
            }
            charSequence2 = "";
            String string2 = "";
            if (((String)charSequence3).startsWith("\"")) {
                int n = ((String)charSequence3).indexOf("\"", 1);
                if (n > -1) {
                    charSequence2 = ((String)charSequence3).substring(1, n);
                    string2 = ((String)charSequence3).substring(n + 1).trim();
                } else {
                    charSequence2 = Token.getFirstToken((String)charSequence3);
                    string2 = Token.getStringAfter((String)charSequence3, Token.getFirstToken((String)charSequence3));
                }
            }
            charSequence3 = string2.equalsIgnoreCase("") ? charSequence2 : ((String)charSequence2).concat(SPACE_SEPARATOR).concat(string2);
            if (charSequence.equalsIgnoreCase("")) {
                charSequence = charSequence3;
                continue;
            }
            charSequence = charSequence.concat(",").concat((String)charSequence3);
        }
        if (charSequence.trim().equalsIgnoreCase("")) {
            charSequence = string;
        }
        return charSequence;
    }

    public static String cutN(String string) {
        if (string.toUpperCase().startsWith("N'")) {
            return string.substring(1);
        }
        return string;
    }

    public static boolean startsWithString(String string, String string2) {
        if (string.toUpperCase().trim().startsWith(string2.toUpperCase().trim() + SPACE_SEPARATOR)) {
            return true;
        }
        string = Token.replaceAll(string, SPACE_SEPARATOR, SPACE_SEPARATOR);
        return string.toUpperCase().trim().startsWith(string2.toUpperCase().trim() + SPACE_SEPARATOR);
    }

    public static boolean startsWithString2(String string, String string2) {
        if (string.toUpperCase().trim().startsWith(string2.toUpperCase().trim() + SPACE_SEPARATOR)) {
            return true;
        }
        String string3 = string.replaceAll("[ \t\n\f\r\u000b]+", SPACE_SEPARATOR);
        return string3.toUpperCase().trim().startsWith(string2.toUpperCase().trim() + SPACE_SEPARATOR);
    }

    public static String encodeQuotedString(String string) {
        int n = string.indexOf(34);
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(34, n + 1);
        if (n2 == -1) {
            return string;
        }
        String string2 = string.substring(n, n2 + 1);
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append(string2.replaceAll(SPACE_SEPARATOR, ENCODED_STR));
        int n3 = n2 + 1;
        while (n > -1) {
            n = string.indexOf(34, n2 + 1);
            if (n > -1) {
                n2 = string.indexOf(34, n + 1);
            }
            if (n <= -1 || n2 <= -1) continue;
            if (n > n3) {
                stringBuffer.append(string.substring(n3, n));
            }
            n3 = n2 + 1;
            string2 = string.substring(n, n2 + 1);
            stringBuffer.append(string2.replaceAll(SPACE_SEPARATOR, ENCODED_STR));
        }
        stringBuffer.append(string.substring(n2 + 1));
        return stringBuffer.toString();
    }

    public static String encodeSquareBracketsString(String string) {
        int n = string.indexOf(91);
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(93, n + 1);
        if (n2 == -1) {
            return string;
        }
        String string2 = string.substring(n, n2 + 1);
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append(string2.replaceAll(SPACE_SEPARATOR, ENCODED_STR));
        int n3 = n2 + 1;
        while (n > -1) {
            n = string.indexOf(91, n2 + 1);
            if (n > -1) {
                n2 = string.indexOf(93, n + 1);
            }
            if (n <= -1 || n2 <= -1) continue;
            if (n > n3) {
                stringBuffer.append(string.substring(n3, n));
            }
            n3 = n2 + 1;
            string2 = string.substring(n, n2 + 1);
            stringBuffer.append(string2.replaceAll(SPACE_SEPARATOR, ENCODED_STR));
        }
        stringBuffer.append(string.substring(n2 + 1));
        return stringBuffer.toString();
    }

    public static String decodeQuotedString(String string) {
        return string.replaceAll(ENCODED_STR, SPACE_SEPARATOR);
    }

    public static String removeQuotes(String string) {
        return string.replaceAll("\"", "").trim();
    }

    public static String trimLeft(String string) {
        return string.replaceAll("^[ \t\n\f\r\u000b]+", "");
    }

    public static String trimRight(String string) {
        return string.replaceAll("$[ \t\n\f\r\u000b]+", "");
    }

    public static void main(String[] stringArray) {
        String string = "\\$\\%\\@\\*\\$";
        String string2 = "aaa$%@*$bbbb$%@*$ccc$%@*$ddd";
        String[] stringArray2 = string2.split(string);
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(i + ": " + stringArray2[i]);
        }
    }
}

