/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports;

import oracle.dbtools.crest.imports.metadata.DBMEncodedString;
import oracle.dbtools.thirdparty.db2.DB2ConnectionPanel;
import oracle.dbtools.thirdparty.udb.UDBConnectionPanel;

public class DBConnectionStamp {
    private String connName = "";
    private String connUrl = "";
    private String connUser = "";
    private DBMEncodedString connPass = null;
    private int connType = -1;

    public DBConnectionStamp() {
        this.connPass = null;
    }

    public DBConnectionStamp(String string, String string2, String string3, String string4, int n) {
        this.connName = string;
        this.connUrl = string2;
        this.connUser = string3;
        this.connPass = new DBMEncodedString("");
        this.connPass.encode(string4);
        this.connType = n;
    }

    public DBConnectionStamp(String string, String string2, String string3, int n) {
        this.connName = string;
        this.connUrl = string2;
        this.connUser = string3;
        this.connPass = null;
        this.connType = n;
    }

    public String toString() {
        return this.getConnName();
    }

    public String getConnName() {
        return this.connName;
    }

    public void setConnName(String string) {
        this.connName = string;
    }

    public String getConnUrl() {
        return this.connUrl;
    }

    public void setConnUrl(String string) {
        this.connUrl = string;
    }

    public String getConnUser() {
        return this.connUser;
    }

    public void setConnUser(String string) {
        this.connUser = string;
    }

    public String getConnPass() {
        if (this.connPass == null) {
            return null;
        }
        return this.connPass.decode();
    }

    public void setConnPass(String string) {
        if (string == null) {
            this.connPass = null;
        } else {
            this.connPass = new DBMEncodedString("");
            this.connPass.encode(string);
        }
    }

    public int getConnType() {
        return this.connType;
    }

    public void setConnType(int n) {
        this.connType = n;
    }

    public String getConnTypeDisplay() {
        if (this.connType == 1) {
            return "Oracle";
        }
        if (this.connType == 2) {
            return "Microsoft SQL Server";
        }
        if (this.connType == 3) {
            return DB2ConnectionPanel.CONNECTION_TYPE;
        }
        if (this.connType == 4) {
            return UDBConnectionPanel.CONNECTION_TYPE;
        }
        return "";
    }

    public boolean isSameDB(DBConnectionStamp dBConnectionStamp) {
        return dBConnectionStamp != null && this.connUrl.equalsIgnoreCase(dBConnectionStamp.getConnUrl());
    }
}

