/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.net.URL;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.vhv.VHVCommand;
import oracle.ide.vhv.VHVCustomizer;
import oracle.ide.vhv.VHVQuery;
import oracle.jdeveloper.vcs.versiontree.VersionTreeCommand;
import oracle.jdevimpl.vcs.svn.op.SVNOperationVHVCompareOther;
import oracle.jdevimpl.vcs.svn.op.SVNOperationVHVComparePrevious;
import oracle.jdevimpl.vcs.svn.op.SVNOperationVersionTree;
import oracle.jdevimpl.vcs.svn.versiontree.SVNVHVQuery;

public class SVNVersionTreeCommand
extends VersionTreeCommand {
    public static final String COMMAND_ID = Extension.isDataModeler() ? SVNOperationVersionTree.class.getName() : SVNVersionTreeCommand.class.getName();
    public static final int TREE_CMD_ID = Ide.findOrCreateCmdID((String)COMMAND_ID);
    private static final Logger LOGGER = new Logger(SVNVersionTreeCommand.class);
    private static final IdeAction ACTION = DataModelerAddin.overrideAction(SVNOperationVersionTree.class.getName(), SVNVersionTreeCommand.class.getName());

    public SVNVersionTreeCommand() {
        super(TREE_CMD_ID);
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    public boolean isAvailable() {
        return DataModelerAddin.getVCSClientHelper().actionsEnabled(null, this.getContext(), true, true, false, false, false, true, false, true);
    }

    public int doitImpl() throws Exception {
        DisplayableLocatableNode[] displayableLocatableNodeArray = VCSClientHelper.getSelection(this.getContext().getView());
        if (displayableLocatableNodeArray != null && displayableLocatableNodeArray.length > 0) {
            URL uRL = displayableLocatableNodeArray[0].getURL();
            VHVQuery vHVQuery = this.createQuery();
            String string = this.getVersionPath(uRL);
            try {
                VHVCommand.show((URL)uRL, (VHVQuery)vHVQuery, null, (String)string);
            }
            catch (Exception exception) {
                LOGGER.error(exception);
                throw exception;
            }
        }
        return 0;
    }

    protected VHVQuery createQuery() {
        return new SVNVHVQuery();
    }

    protected String getVersionPath(URL uRL) {
        return uRL == null ? "" : uRL.toExternalForm();
    }

    protected VHVCustomizer createCustomizer() {
        VHVCustomizer vHVCustomizer = new VHVCustomizer();
        vHVCustomizer.setComparePreviousCommand(SVNOperationVHVComparePrevious.COMMAND_ID);
        vHVCustomizer.setCompareOtherCommand(SVNOperationVHVCompareOther.COMMAND_ID);
        return vHVCustomizer;
    }
}

