/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import oracle.dbtools.crest.fcp.BrowserDockable;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.log.LogManager;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryCommand;

public class SVNVersionHistoryCommand
extends VersionHistoryCommand {
    private static String HISTORY_COMMAND_ID = "oracle.jdeveloper.subversion.oracle.jdeveloper.vcs.action.HISTORY";
    public static final String COMMAND_ID = Extension.isDataModeler() ? HISTORY_COMMAND_ID : SVNVersionHistoryCommand.class.getName();
    public static final int HISTORY_CMD_ID = Ide.findOrCreateCmdID((String)COMMAND_ID);
    private static final IdeAction ACTION = DataModelerAddin.overrideAction(COMMAND_ID, SVNVersionHistoryCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNVersionHistoryCommand() {
        super(HISTORY_CMD_ID);
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    public boolean isAvailable() {
        return this.getSelectedStorableObjectStatus() != null && SVN_CLIENT_HELPER.actionsEnabled(null, this.context, true, true, true, false, false, true, true, true);
    }

    protected int doitImpl() throws Exception {
        this.showSVNHistoryWindow();
        return 0;
    }

    private void showSVNHistoryWindow() {
        DockStation dockStation = DockStation.getDockStation();
        SVNHistoryWindow sVNHistoryWindow = (SVNHistoryWindow)dockStation.getDockable(SVNHistoryWindow.VIEW_ID);
        if (sVNHistoryWindow == null) {
            sVNHistoryWindow = SVNHistoryWindow.getInstance();
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition((Dockable)LogManager.getIdeLogWindow(), 4);
            dockStation.dock((Dockable)sVNHistoryWindow, dockingParam);
        }
        this.init(sVNHistoryWindow);
        sVNHistoryWindow.show();
        dockStation.activateDockable((Dockable)sVNHistoryWindow);
    }

    protected void init(SVNHistoryWindow sVNHistoryWindow) {
        sVNHistoryWindow.setStorableObjectStatus(this.getSelectedStorableObjectStatus());
    }

    private StorableObjectStatus getSelectedStorableObjectStatus() {
        StorableObjectStatus storableObjectStatus = null;
        View view = this.context.getView();
        if (view instanceof SVNChangeListWindow) {
            DataModelerChangeList dataModelerChangeList = (DataModelerChangeList)((SVNChangeListWindow)view).getContextChangeList();
            VersioningTreeNode versioningTreeNode = dataModelerChangeList.getPanel().getSelectedNode();
            storableObjectStatus = versioningTreeNode == null ? null : versioningTreeNode.getStorableObjectStatus();
        } else if (view instanceof BrowserDockable) {
            StorableObject storableObject = (StorableObject)((BrowserPanel)((BrowserDockable)view).getBrowser()).getJTree().getLastSelectedPathComponent();
            storableObjectStatus = new SVNStorableObjectStatus(storableObject);
        } else if (view instanceof DMDiagramEditor) {
            Object[] objectArray = ((DMDiagramEditor)view).getDesignPartView().getSelectedObjects();
            if (objectArray != null && objectArray.length > 0) {
                if (objectArray.length == 1) {
                    StorableObject storableObject = (StorableObject)objectArray[0];
                    storableObjectStatus = new SVNStorableObjectStatus(storableObject);
                }
            } else {
                DesignPartView designPartView = ((DMDiagramEditor)view).getDesignPartView();
                if (!designPartView.isMasterDPV()) {
                    designPartView = designPartView.getMasterDPV();
                }
                storableObjectStatus = new SVNStorableObjectStatus(designPartView);
            }
        }
        return storableObjectStatus;
    }
}

