/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DMSVNOperationUpdate;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;

public class SVNUpdateCommand
extends DMSVNOperationUpdate {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.update" : SVNUpdateCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.update", SVNUpdateCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public static IdeAction getAction() {
        return ACTION;
    }

    public SVNUpdateCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.update");
    }

    public boolean isAvailableImpl() {
        return SVN_CLIENT_HELPER.actionsEnabled(SVNChangeListWindow.getSVNIncomingChangesChangeList(), null, false, false, false, true, true, true, false, true);
    }

    protected int doitImpl(VCSProfile vCSProfile) throws Exception {
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        List<File> list = this.collectFilePaths(arrayList);
        if (!list.isEmpty()) {
            Collections.sort(list);
            if (this.containsDeletedSystemFiles(arrayList) && JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SVNCommitCommand.UpdateDeletedSystemTypes"), Messages.getString("SVNCommitCommand.UpdateDeletedSystemTypesTitle"), 2) != 0) {
                return 1;
            }
            this.updateNotAddedParents(list);
            SVN_CLIENT_HELPER.doUpdate(list.toArray(new File[0]), true);
            VersioningTreeNode.refresh(arrayList, false);
            SVNChangeListWindow.getSVNIncomingChangesChangeList().refresh();
        }
        return 0;
    }

    protected void updateNotAddedParents(List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            SVN_CLIENT_HELPER.findNotAddedParents(file, arrayList);
        }
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList);
            SVN_CLIENT_HELPER.doUpdate(arrayList.toArray(new File[0]), false);
        }
    }

    private boolean containsDeletedSystemFiles(List<VersioningTreeNode> list) {
        File file = XMLTransformationManager.getDefaultRDBMSFile();
        File file2 = XMLTransformationManager.getDefaultTypesFile();
        for (VersioningTreeNode versioningTreeNode : list) {
            File file3 = versioningTreeNode.getFilePath();
            if (!file3.equals(file) && !file3.equals(file2) || !versioningTreeNode.getStorableObjectStatus().isDeleted()) continue;
            return true;
        }
        return false;
    }

    protected List<File> collectFilePaths(List<VersioningTreeNode> list) {
        return SVNChangeListWindow.getSVNIncomingChangesChangeList().getPanel().getSelectedFilePaths(list, false, true);
    }
}

