/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.controller.IdeAction;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdevimpl.vcs.svn.op.SVNOperationRevert;

public class SVNRevertCommand
extends SVNOperationRevert {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.revert" : SVNRevertCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.revert", SVNRevertCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNRevertCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.revert");
    }

    public boolean isAvailableImpl() {
        return SVN_CLIENT_HELPER.actionsEnabled(SVNChangeListWindow.getSVNOutgoingChangesChangeList(), null, false, true, false, false, true, true, false, false);
    }

    protected int doitImpl(VCSProfile vCSProfile) throws Exception {
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        List<File> list = this.collectFilePaths(arrayList);
        if (!list.isEmpty()) {
            Collections.reverse(list);
            SVN_CLIENT_HELPER.doRevert(list.toArray(new File[0]), true);
            VersioningTreeNode.refresh(arrayList, true);
            SVNChangeListWindow.getSVNOutgoingChangesChangeList().refresh();
        }
        return 0;
    }

    protected List<File> collectFilePaths(List<VersioningTreeNode> list) {
        return SVNChangeListWindow.getSVNOutgoingChangesChangeList().getPanel().getSelectedFilePaths(list, false, true);
    }
}

