/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DeletedFile;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.MergeConflictsDialog;
import oracle.dbtools.crest.fcp.vcs.RevisionRange;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareFrame;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeDesignCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNViewPropertiesCommand;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.XMLFromMapTransformer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.layout.ViewId;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNMergeWindow
extends SVNHistoryWindow {
    public static final String WINDOW_ID = "SVNMergeWindow";
    public static final ViewId VIEW_ID = new ViewId("EXTDockable", "SVNMergeWindow");
    private static final String TEST_MERGE = Messages.getString("SVNMergeWindow.TestMerge");
    private static final Logger LOGGER = new Logger(SVNMergeWindow.class);
    private static final SVNMergeWindow INSTANCE = new SVNMergeWindow();
    protected SVNUrl mergeUrl;
    protected String mergeSvnDesignPath;

    protected SVNMergeWindow() {
        this.historyTable.setDefaultRenderer(Object.class, new ConflictedRevisionCellRenderer());
        this.changedObjectsTable.setDefaultRenderer(Object.class, new ConflictedFileCellRenderer());
        this.historyTable.setSelectionMode(2);
    }

    public static SVNMergeWindow getInstance() {
        return INSTANCE;
    }

    @Override
    protected void addToolbarActions() {
        this.toolbar.add((Action)new MergeReintegrateAction());
        this.toolbar.addSeparator();
    }

    @Override
    public String getTitleName() {
        return Messages.getString("SVNMergeWindow.MergeDesign");
    }

    @Override
    public Icon getTabIcon() {
        return (Icon)SVNMergeDesignCommand.getAction().getValue("SmallIcon");
    }

    @Override
    protected List<ISVNLogMessage> getLogMessages() {
        if (this.mergeUrl != null) {
            return this.getLogMessages(this.mergeUrl.toString(), null, null, true, false);
        }
        return null;
    }

    @Override
    protected void installPopupMenus() {
        this.installPopupMenu(this.historyTable, new MergeRevisionAction(), new TestMergeRevisionAction());
        this.installPopupMenu(this.changedObjectsTable, new AbstractAction[]{new VCSHistoryWindow.ComparePreviousAction(Messages.getString("SVNMergeWindow.ComparePrevious")), new VCSHistoryWindow.ComparePreviousAsTextAction(Messages.getString("SVNMergeWindow.ComparePreviousAsText")), new CompareAndMergeAction(), new CompareAndMergeAsTextAction(), new MergeAction(), new TestMergeAction(), new DeleteLocalFolderAction(), new DeleteLocalFilesAction(), new VCSHistoryWindow.CopyAction(), new MarkAsMergedAction(), SVNViewPropertiesCommand.getAction()});
    }

    @Override
    protected String readPropertyName(File file, SVNStorableObjectStatus sVNStorableObjectStatus, Long l) {
        String string = null;
        if (!sVNStorableObjectStatus.isAdded()) {
            string = super.readPropertyName(file, sVNStorableObjectStatus, l);
        }
        if (!StringUtilities.isNotEmpty(string)) {
            try {
                string = SVN_CLIENT_HELPER.doGetProperty(new SVNUrl(sVNStorableObjectStatus.getURL()), 5, l);
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.error(malformedURLException);
            }
        }
        return string;
    }

    protected void init(SVNUrl sVNUrl, Design design) {
        this.mergeUrl = sVNUrl;
        this.design = design;
        ISVNInfo iSVNInfo = SVN_CLIENT_HELPER.doInfo(new File(design.getDesignPath()));
        this.repositoryUrl = iSVNInfo.getRepository().toString();
        this.svnDesignPath = this.resolveSvnDesignPath(iSVNInfo);
        this.mergeSvnDesignPath = sVNUrl.toString().replaceAll(this.repositoryUrl, "");
        this.updateDesignLabel(design);
    }

    @Override
    protected Long findLastMergedRevision() {
        File file = new File(ApplicationView.getInstance().getCurrentDesign().getDesignPath());
        return SVN_CLIENT_HELPER.getLastMergedRevision(file, null, this.mergeUrl.toString());
    }

    @Override
    protected Long findLastCopiedRevision() {
        File file = new File(ApplicationView.getInstance().getCurrentDesign().getDesignPath());
        return SVN_CLIENT_HELPER.doGetLogMessages(file, (Long)null, (Long)null, true, false, 1).get(0).getRevision().getNumber();
    }

    @Override
    protected File resolveLocalFile(ISVNLogMessageChangePath iSVNLogMessageChangePath) {
        String string = iSVNLogMessageChangePath.getPath();
        String string2 = string.indexOf(this.svnDesignPath) > -1 ? string.replace(this.svnDesignPath, "") : string.replace(this.mergeSvnDesignPath, "");
        return new File(this.design.getDesignPath() + string2);
    }

    @Override
    public void clear() {
        super.clear();
        this.mergeUrl = null;
    }

    @Override
    public void clearForDesign(Design design) {
        if (design.equals(this.design)) {
            this.clear();
        }
    }

    public void setMergeUrl(SVNUrl sVNUrl) {
        this.init(sVNUrl, ApplicationView.getInstance().getCurrentDesign());
        this.fileLabel.setText(sVNUrl.toString());
        this.refresh();
    }

    private List<VersioningTreeNode> collectNodesForMerging(boolean bl) {
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        if (!bl && this.changedObjectsTable.getSelectedRowCount() > 0) {
            for (int n : this.changedObjectsTable.getSelectedRows()) {
                this.createAndAddNodeForMerging(n, arrayList, bl);
            }
        } else {
            for (int i = 0; i < this.changedObjectsTable.getRowCount(); ++i) {
                this.createAndAddNodeForMerging(i, arrayList, bl);
            }
        }
        return arrayList;
    }

    private void createAndAddNodeForMerging(int n, List<VersioningTreeNode> list, boolean bl) {
        SVNStorableObjectStatus sVNStorableObjectStatus = (SVNStorableObjectStatus)this.changedObjectsTableModel.getChangedObjects().get(n);
        if (bl || !sVNStorableObjectStatus.isAdded()) {
            list.add(new VersioningTreeNode(sVNStorableObjectStatus));
        }
    }

    private void removeMergeConflicts(List<VersioningTreeNode> list, List<MergeConflict> list2) {
        if (list2.isEmpty() || list.isEmpty()) {
            return;
        }
        block0: for (MergeConflict mergeConflict : list2) {
            StorableObjectStatus storableObjectStatus = mergeConflict.getStorableObjectStatus();
            for (VersioningTreeNode versioningTreeNode : list) {
                if (!versioningTreeNode.getStorableObjectStatus().equals(storableObjectStatus)) continue;
                list.remove(versioningTreeNode);
                continue block0;
            }
        }
    }

    private boolean mergeEnabled() {
        for (int n : this.changedObjectsTable.getSelectedRows()) {
            SVNStorableObjectStatus sVNStorableObjectStatus = (SVNStorableObjectStatus)this.changedObjectsTableModel.getValueAt(n, 1);
            if (sVNStorableObjectStatus.getPathUrl().startsWith(this.mergeSvnDesignPath) && !sVNStorableObjectStatus.isAdded()) continue;
            return false;
        }
        return true;
    }

    private List<RevisionRange> collectSelectedRevisionRanges() {
        int n;
        ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>();
        ListSelectionModel listSelectionModel = this.historyTable.getSelectionModel();
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        do {
            n = this.findSelectionEndIndex(listSelectionModel, n3);
            arrayList.add(this.createRevisionRange(n3, n));
        } while ((n3 = this.findSelectionStartIndex(listSelectionModel, n)) >= n2);
        return arrayList;
    }

    private int findSelectionStartIndex(ListSelectionModel listSelectionModel, int n) {
        return this.findNextSelectedIndex(listSelectionModel, n, true);
    }

    private int findSelectionEndIndex(ListSelectionModel listSelectionModel, int n) {
        return this.findNextSelectedIndex(listSelectionModel, n, false) + 1;
    }

    private int findNextSelectedIndex(ListSelectionModel listSelectionModel, int n, boolean bl) {
        for (int i = n - 1; i >= 0; --i) {
            if (listSelectionModel.isSelectedIndex(i) != bl) continue;
            return i;
        }
        return -1;
    }

    private RevisionRange createRevisionRange(int n, int n2) {
        Long l = this.getRevisionNumber(n);
        Long l2 = this.getRevisionNumber(n2);
        Set<StorableObjectStatus> set = this.getChangedObjects(n2, n);
        return new RevisionRange(l, l2, set);
    }

    private Long getRevisionNumber(int n) {
        return ((ISVNLogMessage)this.historyTableModel.getRows().get(n)).getRevision().getNumber();
    }

    private Set<StorableObjectStatus> getChangedObjects(int n, int n2) {
        HashSet<StorableObjectStatus> hashSet = new HashSet<StorableObjectStatus>();
        for (int i = n; i <= n2; ++i) {
            ISVNLogMessage iSVNLogMessage = (ISVNLogMessage)this.historyTableModel.getRows().get(i);
            List list = (List)this.storableObjectStatusesMap.get(iSVNLogMessage);
            hashSet.addAll(list);
        }
        return hashSet;
    }

    private boolean containsMergeConflicts() {
        List<RevisionRange> list = this.collectSelectedRevisionRanges();
        ArrayList<StorableObjectStatus> arrayList = new ArrayList<StorableObjectStatus>();
        for (RevisionRange revisionRange : list) {
            Set<StorableObjectStatus> set = revisionRange.getChangedObjects();
            if (!arrayList.isEmpty()) {
                for (StorableObjectStatus storableObjectStatus : set) {
                    if (!arrayList.contains(storableObjectStatus)) continue;
                    return true;
                }
            }
            arrayList.addAll(set);
        }
        return false;
    }

    private boolean containsTreeConflicts() {
        List<RevisionRange> list = this.collectSelectedRevisionRanges();
        for (RevisionRange revisionRange : list) {
            if (!this.containsTreeConflicts(revisionRange)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTreeConflicts(RevisionRange revisionRange) {
        for (StorableObjectStatus storableObjectStatus : revisionRange.getChangedObjects()) {
            if (!this.containsTreeConflict(storableObjectStatus)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTreeConflict(StorableObjectStatus storableObjectStatus) {
        Long l = storableObjectStatus.getRevision();
        String string = storableObjectStatus.getCopyPath();
        return l != null && this.lastCopiedRevision != null && l > this.lastCopiedRevision && storableObjectStatus.isAdded() && storableObjectStatus.getFilePath().exists() && SVN_CLIENT_HELPER.isVersioned(storableObjectStatus.getFilePath()) && storableObjectStatus.getPathUrl().startsWith(this.mergeSvnDesignPath) && (!StringUtilities.isNotEmpty(string) || !string.startsWith(this.svnDesignPath));
    }

    private boolean hasOutgoingChanges() {
        List<ISVNStatus> list = SVN_CLIENT_HELPER.doStatus(new File(this.design.getDesignPath()), false);
        for (ISVNStatus iSVNStatus : list) {
            if (SVNStatusKind.UNVERSIONED.equals((Object)iSVNStatus.getTextStatus())) continue;
            return true;
        }
        return false;
    }

    private class ConflictedFileCellRenderer
    extends DefaultTableCellRenderer {
        private ConflictedFileCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (SVNMergeWindow.this.containsTreeConflict((StorableObjectStatus)SVNMergeWindow.this.changedObjectsTableModel.getValueAt(n, 1))) {
                this.setForeground(Color.RED);
            } else {
                this.setForeground(Color.BLACK);
            }
            return component;
        }
    }

    private class ConflictedRevisionCellRenderer
    extends DefaultTableCellRenderer {
        private ConflictedRevisionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (SVNMergeWindow.this.containsTreeConflicts(SVNMergeWindow.this.createRevisionRange(n, n))) {
                this.setForeground(Color.RED);
            } else {
                this.setForeground(Color.BLACK);
            }
            return component;
        }
    }

    private class CompareAndMergeAsTextAction
    extends VCSHistoryWindow.ComparePreviousAsTextAction {
        protected File localFile;

        public CompareAndMergeAsTextAction() {
            super(Messages.getString("SVNMergeWindow.CompareAndMergeAsText"));
        }

        @Override
        public void update() {
            super.update();
            this.setEnabled(SVNMergeWindow.this.mergeEnabled());
        }

        @Override
        protected void init() {
            super.init();
            this.localFile = new File(this.url.replace(SVNMergeWindow.this.repositoryUrl, "").replace(SVNMergeWindow.this.mergeSvnDesignPath, SVNMergeWindow.this.design.getDesignPath()));
        }

        @Override
        protected InputStream getRightText() {
            return SVNMergeWindow.this.getRevision(this.localFile, null);
        }

        @Override
        protected void compare(InputStream inputStream, String string, InputStream inputStream2, String string2) {
            final StorableObjectStatus storableObjectStatus = SVNMergeWindow.this.getSelectedStorableObjectStatus();
            VCSTextCompareFrame vCSTextCompareFrame = new VCSTextCompareFrame((Window)Ide.getMainWindow(), this.localFile, inputStream, string, inputStream2, string2, true, false, storableObjectStatus){

                @Override
                public void afterSave() {
                    super.afterSave();
                    try {
                        SVN_CLIENT_HELPER.doMerge(new SVNUrl(storableObjectStatus.getURL()), storableObjectStatus.getFilePath(), (List<RevisionRange>)SVNMergeWindow.this.collectSelectedRevisionRanges(), true, false);
                    }
                    catch (MalformedURLException malformedURLException) {
                        LOGGER.error(malformedURLException);
                    }
                }
            };
            vCSTextCompareFrame.showModal();
        }
    }

    private class CompareAndMergeAction
    extends VCSHistoryWindow.ComparePreviousAction {
        protected File localFile;

        protected CompareAndMergeAction() {
            super(Messages.getString("SVNMergeWindow.CompareAndMerge"));
        }

        @Override
        public void update() {
            super.update();
            this.setEnabled(SVNMergeWindow.this.mergeEnabled());
        }

        @Override
        protected void init() {
            super.init();
            this.localFile = new File(this.url.replace(SVNMergeWindow.this.repositoryUrl, "").replace(SVNMergeWindow.this.mergeSvnDesignPath, SVNMergeWindow.this.design.getDesignPath()));
        }

        @Override
        protected InputStream getRightText() {
            return SVNMergeWindow.this.getRevision(this.url.replace(SVNMergeWindow.this.mergeSvnDesignPath, SVNMergeWindow.this.svnDesignPath), null);
        }

        @Override
        protected void compare(InputStream inputStream, String string, InputStream inputStream2, String string2) {
            XMLMetadataComparator xMLMetadataComparator;
            Map map;
            StorageDesign storageDesign = null;
            StorableObjectStatus storableObjectStatus = SVNMergeWindow.this.getSelectedStorableObjectStatus();
            if (storableObjectStatus != null) {
                storageDesign = SVNMergeWindow.this.getVCSClientHelper().findStorageDesign(SVNMergeWindow.this.design, storableObjectStatus.getStorableObjectID());
            }
            if ((map = (xMLMetadataComparator = new XMLMetadataComparator(SVNMergeWindow.this.design, storageDesign, inputStream, string, inputStream2, string2, true)).showModal()) != null && storableObjectStatus != null) {
                StorableObject storableObject = storableObjectStatus.getStorableObject();
                XMLFromMapTransformer.transformMapToXMLFile(map, this.localFile.getPath(), SVNMergeWindow.this.design.isCompressedDesign());
                if (storableObject != null) {
                    DataModelerAddin.getVCSClientHelper().reloadStorableObject(storableObject, this.localFile, storableObjectStatus.getDesignPart());
                }
                try {
                    SVN_CLIENT_HELPER.doMerge(new SVNUrl(storableObjectStatus.getURL()), storableObjectStatus.getFilePath(), (List<RevisionRange>)SVNMergeWindow.this.collectSelectedRevisionRanges(), true, false);
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.error(malformedURLException);
                }
            }
        }
    }

    private class MergeReintegrateAction
    extends AbstractAction {
        protected MergeReintegrateAction() {
            super(Messages.getString("SVNMergeWindow.MergeReintegrate"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SVNMergeWindow.this.hasOutgoingChanges()) {
                MessageDialogs.showWarningMessage(Messages.getString("SVNMergeWindow.OutgoingChangesFound"));
            } else {
                int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SVNMergeWindow.MergeReintegrateQuestion"), Messages.getString("SVNMergeWindow.MergeReintegrate"), 0);
                if (n == 0) {
                    List<MergeConflict> list = new ArrayList<MergeConflict>();
                    SVN_CLIENT_HELPER.setCurrentDesign(SVNMergeWindow.this.design);
                    try {
                        boolean bl = SVN_CLIENT_HELPER.doMergeReintegrate(SVNMergeWindow.this.mergeUrl, new File(SVNMergeWindow.this.design.getDesignPath()), list);
                        if (bl) {
                            List<VersioningTreeNode> list2 = SVN_CLIENT_HELPER.getLastMergedObjects();
                            list = MergeConflictsDialog.getInstance().processConflicts(SVNMergeWindow.this.design, list, list2, false);
                            VersioningTreeNode.refresh(list2, false, true);
                        }
                    }
                    finally {
                        SVN_CLIENT_HELPER.setCurrentDesign(null);
                    }
                }
            }
        }
    }

    private class MarkAsMergedAction
    extends VCSHistoryWindow.UpdateableAction {
        private MarkAsMergedAction() {
            super("Mark local as Merged");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<StorableObjectStatus> list = SVNMergeWindow.this.getSelectedStorableObjectsStatuses();
            for (StorableObjectStatus storableObjectStatus : list) {
                Long l = this.getRevisionToCopy(storableObjectStatus);
                try {
                    ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>();
                    HashSet<StorableObjectStatus> hashSet = new HashSet<StorableObjectStatus>();
                    hashSet.add(storableObjectStatus);
                    RevisionRange revisionRange = new RevisionRange(l, l, hashSet);
                    arrayList.add(revisionRange);
                    SVNMergeWindow.this.getVCSClientHelper().doMerge(new SVNUrl(storableObjectStatus.getURL()), storableObjectStatus.getFilePath(), arrayList, true, false);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }

        protected Long getRevisionToCopy(StorableObjectStatus storableObjectStatus) {
            return storableObjectStatus.getRevision();
        }

        @Override
        public void update() {
        }
    }

    private class DeleteLocalFilesAction
    extends DeleteLocalFolderAction {
        private DeleteLocalFilesAction() {
            super(Messages.getString("SVNMergeWindow.DeleteLocalFiles"));
        }

        @Override
        protected void refresh(File[] fileArray) {
            ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
            for (File file : fileArray) {
                SVNStorableObjectStatus sVNStorableObjectStatus = new SVNStorableObjectStatus(SVNMergeWindow.this.design, file, "D", null, null);
                arrayList.add(new VersioningTreeNode(sVNStorableObjectStatus));
            }
            VersioningTreeNode.refresh(arrayList, false, true);
        }

        @Override
        protected boolean commit() {
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SVNMergeWindow.DeleteLocalFilesCommitDialogText"), Messages.getString("SVNMergeWindow.DeleteLocalCommitDialogTitle"), 0, 3);
            return n == 0;
        }

        @Override
        protected void collectFiles(StorableObjectStatus storableObjectStatus, List<File> list) {
            List<DeletedFile> list2 = SVNMergeWindow.this.design.getDLSettings().getDeletedFiles();
            File[] fileArray = null;
            fileArray = storableObjectStatus.getFilePath().isFile() ? new File[]{storableObjectStatus.getFilePath()} : storableObjectStatus.getFilePath().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile();
                }
            });
            for (File file : fileArray) {
                ISVNInfo iSVNInfo = SVN_CLIENT_HELPER.doInfo(file);
                String string = iSVNInfo.getUrlString();
                Long l = iSVNInfo.getRevision().getNumber();
                list.add(file);
                list2.add(new DeletedFile(file, string, l));
            }
            SVNMergeWindow.this.design.saveDesignLevelSettings();
        }
    }

    private class DeleteLocalFolderAction
    extends VCSHistoryWindow.UpdateableAction {
        protected DeleteLocalFolderAction(String string) {
            super(string);
        }

        protected DeleteLocalFolderAction() {
            super(Messages.getString("SVNMergeWindow.DeleteLocalFolder"));
        }

        @Override
        public void update() {
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<StorableObjectStatus> list = SVNMergeWindow.this.getSelectedStorableObjectsStatuses();
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList arrayList2 = new ArrayList();
            for (StorableObjectStatus storableObjectStatus : list) {
                this.collectFiles(storableObjectStatus, arrayList);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            File[] fileArray = arrayList.toArray(new File[arrayList.size()]);
            SVN_CLIENT_HELPER.doRemove(fileArray);
            this.refresh(fileArray);
            if (this.commit()) {
                SVN_CLIENT_HELPER.doCommit(fileArray, Messages.getString("SVNMergeWindow.DeleteLocalCommitMessage"), false, false);
                SVN_CLIENT_HELPER.doUpdate(new File[]{new File(SVNMergeWindow.this.design.getDesignPath())}, true);
            }
        }

        protected void refresh(File[] fileArray) {
        }

        protected boolean commit() {
            return true;
        }

        protected void collectFiles(StorableObjectStatus storableObjectStatus, List<File> list) {
            list.add(storableObjectStatus.getFilePath());
        }
    }

    private class TestMergeAction
    extends MergeAction {
        protected TestMergeAction() {
            super(TEST_MERGE);
            this.dryRun = true;
        }

        @Override
        public void update() {
        }
    }

    private class MergeAction
    extends MergeRevisionAction {
        protected MergeAction() {
        }

        protected MergeAction(String string) {
            super(string);
        }

        @Override
        public void update() {
            this.setEnabled(SVNMergeWindow.this.mergeEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void merge(List<RevisionRange> list) {
            List<MergeConflict> list2 = new ArrayList<MergeConflict>();
            List list3 = SVNMergeWindow.this.collectNodesForMerging(false);
            ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
            SVN_CLIENT_HELPER.setCurrentDesign(SVNMergeWindow.this.design);
            try {
                for (VersioningTreeNode versioningTreeNode : list3) {
                    try {
                        SVNStorableObjectStatus sVNStorableObjectStatus = (SVNStorableObjectStatus)versioningTreeNode.getStorableObjectStatus();
                        SVNUrl sVNUrl = new SVNUrl(sVNStorableObjectStatus.getURL());
                        List<MergeConflict> list4 = SVN_CLIENT_HELPER.doMerge(sVNUrl, sVNStorableObjectStatus.getFilePath(), list, false, this.dryRun);
                        arrayList.addAll(SVN_CLIENT_HELPER.getLastMergedObjects());
                        list2.addAll(list4);
                    }
                    catch (MalformedURLException malformedURLException) {
                        LOGGER.error(malformedURLException);
                    }
                }
                if (!this.dryRun) {
                    list2 = MergeConflictsDialog.getInstance().processConflicts(SVNMergeWindow.this.design, list2, list3, false);
                    VersioningTreeNode.refresh(arrayList, false, true);
                }
            }
            finally {
                SVN_CLIENT_HELPER.setCurrentDesign(null);
            }
        }
    }

    private class TestMergeRevisionAction
    extends MergeRevisionAction {
        private TestMergeRevisionAction() {
            super(TEST_MERGE);
            this.dryRun = true;
        }

        @Override
        public void update() {
        }
    }

    private class MergeRevisionAction
    extends VCSHistoryWindow.UpdateableAction {
        protected boolean dryRun;

        protected MergeRevisionAction() {
            this(Messages.getString("SVNMergeWindow.Merge"));
        }

        protected MergeRevisionAction(String string) {
            super(string);
        }

        @Override
        public void update() {
            if (SVNMergeWindow.this.containsTreeConflicts()) {
                this.putValue("Name", Messages.getString("SVNMergeWindow.MergeConflict"));
            } else {
                this.putValue("Name", Messages.getString("SVNMergeWindow.Merge"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List list = SVNMergeWindow.this.collectSelectedRevisionRanges();
            if (!list.isEmpty()) {
                if (SVNMergeWindow.this.hasOutgoingChanges()) {
                    MessageDialogs.showWarningMessage(Messages.getString("SVNMergeWindow.OutgoingChangesFound"));
                } else {
                    this.merge(list);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void merge(List<RevisionRange> list) {
            SVN_CLIENT_HELPER.setCurrentDesign(SVNMergeWindow.this.design);
            try {
                List list2 = SVNMergeWindow.this.collectNodesForMerging(true);
                List<MergeConflict> list3 = SVN_CLIENT_HELPER.doMerge(SVNMergeWindow.this.mergeUrl, new File(SVNMergeWindow.this.design.getDesignPath()), list, false, this.dryRun);
                if (!this.dryRun) {
                    SVNMergeWindow.this.lastMergedRevision = SVNMergeWindow.this.findLastMergedRevision();
                    list3 = MergeConflictsDialog.getInstance().processConflicts(SVNMergeWindow.this.design, list3, list2, false);
                }
            }
            finally {
                SVN_CLIENT_HELPER.setCurrentDesign(null);
            }
        }
    }
}

