/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.io.File;
import java.net.URL;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class SVNCleanupCommand
extends AbstractSVNOperation {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.cleanup" : SVNCleanupCommand.class.getName();
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNCleanupCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public boolean isAvailableImpl() {
        return ApplicationView.getInstance().getCurrentDesign().isVersioned();
    }

    protected int doitImpl(VCSProfile vCSProfile) throws Exception {
        Design design = DataModelerChangeList.getSelectedDesign();
        SVN_CLIENT_HELPER.doCleanup(new File(design.getStorageName()));
        SVN_CLIENT_HELPER.doCleanup(new File(design.getStoragePath()));
        return 0;
    }

    protected boolean invokeCommand(VCSProfile vCSProfile, CommandState commandState) throws Exception {
        URL uRL = this.getContext().getWorkspace().getActiveProjectURL();
        URL uRL2 = SVNUtil.resolveWorkingCopy((URL)uRL);
        if (uRL2 == null) {
            return false;
        }
        SVNRepositoryInfo sVNRepositoryInfo = SVNUtil.getFirstAssociatedRepository((URL)uRL2);
        try {
            ISVNClientAdapter iSVNClientAdapter = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(iSVNClientAdapter, sVNRepositoryInfo);
            iSVNClientAdapter.cleanup(SVNUtil.toFile((URL)uRL2));
        }
        catch (Exception exception) {
            throw SVNExceptionWrapper.wrapException((Exception)exception);
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return true;
    }
}

