/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeWindow;
import oracle.dbtools.crest.model.design.Design;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.model.Locatable;
import oracle.ide.view.View;
import oracle.jdevimpl.vcs.svn.properties.AbstractPropertiesTableModel;
import oracle.jdevimpl.vcs.svn.properties.DockPropertiesTableModel;
import oracle.jdevimpl.vcs.svn.properties.SVNPropertiesWindow;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class SVNViewPropertiesWindow
extends SVNPropertiesWindow {
    private static final SVNViewPropertiesWindow INSTANCE = new SVNViewPropertiesWindow();
    private Design design;
    private ISVNProperty[] properties;
    private SVNViewPropertiesWindowTableModel svnViewPropertiesWindowTableModel;
    private boolean readOnly = true;
    private Controller controller;

    private SVNViewPropertiesWindow() {
        super(null);
    }

    public static SVNViewPropertiesWindow getInstance() {
        return INSTANCE;
    }

    public Design getDesign() {
        return this.design;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public File[] getSelectionResources() {
        ArrayList<File> arrayList = new ArrayList<File>();
        int[] nArray = this.getTable().getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            File file = new File((String)this.getTableModel().getValueAt(nArray[i], 2));
            arrayList.add(file);
        }
        return arrayList.toArray(new File[0]);
    }

    public void refresh(Context context) {
        if (context != null) {
            View view = context.getView();
            Locatable[] locatableArray = VCSClientHelper.getSelection(view);
            this.design = VCSClientHelper.getSelectionDesign(view);
            this.setViewContext(context);
            if (view instanceof SVNHistoryWindow) {
                this.readOnly = !((SVNHistoryWindow)view).isSelectedWorkingCopyRevision();
                this.updatePropertiesTable(view);
            } else if (view instanceof SVNMergeWindow) {
                this.readOnly = true;
                this.updatePropertiesTable(view);
            } else {
                this.readOnly = false;
                this.updatePropertieTable(DisplayableLocatableNode.convertToFileArray(locatableArray, false));
            }
        } else {
            super.refresh();
        }
    }

    public void refresh() {
        if (this.properties != null) {
            this.setTableData(this.properties, this.getScope());
        } else {
            super.refresh();
        }
    }

    public AbstractPropertiesTableModel getTableModel() {
        if (this.svnViewPropertiesWindowTableModel == null) {
            this.svnViewPropertiesWindowTableModel = new SVNViewPropertiesWindowTableModel();
        }
        return this.svnViewPropertiesWindowTableModel;
    }

    protected void remove() {
        if (!this.readOnly) {
            super.remove();
        }
    }

    public void clearForDesign(Design design) {
        if (design.equals(this.design)) {
            this.clear();
        }
    }

    public void clear() {
        this.properties = null;
        this.updatePropertieTable(new File[0]);
    }

    protected void updatePropertiesTable(View view) {
        ArrayList<ISVNProperty> arrayList = new ArrayList<ISVNProperty>();
        List<StorableObjectStatus> list = ((SVNHistoryWindow)view).getSelectedStorableObjectsStatuses();
        for (StorableObjectStatus storableObjectStatus : list) {
            ISVNProperty[] iSVNPropertyArray = SVNClientHelper.getInstance().doGetProperties(storableObjectStatus.getURL(), storableObjectStatus.getRevision());
            if (iSVNPropertyArray == null || iSVNPropertyArray.length <= 0) continue;
            arrayList.addAll(Arrays.asList(iSVNPropertyArray));
        }
        this.properties = arrayList.toArray(new ISVNProperty[0]);
        this.setTableData(this.properties, this.getScope());
    }

    protected class SVNViewPropertiesWindowTableModel
    extends DockPropertiesTableModel {
        protected SVNViewPropertiesWindowTableModel() {
        }

        public void assignTableValues(String[] stringArray, ISVNProperty iSVNProperty) {
            File file = iSVNProperty.getFile();
            stringArray[0] = iSVNProperty.getName();
            stringArray[1] = iSVNProperty.getValue();
            stringArray[2] = file != null ? file.getAbsolutePath() : iSVNProperty.getUrl().toString();
        }
    }
}

