/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChangeListTablePanel;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangesTimerTask;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.UpdateableAction;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;

public class SVNUnversionedFilesChangeList
extends SVNOutgoingChangesChangeList {
    private DeleteAction deleteAction;

    public SVNUnversionedFilesChangeList() {
        super(Messages.getString("SVNUnversionedFilesChangeList.UnversionedFiles"));
    }

    @Override
    protected TimerTask createStatusTask(VCSThreadPool vCSThreadPool) {
        this.timerTask = new DataModelerChangesTimerTask(this){

            @Override
            protected VCSClientHelper getVCSClientHelper() {
                return SVNClientHelper.getInstance();
            }

            @Override
            protected boolean checkRemoteStatus() {
                return false;
            }

            @Override
            protected boolean acceptAll() {
                return true;
            }
        };
        return this.timerTask;
    }

    private DeleteAction getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
        }
        return this.deleteAction;
    }

    @Override
    protected IChangeListPanel createChangeListPanel() {
        this.panel = new ChangeListTablePanel();
        return this.panel;
    }

    @Override
    protected void addActions() {
        this.popupMenu.add(new JMenuItem(this.getDeleteAction()));
    }

    @Override
    protected IdeAction addCompareActions() {
        return null;
    }

    @Override
    protected void addAdditionalActions() {
    }

    @Override
    protected void addToolbarActions(ChangeListWindow changeListWindow, Toolbar toolbar) {
        this.addScopeComboBox(toolbar);
        toolbar.add((Action)this.getDeleteAction());
    }

    private class DeleteAction
    extends UpdateableAction {
        private DeleteAction() {
            super(Messages.getString("SVNUnversionedFilesChangeList.Delete"));
            this.putValue("SmallIcon", GUIConfiguration.getInstance().getIcon("DELETE_ICON"));
            this.update();
        }

        @Override
        public void update() {
            this.setEnabled(SVNUnversionedFilesChangeList.this.panel.hasSelection());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<File> list = SVNUnversionedFilesChangeList.this.panel.getSelectedFilePaths(null, true, true);
            for (File file : list) {
                this.delete(file);
            }
            SVNUnversionedFilesChangeList.this.refresh();
        }

        private void delete(File file) {
            if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    if (file2.isDirectory()) {
                        this.delete(file2);
                        continue;
                    }
                    file2.delete();
                }
            }
            file.delete();
        }
    }
}

