/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.RXMLRDBMSSiteSet;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;

public class VersioningTreeNode
extends DisplayableLocatableNode {
    private static final ApplicationView APPLICATION_VIEW = ApplicationView.getInstance();
    private static final Settings SETTINGS = APPLICATION_VIEW.getSettings();
    private static final XMLTransformationManager XML_TRANSFORMATION_MANAGER = APPLICATION_VIEW.getXMLTransformationManager();
    private static final ProcessModelNodesComparator PROCESS_MODEL_NODES_COMPARATOR = new ProcessModelNodesComparator();
    private static final Logger LOGGER = new Logger(VersioningTreeNode.class);
    private static final String NOT_ABLE_TO_DELETE_MESSAGE = Messages.getString("VersioningTreeNode.NotAbleToDelete");
    private StorableObjectStatus storableObjectStatus;
    private boolean conflicted;
    private VersioningTreeNode dependingOn;
    private File dependantFilePath;

    public VersioningTreeNode(String string, File file) {
        super(string, file, null);
    }

    public VersioningTreeNode(String string, File file, Class clazz) {
        super(string, file, clazz);
    }

    public VersioningTreeNode(StorableObjectStatus storableObjectStatus) {
        super(storableObjectStatus.getStorableObjectName(), null, null);
        this.setStorableObjectStatus(storableObjectStatus);
    }

    @Override
    public StorableObject getStorableObject() {
        return this.storableObjectStatus != null ? this.storableObjectStatus.getStorableObject() : null;
    }

    public StorableObjectStatus getStorableObjectStatus() {
        return this.storableObjectStatus;
    }

    public void setStorableObjectStatus(StorableObjectStatus storableObjectStatus) {
        this.storableObjectStatus = storableObjectStatus;
        this.filePath = storableObjectStatus.getFilePath();
        this.setObjectClass(storableObjectStatus.getObjectClass());
        if ("C".equals(storableObjectStatus.getTextStatus())) {
            this.propagateConflicted(this);
        }
    }

    @Override
    public void setObjectClass(Class clazz) {
        this.objectClass = clazz;
        if (Design.class.equals((Object)clazz) || StorageDesign.class.equals((Object)clazz) || VersioningTreeNode.isMultiModel(clazz)) {
            this.setDependingOn(null);
            this.propagateDependances(this);
            this.setDependantFilePath(StorageDesign.class.equals((Object)clazz) ? this.filePath.getParentFile() : new File(FileUtils.removeExt(this.filePath.getPath())));
        } else if (this.getParent() != null) {
            this.setDependingOn(((VersioningTreeNode)this.getParent()).getDependingOn());
        }
    }

    @Override
    public Icon getIcon() {
        return VCSClientHelper.getIcon(this.objectClass);
    }

    @Override
    public Class getObjectClass() {
        return this.objectClass;
    }

    public static void refresh(List<VersioningTreeNode> list, boolean bl) {
        VersioningTreeNode.refresh(list, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(List<VersioningTreeNode> list, boolean bl, boolean bl2) {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap hashMap2 = new HashMap();
        try {
            List<Object> list2;
            Object object2;
            ApplicationView.loading = true;
            for (VersioningTreeNode object32 : list) {
                object = object32.getStorableObjectStatus().getDesignPart();
                if (object == null || !object32.getStorableObjectStatus().isAdded() && !object32.getStorableObjectStatus().isDeleted()) continue;
                hashMap.put(((ModelIDObject)object).getObjectID(), object);
                object2 = object32.getStorableObjectStatus().getRdbmsSite();
                if (object2 == null) continue;
                list2 = (List)hashMap2.get(object);
                if (list2 == null) {
                    list2 = new ArrayList<Object>();
                    hashMap2.put(object, list2);
                }
                if (list2.contains(object2)) continue;
                list2.add(object2);
            }
            Iterator iterator = VersioningTreeNode.splitSystemNodes(list);
            ArrayList arrayList = new ArrayList();
            object = new ArrayList();
            object2 = new ArrayList();
            list2 = new HashMap();
            VersioningTreeNode.refreshMultiDesignParts(list, bl, arrayList, (List)object, (List)object2, list2);
            Map map = VersioningTreeNode.splitNodes(list);
            VersioningTreeNode.refreshNodes((Map)map.get(Design.class), bl);
            Map map2 = (Map)map.get(ChangeRequest.class);
            if (map2 != null) {
                VersioningTreeNode.refreshNodes(map2, bl);
                VersioningTreeNode.refreshChangeRequestsList(DataModelerChangeList.getSelectedDesign());
            }
            VersioningTreeNode.refreshNodes((Map)map.get(BusinessInfoDesign.class), bl);
            VersioningTreeNode.refreshNodes((Map)map.get(DataTypesDesign.class), bl);
            VersioningTreeNode.refreshNodes((Map)map.get(LogicalDesign.class), bl);
            VersioningTreeNode.refreshNodes((Map)map.get(RelationalDesign.class), bl);
            VersioningTreeNode.refreshExtendedMaps((Map)((Object)iterator));
            VersioningTreeNode.addNewDimensionalModels((List)object);
            VersioningTreeNode.refreshNodes((Map)map.get(MultidimensionalDesign.class), bl);
            VersioningTreeNode.refreshNodes((Map)map.get(ProcessModel.class), bl);
            VersioningTreeNode.addNewPackages((List)object2);
            VersioningTreeNode.addNewTransformationTasks(list2);
            ArrayList arrayList2 = new ArrayList();
            VersioningTreeNode.addAndPreProcessDFDs(arrayList, arrayList2);
            VersioningTreeNode.refreshNodes((Map)map.get(DataFlowDesign.class), bl, true, arrayList2);
            VersioningTreeNode.refreshNodes((Map)map.get(TransformationTask.class), bl);
            if (DataModelerChangeList.getSelectedDesign() != null) {
                DataModelerChangeList.getSelectedDesign().getProcessModel().updateObjects();
            }
        }
        finally {
            for (DesignPart designPart : hashMap.values()) {
                if (designPart == null) continue;
                VersioningTreeNode.removeLocalFiles(designPart, "Objects.local");
                VersioningTreeNode.removeLocalFiles(designPart, "Diagrams.local");
                object = (List)hashMap2.get(designPart);
                if (object == null) continue;
                VersioningTreeNode.removeLocalFiles(designPart, (List)object, "Objects.local");
            }
            ApplicationView.loading = false;
        }
    }

    private static void addNewTransformationTasks(Map map) {
        for (VersioningTreeNode versioningTreeNode : map.values()) {
            TransformationPackage transformationPackage;
            TransformationTask transformationTask;
            String string;
            File file;
            Class clazz = versioningTreeNode.getObjectClass();
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            String string2 = storableObjectStatus.getStorableObjectID();
            Design design = versioningTreeNode.getStorableObjectStatus().getDesign();
            if (clazz == null || !TransformationTask.class.isAssignableFrom(clazz) || !(file = storableObjectStatus.getFilePath()).exists() || (string = storableObjectStatus.getStorableObjectParentID()) == null || "".equals(string) || (transformationTask = (TransformationTask)(transformationPackage = (TransformationPackage)design.getProcessModel().getTransformationPackageSet().getObjectByID(string)).getTransformationTaskSet().getObjectByID(string2)) != null) continue;
            transformationTask = transformationPackage.createTransformationTask(string2);
            XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(transformationTask, file, design.isCompressedDesign());
            XML_TRANSFORMATION_MANAGER.loadTransformationTask(transformationTask);
            design.createLocalDP_Map();
        }
    }

    private static void addAndPreProcessDFDs(List list, List list2) {
        Design design = null;
        for (VersioningTreeNode versioningTreeNode : list) {
            File file;
            Class clazz = versioningTreeNode.getObjectClass();
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            design = versioningTreeNode.getStorableObjectStatus().getDesign();
            if (clazz == null || !DataFlowDesign.class.isAssignableFrom(clazz) || !(file = storableObjectStatus.getFilePath()).exists()) continue;
            DataFlowDesign dataFlowDesign = design.getProcessModel().getObjectID().equals(storableObjectStatus.getStorableObjectParentID()) ? design.getProcessModel().addDataFlowDesign(storableObjectStatus.getStorableObjectName(), true) : design.getProcessModel().addDataFlowDesign(storableObjectStatus.getStorableObjectName());
            try {
                XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(dataFlowDesign, file, design.isCompressedDesign());
            }
            catch (Exception exception) {
                Design.openFailed();
                LOGGER.error("Error in loading of " + file, exception);
            }
        }
        if (design != null) {
            design.createLocalDP_Map();
            design.getProcessModel().getDataFlowDesigns().addOrderedDataFlowDesigns(list2);
        }
    }

    private static void addNewPackages(List list) {
        for (VersioningTreeNode versioningTreeNode : list) {
            File file;
            Class clazz = versioningTreeNode.getObjectClass();
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            Design design = versioningTreeNode.getStorableObjectStatus().getDesign();
            if (clazz == null || !TransformationPackage.class.isAssignableFrom(clazz) || !(file = storableObjectStatus.getFilePath()).exists()) continue;
            TransformationPackage transformationPackage = design.getProcessModel().createTransformationPackage(storableObjectStatus.getStorableObjectID());
            try {
                XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(transformationPackage, file, design.isCompressedDesign());
            }
            catch (Exception exception) {
                Design.openFailed();
                LOGGER.error("Error in loading of " + file, exception);
            }
            design.getProcessModel().setTransformationPackage(transformationPackage);
            XML_TRANSFORMATION_MANAGER.loadTransformationPackage(transformationPackage);
            design.createLocalDP_Map();
        }
    }

    private static void addNewDimensionalModels(List list) {
        for (VersioningTreeNode versioningTreeNode : list) {
            File file;
            Class clazz = versioningTreeNode.getObjectClass();
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            Design design = versioningTreeNode.getStorableObjectStatus().getDesign();
            if (clazz == null || !MultidimensionalDesign.class.isAssignableFrom(clazz) || !(file = storableObjectStatus.getFilePath()).exists()) continue;
            MultidimensionalDesign multidimensionalDesign = design.addMultidimensionalDesign(storableObjectStatus.getStorableObjectID());
            XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(multidimensionalDesign, file, design.isCompressedDesign());
            design.createLocalDP_Map();
            XML_TRANSFORMATION_MANAGER.openDesignPart(multidimensionalDesign);
        }
    }

    private static void refreshDesignParts(List<VersioningTreeNode> list, boolean bl) {
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        Collections.sort(list, PROCESS_MODEL_NODES_COMPARATOR);
        for (VersioningTreeNode versioningTreeNode : list) {
            Object object;
            Object object2;
            Class clazz = versioningTreeNode.getObjectClass();
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            Design design = versioningTreeNode.getStorableObjectStatus().getDesign();
            if (clazz == null) {
                return;
            }
            if (VersioningTreeNode.isMultiModel(clazz) && (bl && storableObjectStatus.isAdded() || !bl && storableObjectStatus.isDeleted())) {
                object2 = versioningTreeNode.getStorableObjectStatus().getDesignPart();
                if (object2 instanceof RelationalDesign) {
                    object = (RelationalDesign)object2;
                    design.removeRelationalDesign((RelationalDesign)object);
                } else if (object2 instanceof MultidimensionalDesign) {
                    object = (MultidimensionalDesign)object2;
                    design.removeMultidimensionalDesign((MultidimensionalDesign)object);
                } else if (object2 instanceof DataFlowDesign) {
                    object = (DataFlowDesign)object2;
                    design.getProcessModel().removeDataFlowDesign((DataFlowDesign)object);
                } else if (object2 instanceof TransformationTask) {
                    object = (TransformationTask)object2;
                    ((TransformationTask)object).getTransformationPackage().removeTransformationTask((TransformationTask)object);
                }
                design.removeDeletedDesignParts(false);
                design.createLocalDP_Map();
                arrayList.add(versioningTreeNode);
                continue;
            }
            if (!VersioningTreeNode.isMultiModel(clazz) && !TransformationPackage.class.isAssignableFrom(clazz) && !InfoStore.class.isAssignableFrom(clazz) || (!bl || !storableObjectStatus.isDeleted()) && (bl || !storableObjectStatus.isAdded())) continue;
            object2 = storableObjectStatus.getFilePath();
            if (((File)object2).exists()) {
                TransformationPackage transformationPackage;
                SVNObjectHelper sVNObjectHelper;
                Object object3;
                object = storableObjectStatus.getDesignPartClass();
                DesignPart designPart = null;
                if (RelationalDesign.class.isAssignableFrom((Class<?>)object)) {
                    designPart = design.addRelationalDesign(storableObjectStatus.getStorableObjectID());
                } else if (MultidimensionalDesign.class.isAssignableFrom((Class<?>)object)) {
                    designPart = design.addMultidimensionalDesign(storableObjectStatus.getStorableObjectID());
                } else if (DataFlowDesign.class.isAssignableFrom((Class<?>)object)) {
                    designPart = design.getProcessModel().addDataFlowDesign(storableObjectStatus.getStorableObjectID());
                } else if (TransformationPackage.class.isAssignableFrom(clazz)) {
                    object3 = storableObjectStatus.getStorableObjectID();
                    sVNObjectHelper = SVNObjectHelper.getSVNObjectHelperFor(design, (String)object3);
                    if (sVNObjectHelper != null) {
                        transformationPackage = design.getProcessModel().createTransformationPackage(sVNObjectHelper.propID);
                        transformationPackage.setName(sVNObjectHelper.propName);
                        design.getProcessModel().setTransformationPackage(transformationPackage);
                    }
                } else if (TransformationTask.class.isAssignableFrom((Class<?>)object)) {
                    object3 = SVNObjectHelper.getSVNObjectHelperFor(design, storableObjectStatus.getStorableObjectID());
                    if (object3 != null && (sVNObjectHelper = SVNObjectHelper.getSVNObjectHelperFor(design, ((SVNObjectHelper)object3).parentID)) != null) {
                        transformationPackage = (TransformationPackage)design.getProcessModel().getTransformationPackageSet().getObjectByID(sVNObjectHelper.propID);
                        designPart = transformationPackage.createTransformationTask(storableObjectStatus.getStorableObjectID());
                    }
                } else if (InfoStore.class.isAssignableFrom(clazz)) {
                    ((ProcessModel)storableObjectStatus.getDesignPart()).getInfoStoreSet().createInfoStore(storableObjectStatus.getStorableObjectID());
                }
                if (designPart != null) {
                    XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(designPart, (File)object2, design.isCompressedDesign());
                    design.createLocalDP_Map();
                    XML_TRANSFORMATION_MANAGER.openDesignPart(designPart);
                }
            }
            arrayList.add(versioningTreeNode);
        }
        VersioningTreeNode.removeProcessedNodes(list, arrayList);
    }

    private static void refreshMultiDesignParts(List<VersioningTreeNode> list, boolean bl, List list2, List list3, List list4, Map map) {
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        Collections.sort(list, PROCESS_MODEL_NODES_COMPARATOR);
        for (VersioningTreeNode versioningTreeNode : list) {
            Object object;
            Object object2;
            Class clazz = versioningTreeNode.getObjectClass();
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            Design design = versioningTreeNode.getStorableObjectStatus().getDesign();
            if (clazz == null) continue;
            if (VersioningTreeNode.isMultiModel(clazz) && (bl && storableObjectStatus.isAdded() || !bl && storableObjectStatus.isDeleted())) {
                object2 = versioningTreeNode.getStorableObjectStatus().getDesignPart();
                if (object2 instanceof RelationalDesign) {
                    object = (RelationalDesign)object2;
                    design.removeRelationalDesign((RelationalDesign)object);
                } else if (object2 instanceof MultidimensionalDesign) {
                    object = (MultidimensionalDesign)object2;
                    design.removeMultidimensionalDesign((MultidimensionalDesign)object);
                } else if (object2 instanceof DataFlowDesign) {
                    object = (DataFlowDesign)object2;
                    design.getProcessModel().removeDataFlowDesign((DataFlowDesign)object);
                } else if (object2 instanceof TransformationTask) {
                    object = (TransformationTask)object2;
                    ((TransformationTask)object).getTransformationPackage().removeTransformationTask((TransformationTask)object);
                }
                design.removeDeletedDesignParts(false);
                design.createLocalDP_Map();
                arrayList.add(versioningTreeNode);
                continue;
            }
            if (!VersioningTreeNode.isMultiModel(clazz) && !TransformationPackage.class.isAssignableFrom(clazz) || (!bl || !storableObjectStatus.isDeleted()) && (bl || !storableObjectStatus.isAdded())) continue;
            object2 = storableObjectStatus.getFilePath();
            if (((File)object2).exists()) {
                object = storableObjectStatus.getDesignPartClass();
                RelationalDesign relationalDesign = null;
                if (RelationalDesign.class.isAssignableFrom((Class<?>)object)) {
                    relationalDesign = design.addRelationalDesign(storableObjectStatus.getStorableObjectID());
                    ((DesignPart)relationalDesign).setLoaded(false);
                } else if (MultidimensionalDesign.class.isAssignableFrom((Class<?>)object)) {
                    list3.add(versioningTreeNode);
                } else if (DataFlowDesign.class.isAssignableFrom((Class<?>)object)) {
                    list2.add(versioningTreeNode);
                } else if (TransformationPackage.class.isAssignableFrom(clazz)) {
                    list4.add(versioningTreeNode);
                } else if (TransformationTask.class.isAssignableFrom((Class<?>)object)) {
                    map.put(storableObjectStatus.getStorableObjectID(), versioningTreeNode);
                } else if (InfoStore.class.isAssignableFrom(clazz)) {
                    ((ProcessModel)storableObjectStatus.getDesignPart()).getInfoStoreSet().createInfoStore(storableObjectStatus.getStorableObjectID());
                }
                if (relationalDesign != null && !(relationalDesign instanceof RelationalDesign)) {
                    XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(relationalDesign, (File)object2, design.isCompressedDesign());
                    design.createLocalDP_Map();
                    XML_TRANSFORMATION_MANAGER.openDesignPart(relationalDesign);
                } else if (relationalDesign != null && relationalDesign instanceof RelationalDesign) {
                    XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(relationalDesign, (File)object2, design.isCompressedDesign());
                    design.createLocalDP_Map();
                    ((DesignPart)relationalDesign).setLoaded(false);
                }
            }
            arrayList.add(versioningTreeNode);
        }
        VersioningTreeNode.removeProcessedNodes(list, arrayList);
    }

    private static void removeProcessedNodes(List<VersioningTreeNode> list, List<VersioningTreeNode> list2) {
        list.removeAll(list2);
        for (VersioningTreeNode versioningTreeNode : list2) {
            DesignPart designPart = versioningTreeNode.getStorableObjectStatus().getDesignPart();
            for (int i = list.size() - 1; i >= 0; --i) {
                VersioningTreeNode versioningTreeNode2 = list.get(i);
                if (designPart != null && designPart.equals(versioningTreeNode2.getStorableObjectStatus().getDesignPart())) {
                    if (designPart instanceof ProcessModel) continue;
                    list.remove(i);
                    continue;
                }
                if (!versioningTreeNode.equals(versioningTreeNode2.getDependingOn())) continue;
                list.remove(i);
            }
        }
    }

    private static Map splitNodes(List<VersioningTreeNode> list) {
        HashMap hashMap = new HashMap();
        HashSet<DesignPart> hashSet = new HashSet<DesignPart>();
        HashSet<DesignPart> hashSet2 = new HashSet<DesignPart>();
        HashSet<StorageDesign> hashSet3 = new HashSet<StorageDesign>();
        for (VersioningTreeNode versioningTreeNode : list) {
            ArrayList<VersioningTreeNode> arrayList;
            HashMap<String, ArrayList<VersioningTreeNode>> hashMap2;
            HashMap hashMap3;
            HashMap hashMap4;
            Object object;
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            DesignPart designPart = storableObjectStatus.getDesignPart();
            RDBMSSite rDBMSSite = storableObjectStatus.getRdbmsSite();
            StorageDesign storageDesign = null;
            if (rDBMSSite != null && storableObjectStatus.getDesignPart() instanceof RelationalDesign) {
                storageDesign = ((RelationalDesign)storableObjectStatus.getDesignPart()).getStorageDesign(rDBMSSite);
            }
            Class clazz = storableObjectStatus.getDesignPartClass();
            String string = storableObjectStatus.getTextStatus();
            if (storageDesign != null) {
                if (hashSet3.contains(storageDesign)) continue;
                hashSet3.add(storageDesign);
                continue;
            }
            if (designPart != null && !designPart.isLoaded() && ("A".equals(string) || "D".equals(string))) {
                object = storableObjectStatus.getObjectClass();
                if (object != null && DesignPartView.class.isAssignableFrom((Class<?>)object)) {
                    hashSet2.add(designPart);
                    continue;
                }
                hashSet.add(designPart);
                continue;
            }
            object = storableObjectStatus.getObjectType();
            if (object == null) {
                object = storableObjectStatus.getClass().toString();
            }
            if (clazz == null) {
                clazz = storableObjectStatus.getObjectClass();
            }
            if ((hashMap4 = (HashMap)hashMap.get(clazz)) == null) {
                hashMap4 = new HashMap();
                hashMap.put(clazz, hashMap4);
            }
            if ((hashMap3 = (HashMap)hashMap4.get(designPart)) == null) {
                hashMap3 = new HashMap();
                hashMap4.put(designPart, hashMap3);
            }
            if ((hashMap2 = (HashMap<String, ArrayList<VersioningTreeNode>>)hashMap3.get(object)) == null) {
                hashMap2 = new HashMap<String, ArrayList<VersioningTreeNode>>();
                hashMap3.put(object, hashMap2);
            }
            if ((arrayList = (ArrayList<VersioningTreeNode>)hashMap2.get(string)) == null) {
                arrayList = new ArrayList<VersioningTreeNode>();
                hashMap2.put(string, arrayList);
            }
            arrayList.add(versioningTreeNode);
        }
        VersioningTreeNode.removeLocalFiles(hashSet, "Objects.local", hashMap);
        VersioningTreeNode.removeLocalFiles(hashSet2, "Diagrams.local", hashMap);
        VersioningTreeNode.removeLocalFiles(hashSet3, "Objects.local");
        return hashMap;
    }

    private static void refreshNodes(Map map, boolean bl) {
        VersioningTreeNode.refreshNodes(map, bl, false);
    }

    private static void refreshNodes(Map map, boolean bl, boolean bl2) {
        if (map != null) {
            Map map2 = (Map)map.remove(null);
            if (map2 != null) {
                VersioningTreeNode.refreshNodesWithoutDesignPart(map2, bl);
            }
            VersioningTreeNode.refreshNodesWithDesignPart(map, bl, bl2);
        }
    }

    private static void refreshNodes(Map map, boolean bl, boolean bl2, List list) {
        if (map != null) {
            Map map2 = (Map)map.remove(null);
            if (map2 != null) {
                VersioningTreeNode.refreshNodesWithoutDesignPart(map2, bl);
            }
            VersioningTreeNode.refreshNodesWithDesignPart(map, bl, bl2, list);
        }
    }

    private static void refreshNodesWithoutDesignPart(Map map, boolean bl) {
        VersioningTreeNode.refresh(map, map.keySet(), bl, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshNodesWithDesignPart(Map map, boolean bl, boolean bl2) {
        for (Object k : map.keySet()) {
            DesignPart designPart = (DesignPart)k;
            if (!designPart.isLoaded()) continue;
            designPart.getDesign().setPropagatePKChahges(false);
            try {
                Map map2 = (Map)map.get(designPart);
                List list = designPart.getOrderedTypes(new ArrayList(map2.keySet()));
                VersioningTreeNode.refresh(map2, list, bl, bl2, map);
                designPart.executeTasks();
                designPart.synchronizeFilesMap(false);
                if (designPart instanceof RelationalDesign) {
                    StorageDesign[] storageDesignArray;
                    for (StorageDesign storageDesign : storageDesignArray = ((RelationalDesign)designPart).getStorageDesignFactory().getOpenStorageDesigns()) {
                        storageDesign.synchronizeFilesMap(false);
                    }
                }
                XML_TRANSFORMATION_MANAGER.saveObjectsAndDiagramsList(designPart);
                designPart.doAfterLoad();
            }
            finally {
                designPart.getDesign().setPropagatePKChahges(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshNodesWithDesignPart(Map map, boolean bl, boolean bl2, List list) {
        for (DesignPart designPart : list) {
            if (designPart instanceof DataFlowDesign && !designPart.isLoaded()) {
                XML_TRANSFORMATION_MANAGER.openDesignPart(designPart);
                designPart.sortCollections();
            }
            if (!designPart.isLoaded()) continue;
            designPart.getDesign().setPropagatePKChahges(false);
            try {
                Map map2 = (Map)map.get(designPart);
                List list2 = designPart.getOrderedTypes(new ArrayList(map2.keySet()));
                VersioningTreeNode.refresh(map2, list2, bl, bl2, map);
                designPart.executeTasks();
                designPart.synchronizeFilesMap(false);
                if (designPart instanceof RelationalDesign) {
                    StorageDesign[] storageDesignArray;
                    for (StorageDesign storageDesign : storageDesignArray = ((RelationalDesign)designPart).getStorageDesignFactory().getOpenStorageDesigns()) {
                        storageDesign.synchronizeFilesMap(false);
                    }
                }
                XML_TRANSFORMATION_MANAGER.saveObjectsAndDiagramsList(designPart);
                designPart.doAfterLoad();
            }
            finally {
                designPart.getDesign().setPropagatePKChahges(true);
            }
        }
    }

    private static void refresh(Map map, Collection<String> collection, boolean bl, boolean bl2, Map map2) {
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        for (String string : collection) {
            List list;
            List list2;
            List list3;
            Map map3 = (Map)map.get(string);
            if (map3 == null) continue;
            if (bl) {
                list3 = (List)map3.get("A");
                VersioningTreeNode.removeObjects(list3, bl2, map2, bl);
                list2 = (List)map3.get("D");
                VersioningTreeNode.createObjects(list2, bl2, map2, bl);
                list = (List)map3.get("C");
                VersioningTreeNode.refreshObjects(list, bl2, map2, bl);
                List list4 = (List)map3.get("M");
                VersioningTreeNode.refreshObjects(list4, bl2, map2, bl);
                VersioningTreeNode.addNodes(list3, arrayList);
                VersioningTreeNode.addNodes(list2, arrayList);
                VersioningTreeNode.addNodes(list, arrayList);
                VersioningTreeNode.addNodes(list4, arrayList);
                continue;
            }
            list3 = (List)map3.get("D");
            VersioningTreeNode.removeObjects(list3, bl2, map2, bl);
            list2 = (List)map3.get("A");
            VersioningTreeNode.createObjects(list2, bl2, map2, bl);
            list = (List)map3.get("M");
            VersioningTreeNode.refreshObjects(list, bl2, map2, bl);
            VersioningTreeNode.addNodes(list2, arrayList);
            VersioningTreeNode.addNodes(list, arrayList);
        }
        VersioningTreeNode.clearDirtyStatus(arrayList);
    }

    private static Map<Object, List<VersioningTreeNode>> splitSystemNodes(List<VersioningTreeNode> list) {
        HashMap<Object, List<VersioningTreeNode>> hashMap = new HashMap<Object, List<VersioningTreeNode>>();
        for (VersioningTreeNode object : list) {
            StorableObjectStatus storableObjectStatus = object.getStorableObjectStatus();
            String string = storableObjectStatus.getStorableObjectName();
            Class clazz = storableObjectStatus.getObjectClass();
            if ("defaultRDBMSSites.xml".equalsIgnoreCase(string)) {
                VersioningTreeNode.addToNodesList(hashMap, "defaultRDBMSSites.xml", object);
                continue;
            }
            if ("types.xml".equalsIgnoreCase(string)) {
                VersioningTreeNode.addToNodesList(hashMap, "types.xml", object);
                continue;
            }
            if ("defaultdomains.xml".equalsIgnoreCase(string)) {
                VersioningTreeNode.addToNodesList(hashMap, "defaultdomains.xml", object);
                continue;
            }
            if ("dr_custom_scripts.xml".equalsIgnoreCase(string)) {
                VersioningTreeNode.addToNodesList(hashMap, "dr_custom_scripts.xml", object);
                continue;
            }
            if (clazz == null) continue;
            if (clazz.isAssignableFrom(RDBMSSite.class)) {
                VersioningTreeNode.addToNodesList(hashMap, RDBMSSite.class, object);
                continue;
            }
            if (clazz.isAssignableFrom(DomainFileWrapper.class)) {
                VersioningTreeNode.addToNodesList(hashMap, DomainFileWrapper.class, object);
                continue;
            }
            if (clazz.isAssignableFrom(Design.DLSettings.class)) {
                VersioningTreeNode.addToNodesList(hashMap, Design.DLSettings.class, object);
                continue;
            }
            if (!clazz.isAssignableFrom(ExtendedMap.class)) continue;
            VersioningTreeNode.addToNodesList(hashMap, ExtendedMap.class, object);
        }
        for (List list2 : hashMap.values()) {
            list.removeAll(list2);
        }
        return hashMap;
    }

    private static void addToNodesList(Map<Object, List<VersioningTreeNode>> map, Object object, VersioningTreeNode versioningTreeNode) {
        List<VersioningTreeNode> list = map.get(object);
        if (list == null) {
            list = new ArrayList<VersioningTreeNode>();
            map.put(object, list);
        }
        list.add(versioningTreeNode);
    }

    private static List<VersioningTreeNode> collectSystemNodes(List<VersioningTreeNode> list) {
        ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
        for (VersioningTreeNode versioningTreeNode : list) {
            if (versioningTreeNode.getStorableObjectStatus() != null) continue;
            arrayList.add(versioningTreeNode);
        }
        return arrayList;
    }

    private static void addNodes(List<VersioningTreeNode> list, List<VersioningTreeNode> list2) {
        if (list != null) {
            list2.addAll(list);
        }
    }

    private static void clearDirtyStatus(List<VersioningTreeNode> list) {
        for (VersioningTreeNode versioningTreeNode : list) {
            StorableObject storableObject = versioningTreeNode.getStorableObject();
            if (storableObject == null) continue;
            XML_TRANSFORMATION_MANAGER.clearDirtyStatus(storableObject);
        }
    }

    private static void createObjects(List<VersioningTreeNode> list, boolean bl, Map map, boolean bl2) {
        if (list != null) {
            for (VersioningTreeNode versioningTreeNode : list) {
                VersioningTreeNode.createObject(versioningTreeNode, bl, map, bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createObject(VersioningTreeNode versioningTreeNode, boolean bl, Map map, boolean bl2) {
        File file = versioningTreeNode.getFilePath();
        if (file.exists()) {
            StorableObject storableObject = null;
            StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
            String string = storableObjectStatus.getObjectType();
            Class clazz = storableObjectStatus.getObjectClass();
            DesignPart designPart = storableObjectStatus.getDesignPart();
            if (bl) {
                VersioningTreeNode.processParent(storableObjectStatus.getStorableObjectParentID(), map, bl2);
            }
            if (clazz != null && DesignPartView.class.isAssignableFrom(clazz)) {
                storableObject = designPart.createDesignPartSubView();
            } else if (clazz != null && StorageObject.class.isAssignableFrom(clazz)) {
                StorageDesign storageDesign;
                RDBMSSite rDBMSSite = storableObjectStatus.getRdbmsSite();
                if (rDBMSSite != null && storableObjectStatus.getDesignPart() instanceof RelationalDesign && (storageDesign = ((RelationalDesign)storableObjectStatus.getDesignPart()).getStorageDesign(rDBMSSite)).isOpen()) {
                    StorageObjectSet storageObjectSet = storageDesign.getStorageObjectSetForType(string);
                    if (storageObjectSet == null) {
                        return;
                    }
                    storableObject = storageObjectSet.createElement(storableObjectStatus.getStorableObjectID());
                }
            } else if (clazz != null && StorageDesign.class.isAssignableFrom(clazz)) {
                XML_TRANSFORMATION_MANAGER.loadExistingPhysicalModels((RelationalDesign)designPart);
            } else if (string != null) {
                storableObject = designPart.createObject(string, storableObjectStatus.getStorableObjectID(), null);
            }
            boolean bl3 = ApplicationView.loading;
            if (storableObject instanceof DesignPartView) {
                ApplicationView.loading = false;
            }
            try {
                VersioningTreeNode.transformFromXMLToObject(storableObject, file, storableObjectStatus);
            }
            finally {
                ApplicationView.loading = bl3;
            }
        }
    }

    private static void transformFromXMLToObject(StorableObject storableObject, File file, StorableObjectStatus storableObjectStatus) {
        if (storableObject != null) {
            Relation relation;
            XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(storableObject, file, storableObject.getDesign().isCompressedDesign());
            if (storableObject instanceof FKIndexAssociation) {
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)storableObject;
                XML_TRANSFORMATION_MANAGER.clearDirtyStatus(fKIndexAssociation.getTable());
            } else if (storableObject instanceof Relation && ((relation = (Relation)storableObject).getSourceEntity() == null || relation.getTargetEntity() == null)) {
                relation.remove();
            }
            storableObjectStatus.setStorableObject(storableObject);
            XML_TRANSFORMATION_MANAGER.clearDirtyStatus(storableObject);
        }
    }

    private static void refreshObjects(List<VersioningTreeNode> list, boolean bl, Map map, boolean bl2) {
        if (list != null) {
            for (VersioningTreeNode versioningTreeNode : list) {
                VersioningTreeNode.refreshObject(versioningTreeNode, bl, map, bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshObject(VersioningTreeNode versioningTreeNode, boolean bl, Map map, boolean bl2) {
        StorableObject storableObject = versioningTreeNode.getStorableObject();
        if (storableObject != null) {
            if (bl) {
                VersioningTreeNode.processParent(versioningTreeNode.getStorableObjectStatus().getStorableObjectParentID(), map, bl2);
            }
            boolean bl3 = ApplicationView.loading;
            if (storableObject instanceof DesignPartView) {
                ApplicationView.loading = false;
            }
            try {
                DesignPartView designPartView;
                XML_TRANSFORMATION_MANAGER.transformFromXMLToObject(storableObject, versioningTreeNode.getFilePath(), storableObject.getDesign().isCompressedDesign());
                if (storableObject instanceof DesignPartView && (designPartView = (DesignPartView)storableObject).isVisible()) {
                    designPartView.setVisible(true);
                    for (DesignPartView designPartView2 : designPartView.getSubordinateViews()) {
                        designPartView2.setVisible(true);
                    }
                }
            }
            finally {
                ApplicationView.loading = bl3;
            }
        }
    }

    private static void refreshSystemFiles(Map<Object, List<VersioningTreeNode>> map) {
        VersioningTreeNode.refreshDefaultRDBMSSites(map);
        VersioningTreeNode.refreshRDBMSSites(map);
        VersioningTreeNode.refreshDefaultTypes(map);
        VersioningTreeNode.refreshDefaultDomains(map);
        VersioningTreeNode.refreshDesignLevelDomains(map);
        VersioningTreeNode.refreshDesignLevelSettings(map);
        VersioningTreeNode.refreshCustomDesignRules(map);
    }

    private static void refreshExtendedMaps(Map map) {
        List list = (List)map.get(ExtendedMap.class);
        if (list != null) {
            for (VersioningTreeNode versioningTreeNode : list) {
                StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
                Design design = storableObjectStatus.getDesign();
                String string = storableObjectStatus.getStorableObjectID();
                if (string.startsWith("ExtendedMap_RM")) {
                    int n = string.toUpperCase().indexOf(".XML");
                    if (n > 0) {
                        string = string.substring(0, n);
                    }
                    string = string.substring("ExtendedMap_RM".length());
                    RelationalDesign relationalDesign = (RelationalDesign)design.getRelationalDesigns().getObjectByID(string);
                    if (relationalDesign == null || !relationalDesign.isLoaded()) continue;
                    relationalDesign.getRMExtendedMap().clearMappings();
                    design.getAppView().getXMLTransformationManager().transformFromXMLToObject(relationalDesign.getRMExtendedMap(), new File(relationalDesign.getRMExtendedMap().getStorageName()), design.isCompressedDesign());
                    continue;
                }
                ExtendedMap extendedMap = design.getExtendedMap();
                extendedMap.clearMappingsMaps();
                if (design.isOldRepositoryType()) {
                    extendedMap.load();
                    continue;
                }
                design.getAppView().getXMLTransformationManager().transformFromXMLToObject(extendedMap, new File(extendedMap.getStorageName()), design.isCompressedDesign());
            }
        }
    }

    private static void refreshRDBMSSites(Map map) {
        List list = (List)map.get(RDBMSSite.class);
        if (list != null) {
            for (VersioningTreeNode versioningTreeNode : list) {
                StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
                Design design = storableObjectStatus.getDesign();
                String string = storableObjectStatus.getFilePath().getPath();
                XMLPersistenceManager xMLPersistenceManager = design.getAppView().getPersistenceManager();
                new RXMLRDBMSSiteSet(xMLPersistenceManager).readNoneDefaultRDBMSSites(string, design, design.getRDBMSSiteSet());
            }
        }
    }

    private static void refreshDesignLevelSettings(Map map) {
        List list = (List)map.get(Design.DLSettings.class);
        if (list != null) {
            for (VersioningTreeNode versioningTreeNode : list) {
                StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
                Design design = storableObjectStatus.getDesign();
                design.loadDLSettingsFile(design.getStoragePath());
            }
        }
    }

    private static void refreshDefaultTypes(Map map) {
        if (map.get("types.xml") != null) {
            SETTINGS.refreshDefaultTypes();
        }
    }

    private static void refreshDefaultDomains(Map map) {
        if (map.get("defaultdomains.xml") != null) {
            SETTINGS.refreshDefaultDomains();
        }
    }

    private static void refreshDesignLevelDomains(Map map) {
        List list = (List)map.get(DomainFileWrapper.class);
        if (list != null) {
            for (VersioningTreeNode versioningTreeNode : list) {
                StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
                Design design = storableObjectStatus.getDesign();
                String string = storableObjectStatus.getFilePath().getPath();
                ApplicationView applicationView = design.getAppView();
                if (design.isOldRepositoryType()) {
                    applicationView.getPersistenceManager().readDomainFile(string, design, false);
                    continue;
                }
                applicationView.getXMLTransformationManager().loadDomainFile(new File(string), design);
            }
        }
    }

    private static void refreshDefaultRDBMSSites(Map map) {
        if (map.get("defaultRDBMSSites.xml") != null) {
            SETTINGS.refreshDefaultRDBMSSites();
        }
    }

    private static void refreshCustomDesignRules(Map map) {
        if (map.get("dr_custom_scripts.xml") != null) {
            APPLICATION_VIEW.loadCustomDRScripts();
        }
    }

    private static void removeObjects(List<VersioningTreeNode> list, boolean bl, Map map, boolean bl2) {
        if (list != null) {
            for (VersioningTreeNode versioningTreeNode : list) {
                VersioningTreeNode.removeObject(versioningTreeNode, bl, map, bl2);
            }
        }
    }

    private static void removeObject(VersioningTreeNode versioningTreeNode, boolean bl, Map map, boolean bl2) {
        StorableObject storableObject = versioningTreeNode.getStorableObject();
        if (storableObject != null) {
            if (bl) {
                VersioningTreeNode.processParent(versioningTreeNode.getStorableObjectStatus().getStorableObjectParentID(), map, bl2);
            }
            if (storableObject instanceof RelationalObjectProxy) {
                String string = ((RelationalObjectProxy)storableObject).getSegmentedStorageName();
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add(string);
                storableObject.getDesign().getAppView().getXMLTransformationManager().deleteFiles(arrayList);
            } else if (storableObject instanceof StorageDesign) {
                StorageDesign storageDesign = (StorageDesign)storableObject;
                storageDesign.delete(false);
            } else if (storableObject instanceof ModelIDObject) {
                ((ModelIDObject)storableObject).remove();
            } else if (storableObject instanceof DesignPartView) {
                DesignPartView designPartView = (DesignPartView)storableObject;
                designPartView.getDesignPart().deleteSubview(designPartView);
            }
        }
    }

    private static void processParent(String string, Map<DesignPart, Map> map, boolean bl) {
        if (string != null) {
            VersioningTreeNode versioningTreeNode = VersioningTreeNode.searchForParent(string, "A", map);
            if (versioningTreeNode != null) {
                if (bl) {
                    VersioningTreeNode.removeObject(versioningTreeNode, true, map, bl);
                } else {
                    VersioningTreeNode.createObject(versioningTreeNode, true, map, bl);
                }
                return;
            }
            versioningTreeNode = VersioningTreeNode.searchForParent(string, "D", map);
            if (versioningTreeNode != null) {
                if (bl) {
                    VersioningTreeNode.createObject(versioningTreeNode, true, map, bl);
                } else {
                    VersioningTreeNode.removeObject(versioningTreeNode, true, map, bl);
                }
                return;
            }
            versioningTreeNode = VersioningTreeNode.searchForParent(string, "M", map);
            if (versioningTreeNode != null) {
                VersioningTreeNode.refreshObject(versioningTreeNode, true, map, bl);
                return;
            }
            if (bl && (versioningTreeNode = VersioningTreeNode.searchForParent(string, "C", map)) != null) {
                VersioningTreeNode.refreshObject(versioningTreeNode, true, map, bl);
            }
        }
    }

    private static VersioningTreeNode searchForParent(String string, String string2, Map<DesignPart, Map> map) {
        for (DesignPart designPart : map.keySet()) {
            Map map2 = map.get(designPart);
            for (Object k : map2.keySet()) {
                Map map3 = (Map)map2.get(k);
                List list = (List)map3.get(string2);
                if (list == null) continue;
                for (int i = list.size() - 1; i >= 0; --i) {
                    VersioningTreeNode versioningTreeNode = (VersioningTreeNode)list.get(i);
                    StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
                    if (storableObjectStatus == null || !string.equals(storableObjectStatus.getStorableObjectID())) continue;
                    list.remove(i);
                    if (list.isEmpty()) {
                        map3.remove(string2);
                    }
                    return versioningTreeNode;
                }
            }
        }
        return null;
    }

    public void setConflicted(boolean bl) {
        this.conflicted = bl;
    }

    public boolean isConflicted() {
        return this.conflicted;
    }

    public VersioningTreeNode getDependingOn() {
        return this.dependingOn;
    }

    public void setDependingOn(VersioningTreeNode versioningTreeNode) {
        this.dependingOn = versioningTreeNode;
    }

    public File getDependantFilePath() {
        return this.dependantFilePath;
    }

    public void setDependantFilePath(File file) {
        this.dependantFilePath = file;
    }

    private void propagateConflicted(VersioningTreeNode versioningTreeNode) {
        versioningTreeNode.setConflicted(true);
        VersioningTreeNode versioningTreeNode2 = (VersioningTreeNode)versioningTreeNode.getParent();
        if (versioningTreeNode2 != null) {
            this.propagateConflicted(versioningTreeNode2);
        }
    }

    private void propagateDependances(VersioningTreeNode versioningTreeNode) {
        for (int i = 0; i < versioningTreeNode.getChildCount(); ++i) {
            VersioningTreeNode versioningTreeNode2 = (VersioningTreeNode)versioningTreeNode.getChildAt(i);
            this.setDependances(versioningTreeNode2);
            this.propagateDependances(versioningTreeNode2);
        }
    }

    private void setDependances(VersioningTreeNode versioningTreeNode) {
        if (this.objectClass != null && VersioningTreeNode.isMultiModel(this.objectClass) && this.storableObjectStatus != null && !"M".equals(this.storableObjectStatus.getTextStatus())) {
            versioningTreeNode.setDependingOn(this);
        } else {
            versioningTreeNode.setDependingOn(this.getDependingOn());
        }
    }

    @Override
    public void add(MutableTreeNode mutableTreeNode) {
        VersioningTreeNode versioningTreeNode = (VersioningTreeNode)mutableTreeNode;
        super.add(mutableTreeNode);
        if (versioningTreeNode.isConflicted()) {
            this.propagateConflicted(this);
        }
        this.setDependances(versioningTreeNode);
    }

    private static boolean isMultiModel(Class clazz) {
        return clazz != null && (RelationalDesign.class.isAssignableFrom(clazz) || MultidimensionalDesign.class.isAssignableFrom(clazz) || DataFlowDesign.class.isAssignableFrom(clazz) || TransformationTask.class.isAssignableFrom(clazz) || StorageDesign.class.isAssignableFrom(clazz));
    }

    private boolean equals(Class clazz, Class clazz2) {
        return clazz2 != null && clazz2.equals(clazz);
    }

    private static void removeLocalFiles(Collection<StorageDesign> collection, String string) {
        for (StorageDesign storageDesign : collection) {
            File file = new File(storageDesign.getStoragePath(), string);
            if (!file.exists() || file.delete()) continue;
            LOGGER.warn(NOT_ABLE_TO_DELETE_MESSAGE + file.getPath());
        }
    }

    private static void removeLocalFiles(DesignPart designPart, String string) {
        File file = new File(designPart.getStoragePath(), string);
        if (file.exists() && !file.delete()) {
            LOGGER.warn(NOT_ABLE_TO_DELETE_MESSAGE + file.getPath());
        }
    }

    private static void removeLocalFiles(DesignPart designPart, List list, String string) {
        if (designPart instanceof RelationalDesign) {
            RelationalDesign relationalDesign = (RelationalDesign)designPart;
            for (RDBMSSite rDBMSSite : list) {
                File file;
                StorageDesign storageDesign = relationalDesign.getStorageDesign(rDBMSSite);
                if (storageDesign == null || !(file = new File(storageDesign.getStoragePath(), string)).exists() || file.delete()) continue;
                LOGGER.warn(NOT_ABLE_TO_DELETE_MESSAGE + file.getPath());
            }
        }
    }

    private static void removeLocalFiles(Collection<DesignPart> collection, String string, Map map) {
        for (DesignPart designPart : collection) {
            VersioningTreeNode.removeLocalFiles(designPart, string);
            Map map2 = (Map)map.get(designPart.getClass());
            map2.remove(designPart);
        }
    }

    private static void refreshChangeRequestsList(Design design) {
        File file = new File(design.getStoragePath(), "ChangeRequests.local");
        if (file.exists() && !file.delete()) {
            LOGGER.warn(NOT_ABLE_TO_DELETE_MESSAGE + file.getPath());
        }
        design.synchronizeChangeRequestsMap();
        XML_TRANSFORMATION_MANAGER.openChangeRequestList(design);
    }

    private static class ProcessModelNodesComparator
    implements Comparator<VersioningTreeNode> {
        private ProcessModelNodesComparator() {
        }

        @Override
        public int compare(VersioningTreeNode versioningTreeNode, VersioningTreeNode versioningTreeNode2) {
            return this.calculateWeight(versioningTreeNode) - this.calculateWeight(versioningTreeNode2);
        }

        private int calculateWeight(VersioningTreeNode versioningTreeNode) {
            Class clazz = versioningTreeNode.getObjectClass();
            if (clazz == null) {
                return -1;
            }
            if (ProcessModel.class.isAssignableFrom(clazz)) {
                return 0;
            }
            if (InfoStore.class.isAssignableFrom(clazz)) {
                return 1;
            }
            return 2;
        }
    }
}

