/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.TextCompareEditor;
import oracle.dbtools.crest.fcp.vcs.VCSTextComparePanel;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class VCSTextCompareFrame
extends JFrame {
    private Window parent;
    private VCSTextComparePanel textComparePanel;
    private StorableObjectStatus storableObjectStatus;
    private File localFile;

    public VCSTextCompareFrame(final Window window, File file, InputStream inputStream, String string, InputStream inputStream2, String string2, boolean bl, boolean bl2, StorableObjectStatus storableObjectStatus) {
        this.parent = window;
        this.localFile = file;
        this.storableObjectStatus = storableObjectStatus;
        this.textComparePanel = new VCSTextComparePanel(file, inputStream, string, inputStream2, string2, bl, bl2){

            @Override
            public void closeParent() {
                VCSTextCompareFrame.this.close();
            }

            @Override
            protected void save() {
                VCSTextCompareFrame.this.beforeSave();
                super.save();
                VCSTextCompareFrame.this.afterSave();
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.textComparePanel, "Center");
        this.setDefaultCloseOperation(2);
        this.setTitle(Messages.getString("VCSTextCompareDialog.Title"));
        this.setSize(720, 600);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                window.setEnabled(true);
            }
        });
        this.addCloseOnEscapeAction();
        CommonUtil.centerOnScreen(this);
    }

    public void showModal() {
        this.parent.setEnabled(false);
        this.setVisible(true);
    }

    public void close() {
        this.parent.setEnabled(true);
        this.dispose();
    }

    public void beforeSave() {
    }

    public void afterSave() {
        StorableObject storableObject;
        if (this.storableObjectStatus != null && (storableObject = this.storableObjectStatus.getStorableObject()) != null) {
            DataModelerAddin.getVCSClientHelper().reloadStorableObject(storableObject, this.localFile, this.storableObjectStatus.getDesignPart());
        }
    }

    private void addCloseOnEscapeAction() {
        String string = "ESCAPE";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), string);
        this.getRootPane().getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VCSTextCompareFrame.this.close();
            }
        });
    }

    public TextCompareEditor getEditor() {
        return this.textComparePanel.getEditor();
    }

    public boolean isOk() {
        return this.textComparePanel.isOk();
    }
}

