/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareFrame;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNViewPropertiesCommand;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.ViewId;
import oracle.ide.view.View;

public abstract class VCSHistoryWindow<L>
extends DockableWindow {
    public static final String WINDOW_ID = "VCSHistoryWindow";
    public static final ViewId VIEW_ID = new ViewId("EXTDockable", "VCSHistoryWindow");
    public static final String LOCAL_SAVED = Messages.getString("VCSHistoryWindow.LocalSaved");
    protected Map<L, List<StorableObjectStatus>> storableObjectStatusesMap;
    protected StorableObjectStatus storableObjectStatus;
    protected File[] filePaths;
    protected Design design;
    private JSplitPane gui = new JSplitPane(0);
    protected VCSHistoryTableModel historyTableModel;
    protected ChangedObjectsTableModel changedObjectsTableModel;
    protected JTable historyTable;
    protected JTable changedObjectsTable;
    protected Toolbar toolbar;
    protected JLabel designLabel = new JLabel();
    protected JLabel fileLabel = new JLabel();
    protected Long lastMergedRevision;
    protected Long lastCopiedRevision;

    public VCSHistoryWindow() {
        this.historyTableModel = new VCSHistoryTableModel();
        this.changedObjectsTableModel = new ChangedObjectsTableModel();
        this.historyTable = new JTable(this.historyTableModel);
        this.changedObjectsTable = new JTable(this.changedObjectsTableModel);
        JPanel jPanel = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1);
        JScrollPane jScrollPane = new JScrollPane(this.historyTable);
        JScrollPane jScrollPane2 = new JScrollPane(this.changedObjectsTable);
        final JTextArea jTextArea = new JTextArea();
        JScrollPane jScrollPane3 = new JScrollPane(jTextArea);
        this.historyTable.setSelectionMode(2);
        this.historyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int[] nArray = VCSHistoryWindow.this.historyTable.getSelectedRows();
                    int n = nArray.length;
                    String string = null;
                    VCSHistoryWindow.this.changedObjectsTableModel.clear();
                    for (int i = 0; i < n; ++i) {
                        int n2 = nArray[i];
                        Object l = null;
                        if (n2 > -1) {
                            l = VCSHistoryWindow.this.historyTableModel.getRows().get(n2);
                            if (n == 1) {
                                string = VCSHistoryWindow.this.getComment(l);
                            }
                        }
                        VCSHistoryWindow.this.changedObjectsTableModel.addLogMessage(l);
                    }
                    jTextArea.setText(string);
                    VCSHistoryWindow.this.changedObjectsTable.updateUI();
                }
            }
        });
        TableColumnModel tableColumnModel = this.historyTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMinWidth(50);
        tableColumn.setPreferredWidth(70);
        tableColumn.setMaxWidth(70);
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setMinWidth(70);
        tableColumn.setPreferredWidth(120);
        tableColumn.setMaxWidth(200);
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setMinWidth(50);
        tableColumn.setPreferredWidth(100);
        tableColumn.setMaxWidth(200);
        TableColumnModel tableColumnModel2 = this.changedObjectsTable.getColumnModel();
        tableColumn = tableColumnModel2.getColumn(0);
        tableColumn.setMinWidth(20);
        tableColumn.setPreferredWidth(50);
        tableColumn.setMaxWidth(50);
        tableColumn = tableColumnModel2.getColumn(3);
        tableColumn.setMinWidth(20);
        tableColumn.setPreferredWidth(60);
        tableColumn.setMaxWidth(100);
        tableColumn = tableColumnModel2.getColumn(1);
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                StorableObjectStatus storableObjectStatus = (StorableObjectStatus)object;
                this.setIcon(VCSClientHelper.getIcon(storableObjectStatus.getObjectClass()));
                this.setText(storableObjectStatus.getStorableObjectName());
                return this;
            }
        });
        jTextArea.setRows(3);
        jTextArea.setEditable(false);
        jPanel.add((Component)this.getToolbar(), "North");
        jPanel.add((Component)jScrollPane, "Center");
        jSplitPane.add(jScrollPane2);
        jSplitPane.add(jScrollPane3);
        this.gui.add(jPanel);
        this.gui.add(jSplitPane);
        jSplitPane.setDividerLocation(0.5);
        this.gui.setDividerLocation(150);
        this.installPopupMenus();
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    protected void installPopupMenus() {
        this.installPopupMenu(this.historyTable, this.createCompareAction(), this.createCompareAsTextAction());
        this.installPopupMenu(this.changedObjectsTable, new AbstractAction[]{new ComparePreviousAction(Messages.getString("VCSHistoryWindow.Compare")), new ComparePreviousAsTextAction(Messages.getString("VCSHistoryWindow.CompareAsText")), new RestoreAction(), SVNViewPropertiesCommand.getAction()});
    }

    public abstract VCSClientHelper getVCSClientHelper();

    protected abstract List<L> getLogMessages(String var1, Long var2, Long var3, boolean var4, boolean var5);

    protected abstract List<L> getLogMessages(File[] var1, Long var2, Long var3, boolean var4, boolean var5);

    protected abstract Long getRevision(L var1);

    protected abstract InputStream getRevision(String var1, Long var2);

    protected abstract InputStream getRevision(File var1, Long var2);

    protected abstract Date getDate(L var1);

    protected abstract String getAuthor(L var1);

    protected abstract String getComment(L var1);

    protected void installPopupMenu(final JTable jTable, final AbstractAction ... abstractActionArray) {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        for (AbstractAction abstractAction : abstractActionArray) {
            jPopupMenu.add(abstractAction);
        }
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.selectRow(mouseEvent);
                    this.showPopupMenu(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.selectRow(mouseEvent);
                    this.showPopupMenu(mouseEvent);
                }
            }

            private void selectRow(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = jTable.rowAtPoint(point);
                ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                if (!listSelectionModel.isSelectedIndex(n)) {
                    listSelectionModel.setSelectionInterval(n, n);
                }
            }

            private void showPopupMenu(MouseEvent mouseEvent) {
                for (AbstractAction abstractAction : abstractActionArray) {
                    if (abstractAction instanceof UpdateableAction) {
                        ((UpdateableAction)abstractAction).update();
                        continue;
                    }
                    if (!(abstractAction instanceof IdeAction)) continue;
                    ((IdeAction)abstractAction).updateAction();
                }
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    private UpdateableAction createCompareAction() {
        return new CompareAction(Messages.getString("VCSHistoryWindow.Compare")){

            @Override
            protected void compare(InputStream inputStream, String string, InputStream inputStream2, String string2, File file) {
                String string3 = VCSHistoryWindow.this.storableObjectStatus.getStorableObjectID();
                StorageDesign storageDesign = VCSHistoryWindow.this.getVCSClientHelper().findStorageDesign(VCSHistoryWindow.this.design, string3);
                XMLMetadataComparator xMLMetadataComparator = new XMLMetadataComparator(VCSHistoryWindow.this.design, storageDesign, inputStream, string, inputStream2, string2, LOCAL_SAVED.equals(string2));
                Map map = xMLMetadataComparator.showModal();
                if (map != null) {
                    VCSHistoryWindow.this.getVCSClientHelper().merge(VCSHistoryWindow.this.storableObjectStatus, file, map);
                }
            }
        };
    }

    private UpdateableAction createCompareAsTextAction() {
        return new CompareAction(Messages.getString("VCSHistoryWindow.CompareAsText")){

            @Override
            protected void compare(InputStream inputStream, String string, InputStream inputStream2, String string2, File file) {
                VCSTextCompareFrame vCSTextCompareFrame = new VCSTextCompareFrame((Window)Ide.getMainWindow(), file, inputStream, string, inputStream2, string2, true, !LOCAL_SAVED.equals(string2), VCSHistoryWindow.this.storableObjectStatus);
                vCSTextCompareFrame.showModal();
            }
        };
    }

    public void setStorableObjectStatus(StorableObjectStatus storableObjectStatus) {
        this.storableObjectStatus = storableObjectStatus;
        this.filePaths = new File[]{storableObjectStatus.getFilePath()};
        this.fileLabel.setText(storableObjectStatus.getStorableObjectName());
        this.init(new File[]{storableObjectStatus.getFilePath()}, storableObjectStatus.getDesign());
        this.refresh();
    }

    public void setFilePaths(File[] fileArray) {
        this.fileLabel.setText(fileArray[0].getPath());
        this.init(fileArray, ApplicationView.getInstance().getCurrentDesign());
        this.refresh();
    }

    protected void init(File[] fileArray, Design design) {
        this.filePaths = fileArray;
        this.design = design;
        this.updateDesignLabel(design);
    }

    protected void updateDesignLabel(Design design) {
        this.designLabel.setText(design.getName() + " (" + design.getDesignPath() + ")");
    }

    public void clear() {
        this.storableObjectStatus = null;
        this.filePaths = null;
        this.designLabel.setText(null);
        this.fileLabel.setText(null);
        this.historyTableModel.clear();
        this.historyTable.updateUI();
        this.changedObjectsTableModel.clear();
        this.changedObjectsTable.updateUI();
    }

    public void clearForDesign(Design design) {
        if (this.storableObjectStatus != null) {
            if (this.storableObjectStatus.getStorableObject().getDesign().equals(design)) {
                this.clear();
            }
        } else if (design.equals(this.design)) {
            this.clear();
        }
    }

    protected void refresh() {
        List list = this.historyTableModel.getRows();
        List<L> list2 = null;
        this.historyTable.clearSelection();
        list.clear();
        list2 = this.getLogMessages();
        if (list2 != null && !list2.isEmpty()) {
            this.storableObjectStatusesMap = this.parseChangedObjects(list2);
            list.addAll(list2);
        }
        this.lastMergedRevision = this.findLastMergedRevision();
        this.lastCopiedRevision = this.findLastCopiedRevision();
        this.historyTable.updateUI();
        this.changedObjectsTable.updateUI();
    }

    protected Long findLastMergedRevision() {
        return null;
    }

    protected Long findLastCopiedRevision() {
        return null;
    }

    protected List<L> getLogMessages() {
        if (this.filePaths != null && this.filePaths.length > 0) {
            return this.getLogMessages(this.filePaths, null, null, true, this.storableObjectStatus != null);
        }
        return null;
    }

    public String getTitleName() {
        return Messages.getString("VCSHistoryWindow.Title");
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Component getGUI() {
        return this.gui;
    }

    public Toolbar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar();
            this.toolbar.add((ToggleAction)this.createRefreshAction());
            this.toolbar.addSeparator();
            this.addToolbarActions();
            this.toolbar.add((Component)this.designLabel);
            this.toolbar.addSeparator();
            this.toolbar.add((Component)this.fileLabel);
        }
        return this.toolbar;
    }

    protected void addToolbarActions() {
    }

    protected IdeAction createRefreshAction() {
        IdeAction ideAction = IdeAction.find((int)51);
        if (ideAction != null) {
            IdeAction ideAction2 = ideAction.newLocalAction((View)this);
            ideAction2.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    VCSHistoryWindow.this.refresh();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    return true;
                }
            });
            ideAction2.setEnabled(true);
            return ideAction2;
        }
        return null;
    }

    protected abstract Map<L, List<StorableObjectStatus>> parseChangedObjects(List<L> var1);

    public StorableObjectStatus getSelectedStorableObjectStatus() {
        int n = this.changedObjectsTable.getSelectedRow();
        return n > -1 ? (StorableObjectStatus)this.changedObjectsTableModel.getValueAt(n, 1) : null;
    }

    public List<StorableObjectStatus> getSelectedStorableObjectsStatuses() {
        int[] nArray;
        ArrayList<StorableObjectStatus> arrayList = new ArrayList<StorableObjectStatus>(this.changedObjectsTable.getSelectedRowCount());
        for (int n : nArray = this.changedObjectsTable.getSelectedRows()) {
            arrayList.add((StorableObjectStatus)this.changedObjectsTableModel.getValueAt(n, 1));
        }
        return arrayList;
    }

    protected class RestoreAction
    extends CopyAction {
        protected RestoreAction() {
            super(Messages.getString("VCSHistoryWindow.Restore"));
        }

        protected RestoreAction(String string) {
            super(string);
        }

        @Override
        public void update() {
            int[] nArray;
            for (int n : nArray = VCSHistoryWindow.this.changedObjectsTable.getSelectedRows()) {
                if ("D".equals(VCSHistoryWindow.this.changedObjectsTableModel.getValueAt(n, 0))) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        @Override
        public Long getRevisionToCopy(StorableObjectStatus storableObjectStatus) {
            return storableObjectStatus.getRevision() - 1L;
        }

        @Override
        protected void refresh(List<VersioningTreeNode> list) {
            VersioningTreeNode.refresh(list, true, true);
        }
    }

    protected class CopyAction
    extends UpdateableAction {
        public CopyAction() {
            super(Messages.getString("VCSHistoryWindow.Copy"));
        }

        protected CopyAction(String string) {
            super(string);
        }

        @Override
        public void update() {
            int[] nArray;
            for (int n : nArray = VCSHistoryWindow.this.changedObjectsTable.getSelectedRows()) {
                if (!"D".equals(VCSHistoryWindow.this.changedObjectsTableModel.getValueAt(n, 0))) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.performAction(VCSHistoryWindow.this.getSelectedStorableObjectsStatuses());
        }

        public void performAction(List<StorableObjectStatus> list) {
            ArrayList<VersioningTreeNode> arrayList = new ArrayList<VersioningTreeNode>();
            for (StorableObjectStatus storableObjectStatus : list) {
                VCSHistoryWindow.this.getVCSClientHelper().doCopy(storableObjectStatus.getURL(), storableObjectStatus.getFilePath(), this.getRevisionToCopy(storableObjectStatus));
                arrayList.add(new VersioningTreeNode(storableObjectStatus));
            }
            this.refresh(arrayList);
        }

        protected Long getRevisionToCopy(StorableObjectStatus storableObjectStatus) {
            return storableObjectStatus.getRevision();
        }

        protected void refresh(List<VersioningTreeNode> list) {
            VersioningTreeNode.refresh(list, false, true);
        }
    }

    protected class ComparePreviousAsTextAction
    extends AbstractComparePreviousAction {
        public ComparePreviousAsTextAction(String string) {
            super(string);
        }

        @Override
        protected void compare(InputStream inputStream, String string, InputStream inputStream2, String string2) {
            new VCSTextCompareFrame((Window)Ide.getMainWindow(), null, inputStream, string, inputStream2, string2, true, true, null).showModal();
        }
    }

    protected class ComparePreviousAction
    extends AbstractComparePreviousAction {
        public ComparePreviousAction(String string) {
            super(string);
        }

        @Override
        protected void compare(InputStream inputStream, String string, InputStream inputStream2, String string2) {
            StorageDesign storageDesign = null;
            if (VCSHistoryWindow.this.storableObjectStatus != null) {
                storageDesign = VCSHistoryWindow.this.getVCSClientHelper().findStorageDesign(VCSHistoryWindow.this.design, VCSHistoryWindow.this.storableObjectStatus.getStorableObjectID());
            }
            new XMLMetadataComparator(VCSHistoryWindow.this.design, storageDesign, inputStream, string, inputStream2, string2, false).showModal();
        }
    }

    protected abstract class AbstractComparePreviousAction
    extends UpdateableAction {
        protected String url;
        protected Long leftFileRevision;
        protected Long rightFileRevision;

        protected AbstractComparePreviousAction(String string) {
            super(string);
        }

        @Override
        public void update() {
            this.setEnabled(VCSHistoryWindow.this.changedObjectsTable.getSelectedRowCount() == 1 && "M".equals(VCSHistoryWindow.this.changedObjectsTableModel.getValueAt(VCSHistoryWindow.this.changedObjectsTable.getSelectedRow(), 0)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.init();
            InputStream inputStream = this.getLeftText();
            InputStream inputStream2 = this.getRightText();
            this.compare(inputStream, String.valueOf(this.leftFileRevision), inputStream2, this.rightFileRevision == null ? Messages.getString("SVNAbstractCompareCommand.LastLocalRevision") : String.valueOf(this.rightFileRevision));
        }

        protected void init() {
            StorableObjectStatus storableObjectStatus = (StorableObjectStatus)VCSHistoryWindow.this.changedObjectsTableModel.getValueAt(VCSHistoryWindow.this.changedObjectsTable.getSelectedRow(), 1);
            this.url = storableObjectStatus.getURL();
        }

        protected InputStream getLeftText() {
            Object l = VCSHistoryWindow.this.changedObjectsTableModel.getLogMessage();
            this.leftFileRevision = VCSHistoryWindow.this.getRevision(l);
            return VCSHistoryWindow.this.getRevision(this.url, this.leftFileRevision);
        }

        protected InputStream getRightText() {
            List list = VCSHistoryWindow.this.getLogMessages(this.url, null, (Long)(this.leftFileRevision - 1L), false, false);
            Object l = list.get(0);
            this.rightFileRevision = VCSHistoryWindow.this.getRevision(l);
            return VCSHistoryWindow.this.getRevision(this.url, this.rightFileRevision);
        }

        protected abstract void compare(InputStream var1, String var2, InputStream var3, String var4);
    }

    private abstract class CompareAction
    extends UpdateableAction {
        private CompareAction(String string) {
            super(string);
        }

        @Override
        public void update() {
            this.setEnabled(VCSHistoryWindow.this.historyTable.getSelectedRowCount() == 2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Long l;
            Long l2;
            File file = VCSHistoryWindow.this.storableObjectStatus.getFilePath();
            List list = VCSHistoryWindow.this.historyTableModel.getRows();
            Long l3 = VCSHistoryWindow.this.getRevision(list.get(VCSHistoryWindow.this.historyTable.getSelectedRows()[0]));
            Long l4 = VCSHistoryWindow.this.getRevision(list.get(VCSHistoryWindow.this.historyTable.getSelectedRows()[1]));
            if (l3 == null) {
                l2 = l4;
                l = l3;
            } else {
                l2 = l3;
                l = l4;
            }
            this.compare(VCSHistoryWindow.this.getRevision(file, l2), l2 == null ? LOCAL_SAVED : String.valueOf(l2), VCSHistoryWindow.this.getRevision(file, l), l == null ? LOCAL_SAVED : String.valueOf(l), file);
        }

        protected abstract void compare(InputStream var1, String var2, InputStream var3, String var4, File var5);
    }

    protected static abstract class UpdateableAction
    extends AbstractAction {
        protected UpdateableAction(String string) {
            super(string);
        }

        public abstract void update();
    }

    protected class ChangedObjectsTableModel
    extends VCSDefaultTableModel {
        private List<StorableObjectStatus> changedObjects;
        protected List<L> logMessages;

        protected ChangedObjectsTableModel() {
            this.changedObjects = new ArrayList<StorableObjectStatus>();
            this.logMessages = new ArrayList();
        }

        public L getLogMessage() {
            return this.logMessages.get(0);
        }

        public List<StorableObjectStatus> getChangedObjects() {
            return this.changedObjects;
        }

        public void addLogMessage(L l) {
            this.logMessages.add(l);
            for (StorableObjectStatus storableObjectStatus : VCSHistoryWindow.this.storableObjectStatusesMap.get(l)) {
                if (this.changedObjects.contains(storableObjectStatus)) continue;
                this.changedObjects.add(storableObjectStatus);
            }
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("VCSHistoryWindow.Action");
            }
            if (n == 1) {
                return Messages.getString("VCSHistoryWindow.ChangedObjects");
            }
            if (n == 2) {
                return Messages.getString("VCSHistoryWindow.Location");
            }
            if (n == 3) {
                return Messages.getString("VCSHistoryWindow.CopyRevision");
            }
            if (n == 4) {
                return Messages.getString("VCSHistoryWindow.CopyPath");
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this.changedObjects == null ? 0 : this.changedObjects.size();
        }

        @Override
        public void clear() {
            this.logMessages.clear();
            this.changedObjects.clear();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.logMessages.size() == 1 ? this.changedObjects.get(n).getTextStatus() : null;
            }
            if (n2 == 1) {
                return this.changedObjects.get(n);
            }
            if (n2 == 2) {
                return this.changedObjects.get(n).getPathString();
            }
            if (n2 == 3) {
                return this.changedObjects.get(n).getCopyRevision();
            }
            if (n2 == 4) {
                return this.changedObjects.get(n).getCopyPath();
            }
            return null;
        }
    }

    protected class VCSHistoryTableModel
    extends VCSDefaultTableModel {
        protected VCSHistoryTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.rows == null ? 0 : this.rows.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("VCSHistoryWindow.Revision");
            }
            if (n == 1) {
                return Messages.getString("VCSHistoryWindow.Date");
            }
            if (n == 2) {
                return Messages.getString("VCSHistoryWindow.Author");
            }
            if (n == 3) {
                return Messages.getString("VCSHistoryWindow.Comment");
            }
            return super.getColumnName(n);
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                Long l = VCSHistoryWindow.this.getRevision(this.rows.get(n));
                return l == null ? LOCAL_SAVED : l;
            }
            if (n2 == 1) {
                return VCSHistoryWindow.this.getDate(this.rows.get(n));
            }
            if (n2 == 2) {
                return VCSHistoryWindow.this.getAuthor(this.rows.get(n));
            }
            if (n2 == 3) {
                return VCSHistoryWindow.this.getComment(this.rows.get(n));
            }
            return null;
        }

        @Override
        public void clear() {
            this.rows.clear();
        }
    }

    protected abstract class VCSDefaultTableModel
    extends DefaultTableModel {
        protected List rows = new ArrayList();

        protected VCSDefaultTableModel() {
        }

        public abstract void clear();

        public List getRows() {
            return this.rows;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

